/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.io.DataExternalizer;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00040\u0003B!\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00042\u0006\u0010\t\u001a\u00020\nH\u0016J$\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/LinkedHashMapExternalizer;", "K", "V", "Lorg/jetbrains/kotlin/com/intellij/util/io/DataExternalizer;", "Ljava/util/LinkedHashMap;", "keyExternalizer", "valueExternalizer", "(Lcom/intellij/util/io/DataExternalizer;Lcom/intellij/util/io/DataExternalizer;)V", "read", "input", "Ljava/io/DataInput;", "save", "", "output", "Ljava/io/DataOutput;", "map", "kotlin-build-common"})
public final class LinkedHashMapExternalizer<K, V>
implements DataExternalizer<LinkedHashMap<K, V>> {
    @NotNull
    private final DataExternalizer<K> keyExternalizer;
    @NotNull
    private final DataExternalizer<V> valueExternalizer;

    public LinkedHashMapExternalizer(@NotNull DataExternalizer<K> keyExternalizer, @NotNull DataExternalizer<V> valueExternalizer) {
        Intrinsics.checkNotNullParameter(keyExternalizer, "keyExternalizer");
        Intrinsics.checkNotNullParameter(valueExternalizer, "valueExternalizer");
        this.keyExternalizer = keyExternalizer;
        this.valueExternalizer = valueExternalizer;
    }

    @Override
    public void save(@NotNull DataOutput output, @NotNull LinkedHashMap<K, V> map2) {
        Intrinsics.checkNotNullParameter(output, "output");
        Intrinsics.checkNotNullParameter(map2, "map");
        output.writeInt(map2.size());
        for (Map.Entry entry : ((Map)map2).entrySet()) {
            Object key = entry.getKey();
            Object value2 = entry.getValue();
            this.keyExternalizer.save(output, key);
            this.valueExternalizer.save(output, value2);
        }
    }

    @Override
    @NotNull
    public LinkedHashMap<K, V> read(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter(input, "input");
        int size = input.readInt();
        LinkedHashMap map2 = new LinkedHashMap(size);
        int n = 0;
        while (n < size) {
            int n2;
            int it = n2 = n++;
            boolean bl = false;
            K key = this.keyExternalizer.read(input);
            V value2 = this.valueExternalizer.read(input);
            Map map3 = map2;
            map3.put(key, value2);
        }
        return map2;
    }
}

