/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.messages;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@ApiStatus.NonExtendable
public class Topic<L> {
    private final String name;
    private final Class<L> myListenerClass;
    private final BroadcastDirection myBroadcastDirection;
    private final boolean immediateDelivery;

    public Topic(@NonNls @NotNull String name2, @NotNull Class<L> listenerClass) {
        if (name2 == null) {
            Topic.$$$reportNull$$$0(0);
        }
        if (listenerClass == null) {
            Topic.$$$reportNull$$$0(1);
        }
        this(name2, listenerClass, BroadcastDirection.TO_CHILDREN);
    }

    public Topic(@NotNull Class<L> listenerClass, @NotNull BroadcastDirection broadcastDirection) {
        if (listenerClass == null) {
            Topic.$$$reportNull$$$0(3);
        }
        if (broadcastDirection == null) {
            Topic.$$$reportNull$$$0(4);
        }
        this(listenerClass.getSimpleName(), listenerClass, broadcastDirection);
    }

    @ApiStatus.Experimental
    public Topic(@NotNull Class<L> listenerClass, @NotNull BroadcastDirection broadcastDirection, boolean immediateDelivery) {
        if (listenerClass == null) {
            Topic.$$$reportNull$$$0(5);
        }
        if (broadcastDirection == null) {
            Topic.$$$reportNull$$$0(6);
        }
        this.name = listenerClass.getSimpleName();
        this.myListenerClass = listenerClass;
        this.myBroadcastDirection = broadcastDirection;
        this.immediateDelivery = immediateDelivery;
    }

    public Topic(@NonNls @NotNull String name2, @NotNull Class<L> listenerClass, @NotNull BroadcastDirection broadcastDirection) {
        if (name2 == null) {
            Topic.$$$reportNull$$$0(7);
        }
        if (listenerClass == null) {
            Topic.$$$reportNull$$$0(8);
        }
        if (broadcastDirection == null) {
            Topic.$$$reportNull$$$0(9);
        }
        this.name = name2;
        this.myListenerClass = listenerClass;
        this.myBroadcastDirection = broadcastDirection;
        this.immediateDelivery = false;
    }

    @NotNull
    public Class<L> getListenerClass() {
        Class<L> clazz = this.myListenerClass;
        if (clazz == null) {
            Topic.$$$reportNull$$$0(11);
        }
        return clazz;
    }

    public String toString() {
        return "Topic(name='" + this.name + '\'' + ", listenerClass=" + this.myListenerClass + ", broadcastDirection=" + (Object)((Object)this.myBroadcastDirection) + ", immediateDelivery=" + this.immediateDelivery + ')';
    }

    @NotNull
    public static <L> Topic<L> create(@NonNls @NotNull String displayName, @NotNull Class<L> listenerClass) {
        if (displayName == null) {
            Topic.$$$reportNull$$$0(12);
        }
        if (listenerClass == null) {
            Topic.$$$reportNull$$$0(13);
        }
        return new Topic<L>(displayName, listenerClass);
    }

    @NotNull
    public BroadcastDirection getBroadcastDirection() {
        BroadcastDirection broadcastDirection = this.myBroadcastDirection;
        if (broadcastDirection == null) {
            Topic.$$$reportNull$$$0(16);
        }
        return broadcastDirection;
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    public boolean isImmediateDelivery() {
        return this.immediateDelivery;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 16: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listenerClass";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "broadcastDirection";
                break;
            }
            case 10: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/messages/Topic";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/messages/Topic";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getListenerClass";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getBroadcastDirection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 11: 
            case 16: {
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 10: 
            case 11: 
            case 16: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum BroadcastDirection {
        TO_CHILDREN,
        TO_DIRECT_CHILDREN,
        NONE,
        TO_PARENT;

    }
}

