/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.codegen;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredStatementOrigin;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0012\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\f\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\b\u00a8\u0006\t"}, d2={"isInlineArrayConstructor", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "isInlineFunctionCall", "unwrapInlineLambda", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "Lorg/jetbrains/kotlin/ir/IrStatement;", "backend.jvm"})
public final class IrInlineCodegenKt {
    @Nullable
    public static final IrFunctionReference unwrapInlineLambda(@NotNull IrStatement $this$unwrapInlineLambda) {
        IrFunctionReference irFunctionReference;
        Intrinsics.checkNotNullParameter($this$unwrapInlineLambda, "<this>");
        IrStatement irStatement = $this$unwrapInlineLambda;
        if (irStatement instanceof IrBlock) {
            IrStatement irStatement2 = CollectionsKt.lastOrNull(((IrBlock)$this$unwrapInlineLambda).getStatements());
            irFunctionReference = irStatement2 == null ? null : IrInlineCodegenKt.unwrapInlineLambda(irStatement2);
        } else if (irStatement instanceof IrFunctionReference) {
            IrStatement irStatement3 = $this$unwrapInlineLambda;
            IrFunctionReference it = (IrFunctionReference)irStatement3;
            boolean bl = false;
            irFunctionReference = (IrFunctionReference)(Intrinsics.areEqual(it.getOrigin(), JvmLoweredStatementOrigin.INLINE_LAMBDA.INSTANCE) ? irStatement3 : null);
        } else {
            irFunctionReference = null;
        }
        return irFunctionReference;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInlineFunctionCall(@NotNull IrFunction $this$isInlineFunctionCall, @NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter($this$isInlineFunctionCall, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (context2.getState().isInlineDisabled()) {
            IrTypeParameter it;
            Iterable $this$any$iv = $this$isInlineFunctionCall.getTypeParameters();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                it = (IrTypeParameter)element$iv;
                boolean bl = false;
            } while (!it.isReified());
            boolean bl = true;
            if (!bl) return false;
        }
        if ($this$isInlineFunctionCall.isInline()) return true;
        if (!IrInlineCodegenKt.isInlineArrayConstructor($this$isInlineFunctionCall, context2)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isInlineArrayConstructor(IrFunction $this$isInlineArrayConstructor, JvmBackendContext context2) {
        IrClassSymbol irClassSymbol;
        if (!($this$isInlineArrayConstructor instanceof IrConstructor)) return false;
        if ($this$isInlineArrayConstructor.getValueParameters().size() != 2) return false;
        IrClassSymbol it = irClassSymbol = AdditionalIrUtilsKt.getConstructedClass((IrConstructor)$this$isInlineArrayConstructor).getSymbol();
        boolean bl = false;
        if (Intrinsics.areEqual(it, context2.getIrBuiltIns().getArrayClass())) return true;
        Map<IrClassSymbol, PrimitiveType> map2 = context2.getIrBuiltIns().getPrimitiveArraysToPrimitiveTypes();
        Map<IrClassSymbol, PrimitiveType> map3 = map2;
        if (!map3.containsKey(it)) return false;
        return true;
    }
}

