/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus;

import com.google.inject.Binder;
import com.google.inject.Module;
import java.security.SecureClassLoader;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.inject.Provider;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Startable;
import org.eclipse.sisu.bean.BeanManager;
import org.eclipse.sisu.bean.BeanProperty;
import org.eclipse.sisu.bean.BeanScheduler;
import org.eclipse.sisu.bean.PropertyBinding;
import org.eclipse.sisu.inject.Logs;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

public final class PlexusLifecycleManager
extends BeanScheduler
implements BeanManager,
Module {
    private static final Class<?>[] LIFECYCLE_TYPES = new Class[]{LogEnabled.class, Contextualizable.class, Initializable.class, Startable.class, Disposable.class};
    private final Deque<Startable> startableBeans = new ArrayDeque<Startable>();
    private final Deque<Disposable> disposableBeans = new ArrayDeque<Disposable>();
    private final Logger consoleLogger = new ConsoleLogger();
    private final Provider<Context> plexusContextProvider;
    private final Provider<LoggerManager> plexusLoggerManagerProvider;
    private final Provider<?> slf4jLoggerFactoryProvider;
    private final BeanManager delegate;

    public PlexusLifecycleManager(Provider<Context> plexusContextProvider, Provider<LoggerManager> plexusLoggerManagerProvider, Provider<?> slf4jLoggerFactoryProvider, BeanManager delegate2) {
        this.plexusContextProvider = plexusContextProvider;
        this.plexusLoggerManagerProvider = plexusLoggerManagerProvider;
        this.slf4jLoggerFactoryProvider = slf4jLoggerFactoryProvider;
        this.delegate = delegate2;
    }

    @Override
    public void configure(Binder binder) {
        BeanScheduler.MODULE.configure(binder);
    }

    @Override
    public boolean manage(Class<?> clazz) {
        Class<?>[] classArray = LIFECYCLE_TYPES;
        int n = LIFECYCLE_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> lifecycleType = classArray[n2];
            if (lifecycleType.isAssignableFrom(clazz)) {
                return true;
            }
            ++n2;
        }
        return this.delegate != null ? this.delegate.manage(clazz) : false;
    }

    public PropertyBinding manage(final BeanProperty property2) {
        Class clazz = property2.getType().getRawType();
        if ("org.slf4j.Logger".equals(clazz.getName())) {
            return new PropertyBinding(){

                @Override
                public <B> void injectProperty(B bean) {
                    property2.set(bean, PlexusLifecycleManager.this.getSLF4JLogger(bean));
                }
            };
        }
        if (Logger.class.equals(clazz)) {
            return new PropertyBinding(){

                @Override
                public <B> void injectProperty(B bean) {
                    property2.set(bean, PlexusLifecycleManager.this.getPlexusLogger(bean));
                }
            };
        }
        return this.delegate != null ? this.delegate.manage(property2) : null;
    }

    @Override
    public boolean manage(Object bean) {
        if (bean instanceof Disposable) {
            PlexusLifecycleManager.synchronizedPush(this.disposableBeans, (Disposable)bean);
        }
        if (bean instanceof LogEnabled) {
            ((LogEnabled)bean).enableLogging(this.getPlexusLogger(bean));
        }
        if (bean instanceof Contextualizable || bean instanceof Initializable || bean instanceof Startable) {
            this.schedule(bean);
        }
        return this.delegate != null ? this.delegate.manage(bean) : true;
    }

    @Override
    public boolean unmanage(Object bean) {
        if (PlexusLifecycleManager.synchronizedRemove(this.startableBeans, bean)) {
            this.stop((Startable)bean);
        }
        if (PlexusLifecycleManager.synchronizedRemove(this.disposableBeans, bean)) {
            this.dispose((Disposable)bean);
        }
        return this.delegate != null ? this.delegate.unmanage(bean) : true;
    }

    @Override
    public boolean unmanage() {
        Object bean;
        while ((bean = PlexusLifecycleManager.synchronizedPop(this.startableBeans)) != null) {
            this.stop((Startable)bean);
        }
        while ((bean = PlexusLifecycleManager.synchronizedPop(this.disposableBeans)) != null) {
            this.dispose((Disposable)bean);
        }
        return this.delegate != null ? this.delegate.unmanage() : true;
    }

    @Override
    protected void activate(Object bean) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = bean.getClass();
            while (clazz != null) {
                ClassLoader loader = clazz.getClassLoader();
                if (loader instanceof SecureClassLoader) {
                    Thread.currentThread().setContextClassLoader(loader);
                    break;
                }
                clazz = clazz.getSuperclass();
            }
            if (bean instanceof Contextualizable) {
                this.contextualize((Contextualizable)bean);
            }
            if (bean instanceof Initializable) {
                this.initialize((Initializable)bean);
            }
            if (bean instanceof Startable) {
                Startable startableBean = (Startable)bean;
                PlexusLifecycleManager.synchronizedPush(this.startableBeans, startableBean);
                this.start(startableBean);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    Logger getPlexusLogger(Object bean) {
        String name2 = bean.getClass().getName();
        try {
            return this.plexusLoggerManagerProvider.get().getLoggerForComponent(name2, null);
        }
        catch (RuntimeException runtimeException) {
            return this.consoleLogger;
        }
    }

    Object getSLF4JLogger(Object bean) {
        String name2 = bean.getClass().getName();
        try {
            return ((ILoggerFactory)this.slf4jLoggerFactoryProvider.get()).getLogger(name2);
        }
        catch (RuntimeException runtimeException) {
            return LoggerFactory.getLogger(name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void synchronizedPush(Deque<T> deque, T element) {
        Deque<T> deque2 = deque;
        synchronized (deque2) {
            deque.addLast(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean synchronizedRemove(Deque<?> deque, Object element) {
        Deque<?> deque2 = deque;
        synchronized (deque2) {
            return deque.remove(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T synchronizedPop(Deque<T> deque) {
        Deque<T> deque2 = deque;
        synchronized (deque2) {
            return deque.pollLast();
        }
    }

    private void contextualize(Contextualizable bean) {
        Logs.trace("Contextualize: <>", bean, null);
        try {
            bean.contextualize(this.plexusContextProvider.get());
        }
        catch (Throwable e) {
            Logs.catchThrowable(e);
            try {
                this.getPlexusLogger(this).warn("Error contextualizing: " + Logs.identityToString(bean), e);
            }
            finally {
                Logs.throwUnchecked(e);
            }
        }
    }

    private void initialize(Initializable bean) {
        Logs.trace("Initialize: <>", bean, null);
        try {
            bean.initialize();
        }
        catch (Throwable e) {
            Logs.catchThrowable(e);
            try {
                this.getPlexusLogger(this).warn("Error initializing: " + Logs.identityToString(bean), e);
            }
            finally {
                Logs.throwUnchecked(e);
            }
        }
    }

    private void start(Startable bean) {
        Logs.trace("Start: <>", bean, null);
        try {
            bean.start();
        }
        catch (Throwable e) {
            Logs.catchThrowable(e);
            try {
                this.getPlexusLogger(this).warn("Error starting: " + Logs.identityToString(bean), e);
            }
            finally {
                Logs.throwUnchecked(e);
            }
        }
    }

    private void stop(Startable bean) {
        Logs.trace("Stop: <>", bean, null);
        try {
            bean.stop();
        }
        catch (Throwable e) {
            Logs.catchThrowable(e);
            try {
                this.getPlexusLogger(this).warn("Problem stopping: " + Logs.identityToString(bean), e);
            }
            catch (Throwable throwable) {}
            return;
        }
    }

    private void dispose(Disposable bean) {
        Logs.trace("Dispose: <>", bean, null);
        try {
            bean.dispose();
        }
        catch (Throwable e) {
            Logs.catchThrowable(e);
            try {
                this.getPlexusLogger(this).warn("Problem disposing: " + Logs.identityToString(bean), e);
            }
            catch (Throwable throwable) {}
            return;
        }
    }
}

