/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.aether.RepositorySystemSession;

public final class ConfigUtils {
    private ConfigUtils() {
    }

    public static Object getObject(Map<?, ?> properties2, Object defaultValue2, String ... keys2) {
        for (String key : keys2) {
            Object value2 = properties2.get(key);
            if (value2 == null) continue;
            return value2;
        }
        return defaultValue2;
    }

    public static Object getObject(RepositorySystemSession session2, Object defaultValue2, String ... keys2) {
        return ConfigUtils.getObject(session2.getConfigProperties(), defaultValue2, keys2);
    }

    public static String getString(Map<?, ?> properties2, String defaultValue2, String ... keys2) {
        for (String key : keys2) {
            Object value2 = properties2.get(key);
            if (!(value2 instanceof String)) continue;
            return (String)value2;
        }
        return defaultValue2;
    }

    public static String getString(RepositorySystemSession session2, String defaultValue2, String ... keys2) {
        return ConfigUtils.getString(session2.getConfigProperties(), defaultValue2, keys2);
    }

    public static int getInteger(Map<?, ?> properties2, int defaultValue2, String ... keys2) {
        for (String key : keys2) {
            Object value2 = properties2.get(key);
            if (value2 instanceof Number) {
                return ((Number)value2).intValue();
            }
            try {
                return Integer.parseInt((String)value2);
            }
            catch (Exception exception) {
            }
        }
        return defaultValue2;
    }

    public static int getInteger(RepositorySystemSession session2, int defaultValue2, String ... keys2) {
        return ConfigUtils.getInteger(session2.getConfigProperties(), defaultValue2, keys2);
    }

    public static long getLong(Map<?, ?> properties2, long defaultValue2, String ... keys2) {
        for (String key : keys2) {
            Object value2 = properties2.get(key);
            if (value2 instanceof Number) {
                return ((Number)value2).longValue();
            }
            try {
                return Long.parseLong((String)value2);
            }
            catch (Exception exception) {
            }
        }
        return defaultValue2;
    }

    public static long getLong(RepositorySystemSession session2, long defaultValue2, String ... keys2) {
        return ConfigUtils.getLong(session2.getConfigProperties(), defaultValue2, keys2);
    }

    public static float getFloat(Map<?, ?> properties2, float defaultValue2, String ... keys2) {
        for (String key : keys2) {
            Object value2 = properties2.get(key);
            if (value2 instanceof Number) {
                return ((Number)value2).floatValue();
            }
            try {
                return Float.parseFloat((String)value2);
            }
            catch (Exception exception) {
            }
        }
        return defaultValue2;
    }

    public static float getFloat(RepositorySystemSession session2, float defaultValue2, String ... keys2) {
        return ConfigUtils.getFloat(session2.getConfigProperties(), defaultValue2, keys2);
    }

    public static boolean getBoolean(Map<?, ?> properties2, boolean defaultValue2, String ... keys2) {
        for (String key : keys2) {
            Object value2 = properties2.get(key);
            if (value2 instanceof Boolean) {
                return (Boolean)value2;
            }
            if (!(value2 instanceof String)) continue;
            return Boolean.parseBoolean((String)value2);
        }
        return defaultValue2;
    }

    public static boolean getBoolean(RepositorySystemSession session2, boolean defaultValue2, String ... keys2) {
        return ConfigUtils.getBoolean(session2.getConfigProperties(), defaultValue2, keys2);
    }

    public static List<?> getList(Map<?, ?> properties2, List<?> defaultValue2, String ... keys2) {
        for (String key : keys2) {
            Object value2 = properties2.get(key);
            if (value2 instanceof List) {
                return (List)value2;
            }
            if (!(value2 instanceof Collection)) continue;
            return Collections.unmodifiableList(new ArrayList((Collection)value2));
        }
        return defaultValue2;
    }

    public static List<?> getList(RepositorySystemSession session2, List<?> defaultValue2, String ... keys2) {
        return ConfigUtils.getList(session2.getConfigProperties(), defaultValue2, keys2);
    }

    public static Map<?, ?> getMap(Map<?, ?> properties2, Map<?, ?> defaultValue2, String ... keys2) {
        for (String key : keys2) {
            Object value2 = properties2.get(key);
            if (!(value2 instanceof Map)) continue;
            return (Map)value2;
        }
        return defaultValue2;
    }

    public static Map<?, ?> getMap(RepositorySystemSession session2, Map<?, ?> defaultValue2, String ... keys2) {
        return ConfigUtils.getMap(session2.getConfigProperties(), defaultValue2, keys2);
    }
}

