/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters.composite;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.AbstractConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.ParameterizedConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.eclipse.sisu.inject.Logs;

public class MapConverter
extends AbstractConfigurationConverter
implements ParameterizedConfigurationConverter {
    @Override
    public boolean canConvert(Class<?> type2) {
        return Map.class.isAssignableFrom(type2) && !Properties.class.isAssignableFrom(type2);
    }

    @Override
    public Object fromConfiguration(ConverterLookup lookup2, PlexusConfiguration configuration2, Class<?> type2, Class<?> enclosingType, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        return this.fromConfiguration(lookup2, configuration2, type2, null, enclosingType, loader, evaluator, listener);
    }

    @Override
    public Object fromConfiguration(ConverterLookup lookup2, PlexusConfiguration configuration2, Class<?> type2, Type[] typeArguments2, Class<?> enclosingType, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        Object value2 = this.fromExpression(configuration2, evaluator, type2);
        if (value2 != null) {
            return value2;
        }
        try {
            Map<Object, Object> map2 = this.instantiateMap(configuration2, type2, loader);
            Class<?> elementType = MapConverter.findElementType(typeArguments2);
            if (Object.class == elementType || String.class == elementType) {
                int i = 0;
                int size = configuration2.getChildCount();
                while (i < size) {
                    PlexusConfiguration element = configuration2.getChild(i);
                    map2.put(element.getName(), this.fromExpression(element, evaluator));
                    ++i;
                }
                return map2;
            }
            ConfigurationConverter converter = lookup2.lookupConverterForType(elementType);
            int i = 0;
            int size = configuration2.getChildCount();
            while (i < size) {
                Object elementValue;
                PlexusConfiguration element = configuration2.getChild(i);
                try {
                    elementValue = converter.fromConfiguration(lookup2, element, elementType, enclosingType, loader, evaluator, listener);
                }
                catch (ComponentConfigurationException componentConfigurationException) {
                    elementValue = this.fromExpression(element, evaluator);
                    Logs.warn("Map in " + enclosingType + " declares value type as: {} but saw: {} at runtime", elementType, elementValue != null ? elementValue.getClass() : null);
                }
                map2.put(element.getName(), elementValue);
                ++i;
            }
            return map2;
        }
        catch (ComponentConfigurationException e) {
            if (e.getFailedConfiguration() == null) {
                e.setFailedConfiguration(configuration2);
            }
            throw e;
        }
    }

    private Map<Object, Object> instantiateMap(PlexusConfiguration configuration2, Class<?> type2, ClassLoader loader) throws ComponentConfigurationException {
        Class<?> implType = this.getClassForImplementationHint(type2, configuration2, loader);
        if (implType == null || Modifier.isAbstract(implType.getModifiers())) {
            return new TreeMap<Object, Object>();
        }
        Object impl = this.instantiateObject(implType);
        this.failIfNotTypeCompatible(impl, type2, configuration2);
        return (Map)impl;
    }

    private static Class<?> findElementType(Type[] typeArguments2) {
        if (typeArguments2 != null && typeArguments2.length > 1 && typeArguments2[1] instanceof Class) {
            return (Class)typeArguments2[1];
        }
        return Object.class;
    }
}

