/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.shared.http;

import java.util.Map;
import java.util.Properties;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

public class HttpMethodConfiguration {
    private Boolean useDefaultHeaders;
    private Properties headers = new Properties();
    private Properties params = new Properties();
    private int connectionTimeout = 60000;
    private int readTimeout = Integer.parseInt(System.getProperty("maven.wagon.rto", Integer.toString(1800000)));
    private boolean usePreemptive = false;

    public boolean isUseDefaultHeaders() {
        return this.useDefaultHeaders == null || this.useDefaultHeaders != false;
    }

    public HttpMethodConfiguration setUseDefaultHeaders(boolean useDefaultHeaders) {
        this.useDefaultHeaders = useDefaultHeaders;
        return this;
    }

    public Boolean getUseDefaultHeaders() {
        return this.useDefaultHeaders;
    }

    public HttpMethodConfiguration addHeader(String header, String value2) {
        this.headers.setProperty(header, value2);
        return this;
    }

    public Properties getHeaders() {
        return this.headers;
    }

    public HttpMethodConfiguration setHeaders(Properties headers) {
        this.headers = headers;
        return this;
    }

    public HttpMethodConfiguration addParam(String param, String value2) {
        this.params.setProperty(param, value2);
        return this;
    }

    public Properties getParams() {
        return this.params;
    }

    public HttpMethodConfiguration setParams(Properties params) {
        this.params = params;
        return this;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public HttpMethodConfiguration setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public HttpMethodConfiguration setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public boolean isUsePreemptive() {
        return this.usePreemptive;
    }

    public HttpMethodConfiguration setUsePreemptive(boolean usePreemptive) {
        this.usePreemptive = usePreemptive;
        return this;
    }

    public Header[] asRequestHeaders() {
        if (this.headers == null) {
            return new Header[0];
        }
        Header[] result2 = new Header[this.headers.size()];
        int index2 = 0;
        for (Map.Entry<Object, Object> entry : this.headers.entrySet()) {
            String key = (String)entry.getKey();
            String value2 = (String)entry.getValue();
            BasicHeader header = new BasicHeader(key, value2);
            result2[index2++] = header;
        }
        return result2;
    }

    HttpMethodConfiguration copy() {
        HttpMethodConfiguration copy2 = new HttpMethodConfiguration();
        copy2.setConnectionTimeout(this.getConnectionTimeout());
        copy2.setReadTimeout(this.getReadTimeout());
        if (this.getHeaders() != null) {
            copy2.getHeaders().putAll((Map<?, ?>)this.getHeaders());
        }
        if (this.getParams() != null) {
            copy2.getParams().putAll((Map<?, ?>)this.getParams());
        }
        copy2.setUseDefaultHeaders(this.isUseDefaultHeaders());
        return copy2;
    }
}

