/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.shared.http;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.message.BasicHeader;
import org.apache.maven.wagon.shared.http.HttpMethodConfiguration;

public class ConfigurationUtils {
    private static final String SO_TIMEOUT = "http.socket.timeout";
    private static final String STALE_CONNECTION_CHECK = "http.connection.stalecheck";
    private static final String CONNECTION_TIMEOUT = "http.connection.timeout";
    private static final String USE_EXPECT_CONTINUE = "http.protocol.expect-continue";
    private static final String DEFAULT_PROXY = "http.route.default-proxy";
    private static final String LOCAL_ADDRESS = "http.route.local-address";
    private static final String PROXY_AUTH_PREF = "http.auth.proxy-scheme-pref";
    private static final String TARGET_AUTH_PREF = "http.auth.target-scheme-pref";
    private static final String HANDLE_AUTHENTICATION = "http.protocol.handle-authentication";
    private static final String ALLOW_CIRCULAR_REDIRECTS = "http.protocol.allow-circular-redirects";
    private static final String CONN_MANAGER_TIMEOUT = "http.conn-manager.timeout";
    private static final String COOKIE_POLICY = "http.protocol.cookie-policy";
    private static final String MAX_REDIRECTS = "http.protocol.max-redirects";
    private static final String HANDLE_REDIRECTS = "http.protocol.handle-redirects";
    private static final String REJECT_RELATIVE_REDIRECT = "http.protocol.reject-relative-redirect";
    private static final String HANDLE_CONTENT_COMPRESSION = "http.protocol.handle-content-compression";
    private static final String HANDLE_URI_NORMALIZATION = "http.protocol.handle-uri-normalization";
    private static final String COERCE_PATTERN = "%(\\w+),(.+)";

    public static void copyConfig(HttpMethodConfiguration config, RequestConfig.Builder builder2) {
        Properties params;
        if (config.getConnectionTimeout() > 0) {
            builder2.setConnectTimeout(config.getConnectionTimeout());
        }
        if (config.getReadTimeout() > 0) {
            builder2.setSocketTimeout(config.getReadTimeout());
        }
        if ((params = config.getParams()) != null) {
            Pattern coercePattern = Pattern.compile(COERCE_PATTERN);
            for (Map.Entry<Object, Object> entry : params.entrySet()) {
                String key = (String)entry.getKey();
                String value2 = (String)entry.getValue();
                Matcher matcher2 = coercePattern.matcher(value2);
                if (matcher2.matches()) {
                    value2 = matcher2.group(2);
                }
                if (key.equals(SO_TIMEOUT)) {
                    builder2.setSocketTimeout(Integer.parseInt(value2));
                    continue;
                }
                if (key.equals(STALE_CONNECTION_CHECK)) {
                    builder2.setStaleConnectionCheckEnabled(Boolean.valueOf(value2));
                    continue;
                }
                if (key.equals(CONNECTION_TIMEOUT)) {
                    builder2.setConnectTimeout(Integer.parseInt(value2));
                    continue;
                }
                if (key.equals(USE_EXPECT_CONTINUE)) {
                    builder2.setExpectContinueEnabled(Boolean.valueOf(value2));
                    continue;
                }
                if (key.equals(DEFAULT_PROXY)) {
                    builder2.setProxy(HttpHost.create(value2));
                    continue;
                }
                if (key.equals(LOCAL_ADDRESS)) {
                    try {
                        builder2.setLocalAddress(InetAddress.getByName(value2));
                    }
                    catch (UnknownHostException unknownHostException) {}
                    continue;
                }
                if (key.equals(PROXY_AUTH_PREF)) {
                    builder2.setProxyPreferredAuthSchemes(Arrays.asList(value2.split(",")));
                    continue;
                }
                if (key.equals(TARGET_AUTH_PREF)) {
                    builder2.setTargetPreferredAuthSchemes(Arrays.asList(value2.split(",")));
                    continue;
                }
                if (key.equals(HANDLE_AUTHENTICATION)) {
                    builder2.setAuthenticationEnabled(Boolean.valueOf(value2));
                    continue;
                }
                if (key.equals(ALLOW_CIRCULAR_REDIRECTS)) {
                    builder2.setCircularRedirectsAllowed(Boolean.valueOf(value2));
                    continue;
                }
                if (key.equals(CONN_MANAGER_TIMEOUT)) {
                    builder2.setConnectionRequestTimeout(Integer.parseInt(value2));
                    continue;
                }
                if (key.equals(COOKIE_POLICY)) {
                    builder2.setCookieSpec(value2);
                    continue;
                }
                if (key.equals(MAX_REDIRECTS)) {
                    builder2.setMaxRedirects(Integer.parseInt(value2));
                    continue;
                }
                if (key.equals(HANDLE_REDIRECTS)) {
                    builder2.setRedirectsEnabled(Boolean.valueOf(value2));
                    continue;
                }
                if (key.equals(REJECT_RELATIVE_REDIRECT)) {
                    builder2.setRelativeRedirectsAllowed(Boolean.valueOf(value2) == false);
                    continue;
                }
                if (key.equals(HANDLE_CONTENT_COMPRESSION)) {
                    builder2.setContentCompressionEnabled(Boolean.valueOf(value2));
                    continue;
                }
                if (!key.equals(HANDLE_URI_NORMALIZATION)) continue;
                builder2.setNormalizeUri(Boolean.valueOf(value2));
            }
        }
    }

    public static Header[] asRequestHeaders(HttpMethodConfiguration config) {
        Properties headers = config.getHeaders();
        if (headers == null) {
            return new Header[0];
        }
        Header[] result2 = new Header[headers.size()];
        int index2 = 0;
        for (Map.Entry<Object, Object> entry : headers.entrySet()) {
            String key = (String)entry.getKey();
            String value2 = (String)entry.getValue();
            BasicHeader header = new BasicHeader(key, value2);
            result2[index2++] = header;
        }
        return result2;
    }

    public static HttpMethodConfiguration merge(HttpMethodConfiguration defaults, HttpMethodConfiguration base2, HttpMethodConfiguration local) {
        HttpMethodConfiguration result2 = ConfigurationUtils.merge(defaults, base2);
        return ConfigurationUtils.merge(result2, local);
    }

    public static HttpMethodConfiguration merge(HttpMethodConfiguration base2, HttpMethodConfiguration local) {
        if (base2 == null && local == null) {
            return null;
        }
        if (base2 == null) {
            return local;
        }
        if (local == null) {
            return base2;
        }
        HttpMethodConfiguration result2 = base2.copy();
        if (local.getConnectionTimeout() != 60000) {
            result2.setConnectionTimeout(local.getConnectionTimeout());
        }
        if (local.getReadTimeout() != 1800000) {
            result2.setReadTimeout(local.getReadTimeout());
        }
        if (local.getHeaders() != null) {
            result2.getHeaders().putAll((Map<?, ?>)local.getHeaders());
        }
        if (local.getParams() != null) {
            result2.getParams().putAll((Map<?, ?>)local.getParams());
        }
        if (local.getUseDefaultHeaders() != null) {
            result2.setUseDefaultHeaders(local.isUseDefaultHeaders());
        }
        return result2;
    }
}

