/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.utils.xml;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

final class XMLEncode {
    private static final int CDATA_BLOCK_THRESHOLD_LENGTH = 12;
    private static final char DEFAULT_QUOTE_CHAR = '\"';

    XMLEncode() {
    }

    public static boolean isWhiteSpace(String text2) {
        for (int i = 0; i < text2.length(); ++i) {
            char c = text2.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public static String xmlEncodeTextForAttribute(String text2, char quoteChar) {
        if (text2 == null) {
            return null;
        }
        return XMLEncode.xmlEncodeTextAsPCDATA(text2, true, quoteChar);
    }

    public static String xmlEncodeText(String text2) {
        if (text2 == null) {
            return null;
        }
        StringWriter writer = new StringWriter(text2.length() * 2);
        XMLEncode.xmlEncodeText(text2, writer);
        return writer.toString();
    }

    public static void xmlEncodeText(String text2, Writer writer) {
        if (text2 == null) {
            return;
        }
        try {
            String cdata;
            if (!XMLEncode.needsEncoding(text2)) {
                writer.write(text2);
                return;
            }
            if (text2.length() > 12 && (cdata = XMLEncode.xmlEncodeTextAsCDATABlock(text2)) != null) {
                writer.write(cdata);
                return;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        XMLEncode.xmlEncodeTextAsPCDATA(text2, false, '\"', writer);
    }

    public static String xmlEncodeTextAsPCDATA(String text2) {
        if (text2 == null) {
            return null;
        }
        return XMLEncode.xmlEncodeTextAsPCDATA(text2, false);
    }

    public static String xmlEncodeTextAsPCDATA(String text2, boolean forAttribute) {
        return XMLEncode.xmlEncodeTextAsPCDATA(text2, forAttribute, '\"');
    }

    public static String xmlEncodeTextAsPCDATA(String text2, boolean forAttribute, char quoteChar) {
        if (text2 == null) {
            return null;
        }
        StringWriter writer = new StringWriter(text2.length() * 2);
        XMLEncode.xmlEncodeTextAsPCDATA(text2, forAttribute, quoteChar, writer);
        return writer.toString();
    }

    public static void xmlEncodeTextAsPCDATA(String text2, boolean forAttribute, char quoteChar, Writer n) {
        if (text2 == null) {
            return;
        }
        try {
            int length = text2.length();
            if (forAttribute) {
                n.append(quoteChar);
            }
            block11: for (int i = 0; i < length; ++i) {
                char c = text2.charAt(i);
                switch (c) {
                    case '&': {
                        n.append("&amp;");
                        continue block11;
                    }
                    case '<': {
                        n.append("&lt;");
                        continue block11;
                    }
                    case '>': {
                        n.append("&gt;");
                        continue block11;
                    }
                    case '\"': {
                        if (forAttribute) {
                            n.append("&quot;");
                            continue block11;
                        }
                        n.append(c);
                        continue block11;
                    }
                    case '\'': {
                        if (forAttribute) {
                            n.append("&apos;");
                            continue block11;
                        }
                        n.append(c);
                        continue block11;
                    }
                    case '\r': {
                        if (forAttribute) {
                            if (i != length - 1 && text2.charAt(i + 1) == '\n') continue block11;
                            n.append("&#13;");
                            continue block11;
                        }
                        n.append(c);
                        continue block11;
                    }
                    case '\n': {
                        if (!forAttribute) continue block11;
                        n.append("&#10;");
                        continue block11;
                    }
                    default: {
                        n.append(c);
                    }
                }
            }
            if (forAttribute) {
                n.append(quoteChar);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String xmlEncodeTextAsCDATABlock(String text2) {
        if (text2 == null) {
            return null;
        }
        if (XMLEncode.isCompatibleWithCDATABlock(text2)) {
            return "<![CDATA[" + text2 + "]]>";
        }
        return null;
    }

    public static boolean needsEncoding(String text2) {
        return XMLEncode.needsEncoding(text2, false);
    }

    public static boolean needsEncoding(String data2, boolean checkForAttr) {
        if (data2 == null) {
            return false;
        }
        for (int i = 0; i < data2.length(); ++i) {
            char c = data2.charAt(i);
            if (c != '&' && c != '<' && (!checkForAttr || c != '\"' && c != '\'')) continue;
            return true;
        }
        return false;
    }

    public static boolean isCompatibleWithCDATABlock(String text2) {
        return text2 != null && !text2.contains("]]>");
    }

    public static String xmlDecodeTextToCDATA(String pcdata) {
        if (pcdata == null) {
            return null;
        }
        StringBuilder n = new StringBuilder(pcdata.length());
        for (int i = 0; i < pcdata.length(); ++i) {
            char c = pcdata.charAt(i);
            if (c == '&') {
                char c1 = XMLEncode.lookAhead(1, i, pcdata);
                char c2 = XMLEncode.lookAhead(2, i, pcdata);
                char c3 = XMLEncode.lookAhead(3, i, pcdata);
                char c4 = XMLEncode.lookAhead(4, i, pcdata);
                char c5 = XMLEncode.lookAhead(5, i, pcdata);
                if (c1 == 'a' && c2 == 'm' && c3 == 'p' && c4 == ';') {
                    n.append("&");
                    i += 4;
                    continue;
                }
                if (c1 == 'l' && c2 == 't' && c3 == ';') {
                    n.append("<");
                    i += 3;
                    continue;
                }
                if (c1 == 'g' && c2 == 't' && c3 == ';') {
                    n.append(">");
                    i += 3;
                    continue;
                }
                if (c1 == 'q' && c2 == 'u' && c3 == 'o' && c4 == 't' && c5 == ';') {
                    n.append("\"");
                    i += 5;
                    continue;
                }
                if (c1 == 'a' && c2 == 'p' && c3 == 'o' && c4 == 's' && c5 == ';') {
                    n.append("'");
                    i += 5;
                    continue;
                }
                n.append("&");
                continue;
            }
            n.append(c);
        }
        return n.toString();
    }

    private static char lookAhead(int la, int offset2, String data2) {
        try {
            return data2.charAt(offset2 + la);
        }
        catch (StringIndexOutOfBoundsException e) {
            return '\u0000';
        }
    }
}

