/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.DefaultLifecycles;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.lifecycle.LifecycleMappingDelegate;
import org.apache.maven.lifecycle.LifecycleNotFoundException;
import org.apache.maven.lifecycle.LifecyclePhaseNotFoundException;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.lifecycle.MojoExecutionConfigurator;
import org.apache.maven.lifecycle.internal.DefaultMojoExecutionConfigurator;
import org.apache.maven.lifecycle.internal.ExecutionPlanItem;
import org.apache.maven.lifecycle.internal.GoalTask;
import org.apache.maven.lifecycle.internal.LifecycleDependencyResolver;
import org.apache.maven.lifecycle.internal.LifecycleExecutionPlanCalculator;
import org.apache.maven.lifecycle.internal.LifecyclePluginResolver;
import org.apache.maven.lifecycle.internal.LifecycleTask;
import org.apache.maven.lifecycle.internal.MojoDescriptorCreator;
import org.apache.maven.lifecycle.internal.builder.BuilderCommon;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoNotFoundException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.lifecycle.Execution;
import org.apache.maven.plugin.lifecycle.Phase;
import org.apache.maven.plugin.prefix.NoPluginFoundForPrefixException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.plugin.version.PluginVersionResolver;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Component(role=LifecycleExecutionPlanCalculator.class)
public class DefaultLifecycleExecutionPlanCalculator
implements LifecycleExecutionPlanCalculator {
    @Requirement
    private PluginVersionResolver pluginVersionResolver;
    @Requirement
    private BuildPluginManager pluginManager;
    @Requirement
    private DefaultLifecycles defaultLifeCycles;
    @Requirement
    private MojoDescriptorCreator mojoDescriptorCreator;
    @Requirement
    private LifecyclePluginResolver lifecyclePluginResolver;
    @Requirement(hint="default")
    private LifecycleMappingDelegate standardDelegate;
    @Requirement
    private Map<String, LifecycleMappingDelegate> delegates;
    @Requirement
    private Map<String, MojoExecutionConfigurator> mojoExecutionConfigurators;

    public DefaultLifecycleExecutionPlanCalculator() {
    }

    public DefaultLifecycleExecutionPlanCalculator(BuildPluginManager pluginManager, DefaultLifecycles defaultLifeCycles, MojoDescriptorCreator mojoDescriptorCreator, LifecyclePluginResolver lifecyclePluginResolver) {
        this.pluginManager = pluginManager;
        this.defaultLifeCycles = defaultLifeCycles;
        this.mojoDescriptorCreator = mojoDescriptorCreator;
        this.lifecyclePluginResolver = lifecyclePluginResolver;
        this.mojoExecutionConfigurators = Collections.singletonMap("default", new DefaultMojoExecutionConfigurator());
    }

    @Override
    public MavenExecutionPlan calculateExecutionPlan(MavenSession session2, MavenProject project, List<Object> tasks, boolean setup) throws PluginNotFoundException, PluginResolutionException, LifecyclePhaseNotFoundException, PluginDescriptorParsingException, MojoNotFoundException, InvalidPluginDescriptorException, NoPluginFoundForPrefixException, LifecycleNotFoundException, PluginVersionResolutionException {
        this.lifecyclePluginResolver.resolveMissingPluginVersions(project, session2);
        List<MojoExecution> executions = this.calculateMojoExecutions(session2, project, tasks);
        if (setup) {
            this.setupMojoExecutions(session2, project, executions);
        }
        List<ExecutionPlanItem> planItem = ExecutionPlanItem.createExecutionPlanItems(project, executions);
        return new MavenExecutionPlan(planItem, this.defaultLifeCycles);
    }

    @Override
    public MavenExecutionPlan calculateExecutionPlan(MavenSession session2, MavenProject project, List<Object> tasks) throws PluginNotFoundException, PluginResolutionException, LifecyclePhaseNotFoundException, PluginDescriptorParsingException, MojoNotFoundException, InvalidPluginDescriptorException, NoPluginFoundForPrefixException, LifecycleNotFoundException, PluginVersionResolutionException {
        return this.calculateExecutionPlan(session2, project, tasks, true);
    }

    private void setupMojoExecutions(MavenSession session2, MavenProject project, List<MojoExecution> mojoExecutions) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, InvalidPluginDescriptorException, NoPluginFoundForPrefixException, LifecyclePhaseNotFoundException, LifecycleNotFoundException, PluginVersionResolutionException {
        for (MojoExecution mojoExecution : mojoExecutions) {
            this.setupMojoExecution(session2, project, mojoExecution);
        }
    }

    @Override
    public void setupMojoExecution(MavenSession session2, MavenProject project, MojoExecution mojoExecution) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, InvalidPluginDescriptorException, NoPluginFoundForPrefixException, LifecyclePhaseNotFoundException, LifecycleNotFoundException, PluginVersionResolutionException {
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        if (mojoDescriptor == null) {
            mojoDescriptor = this.pluginManager.getMojoDescriptor(mojoExecution.getPlugin(), mojoExecution.getGoal(), project.getRemotePluginRepositories(), session2.getRepositorySession());
            mojoExecution.setMojoDescriptor(mojoDescriptor);
        }
        this.mojoExecutionConfigurator(mojoExecution).configure(project, mojoExecution, MojoExecution.Source.CLI.equals((Object)mojoExecution.getSource()));
        this.finalizeMojoConfiguration(mojoExecution);
        this.calculateForkedExecutions(mojoExecution, session2, project, new HashSet<MojoDescriptor>());
    }

    public List<MojoExecution> calculateMojoExecutions(MavenSession session2, MavenProject project, List<Object> tasks) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, PluginVersionResolutionException, LifecyclePhaseNotFoundException {
        ArrayList<MojoExecution> mojoExecutions = new ArrayList<MojoExecution>();
        for (Object task : tasks) {
            if (task instanceof GoalTask) {
                String pluginGoal = ((GoalTask)task).pluginGoal;
                String executionId = "default-cli";
                int executionIdx = pluginGoal.indexOf(64);
                if (executionIdx > 0) {
                    executionId = pluginGoal.substring(executionIdx + 1);
                }
                MojoDescriptor mojoDescriptor = this.mojoDescriptorCreator.getMojoDescriptor(pluginGoal, session2, project);
                MojoExecution mojoExecution = new MojoExecution(mojoDescriptor, executionId, MojoExecution.Source.CLI);
                mojoExecutions.add(mojoExecution);
                continue;
            }
            if (task instanceof LifecycleTask) {
                String lifecyclePhase = ((LifecycleTask)task).getLifecyclePhase();
                Map<String, List<MojoExecution>> phaseToMojoMapping = this.calculateLifecycleMappings(session2, project, lifecyclePhase);
                for (List<MojoExecution> mojoExecutionsFromLifecycle : phaseToMojoMapping.values()) {
                    mojoExecutions.addAll(mojoExecutionsFromLifecycle);
                }
                continue;
            }
            throw new IllegalStateException("unexpected task " + task);
        }
        return mojoExecutions;
    }

    private Map<String, List<MojoExecution>> calculateLifecycleMappings(MavenSession session2, MavenProject project, String lifecyclePhase) throws LifecyclePhaseNotFoundException, PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, InvalidPluginDescriptorException {
        LifecycleMappingDelegate delegate2;
        Lifecycle lifecycle = this.defaultLifeCycles.get(lifecyclePhase);
        if (lifecycle == null) {
            throw new LifecyclePhaseNotFoundException("Unknown lifecycle phase \"" + lifecyclePhase + "\". You must specify a valid lifecycle phase or a goal in the format <plugin-prefix>:<goal> or <plugin-group-id>:<plugin-artifact-id>[:<plugin-version>]:<goal>. Available lifecycle phases are: " + this.defaultLifeCycles.getLifecyclePhaseList() + ".", lifecyclePhase);
        }
        if (Arrays.binarySearch(DefaultLifecycles.STANDARD_LIFECYCLES, lifecycle.getId()) >= 0) {
            delegate2 = this.standardDelegate;
        } else {
            delegate2 = this.delegates.get(lifecycle.getId());
            if (delegate2 == null) {
                delegate2 = this.standardDelegate;
            }
        }
        return delegate2.calculateLifecycleMappings(session2, project, lifecycle, lifecyclePhase);
    }

    private void finalizeMojoConfiguration(MojoExecution mojoExecution) {
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        Xpp3Dom executionConfiguration = mojoExecution.getConfiguration();
        if (executionConfiguration == null) {
            executionConfiguration = new Xpp3Dom("configuration");
        }
        Xpp3Dom defaultConfiguration = this.getMojoConfiguration(mojoDescriptor);
        Xpp3Dom finalConfiguration = new Xpp3Dom("configuration");
        if (mojoDescriptor.getParameters() != null) {
            for (Parameter parameter : mojoDescriptor.getParameters()) {
                Xpp3Dom parameterDefaults;
                Xpp3Dom parameterConfiguration = executionConfiguration.getChild(parameter.getName());
                if (parameterConfiguration == null) {
                    parameterConfiguration = executionConfiguration.getChild(parameter.getAlias());
                }
                if ((parameterConfiguration = Xpp3Dom.mergeXpp3Dom(parameterConfiguration, parameterDefaults = defaultConfiguration.getChild(parameter.getName()), Boolean.TRUE)) == null) continue;
                if (StringUtils.isEmpty((parameterConfiguration = new Xpp3Dom(parameterConfiguration, parameter.getName())).getAttribute("implementation")) && StringUtils.isNotEmpty(parameter.getImplementation())) {
                    parameterConfiguration.setAttribute("implementation", parameter.getImplementation());
                }
                finalConfiguration.addChild(parameterConfiguration);
            }
        }
        mojoExecution.setConfiguration(finalConfiguration);
    }

    private Xpp3Dom getMojoConfiguration(MojoDescriptor mojoDescriptor) {
        return MojoDescriptorCreator.convert(mojoDescriptor);
    }

    @Override
    public void calculateForkedExecutions(MojoExecution mojoExecution, MavenSession session2) throws MojoNotFoundException, PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, LifecyclePhaseNotFoundException, LifecycleNotFoundException, PluginVersionResolutionException {
        this.calculateForkedExecutions(mojoExecution, session2, session2.getCurrentProject(), new HashSet<MojoDescriptor>());
    }

    private void calculateForkedExecutions(MojoExecution mojoExecution, MavenSession session2, MavenProject project, Collection<MojoDescriptor> alreadyForkedExecutions) throws MojoNotFoundException, PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, LifecyclePhaseNotFoundException, LifecycleNotFoundException, PluginVersionResolutionException {
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        if (!mojoDescriptor.isForking()) {
            return;
        }
        if (!alreadyForkedExecutions.add(mojoDescriptor)) {
            return;
        }
        List<MavenProject> forkedProjects = LifecycleDependencyResolver.getProjects(project, session2, mojoDescriptor.isAggregator());
        for (MavenProject forkedProject : forkedProjects) {
            if (forkedProject != project) {
                this.lifecyclePluginResolver.resolveMissingPluginVersions(forkedProject, session2);
            }
            List<MojoExecution> forkedExecutions = StringUtils.isNotEmpty(mojoDescriptor.getExecutePhase()) ? this.calculateForkedLifecycle(mojoExecution, session2, forkedProject, alreadyForkedExecutions) : this.calculateForkedGoal(mojoExecution, session2, forkedProject, alreadyForkedExecutions);
            mojoExecution.setForkedExecutions(BuilderCommon.getKey(forkedProject), forkedExecutions);
        }
        alreadyForkedExecutions.remove(mojoDescriptor);
    }

    private List<MojoExecution> calculateForkedLifecycle(MojoExecution mojoExecution, MavenSession session2, MavenProject project, Collection<MojoDescriptor> alreadyForkedExecutions) throws MojoNotFoundException, PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, LifecyclePhaseNotFoundException, LifecycleNotFoundException, PluginVersionResolutionException {
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        String forkedPhase = mojoDescriptor.getExecutePhase();
        Map<String, List<MojoExecution>> lifecycleMappings = this.calculateLifecycleMappings(session2, project, forkedPhase);
        for (List<MojoExecution> forkedExecutions : lifecycleMappings.values()) {
            for (MojoExecution forkedExecution : forkedExecutions) {
                if (forkedExecution.getMojoDescriptor() == null) {
                    MojoDescriptor forkedMojoDescriptor = this.pluginManager.getMojoDescriptor(forkedExecution.getPlugin(), forkedExecution.getGoal(), project.getRemotePluginRepositories(), session2.getRepositorySession());
                    forkedExecution.setMojoDescriptor(forkedMojoDescriptor);
                }
                this.mojoExecutionConfigurator(forkedExecution).configure(project, forkedExecution, false);
            }
        }
        this.injectLifecycleOverlay(lifecycleMappings, mojoExecution, session2, project);
        ArrayList<MojoExecution> mojoExecutions = new ArrayList<MojoExecution>();
        for (List<MojoExecution> forkedExecutions : lifecycleMappings.values()) {
            for (MojoExecution forkedExecution : forkedExecutions) {
                if (alreadyForkedExecutions.contains(forkedExecution.getMojoDescriptor())) continue;
                this.finalizeMojoConfiguration(forkedExecution);
                this.calculateForkedExecutions(forkedExecution, session2, project, alreadyForkedExecutions);
                mojoExecutions.add(forkedExecution);
            }
        }
        return mojoExecutions;
    }

    private void injectLifecycleOverlay(Map<String, List<MojoExecution>> lifecycleMappings, MojoExecution mojoExecution, MavenSession session2, MavenProject project) throws PluginDescriptorParsingException, LifecycleNotFoundException, MojoNotFoundException, PluginNotFoundException, PluginResolutionException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, PluginVersionResolutionException {
        org.apache.maven.plugin.lifecycle.Lifecycle lifecycleOverlay;
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        PluginDescriptor pluginDescriptor = mojoDescriptor.getPluginDescriptor();
        String forkedLifecycle = mojoDescriptor.getExecuteLifecycle();
        if (StringUtils.isEmpty(forkedLifecycle)) {
            return;
        }
        try {
            lifecycleOverlay = pluginDescriptor.getLifecycleMapping(forkedLifecycle);
        }
        catch (IOException | XmlPullParserException e) {
            throw new PluginDescriptorParsingException(pluginDescriptor.getPlugin(), pluginDescriptor.getSource(), e);
        }
        if (lifecycleOverlay == null) {
            throw new LifecycleNotFoundException(forkedLifecycle);
        }
        for (Phase phase : lifecycleOverlay.getPhases()) {
            List<MojoExecution> forkedExecutions = lifecycleMappings.get(phase.getId());
            if (forkedExecutions == null) continue;
            for (Execution execution : phase.getExecutions()) {
                for (String goal : execution.getGoals()) {
                    MojoDescriptor forkedMojoDescriptor;
                    if (goal.indexOf(58) < 0) {
                        forkedMojoDescriptor = pluginDescriptor.getMojo(goal);
                        if (forkedMojoDescriptor == null) {
                            throw new MojoNotFoundException(goal, pluginDescriptor);
                        }
                    } else {
                        forkedMojoDescriptor = this.mojoDescriptorCreator.getMojoDescriptor(goal, session2, project);
                    }
                    MojoExecution forkedExecution = new MojoExecution(forkedMojoDescriptor, mojoExecution.getExecutionId());
                    Xpp3Dom forkedConfiguration = (Xpp3Dom)execution.getConfiguration();
                    forkedExecution.setConfiguration(forkedConfiguration);
                    this.mojoExecutionConfigurator(forkedExecution).configure(project, forkedExecution, true);
                    forkedExecutions.add(forkedExecution);
                }
            }
            Xpp3Dom phaseConfiguration = (Xpp3Dom)phase.getConfiguration();
            if (phaseConfiguration == null) continue;
            for (MojoExecution forkedExecution : forkedExecutions) {
                Xpp3Dom forkedConfiguration = forkedExecution.getConfiguration();
                forkedConfiguration = Xpp3Dom.mergeXpp3Dom(phaseConfiguration, forkedConfiguration);
                forkedExecution.setConfiguration(forkedConfiguration);
            }
        }
    }

    private List<MojoExecution> calculateForkedGoal(MojoExecution mojoExecution, MavenSession session2, MavenProject project, Collection<MojoDescriptor> alreadyForkedExecutions) throws MojoNotFoundException, PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, LifecyclePhaseNotFoundException, LifecycleNotFoundException, PluginVersionResolutionException {
        String forkedGoal;
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        PluginDescriptor pluginDescriptor = mojoDescriptor.getPluginDescriptor();
        MojoDescriptor forkedMojoDescriptor = pluginDescriptor.getMojo(forkedGoal = mojoDescriptor.getExecuteGoal());
        if (forkedMojoDescriptor == null) {
            throw new MojoNotFoundException(forkedGoal, pluginDescriptor);
        }
        if (alreadyForkedExecutions.contains(forkedMojoDescriptor)) {
            return Collections.emptyList();
        }
        MojoExecution forkedExecution = new MojoExecution(forkedMojoDescriptor, forkedGoal);
        this.mojoExecutionConfigurator(forkedExecution).configure(project, forkedExecution, true);
        this.finalizeMojoConfiguration(forkedExecution);
        this.calculateForkedExecutions(forkedExecution, session2, project, alreadyForkedExecutions);
        return Collections.singletonList(forkedExecution);
    }

    private MojoExecutionConfigurator mojoExecutionConfigurator(MojoExecution mojoExecution) {
        MojoExecutionConfigurator mojoExecutionConfigurator;
        String configuratorId = mojoExecution.getMojoDescriptor().getComponentConfigurator();
        if (configuratorId == null) {
            configuratorId = "default";
        }
        if ((mojoExecutionConfigurator = this.mojoExecutionConfigurators.get(configuratorId)) == null) {
            mojoExecutionConfigurator = this.mojoExecutionConfigurators.get("default");
        }
        return mojoExecutionConfigurator;
    }
}

