/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.net.URI;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RedirectLocations
extends AbstractList<Object> {
    private final Set<URI> unique = new HashSet<URI>();
    private final List<URI> all = new ArrayList<URI>();

    public boolean contains(URI uri) {
        return this.unique.contains(uri);
    }

    public void add(URI uri) {
        this.unique.add(uri);
        this.all.add(uri);
    }

    public boolean remove(URI uri) {
        boolean removed2 = this.unique.remove(uri);
        if (removed2) {
            Iterator<URI> it = this.all.iterator();
            while (it.hasNext()) {
                URI current = it.next();
                if (!current.equals(uri)) continue;
                it.remove();
            }
        }
        return removed2;
    }

    public List<URI> getAll() {
        return new ArrayList<URI>(this.all);
    }

    @Override
    public URI get(int index2) {
        return this.all.get(index2);
    }

    @Override
    public int size() {
        return this.all.size();
    }

    @Override
    public Object set(int index2, Object element) {
        URI removed2 = this.all.set(index2, (URI)element);
        this.unique.remove(removed2);
        this.unique.add((URI)element);
        if (this.all.size() != this.unique.size()) {
            this.unique.addAll(this.all);
        }
        return removed2;
    }

    @Override
    public void add(int index2, Object element) {
        this.all.add(index2, (URI)element);
        this.unique.add((URI)element);
    }

    @Override
    public URI remove(int index2) {
        URI removed2 = this.all.remove(index2);
        this.unique.remove(removed2);
        if (this.all.size() != this.unique.size()) {
            this.unique.addAll(this.all);
        }
        return removed2;
    }

    @Override
    public boolean contains(Object o) {
        return this.unique.contains(o);
    }
}

