/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime;

import java.util.BitSet;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.atn.ATNConfig;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.misc.Interval;

public class DiagnosticErrorListener
extends BaseErrorListener {
    protected final boolean exactOnly;

    public DiagnosticErrorListener() {
        this(true);
    }

    public DiagnosticErrorListener(boolean exactOnly) {
        this.exactOnly = exactOnly;
    }

    @Override
    public void reportAmbiguity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, boolean exact, BitSet ambigAlts, ATNConfigSet configs) {
        if (this.exactOnly && !exact) {
            return;
        }
        String format2 = "reportAmbiguity d=%s: ambigAlts=%s, input='%s'";
        String decision = this.getDecisionDescription(recognizer, dfa);
        BitSet conflictingAlts = this.getConflictingAlts(ambigAlts, configs);
        String text2 = recognizer.getTokenStream().getText(Interval.of(startIndex, stopIndex));
        String message2 = String.format(format2, decision, conflictingAlts, text2);
        recognizer.notifyErrorListeners(message2);
    }

    @Override
    public void reportAttemptingFullContext(Parser recognizer, DFA dfa, int startIndex, int stopIndex, BitSet conflictingAlts, ATNConfigSet configs) {
        String format2 = "reportAttemptingFullContext d=%s, input='%s'";
        String decision = this.getDecisionDescription(recognizer, dfa);
        String text2 = recognizer.getTokenStream().getText(Interval.of(startIndex, stopIndex));
        String message2 = String.format(format2, decision, text2);
        recognizer.notifyErrorListeners(message2);
    }

    @Override
    public void reportContextSensitivity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, int prediction, ATNConfigSet configs) {
        String format2 = "reportContextSensitivity d=%s, input='%s'";
        String decision = this.getDecisionDescription(recognizer, dfa);
        String text2 = recognizer.getTokenStream().getText(Interval.of(startIndex, stopIndex));
        String message2 = String.format(format2, decision, text2);
        recognizer.notifyErrorListeners(message2);
    }

    protected String getDecisionDescription(Parser recognizer, DFA dfa) {
        int decision = dfa.decision;
        int ruleIndex = dfa.atnStartState.ruleIndex;
        String[] ruleNames = recognizer.getRuleNames();
        if (ruleIndex < 0 || ruleIndex >= ruleNames.length) {
            return String.valueOf(decision);
        }
        String ruleName = ruleNames[ruleIndex];
        if (ruleName == null || ruleName.isEmpty()) {
            return String.valueOf(decision);
        }
        return String.format("%d (%s)", decision, ruleName);
    }

    protected BitSet getConflictingAlts(BitSet reportedAlts, ATNConfigSet configs) {
        if (reportedAlts != null) {
            return reportedAlts;
        }
        BitSet result2 = new BitSet();
        for (ATNConfig config : configs) {
            result2.set(config.alt);
        }
        return result2;
    }
}

