/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin.header;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmMetadataVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class KotlinClassHeader {
    @NotNull
    private final Kind kind;
    @NotNull
    private final JvmMetadataVersion metadataVersion;
    @Nullable
    private final String[] data;
    @Nullable
    private final String[] incompatibleData;
    @Nullable
    private final String[] strings;
    @Nullable
    private final String extraString;
    private final int extraInt;
    @Nullable
    private final String packageName;
    @Nullable
    private final byte[] serializedIr;

    public KotlinClassHeader(@NotNull Kind kind, @NotNull JvmMetadataVersion metadataVersion, @Nullable String[] data2, @Nullable String[] incompatibleData, @Nullable String[] strings2, @Nullable String extraString, int extraInt, @Nullable String packageName, @Nullable byte[] serializedIr) {
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        Intrinsics.checkNotNullParameter(metadataVersion, "metadataVersion");
        this.kind = kind;
        this.metadataVersion = metadataVersion;
        this.data = data2;
        this.incompatibleData = incompatibleData;
        this.strings = strings2;
        this.extraString = extraString;
        this.extraInt = extraInt;
        this.packageName = packageName;
        this.serializedIr = serializedIr;
    }

    @NotNull
    public final Kind getKind() {
        return this.kind;
    }

    @NotNull
    public final JvmMetadataVersion getMetadataVersion() {
        return this.metadataVersion;
    }

    @Nullable
    public final String[] getData() {
        return this.data;
    }

    @Nullable
    public final String[] getIncompatibleData() {
        return this.incompatibleData;
    }

    @Nullable
    public final String[] getStrings() {
        return this.strings;
    }

    @Nullable
    public final String getMultifileClassName() {
        String string2;
        String it = string2 = this.extraString;
        boolean bl = false;
        return this.getKind() == Kind.MULTIFILE_CLASS_PART ? string2 : null;
    }

    @NotNull
    public final List<String> getMultifilePartNames() {
        Object object;
        String[] it = object = this.data;
        boolean bl = false;
        String[] stringArray = this.getKind() == Kind.MULTIFILE_CLASS ? object : null;
        object = stringArray == null ? null : ArraysKt.asList(stringArray);
        return object == null ? CollectionsKt.emptyList() : object;
    }

    public final boolean isUnstableJvmIrBinary() {
        return this.has(this.extraInt, 16) && !this.has(this.extraInt, 32);
    }

    public final boolean isUnstableFirBinary() {
        return this.has(this.extraInt, 64) && !this.has(this.extraInt, 32);
    }

    public final boolean isPreRelease() {
        return this.has(this.extraInt, 2);
    }

    @NotNull
    public String toString() {
        return (Object)((Object)this.kind) + " version=" + this.metadataVersion;
    }

    private final boolean has(int $this$has, int flag) {
        return ($this$has & flag) != 0;
    }

    public static final class Kind
    extends Enum<Kind> {
        @NotNull
        public static final Companion Companion;
        private final int id;
        @NotNull
        private static final Map<Integer, Kind> entryById;
        public static final /* enum */ Kind UNKNOWN;
        public static final /* enum */ Kind CLASS;
        public static final /* enum */ Kind FILE_FACADE;
        public static final /* enum */ Kind SYNTHETIC_CLASS;
        public static final /* enum */ Kind MULTIFILE_CLASS;
        public static final /* enum */ Kind MULTIFILE_CLASS_PART;
        private static final /* synthetic */ Kind[] $VALUES;

        private Kind(int id) {
            this.id = id;
        }

        public final int getId() {
            return this.id;
        }

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String value2) {
            return Enum.valueOf(Kind.class, value2);
        }

        @JvmStatic
        @NotNull
        public static final Kind getById(int id) {
            return Companion.getById(id);
        }

        /*
         * WARNING - void declaration
         */
        static {
            void $this$associateByTo$iv$iv;
            UNKNOWN = new Kind(0);
            CLASS = new Kind(1);
            FILE_FACADE = new Kind(2);
            SYNTHETIC_CLASS = new Kind(3);
            MULTIFILE_CLASS = new Kind(4);
            MULTIFILE_CLASS_PART = new Kind(5);
            $VALUES = kindArray = new Kind[]{Kind.UNKNOWN, Kind.CLASS, Kind.FILE_FACADE, Kind.SYNTHETIC_CLASS, Kind.MULTIFILE_CLASS, Kind.MULTIFILE_CLASS_PART};
            Companion = new Companion(null);
            Kind[] $this$associateBy$iv = Kind.values();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity($this$associateBy$iv.length), 16);
            Kind[] kindArray = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (void element$iv$iv : $this$associateByTo$iv$iv) {
                void p0;
                void var10_10 = element$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                Integer n = p0.getId();
                map2.put(n, element$iv$iv);
            }
            entryById = destination$iv$iv;
        }

        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final Kind getById(int id) {
                Kind kind = (Kind)((Object)entryById.get(id));
                return kind == null ? UNKNOWN : kind;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

