/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.ForwardingGraph;
import com.google.common.graph.ForwardingNetwork;
import com.google.common.graph.ForwardingValueGraph;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.MutableValueGraph;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import com.google.common.graph.ValueGraph;
import com.google.common.graph.ValueGraphBuilder;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

@Beta
public final class Graphs {
    private Graphs() {
    }

    public static <N> boolean hasCycle(Graph<N> graph2) {
        int numEdges = graph2.edges().size();
        if (numEdges == 0) {
            return false;
        }
        if (!graph2.isDirected() && numEdges >= graph2.nodes().size()) {
            return true;
        }
        HashMap<Object, NodeVisitState> visitedNodes = Maps.newHashMapWithExpectedSize(graph2.nodes().size());
        for (N node : graph2.nodes()) {
            if (!Graphs.subgraphHasCycle(graph2, visitedNodes, node, null)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasCycle(Network<?, ?> network) {
        if (!network.isDirected() && network.allowsParallelEdges() && network.edges().size() > network.asGraph().edges().size()) {
            return true;
        }
        return Graphs.hasCycle(network.asGraph());
    }

    private static <N> boolean subgraphHasCycle(Graph<N> graph2, Map<Object, NodeVisitState> visitedNodes, N node, @NullableDecl N previousNode) {
        NodeVisitState state = visitedNodes.get(node);
        if (state == NodeVisitState.COMPLETE) {
            return false;
        }
        if (state == NodeVisitState.PENDING) {
            return true;
        }
        visitedNodes.put(node, NodeVisitState.PENDING);
        for (N nextNode : graph2.successors(node)) {
            if (!Graphs.canTraverseWithoutReusingEdge(graph2, nextNode, previousNode) || !Graphs.subgraphHasCycle(graph2, visitedNodes, nextNode, node)) continue;
            return true;
        }
        visitedNodes.put(node, NodeVisitState.COMPLETE);
        return false;
    }

    private static boolean canTraverseWithoutReusingEdge(Graph<?> graph2, Object nextNode, @NullableDecl Object previousNode) {
        return graph2.isDirected() || !Objects.equal(previousNode, nextNode);
    }

    public static <N> Graph<N> transitiveClosure(Graph<N> graph2) {
        MutableGraph transitiveClosure = GraphBuilder.from(graph2).allowsSelfLoops(true).build();
        if (graph2.isDirected()) {
            for (N node : graph2.nodes()) {
                for (N reachableNode : Graphs.reachableNodes(graph2, node)) {
                    transitiveClosure.putEdge(node, reachableNode);
                }
            }
        } else {
            HashSet<N> visitedNodes = new HashSet<N>();
            for (N node : graph2.nodes()) {
                if (visitedNodes.contains(node)) continue;
                Set<N> reachableNodes = Graphs.reachableNodes(graph2, node);
                visitedNodes.addAll(reachableNodes);
                int pairwiseMatch = 1;
                for (N nodeU : reachableNodes) {
                    for (N nodeV : Iterables.limit(reachableNodes, pairwiseMatch++)) {
                        transitiveClosure.putEdge(nodeU, nodeV);
                    }
                }
            }
        }
        return transitiveClosure;
    }

    public static <N> Set<N> reachableNodes(Graph<N> graph2, N node) {
        Preconditions.checkArgument(graph2.nodes().contains(node), "Node %s is not an element of this graph.", node);
        LinkedHashSet<N> visitedNodes = new LinkedHashSet<N>();
        ArrayDeque<N> queuedNodes = new ArrayDeque<N>();
        visitedNodes.add(node);
        queuedNodes.add(node);
        while (!queuedNodes.isEmpty()) {
            Object currentNode = queuedNodes.remove();
            for (N successor : graph2.successors(currentNode)) {
                if (!visitedNodes.add(successor)) continue;
                queuedNodes.add(successor);
            }
        }
        return Collections.unmodifiableSet(visitedNodes);
    }

    public static <N> Graph<N> transpose(Graph<N> graph2) {
        if (!graph2.isDirected()) {
            return graph2;
        }
        if (graph2 instanceof TransposedGraph) {
            return ((TransposedGraph)graph2).graph;
        }
        return new TransposedGraph<N>(graph2);
    }

    public static <N, V> ValueGraph<N, V> transpose(ValueGraph<N, V> graph2) {
        if (!graph2.isDirected()) {
            return graph2;
        }
        if (graph2 instanceof TransposedValueGraph) {
            return ((TransposedValueGraph)graph2).graph;
        }
        return new TransposedValueGraph<N, V>(graph2);
    }

    public static <N, E> Network<N, E> transpose(Network<N, E> network) {
        if (!network.isDirected()) {
            return network;
        }
        if (network instanceof TransposedNetwork) {
            return ((TransposedNetwork)network).network;
        }
        return new TransposedNetwork<N, E>(network);
    }

    public static <N> MutableGraph<N> inducedSubgraph(Graph<N> graph2, Iterable<? extends N> nodes) {
        MutableGraph subgraph = nodes instanceof Collection ? GraphBuilder.from(graph2).expectedNodeCount(((Collection)nodes).size()).build() : GraphBuilder.from(graph2).build();
        for (Object node : nodes) {
            subgraph.addNode(node);
        }
        for (Object node : subgraph.nodes()) {
            for (N successorNode : graph2.successors(node)) {
                if (!subgraph.nodes().contains(successorNode)) continue;
                subgraph.putEdge(node, successorNode);
            }
        }
        return subgraph;
    }

    public static <N, V> MutableValueGraph<N, V> inducedSubgraph(ValueGraph<N, V> graph2, Iterable<? extends N> nodes) {
        MutableValueGraph subgraph = nodes instanceof Collection ? ValueGraphBuilder.from(graph2).expectedNodeCount(((Collection)nodes).size()).build() : ValueGraphBuilder.from(graph2).build();
        for (Object node : nodes) {
            subgraph.addNode(node);
        }
        for (Object node : subgraph.nodes()) {
            for (N successorNode : graph2.successors(node)) {
                if (!subgraph.nodes().contains(successorNode)) continue;
                subgraph.putEdgeValue(node, successorNode, graph2.edgeValueOrDefault(node, successorNode, null));
            }
        }
        return subgraph;
    }

    public static <N, E> MutableNetwork<N, E> inducedSubgraph(Network<N, E> network, Iterable<? extends N> nodes) {
        MutableNetwork subgraph = nodes instanceof Collection ? NetworkBuilder.from(network).expectedNodeCount(((Collection)nodes).size()).build() : NetworkBuilder.from(network).build();
        for (Object node : nodes) {
            subgraph.addNode(node);
        }
        for (Object node : subgraph.nodes()) {
            for (E edge : network.outEdges(node)) {
                N successorNode = network.incidentNodes(edge).adjacentNode(node);
                if (!subgraph.nodes().contains(successorNode)) continue;
                subgraph.addEdge(node, successorNode, edge);
            }
        }
        return subgraph;
    }

    public static <N> MutableGraph<N> copyOf(Graph<N> graph2) {
        MutableGraph copy2 = GraphBuilder.from(graph2).expectedNodeCount(graph2.nodes().size()).build();
        for (N n : graph2.nodes()) {
            copy2.addNode(n);
        }
        for (EndpointPair endpointPair : graph2.edges()) {
            copy2.putEdge(endpointPair.nodeU(), endpointPair.nodeV());
        }
        return copy2;
    }

    public static <N, V> MutableValueGraph<N, V> copyOf(ValueGraph<N, V> graph2) {
        MutableValueGraph copy2 = ValueGraphBuilder.from(graph2).expectedNodeCount(graph2.nodes().size()).build();
        for (Object n : graph2.nodes()) {
            copy2.addNode(n);
        }
        for (EndpointPair endpointPair : graph2.edges()) {
            copy2.putEdgeValue(endpointPair.nodeU(), endpointPair.nodeV(), graph2.edgeValueOrDefault(endpointPair.nodeU(), endpointPair.nodeV(), null));
        }
        return copy2;
    }

    public static <N, E> MutableNetwork<N, E> copyOf(Network<N, E> network) {
        MutableNetwork copy2 = NetworkBuilder.from(network).expectedNodeCount(network.nodes().size()).expectedEdgeCount(network.edges().size()).build();
        for (N node : network.nodes()) {
            copy2.addNode(node);
        }
        for (Object edge : network.edges()) {
            EndpointPair<N> endpointPair = network.incidentNodes(edge);
            copy2.addEdge(endpointPair.nodeU(), endpointPair.nodeV(), edge);
        }
        return copy2;
    }

    @CanIgnoreReturnValue
    static int checkNonNegative(int value2) {
        Preconditions.checkArgument(value2 >= 0, "Not true that %s is non-negative.", value2);
        return value2;
    }

    @CanIgnoreReturnValue
    static long checkNonNegative(long value2) {
        Preconditions.checkArgument(value2 >= 0L, "Not true that %s is non-negative.", value2);
        return value2;
    }

    @CanIgnoreReturnValue
    static int checkPositive(int value2) {
        Preconditions.checkArgument(value2 > 0, "Not true that %s is positive.", value2);
        return value2;
    }

    @CanIgnoreReturnValue
    static long checkPositive(long value2) {
        Preconditions.checkArgument(value2 > 0L, "Not true that %s is positive.", value2);
        return value2;
    }

    private static enum NodeVisitState {
        PENDING,
        COMPLETE;

    }

    private static class TransposedNetwork<N, E>
    extends ForwardingNetwork<N, E> {
        private final Network<N, E> network;

        TransposedNetwork(Network<N, E> network) {
            this.network = network;
        }

        @Override
        protected Network<N, E> delegate() {
            return this.network;
        }

        @Override
        public Set<N> predecessors(N node) {
            return this.delegate().successors(node);
        }

        @Override
        public Set<N> successors(N node) {
            return this.delegate().predecessors(node);
        }

        @Override
        public int inDegree(N node) {
            return this.delegate().outDegree(node);
        }

        @Override
        public int outDegree(N node) {
            return this.delegate().inDegree(node);
        }

        @Override
        public Set<E> inEdges(N node) {
            return this.delegate().outEdges(node);
        }

        @Override
        public Set<E> outEdges(N node) {
            return this.delegate().inEdges(node);
        }

        @Override
        public EndpointPair<N> incidentNodes(E edge) {
            EndpointPair<N> endpointPair = this.delegate().incidentNodes(edge);
            return EndpointPair.of(this.network, endpointPair.nodeV(), endpointPair.nodeU());
        }

        @Override
        public Set<E> edgesConnecting(N nodeU, N nodeV) {
            return this.delegate().edgesConnecting(nodeV, nodeU);
        }

        @Override
        public E edgeConnectingOrNull(N nodeU, N nodeV) {
            return this.delegate().edgeConnectingOrNull(nodeV, nodeU);
        }

        @Override
        public boolean hasEdgeConnecting(N nodeU, N nodeV) {
            return this.delegate().hasEdgeConnecting(nodeV, nodeU);
        }
    }

    private static class TransposedValueGraph<N, V>
    extends ForwardingValueGraph<N, V> {
        private final ValueGraph<N, V> graph;

        TransposedValueGraph(ValueGraph<N, V> graph2) {
            this.graph = graph2;
        }

        @Override
        protected ValueGraph<N, V> delegate() {
            return this.graph;
        }

        @Override
        public Set<N> predecessors(N node) {
            return this.delegate().successors(node);
        }

        @Override
        public Set<N> successors(N node) {
            return this.delegate().predecessors(node);
        }

        @Override
        public int inDegree(N node) {
            return this.delegate().outDegree(node);
        }

        @Override
        public int outDegree(N node) {
            return this.delegate().inDegree(node);
        }

        @Override
        public boolean hasEdgeConnecting(N nodeU, N nodeV) {
            return this.delegate().hasEdgeConnecting(nodeV, nodeU);
        }

        @Override
        @NullableDecl
        public V edgeValueOrDefault(N nodeU, N nodeV, @NullableDecl V defaultValue2) {
            return this.delegate().edgeValueOrDefault(nodeV, nodeU, defaultValue2);
        }
    }

    private static class TransposedGraph<N>
    extends ForwardingGraph<N> {
        private final Graph<N> graph;

        TransposedGraph(Graph<N> graph2) {
            this.graph = graph2;
        }

        @Override
        protected Graph<N> delegate() {
            return this.graph;
        }

        @Override
        public Set<N> predecessors(N node) {
            return this.delegate().successors(node);
        }

        @Override
        public Set<N> successors(N node) {
            return this.delegate().predecessors(node);
        }

        @Override
        public int inDegree(N node) {
            return this.delegate().outDegree(node);
        }

        @Override
        public int outDegree(N node) {
            return this.delegate().inDegree(node);
        }

        @Override
        public boolean hasEdgeConnecting(N nodeU, N nodeV) {
            return this.delegate().hasEdgeConnecting(nodeV, nodeU);
        }
    }
}

