/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runner;

import java.util.Comparator;
import org.junit.internal.requests.ClassRequest;
import org.junit.internal.requests.ClassesRequest;
import org.junit.internal.requests.ErrorReportingRequest;
import org.junit.internal.requests.FilterRequest;
import org.junit.internal.requests.SortingRequest;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Request {
    public static Request method(Class<?> clazz, String methodName) {
        Description method = Description.createTestDescription(clazz, methodName);
        return Request.aClass(clazz).filterWith(method);
    }

    public static Request aClass(Class<?> clazz) {
        return new ClassRequest(clazz);
    }

    public static Request classes(String collectionName, Class ... classes2) {
        return new ClassesRequest(collectionName, classes2);
    }

    public static Request errorReport(Class<?> klass, Throwable cause) {
        return new ErrorReportingRequest(klass, cause);
    }

    public abstract Runner getRunner();

    public Request filterWith(Filter filter2) {
        return new FilterRequest(this, filter2);
    }

    public Request filterWith(final Description desiredDescription) {
        return this.filterWith(new Filter(){

            public boolean shouldRun(Description description2) {
                if (description2.isTest()) {
                    return desiredDescription.equals(description2);
                }
                for (Description each : description2.getChildren()) {
                    if (!this.shouldRun(each)) continue;
                    return true;
                }
                return false;
            }

            public String describe() {
                return String.format("Method %s", desiredDescription.getDisplayName());
            }
        });
    }

    public Request sortWith(Comparator<Description> comparator) {
        return new SortingRequest(this, comparator);
    }
}

