/*
 * Decompiled with CFR 0.152.
 */
package org.junit;

import org.junit.ComparisonFailure;

public class Assert {
    protected Assert() {
    }

    public static void assertTrue(String message2, boolean condition) {
        if (!condition) {
            Assert.fail(message2);
        }
    }

    public static void assertTrue(boolean condition) {
        Assert.assertTrue(null, condition);
    }

    public static void assertFalse(String message2, boolean condition) {
        Assert.assertTrue(message2, !condition);
    }

    public static void assertFalse(boolean condition) {
        Assert.assertFalse(null, condition);
    }

    public static void fail(String message2) {
        throw new AssertionError((Object)message2);
    }

    public static void fail() {
        Assert.fail(null);
    }

    public static void assertEquals(String message2, Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        if (expected instanceof String && actual instanceof String) {
            throw new ComparisonFailure(message2, (String)expected, (String)actual);
        }
        Assert.failNotEquals(message2, expected, actual);
    }

    public static void assertEquals(Object expected, Object actual) {
        Assert.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message2, Object[] expecteds, Object[] actuals) {
        String header;
        if (expecteds == actuals) {
            return;
        }
        String string2 = header = message2 == null ? "" : String.valueOf(message2) + ": ";
        if (expecteds == null) {
            Assert.fail(String.valueOf(header) + "expected array was null");
        }
        if (actuals == null) {
            Assert.fail(String.valueOf(header) + "actual array was null");
        }
        if (actuals.length != expecteds.length) {
            Assert.fail(String.valueOf(header) + "array lengths differed, expected.length=" + expecteds.length + " actual.length=" + actuals.length);
        }
        int i = 0;
        while (i < expecteds.length) {
            Object o1 = expecteds[i];
            Object o2 = actuals[i];
            if (o1.getClass().isArray() && o2.getClass().isArray()) {
                Object[] expected = (Object[])o1;
                Object[] actual = (Object[])o2;
                Assert.assertEquals(String.valueOf(header) + "arrays first differed at element " + i + ";", expected, actual);
            } else {
                Assert.assertEquals(String.valueOf(header) + "arrays first differed at element [" + i + "];", o1, o2);
            }
            ++i;
        }
    }

    public static void assertEquals(Object[] expecteds, Object[] actuals) {
        Assert.assertEquals(null, expecteds, actuals);
    }

    public static void assertEquals(String message2, double expected, double actual, double delta) {
        if (Double.compare(expected, actual) == 0) {
            return;
        }
        if (!(Math.abs(expected - actual) <= delta)) {
            Assert.failNotEquals(message2, new Double(expected), new Double(actual));
        }
    }

    public static void assertEquals(double expected, double actual, double delta) {
        Assert.assertEquals(null, expected, actual, delta);
    }

    public static void assertEquals(String message2, float expected, float actual, float delta) {
        if (Float.compare(expected, actual) == 0) {
            return;
        }
        if (!(Math.abs(expected - actual) <= delta)) {
            Assert.failNotEquals(message2, new Float(expected), new Float(actual));
        }
    }

    public static void assertEquals(float expected, float actual, float delta) {
        Assert.assertEquals(null, expected, actual, delta);
    }

    public static void assertNotNull(String message2, Object object) {
        Assert.assertTrue(message2, object != null);
    }

    public static void assertNotNull(Object object) {
        Assert.assertNotNull(null, object);
    }

    public static void assertNull(String message2, Object object) {
        Assert.assertTrue(message2, object == null);
    }

    public static void assertNull(Object object) {
        Assert.assertNull(null, object);
    }

    public static void assertSame(String message2, Object expected, Object actual) {
        if (expected == actual) {
            return;
        }
        Assert.failNotSame(message2, expected, actual);
    }

    public static void assertSame(Object expected, Object actual) {
        Assert.assertSame(null, expected, actual);
    }

    public static void assertNotSame(String message2, Object expected, Object actual) {
        if (expected == actual) {
            Assert.failSame(message2);
        }
    }

    public static void assertNotSame(Object expected, Object actual) {
        Assert.assertNotSame(null, expected, actual);
    }

    private static void failSame(String message2) {
        String formatted = "";
        if (message2 != null) {
            formatted = String.valueOf(message2) + " ";
        }
        Assert.fail(String.valueOf(formatted) + "expected not same");
    }

    private static void failNotSame(String message2, Object expected, Object actual) {
        String formatted = "";
        if (message2 != null) {
            formatted = String.valueOf(message2) + " ";
        }
        Assert.fail(String.valueOf(formatted) + "expected same:<" + expected + "> was not:<" + actual + ">");
    }

    private static void failNotEquals(String message2, Object expected, Object actual) {
        Assert.fail(Assert.format(message2, expected, actual));
    }

    static String format(String message2, Object expected, Object actual) {
        String formatted = "";
        if (message2 != null) {
            formatted = String.valueOf(message2) + " ";
        }
        return String.valueOf(formatted) + "expected:<" + expected + "> but was:<" + actual + ">";
    }
}

