/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.sam;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.sam.SamConversionOracle;
import org.jetbrains.kotlin.resolve.sam.SamConversionResolver;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutionKt;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a \u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\"\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0010\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0013\u001a\u00020\u0004\u001a\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u0006\u001a\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0018"}, d2={"getAbstractMembers", "", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getFunctionTypeForAbstractMethod", "Lorg/jetbrains/kotlin/types/SimpleType;", "function", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "shouldConvertFirstParameterToDescriptor", "", "getFunctionTypeForSamType", "Lorg/jetbrains/kotlin/types/KotlinType;", "samType", "samResolver", "Lorg/jetbrains/kotlin/resolve/sam/SamConversionResolver;", "samConversionOracle", "Lorg/jetbrains/kotlin/resolve/sam/SamConversionOracle;", "getSingleAbstractMethodOrNull", "klass", "nonProjectionParametrization", "getFunctionTypeForPossibleSamType", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "possibleSamType", "descriptors"})
public final class SamConversionResolverImplKt {
    @Nullable
    public static final FunctionDescriptor getSingleAbstractMethodOrNull(@NotNull ClassDescriptor klass) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        String string2 = DescriptorUtilsKt.getFqNameSafe(klass).asString();
        Intrinsics.checkNotNullExpressionValue(string2, "klass.fqNameSafe.asString()");
        if (StringsKt.endsWith$default(string2, ".databinding.DataBindingComponent", false, 2, null)) {
            return null;
        }
        if (klass.isDefinitelyNotSamInterface()) {
            return null;
        }
        CallableMemberDescriptor callableMemberDescriptor = CollectionsKt.singleOrNull(SamConversionResolverImplKt.getAbstractMembers(klass));
        if (callableMemberDescriptor == null) {
            return null;
        }
        CallableMemberDescriptor abstractMember = callableMemberDescriptor;
        return abstractMember instanceof SimpleFunctionDescriptor && ((SimpleFunctionDescriptor)abstractMember).getTypeParameters().isEmpty() ? (FunctionDescriptor)abstractMember : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<CallableMemberDescriptor> getAbstractMembers(@NotNull ClassDescriptor classDescriptor) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(classDescriptor, "classDescriptor");
        Collection<DeclarationDescriptor> collection = DescriptorUtils.getAllDescriptors(classDescriptor.getUnsubstitutedMemberScope());
        Intrinsics.checkNotNullExpressionValue(collection, "getAllDescriptors(classD\u2026unsubstitutedMemberScope)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DeclarationDescriptor it = (DeclarationDescriptor)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)it).getModality() == Modality.ABSTRACT)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final SimpleType getFunctionTypeForAbstractMethod(@NotNull FunctionDescriptor function2, boolean shouldConvertFirstParameterToDescriptor) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter(function2, "function");
        Object object = function2.getReturnType();
        if (object == null) {
            throw new IllegalStateException(Intrinsics.stringPlus("function is not initialized: ", function2).toString());
        }
        KotlinType returnType2 = kotlinType = object;
        object = function2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(object, "function.valueParameters");
        Object valueParameters2 = object;
        ArrayList<KotlinType> parameterTypes = new ArrayList<KotlinType>(valueParameters2.size());
        ArrayList<Name> parameterNames = new ArrayList<Name>(valueParameters2.size());
        int startIndex = 0;
        KotlinType receiverType = null;
        ReceiverParameterDescriptor extensionReceiver = function2.getExtensionReceiverParameter();
        if (extensionReceiver != null) {
            receiverType = extensionReceiver.getType();
        } else if (shouldConvertFirstParameterToDescriptor) {
            List<ValueParameterDescriptor> list2 = function2.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list2, "function.valueParameters");
            if (!((Collection)list2).isEmpty()) {
                receiverType = ((ValueParameterDescriptor)valueParameters2.get(0)).getType();
                startIndex = 1;
            }
        }
        int n = startIndex;
        int n2 = valueParameters2.size();
        while (n < n2) {
            Name name2;
            int i = n++;
            ValueParameterDescriptor parameter = (ValueParameterDescriptor)valueParameters2.get(i);
            parameterTypes.add(parameter.getType());
            if (function2.hasSynthesizedParameterNames()) {
                name2 = SpecialNames.NO_NAME_PROVIDED;
            } else {
                Name name3 = parameter.getName();
                Intrinsics.checkNotNullExpressionValue(name3, "parameter.name");
                name2 = name3;
            }
            parameterNames.add(name2);
        }
        return FunctionTypesKt.createFunctionType(DescriptorUtilsKt.getBuiltIns(function2), Annotations.Companion.getEMPTY(), receiverType, (List<? extends KotlinType>)parameterTypes, (List<Name>)parameterNames, returnType2, function2.isSuspend());
    }

    @Nullable
    public static final UnwrappedType getFunctionTypeForPossibleSamType(@NotNull SamConversionResolver $this$getFunctionTypeForPossibleSamType, @NotNull UnwrappedType possibleSamType, @NotNull SamConversionOracle samConversionOracle) {
        Intrinsics.checkNotNullParameter($this$getFunctionTypeForPossibleSamType, "<this>");
        Intrinsics.checkNotNullParameter(possibleSamType, "possibleSamType");
        Intrinsics.checkNotNullParameter(samConversionOracle, "samConversionOracle");
        KotlinType kotlinType = SamConversionResolverImplKt.getFunctionTypeForSamType(possibleSamType, $this$getFunctionTypeForPossibleSamType, samConversionOracle);
        return kotlinType == null ? null : kotlinType.unwrap();
    }

    @Nullable
    public static final KotlinType getFunctionTypeForSamType(@NotNull KotlinType samType, @NotNull SamConversionResolver samResolver, @NotNull SamConversionOracle samConversionOracle) {
        Intrinsics.checkNotNullParameter(samType, "samType");
        Intrinsics.checkNotNullParameter(samResolver, "samResolver");
        Intrinsics.checkNotNullParameter(samConversionOracle, "samConversionOracle");
        UnwrappedType unwrappedType = samType.unwrap();
        if (unwrappedType instanceof FlexibleType) {
            boolean bl;
            SimpleType lower2 = SamConversionResolverImplKt.getFunctionTypeForSamType(((FlexibleType)unwrappedType).getLowerBound(), samResolver, samConversionOracle);
            SimpleType upper = SamConversionResolverImplKt.getFunctionTypeForSamType(((FlexibleType)unwrappedType).getUpperBound(), samResolver, samConversionOracle);
            boolean bl2 = bl = lower2 == null == (upper == null);
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = Intrinsics.stringPlus("Illegal flexible type: ", unwrappedType);
                throw new AssertionError((Object)string2);
            }
            if (lower2 == null || upper == null) {
                return null;
            }
            return KotlinTypeFactory.flexibleType(lower2, upper);
        }
        return SamConversionResolverImplKt.getFunctionTypeForSamType((SimpleType)unwrappedType, samResolver, samConversionOracle);
    }

    private static final SimpleType getFunctionTypeForSamType(SimpleType samType, SamConversionResolver samResolver, SamConversionOracle samConversionOracle) {
        boolean bl;
        ClassifierDescriptor classifier2 = samType.getConstructor().getDeclarationDescriptor();
        if (!(classifier2 instanceof ClassDescriptor)) {
            return null;
        }
        if (!samConversionOracle.isPossibleSamType(samType)) {
            return null;
        }
        SimpleType simpleType2 = samResolver.resolveFunctionTypeIfSamInterface((ClassDescriptor)classifier2);
        if (simpleType2 == null) {
            return null;
        }
        SimpleType functionTypeDefault = simpleType2;
        SimpleType simpleType3 = SamConversionResolverImplKt.nonProjectionParametrization(samType);
        if (simpleType3 == null) {
            return null;
        }
        SimpleType noProjectionsSamType = simpleType3;
        KotlinType type2 = TypeSubstitutor.create(noProjectionsSamType).substitute(functionTypeDefault, Variance.IN_VARIANCE);
        boolean bl2 = bl = type2 != null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Substitution based on type with no projections '" + noProjectionsSamType + "' should not end with conflict";
            throw new AssertionError((Object)string2);
        }
        KotlinType kotlinType = type2;
        Intrinsics.checkNotNull(kotlinType);
        SimpleType simpleType4 = TypeSubstitutionKt.asSimpleType(kotlinType);
        return simpleType4.makeNullableAsSpecified(samType.isMarkedNullable());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final SimpleType nonProjectionParametrization(@NotNull SimpleType samType) {
        Collection<TypeProjection> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        TypeProjection it;
        boolean bl;
        block10: {
            Intrinsics.checkNotNullParameter(samType, "samType");
            Iterable $this$none$iv = samType.getArguments();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    it = (TypeProjection)element$iv;
                    boolean bl2 = false;
                    if (!(it.getProjectionKind() != Variance.INVARIANT)) continue;
                    bl = false;
                    break block10;
                }
                bl = true;
            }
        }
        if (bl) {
            return samType;
        }
        List<TypeParameterDescriptor> $i$f$none = samType.getConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue($i$f$none, "samType.constructor.parameters");
        List<TypeParameterDescriptor> parameters2 = $i$f$none;
        Set parametersSet = CollectionsKt.toSet((Iterable)parameters2);
        Iterable iterable = CollectionsKt.zip((Iterable)samType.getArguments(), (Iterable)parameters2);
        SimpleType simpleType2 = samType;
        boolean $i$f$map = false;
        it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            KotlinType kotlinType;
            TypeProjection typeProjection;
            void it2;
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            void var12_16 = it2;
            TypeProjection projection = (TypeProjection)var12_16.component1();
            TypeParameterDescriptor parameter = (TypeParameterDescriptor)var12_16.component2();
            if (projection.getProjectionKind() == Variance.INVARIANT) {
                typeProjection = projection;
            } else if (projection.isStarProjection()) {
                Object object = parameter.getUpperBounds();
                Intrinsics.checkNotNullExpressionValue(object, "parameter.upperBounds");
                object = CollectionsKt.first(object);
                KotlinType t = (KotlinType)object;
                boolean bl4 = false;
                Intrinsics.checkNotNullExpressionValue(t, "t");
                kotlinType = (KotlinType)(!TypeUtilsKt.contains(t, (Function1<? super UnwrappedType, Boolean>)new Function1<UnwrappedType, Boolean>(parametersSet){
                    final /* synthetic */ Set<TypeParameterDescriptor> $parametersSet;
                    {
                        this.$parametersSet = $parametersSet;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull UnwrappedType it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return CollectionsKt.contains((Iterable)this.$parametersSet, it.getConstructor().getDeclarationDescriptor());
                    }
                }) ? object : null);
                if (kotlinType == null) {
                    return null;
                }
                typeProjection = TypeUtilsKt.asTypeProjection(kotlinType);
            } else {
                kotlinType = projection.getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType, "projection.type");
                typeProjection = TypeUtilsKt.asTypeProjection(kotlinType);
            }
            TypeProjection typeProjection2 = typeProjection;
            collection.add(typeProjection2);
        }
        collection = (List)destination$iv$iv;
        return TypeSubstitutionKt.replace$default(simpleType2, (List)collection, null, 2, null);
    }
}

