/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.InlineClassManglingRulesKt;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/OverloadsAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkDeclaration", "annotationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "frontend.java"})
public final class OverloadsAnnotationChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context2, "context");
        AnnotationDescriptor annotationDescriptor = JvmAnnotationUtilKt.findJvmOverloadsAnnotation(descriptor2);
        if (annotationDescriptor != null) {
            AnnotationDescriptor annotationDescriptor2;
            AnnotationDescriptor annotation2 = annotationDescriptor2 = annotationDescriptor;
            boolean bl = false;
            KtAnnotationEntry annotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(annotation2);
            if (annotationEntry != null) {
                this.checkDeclaration(annotationEntry, descriptor2, context2);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void checkDeclaration(KtAnnotationEntry annotationEntry, DeclarationDescriptor descriptor, DeclarationCheckerContext context) {
        block11: {
            block9: {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    block10: {
                                        diagnosticHolder = context.getTrace();
                                        if (!(descriptor instanceof CallableDescriptor)) {
                                            return;
                                        }
                                        var6_5 = ((CallableDescriptor)descriptor).getContainingDeclaration();
                                        var5_7 = var6_5 instanceof ClassDescriptor != false ? (ClassDescriptor)var6_5 : null;
                                        if ((var5_7 == null ? null : var5_7.getKind()) != ClassKind.INTERFACE) break block10;
                                        diagnosticHolder.report(ErrorsJvm.OVERLOADS_INTERFACE.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
                                        break block11;
                                    }
                                    if (!(descriptor instanceof FunctionDescriptor) || ((FunctionDescriptor)descriptor).getModality() != Modality.ABSTRACT) break block12;
                                    diagnosticHolder.report(ErrorsJvm.OVERLOADS_ABSTRACT.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
                                    break block11;
                                }
                                if (!DescriptorUtils.isLocal(descriptor)) break block13;
                                diagnosticHolder.report(ErrorsJvm.OVERLOADS_LOCAL.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
                                break block11;
                            }
                            if (!DescriptorUtilsKt.isAnnotationConstructor(descriptor)) break block14;
                            diagnosticHolder.report(ErrorsJvm.OVERLOADS_ANNOTATION_CLASS_CONSTRUCTOR.on(context.getLanguageVersionSettings(), (KtAnnotationEntry)((PsiElement)annotationEntry)));
                            break block11;
                        }
                        if (((CallableDescriptor)descriptor).getVisibility().isPublicAPI() || Intrinsics.areEqual(((CallableDescriptor)descriptor).getVisibility(), DescriptorVisibilities.INTERNAL)) break block15;
                        diagnosticHolder.report(ErrorsJvm.OVERLOADS_PRIVATE.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
                        break block11;
                    }
                    var5_7 = ((CallableDescriptor)descriptor).getValueParameters();
                    Intrinsics.checkNotNullExpressionValue(var5_7, "descriptor.valueParameters");
                    $this$none$iv = (Iterable)var5_7;
                    $i$f$none = false;
                    if (!($this$none$iv instanceof Collection) || !((Collection)$this$none$iv).isEmpty()) break block16;
                    v0 = true;
                    break block9;
                }
                for (T element$iv : $this$none$iv) {
                    it = (ValueParameterDescriptor)element$iv;
                    $i$a$-none-OverloadsAnnotationChecker$checkDeclaration$1 = false;
                    if (it.declaresDefaultValue()) ** GOTO lbl-1000
                    Intrinsics.checkNotNullExpressionValue(it, "it");
                    if (ArgumentsUtilsKt.isActualParameterWithCorrespondingExpectedDefault(it)) lbl-1000:
                    // 2 sources

                    {
                        v1 = true;
                    } else {
                        v1 = false;
                    }
                    if (!v1) continue;
                    v0 = false;
                    break block9;
                }
                v0 = true;
            }
            if (v0) {
                diagnosticHolder.report(ErrorsJvm.OVERLOADS_WITHOUT_DEFAULT_ARGUMENTS.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
            } else if (descriptor instanceof SimpleFunctionDescriptor && (InlineClassManglingRulesKt.requiresFunctionNameManglingForParameterTypes((CallableMemberDescriptor)descriptor) || InlineClassManglingRulesKt.requiresFunctionNameManglingForReturnType((CallableMemberDescriptor)descriptor))) {
                diagnosticHolder.report(ErrorsJvm.OVERLOADS_ANNOTATION_MANGLED_FUNCTION.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
            } else if (descriptor instanceof ClassConstructorDescriptor && InlineClassManglingRulesKt.shouldHideConstructorDueToInlineClassTypeValueParameters((CallableMemberDescriptor)descriptor)) {
                diagnosticHolder.report(ErrorsJvm.OVERLOADS_ANNOTATION_HIDDEN_CONSTRUCTOR.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
            }
        }
    }
}

