/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.resolve.AdditionalAnnotationChecker;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.checkers.ExperimentalMarkerDeclarationAnnotationChecker;
import org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker;
import org.jetbrains.kotlin.resolve.checkers.Experimentality;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J>\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u0012\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\f\u001a\u00020\rH\u0002J*\u0010\u0013\u001a\u00020\u00062\u0010\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\tH\u0002J$\u0010\u0017\u001a\u00020\u0018*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u000e\b\u0002\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ExperimentalMarkerDeclarationAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/AdditionalAnnotationChecker;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)V", "checkEntries", "", "entries", "", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "actualTargets", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "annotated", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "checkMarkerTargetsAndRetention", "checkUseExperimentalUsage", "annotationClasses", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "entry", "hasExperimentalOverriddenDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "experimentalFqName", "Lorg/jetbrains/kotlin/name/FqName;", "visited", "", "frontend"})
public final class ExperimentalMarkerDeclarationAnnotationChecker
implements AdditionalAnnotationChecker {
    @NotNull
    private final ModuleDescriptor module;

    public ExperimentalMarkerDeclarationAnnotationChecker(@NotNull ModuleDescriptor module2) {
        Intrinsics.checkNotNullParameter(module2, "module");
        this.module = module2;
    }

    @Override
    public void checkEntries(@NotNull List<? extends KtAnnotationEntry> entries2, @NotNull List<? extends KotlinTarget> actualTargets, @NotNull BindingTrace trace, @Nullable KtAnnotated annotated, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(entries2, "entries");
        Intrinsics.checkNotNullParameter(actualTargets, "actualTargets");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        boolean isAnnotatedWithExperimental = false;
        for (KtAnnotationEntry ktAnnotationEntry : entries2) {
            DeclarationDescriptor descriptor2;
            AnnotationUseSiteTarget annotationUseSiteTarget;
            boolean bl;
            ClassDescriptor annotationClass;
            block14: {
                Object annotationClasses;
                Object $this$safeAs$iv;
                AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)trace.getBindingContext().get(BindingContext.ANNOTATION, ktAnnotationEntry);
                if (annotationDescriptor == null) continue;
                Object object = annotationDescriptor;
                AnnotationDescriptor annotation2 = object;
                object = annotation2.getFqName();
                if (CollectionsKt.contains((Iterable)OptInNames.INSTANCE.getUSE_EXPERIMENTAL_FQ_NAMES(), object)) {
                    ArrayValue arrayValue;
                    ConstantValue<?> constantValue = annotation2.getAllValueArguments().get(OptInNames.INSTANCE.getUSE_EXPERIMENTAL_ANNOTATION_CLASS());
                    boolean $i$f$safeAs = false;
                    Object object2 = $this$safeAs$iv;
                    if (!(object2 instanceof ArrayValue)) {
                        object2 = null;
                    }
                    $this$safeAs$iv = (arrayValue = (ArrayValue)object2) == null ? null : (List)arrayValue.getValue();
                    annotationClasses = $this$safeAs$iv == null ? CollectionsKt.emptyList() : $this$safeAs$iv;
                    this.checkUseExperimentalUsage((List<? extends ConstantValue<?>>)annotationClasses, trace, ktAnnotationEntry);
                } else if (CollectionsKt.contains((Iterable)OptInNames.INSTANCE.getEXPERIMENTAL_FQ_NAMES(), object)) {
                    isAnnotatedWithExperimental = true;
                }
                annotationClasses = DescriptorUtilsKt.getAnnotationClass(annotation2);
                if (annotationClasses == null) continue;
                annotationClass = annotationClasses;
                Iterable $this$any$iv = annotationClass.getAnnotations();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    $this$safeAs$iv = $this$any$iv.iterator();
                    while ($this$safeAs$iv.hasNext()) {
                        Object element$iv = $this$safeAs$iv.next();
                        AnnotationDescriptor it = (AnnotationDescriptor)element$iv;
                        boolean bl2 = false;
                        if (!CollectionsKt.contains((Iterable)OptInNames.INSTANCE.getEXPERIMENTAL_FQ_NAMES(), it.getFqName())) continue;
                        bl = true;
                        break block14;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            Set<KotlinTarget> applicableTargets = AnnotationChecker.Companion.applicableTargetSet(annotationClass);
            Set possibleTargets = CollectionsKt.intersect((Iterable)applicableTargets, (Iterable)actualTargets);
            KtAnnotationUseSiteTarget element$iv = ktAnnotationEntry.getUseSiteTarget();
            AnnotationUseSiteTarget annotationUseSiteTarget2 = annotationUseSiteTarget = element$iv == null ? null : element$iv.getAnnotationUseSiteTarget();
            if (possibleTargets.contains((Object)KotlinTarget.PROPERTY_GETTER) || annotationUseSiteTarget == AnnotationUseSiteTarget.PROPERTY_GETTER) {
                trace.report(Errors.EXPERIMENTAL_ANNOTATION_ON_WRONG_TARGET.on((KtAnnotationEntry)((PsiElement)ktAnnotationEntry), "getter"));
            }
            if (possibleTargets.contains((Object)KotlinTarget.VALUE_PARAMETER) && annotationUseSiteTarget == null || annotationUseSiteTarget == AnnotationUseSiteTarget.RECEIVER || annotationUseSiteTarget == AnnotationUseSiteTarget.SETTER_PARAMETER || annotationUseSiteTarget == AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER) {
                trace.report(Errors.EXPERIMENTAL_ANNOTATION_ON_WRONG_TARGET.on((KtAnnotationEntry)((PsiElement)ktAnnotationEntry), "parameter"));
            }
            if (possibleTargets.contains((Object)KotlinTarget.LOCAL_VARIABLE)) {
                trace.report(Errors.EXPERIMENTAL_ANNOTATION_ON_WRONG_TARGET.on((KtAnnotationEntry)((PsiElement)ktAnnotationEntry), "variable"));
            }
            if (annotationUseSiteTarget == AnnotationUseSiteTarget.FIELD || annotationUseSiteTarget == AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD) {
                trace.report(Errors.EXPERIMENTAL_ANNOTATION_ON_WRONG_TARGET.on((KtAnnotationEntry)((PsiElement)ktAnnotationEntry), "field"));
            }
            if (!(annotated instanceof KtCallableDeclaration) || annotated instanceof KtPropertyAccessor || annotationUseSiteTarget != null || !((KtCallableDeclaration)annotated).hasModifier(KtTokens.OVERRIDE_KEYWORD) || !((descriptor2 = trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, annotated)) instanceof CallableMemberDescriptor) || ExperimentalMarkerDeclarationAnnotationChecker.hasExperimentalOverriddenDescriptors$default(this, (CallableMemberDescriptor)descriptor2, DescriptorUtilsKt.getFqNameSafe(annotationClass), null, 2, null)) continue;
            if (languageVersionSettings.supportsFeature(LanguageFeature.OptInOnOverrideForbidden)) {
                trace.report(Errors.EXPERIMENTAL_ANNOTATION_ON_OVERRIDE.on((KtAnnotationEntry)((PsiElement)ktAnnotationEntry)));
                continue;
            }
            trace.report(Errors.EXPERIMENTAL_ANNOTATION_ON_OVERRIDE_WARNING.on((KtAnnotationEntry)((PsiElement)ktAnnotationEntry)));
        }
        if (isAnnotatedWithExperimental) {
            this.checkMarkerTargetsAndRetention(entries2, trace);
        }
    }

    private final boolean hasExperimentalOverriddenDescriptors(CallableMemberDescriptor $this$hasExperimentalOverriddenDescriptors, FqName experimentalFqName, Set<CallableMemberDescriptor> visited2) {
        if (!visited2.add($this$hasExperimentalOverriddenDescriptors)) {
            return false;
        }
        for (CallableMemberDescriptor callableMemberDescriptor : $this$hasExperimentalOverriddenDescriptors.getOverriddenDescriptors()) {
            boolean bl;
            block6: {
                Iterable $this$any$iv = callableMemberDescriptor.getAnnotations();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        AnnotationDescriptor it = (AnnotationDescriptor)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(it.getFqName(), experimentalFqName)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return true;
            }
            if (callableMemberDescriptor.getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE) continue;
            Intrinsics.checkNotNullExpressionValue(callableMemberDescriptor, "overridden");
            if (!ExperimentalMarkerDeclarationAnnotationChecker.hasExperimentalOverriddenDescriptors$default(this, callableMemberDescriptor, experimentalFqName, null, 2, null)) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ boolean hasExperimentalOverriddenDescriptors$default(ExperimentalMarkerDeclarationAnnotationChecker experimentalMarkerDeclarationAnnotationChecker, CallableMemberDescriptor callableMemberDescriptor, FqName fqName2, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = new LinkedHashSet();
        }
        return experimentalMarkerDeclarationAnnotationChecker.hasExperimentalOverriddenDescriptors(callableMemberDescriptor, fqName2, set);
    }

    private final void checkUseExperimentalUsage(List<? extends ConstantValue<?>> annotationClasses, BindingTrace trace, KtAnnotationEntry entry) {
        if (annotationClasses.isEmpty()) {
            trace.report(Errors.USE_EXPERIMENTAL_WITHOUT_ARGUMENTS.on((KtAnnotationEntry)((PsiElement)entry)));
            return;
        }
        for (ConstantValue<?> annotationClass : annotationClasses) {
            ClassDescriptor classDescriptor;
            ClassifierDescriptor classifierDescriptor;
            KClassValue kClassValue;
            KClassValue kClassValue2 = kClassValue = annotationClass instanceof KClassValue ? (KClassValue)annotationClass : null;
            if (kClassValue == null) {
                classifierDescriptor = null;
            } else {
                KotlinType kotlinType = kClassValue.getArgumentType(this.module);
                TypeConstructor typeConstructor2 = kotlinType.getConstructor();
                classifierDescriptor = typeConstructor2.getDeclarationDescriptor();
            }
            Object object = classifierDescriptor;
            ClassDescriptor classDescriptor2 = classDescriptor = object instanceof ClassDescriptor ? (ClassDescriptor)object : null;
            if (classDescriptor == null) continue;
            ClassDescriptor classDescriptor3 = classDescriptor;
            Object $this$checkUseExperimentalUsage_u24lambda_u2d2 = object = ExperimentalUsageChecker.Companion;
            boolean bl = false;
            Experimentality experimentality = ExperimentalUsageChecker.Companion.loadExperimentalityForMarkerAnnotation$frontend$default((ExperimentalUsageChecker.Companion)$this$checkUseExperimentalUsage_u24lambda_u2d2, classDescriptor3, false, 1, null);
            if (experimentality != null) continue;
            trace.report(Errors.USE_EXPERIMENTAL_ARGUMENT_IS_NOT_MARKER.on((KtAnnotationEntry)((PsiElement)entry), DescriptorUtilsKt.getFqNameSafe(classDescriptor3)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkMarkerTargetsAndRetention(List<? extends KtAnnotationEntry> entries2, BindingTrace trace) {
        Object v2;
        Object object;
        block9: {
            Object v0;
            Object $dstr$_u24__u24$descriptor;
            Object $this$firstOrNull$iv;
            Set associatedEntries;
            block8: {
                Iterable $this$associateWith$iv = entries2;
                boolean $i$f$associateWith = false;
                LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
                Object $this$associateWithTo$iv$iv = $this$associateWith$iv;
                boolean $i$f$associateWithTo = false;
                object = $this$associateWithTo$iv$iv.iterator();
                while (object.hasNext()) {
                    void entry;
                    Object element$iv$iv = object.next();
                    KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)element$iv$iv;
                    Object t = element$iv$iv;
                    Map map2 = result$iv;
                    boolean bl2 = false;
                    AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)trace.getBindingContext().get(BindingContext.ANNOTATION, entry);
                    map2.put(t, annotationDescriptor);
                }
                associatedEntries = ((Map)result$iv).entrySet();
                $this$firstOrNull$iv = associatedEntries;
                boolean $i$f$firstOrNull = false;
                $this$associateWithTo$iv$iv = $this$firstOrNull$iv.iterator();
                while ($this$associateWithTo$iv$iv.hasNext()) {
                    Object element$iv = $this$associateWithTo$iv$iv.next();
                    $dstr$_u24__u24$descriptor = (Map.Entry)element$iv;
                    boolean bl = false;
                    AnnotationDescriptor descriptor2 = (AnnotationDescriptor)$dstr$_u24__u24$descriptor.getValue();
                    AnnotationDescriptor bl2 = descriptor2;
                    if (!Intrinsics.areEqual(bl2 == null ? null : bl2.getFqName(), StandardNames.FqNames.target)) continue;
                    v0 = element$iv;
                    break block8;
                }
                v0 = null;
            }
            Map.Entry targetEntry = v0;
            if (targetEntry != null) {
                AnnotationDescriptor descriptor3;
                $this$firstOrNull$iv = targetEntry;
                KtAnnotationEntry entry = (KtAnnotationEntry)$this$firstOrNull$iv.getKey();
                AnnotationDescriptor annotationDescriptor = descriptor3 = (AnnotationDescriptor)$this$firstOrNull$iv.getValue();
                Intrinsics.checkNotNull(annotationDescriptor);
                AnnotationDescriptor bl = annotationDescriptor;
                Intrinsics.checkNotNullExpressionValue(bl, "descriptor!!");
                $dstr$_u24__u24$descriptor = AnnotationChecker.Companion.loadAnnotationTargets(bl);
                if ($dstr$_u24__u24$descriptor == null) {
                    return;
                }
                Object allowedTargets = $dstr$_u24__u24$descriptor;
                Set wrongTargets = CollectionsKt.intersect((Iterable)allowedTargets, (Iterable)Experimentality.Companion.getWRONG_TARGETS_FOR_MARKER());
                if (!((Collection)wrongTargets).isEmpty()) {
                    trace.report(Errors.EXPERIMENTAL_ANNOTATION_WITH_WRONG_TARGET.on((KtAnnotationEntry)((PsiElement)entry), CollectionsKt.joinToString$default(wrongTargets, null, null, null, 0, null, checkMarkerTargetsAndRetention.1.INSTANCE, 31, null)));
                }
            }
            Iterable $this$firstOrNull$iv2 = associatedEntries;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv2) {
                Map.Entry $dstr$_u24__u24$descriptor2 = (Map.Entry)element$iv;
                boolean bl = false;
                AnnotationDescriptor descriptor4 = (AnnotationDescriptor)$dstr$_u24__u24$descriptor2.getValue();
                AnnotationDescriptor annotationDescriptor = descriptor4;
                if (!Intrinsics.areEqual(annotationDescriptor == null ? null : annotationDescriptor.getFqName(), StandardNames.FqNames.retention)) continue;
                v2 = element$iv;
                break block9;
            }
            v2 = null;
        }
        Map.Entry retentionEntry = v2;
        if (retentionEntry != null) {
            Map.Entry entry = retentionEntry;
            KtAnnotationEntry entry2 = (KtAnnotationEntry)entry.getKey();
            AnnotationDescriptor descriptor5 = (AnnotationDescriptor)entry.getValue();
            object = descriptor5;
            if ((object == null ? null : DescriptorUtilsKt.getAnnotationRetention((AnnotationDescriptor)object)) == KotlinRetention.SOURCE) {
                trace.report(Errors.EXPERIMENTAL_ANNOTATION_WITH_WRONG_RETENTION.on(entry2));
            }
        }
    }
}

