/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jline.terminal;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ServiceLoader;
import org.jetbrains.kotlin.org.jline.terminal.Attributes;
import org.jetbrains.kotlin.org.jline.terminal.Size;
import org.jetbrains.kotlin.org.jline.terminal.Terminal;
import org.jetbrains.kotlin.org.jline.terminal.impl.AbstractPosixTerminal;
import org.jetbrains.kotlin.org.jline.terminal.impl.DumbTerminal;
import org.jetbrains.kotlin.org.jline.terminal.impl.ExecPty;
import org.jetbrains.kotlin.org.jline.terminal.impl.ExternalTerminal;
import org.jetbrains.kotlin.org.jline.terminal.impl.PosixPtyTerminal;
import org.jetbrains.kotlin.org.jline.terminal.impl.PosixSysTerminal;
import org.jetbrains.kotlin.org.jline.terminal.spi.JansiSupport;
import org.jetbrains.kotlin.org.jline.terminal.spi.JnaSupport;
import org.jetbrains.kotlin.org.jline.terminal.spi.Pty;
import org.jetbrains.kotlin.org.jline.utils.Log;
import org.jetbrains.kotlin.org.jline.utils.OSUtils;

public final class TerminalBuilder {
    private String name;
    private InputStream in;
    private OutputStream out;
    private String type;
    private String encoding;
    private Boolean system;
    private Boolean jna;
    private Boolean jansi;
    private Boolean exec;
    private Boolean dumb;
    private Attributes attributes;
    private Size size;
    private boolean nativeSignals = false;
    private Terminal.SignalHandler signalHandler = Terminal.SignalHandler.SIG_DFL;

    public static Terminal terminal() throws IOException {
        return TerminalBuilder.builder().build();
    }

    public static TerminalBuilder builder() {
        return new TerminalBuilder();
    }

    private TerminalBuilder() {
    }

    public Terminal build() throws IOException {
        Terminal terminal = this.doBuild();
        Log.debug(() -> "Using terminal " + terminal.getClass().getSimpleName());
        if (terminal instanceof AbstractPosixTerminal) {
            Log.debug(() -> "Using pty " + ((AbstractPosixTerminal)terminal).getPty().getClass().getSimpleName());
        }
        return terminal;
    }

    private Terminal doBuild() throws IOException {
        Boolean dumb;
        Boolean exec;
        Boolean jansi;
        Boolean jna;
        String type2;
        String encoding;
        String name2 = this.name;
        if (name2 == null) {
            name2 = "JLine terminal";
        }
        if ((encoding = this.encoding) == null) {
            encoding = System.getProperty("org.jetbrains.kotlin.org.jline.terminal.encoding");
        }
        if (encoding == null) {
            encoding = Charset.defaultCharset().name();
        }
        if ((type2 = this.type) == null) {
            type2 = System.getProperty("org.jetbrains.kotlin.org.jline.terminal.type");
        }
        if (type2 == null) {
            type2 = System.getenv("TERM");
        }
        if ((jna = this.jna) == null) {
            jna = TerminalBuilder.getBoolean("org.jetbrains.kotlin.org.jline.terminal.jna", true);
        }
        if ((jansi = this.jansi) == null) {
            jansi = TerminalBuilder.getBoolean("org.jetbrains.kotlin.org.jline.terminal.jansi", true);
        }
        if ((exec = this.exec) == null) {
            exec = TerminalBuilder.getBoolean("org.jetbrains.kotlin.org.jline.terminal.exec", true);
        }
        if ((dumb = this.dumb) == null) {
            dumb = TerminalBuilder.getBoolean("org.jetbrains.kotlin.org.jline.terminal.dumb", null);
        }
        if (this.system != null && this.system.booleanValue() || this.system == null && this.in == null && this.out == null) {
            if (this.attributes != null || this.size != null) {
                Log.warn("Attributes and size fields are ignored when creating a system terminal");
            }
            IllegalStateException exception = new IllegalStateException("Unable to create a system terminal");
            if (OSUtils.IS_CYGWIN || OSUtils.IS_MINGW) {
                if (exec.booleanValue()) {
                    try {
                        Pty pty = ExecPty.current();
                        if ("xterm".equals(type2) && this.type == null && System.getProperty("org.jetbrains.kotlin.org.jline.terminal.type") == null) {
                            type2 = "xterm-256color";
                        }
                        return new PosixSysTerminal(name2, type2, pty, encoding, this.nativeSignals, this.signalHandler);
                    }
                    catch (IOException e) {
                        Log.debug("Error creating EXEC based terminal: ", e.getMessage(), e);
                        exception.addSuppressed(e);
                    }
                }
            } else if (OSUtils.IS_WINDOWS) {
                if (jna.booleanValue()) {
                    try {
                        return this.load(JnaSupport.class).winSysTerminal(name2, this.nativeSignals, this.signalHandler);
                    }
                    catch (Throwable t) {
                        Log.debug("Error creating JNA based terminal: ", t.getMessage(), t);
                        exception.addSuppressed(t);
                    }
                }
                if (jansi.booleanValue()) {
                    try {
                        return this.load(JansiSupport.class).winSysTerminal(name2, this.nativeSignals, this.signalHandler);
                    }
                    catch (Throwable t) {
                        Log.debug("Error creating JANSI based terminal: ", t.getMessage(), t);
                        exception.addSuppressed(t);
                    }
                }
            } else {
                if (jna.booleanValue()) {
                    try {
                        Pty pty = this.load(JnaSupport.class).current();
                        return new PosixSysTerminal(name2, type2, pty, encoding, this.nativeSignals, this.signalHandler);
                    }
                    catch (Throwable t) {
                        Log.debug("Error creating JNA based terminal: ", t.getMessage(), t);
                        exception.addSuppressed(t);
                    }
                }
                if (jansi.booleanValue()) {
                    try {
                        Pty pty = this.load(JansiSupport.class).current();
                        return new PosixSysTerminal(name2, type2, pty, encoding, this.nativeSignals, this.signalHandler);
                    }
                    catch (Throwable t) {
                        Log.debug("Error creating JANSI based terminal: ", t.getMessage(), t);
                        exception.addSuppressed(t);
                    }
                }
                if (exec.booleanValue()) {
                    try {
                        Pty pty = ExecPty.current();
                        return new PosixSysTerminal(name2, type2, pty, encoding, this.nativeSignals, this.signalHandler);
                    }
                    catch (Throwable t) {
                        Log.debug("Error creating EXEC based terminal: ", t.getMessage(), t);
                        exception.addSuppressed(t);
                    }
                }
            }
            if (dumb == null || dumb.booleanValue()) {
                if (dumb == null) {
                    if (Log.isDebugEnabled()) {
                        Log.warn("Creating a dumb terminal", exception);
                    } else {
                        Log.warn("Unable to create a system terminal, creating a dumb terminal (enable debug logging for more information)");
                    }
                }
                return new DumbTerminal(name2, type2 != null ? type2 : "dumb", new FileInputStream(FileDescriptor.in), new FileOutputStream(FileDescriptor.out), encoding, this.signalHandler);
            }
            throw exception;
        }
        if (jna.booleanValue()) {
            try {
                Pty pty = this.load(JnaSupport.class).open(this.attributes, this.size);
                return new PosixPtyTerminal(name2, type2, pty, this.in, this.out, encoding, this.signalHandler);
            }
            catch (Throwable t) {
                Log.debug("Error creating JNA based terminal: ", t.getMessage(), t);
            }
        }
        if (jansi.booleanValue()) {
            try {
                Pty pty = this.load(JansiSupport.class).open(this.attributes, this.size);
                return new PosixPtyTerminal(name2, type2, pty, this.in, this.out, encoding, this.signalHandler);
            }
            catch (Throwable t) {
                Log.debug("Error creating JANSI based terminal: ", t.getMessage(), t);
            }
        }
        ExternalTerminal terminal = new ExternalTerminal(name2, type2, this.in, this.out, encoding, this.signalHandler);
        if (this.attributes != null) {
            terminal.setAttributes(this.attributes);
        }
        if (this.size != null) {
            terminal.setSize(this.size);
        }
        return terminal;
    }

    private static Boolean getBoolean(String name2, Boolean def) {
        try {
            String str = System.getProperty(name2);
            if (str != null) {
                return Boolean.parseBoolean(str);
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return def;
    }

    private <S> S load(Class<S> clazz) {
        return ServiceLoader.load(clazz, clazz.getClassLoader()).iterator().next();
    }
}

