/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.sisu.wire;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.kotlin.com.google.inject.Binder;
import org.jetbrains.kotlin.com.google.inject.Binding;
import org.jetbrains.kotlin.com.google.inject.Key;
import org.jetbrains.kotlin.com.google.inject.Module;
import org.jetbrains.kotlin.com.google.inject.PrivateBinder;
import org.jetbrains.kotlin.com.google.inject.TypeLiteral;
import org.jetbrains.kotlin.com.google.inject.spi.DefaultElementVisitor;
import org.jetbrains.kotlin.com.google.inject.spi.Element;
import org.jetbrains.kotlin.com.google.inject.spi.Elements;
import org.jetbrains.kotlin.com.google.inject.spi.InjectionRequest;
import org.jetbrains.kotlin.com.google.inject.spi.InstanceBinding;
import org.jetbrains.kotlin.com.google.inject.spi.PrivateElements;
import org.jetbrains.kotlin.com.google.inject.spi.ProviderInstanceBinding;
import org.jetbrains.kotlin.com.google.inject.spi.ProviderLookup;
import org.jetbrains.kotlin.com.google.inject.spi.RequireExplicitBindingsOption;
import org.jetbrains.kotlin.com.google.inject.spi.StaticInjectionRequest;
import org.jetbrains.kotlin.org.eclipse.sisu.Parameters;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.BeanLocator;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.DefaultBeanLocator;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.DefaultRankingFunction;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.Guice4;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.Logs;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.MutableBeanLocator;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.RankingFunction;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.TypeArguments;
import org.jetbrains.kotlin.org.eclipse.sisu.wire.DependencyAnalyzer;
import org.jetbrains.kotlin.org.eclipse.sisu.wire.MergedProperties;
import org.jetbrains.kotlin.org.eclipse.sisu.wire.ParameterKeys;
import org.jetbrains.kotlin.org.eclipse.sisu.wire.StringProperties;
import org.jetbrains.kotlin.org.eclipse.sisu.wire.TypeConverterCache;
import org.jetbrains.kotlin.org.eclipse.sisu.wire.WireModule;
import org.jetbrains.kotlin.org.eclipse.sisu.wire.Wiring;

final class ElementAnalyzer
extends DefaultElementVisitor<Void> {
    private static final Map<Key<?>, Key<?>> LEGACY_KEY_ALIASES;
    private static final List<Element> JIT_BINDINGS;
    private final Set<Key<?>> localKeys = new HashSet();
    private final DependencyAnalyzer analyzer = new DependencyAnalyzer();
    private final List<ElementAnalyzer> privateAnalyzers = new ArrayList<ElementAnalyzer>();
    private final List<Map<?, ?>> properties = new ArrayList();
    private final List<String> arguments = new ArrayList<String>();
    private final Binder binder;
    private boolean requireExplicitBindings;

    static {
        HashMap aliases = new HashMap();
        try {
            ElementAnalyzer.addLegacyKeyAlias(aliases, BeanLocator.class);
            ElementAnalyzer.addLegacyKeyAlias(aliases, MutableBeanLocator.class);
            ElementAnalyzer.addLegacyKeyAlias(aliases, RankingFunction.class);
        }
        catch (Exception exception) {
        }
        catch (LinkageError linkageError) {}
        LEGACY_KEY_ALIASES = aliases.isEmpty() ? null : aliases;
        JIT_BINDINGS = Elements.getElements(new Module(){

            @Override
            public void configure(Binder binder) {
                binder.bind(BeanLocator.class).to(MutableBeanLocator.class);
                binder.bind(MutableBeanLocator.class).to(DefaultBeanLocator.class);
                binder.bind(RankingFunction.class).to(DefaultRankingFunction.class);
                binder.bind(TypeConverterCache.class);
            }
        });
    }

    ElementAnalyzer(Binder binder) {
        this.binder = binder;
    }

    public void ignoreKeys(Set<Key<?>> keys2) {
        this.localKeys.addAll(keys2);
    }

    public void apply(WireModule.Strategy strategy) {
        if (this.requireExplicitBindings) {
            this.makeJitBindingsExplicit();
        }
        Set<Key<?>> missingKeys = this.analyzer.findMissingKeys(this.localKeys);
        MergedProperties mergedProperties = new MergedProperties(this.properties);
        Wiring wiring = strategy.wiring(this.binder);
        for (Key<?> key : missingKeys) {
            if (ElementAnalyzer.isParameters(key)) {
                this.wireParameters(key, mergedProperties);
                continue;
            }
            if (ElementAnalyzer.isRestricted(key)) continue;
            wiring.wire(key);
        }
        for (ElementAnalyzer privateAnalyzer : this.privateAnalyzers) {
            privateAnalyzer.ignoreKeys(this.localKeys);
            privateAnalyzer.ignoreKeys(missingKeys);
            privateAnalyzer.apply(strategy);
        }
    }

    @Override
    public <T> Void visit(Binding<T> binding) {
        Key<T> key = binding.getKey();
        if (!this.localKeys.contains(key)) {
            if (ElementAnalyzer.isParameters(key)) {
                this.mergeParameters(binding);
            } else if (Boolean.TRUE.equals(binding.acceptTargetVisitor(this.analyzer))) {
                Key<?> alias;
                this.localKeys.add(key);
                binding.applyTo(this.binder);
                if (LEGACY_KEY_ALIASES != null && (alias = LEGACY_KEY_ALIASES.get(key)) != null && this.localKeys.add(alias)) {
                    this.binder.bind(alias).to(key);
                }
            } else {
                Logs.trace("Discard binding: {}", binding, null);
            }
        }
        return null;
    }

    @Override
    public Void visit(PrivateElements elements) {
        PrivateBinder privateBinder = this.binder.withSource(elements.getSource()).newPrivateBinder();
        ElementAnalyzer privateAnalyzer = new ElementAnalyzer(privateBinder);
        this.privateAnalyzers.add(privateAnalyzer);
        privateAnalyzer.ignoreKeys(this.localKeys);
        for (Element element : elements.getElements()) {
            element.acceptVisitor(privateAnalyzer);
        }
        for (Key key : elements.getExposedKeys()) {
            if (!privateAnalyzer.localKeys.contains(key) || !this.localKeys.add(key)) continue;
            privateBinder.withSource(elements.getExposedSource(key)).expose(key);
        }
        return null;
    }

    @Override
    public <T> Void visit(ProviderLookup<T> lookup2) {
        this.analyzer.visit(lookup2);
        lookup2.applyTo(this.binder);
        return null;
    }

    @Override
    public Void visit(StaticInjectionRequest request) {
        this.analyzer.visit(request);
        request.applyTo(this.binder);
        return null;
    }

    @Override
    public Void visit(InjectionRequest<?> request) {
        this.analyzer.visit(request);
        request.applyTo(this.binder);
        return null;
    }

    @Override
    public Void visit(RequireExplicitBindingsOption option) {
        this.requireExplicitBindings = true;
        option.applyTo(this.binder);
        return null;
    }

    @Override
    public Void visitOther(Element element) {
        element.applyTo(this.binder);
        return null;
    }

    private void makeJitBindingsExplicit() {
        for (Element element : JIT_BINDINGS) {
            if (!(element instanceof Binding) || !this.localKeys.add(((Binding)element).getKey())) continue;
            element.applyTo(this.binder);
        }
    }

    private void mergeParameters(Binding<?> binding) {
        Object parameters2 = null;
        if (binding instanceof InstanceBinding) {
            parameters2 = ((InstanceBinding)binding).getInstance();
        } else if (binding instanceof ProviderInstanceBinding) {
            parameters2 = Guice4.getProviderInstance((ProviderInstanceBinding)binding).get();
        }
        if (parameters2 instanceof Map) {
            this.properties.add(parameters2);
        } else if (parameters2 instanceof String[]) {
            Collections.addAll(this.arguments, parameters2);
        } else {
            Logs.warn("Ignoring incompatible @Parameters binding: {}", binding, null);
        }
    }

    private void wireParameters(Key key, Map mergedProperties) {
        if (ParameterKeys.PROPERTIES.equals(key)) {
            this.binder.bind(key).toInstance(mergedProperties);
        } else {
            TypeLiteral type2 = key.getTypeLiteral();
            Class clazz = type2.getRawType();
            if (Map.class == clazz) {
                TypeLiteral<?>[] constraints = TypeArguments.get(type2);
                if (constraints.length == 2 && String.class == constraints[1].getRawType()) {
                    this.binder.bind(key).to(StringProperties.class);
                } else {
                    this.binder.bind(key).to(ParameterKeys.PROPERTIES);
                }
            } else if (String[].class == clazz) {
                this.binder.bind(key).toInstance(this.arguments.toArray(new String[this.arguments.size()]));
            }
        }
    }

    private static boolean isParameters(Key<?> key) {
        Class<Annotation> qualifierType = key.getAnnotationType();
        return Parameters.class == qualifierType || org.sonatype.inject.Parameters.class == qualifierType;
    }

    private static boolean isRestricted(Key<?> key) {
        String name2 = key.getTypeLiteral().getRawType().getName();
        if (name2.startsWith("org.jetbrains.kotlin.org.eclipse.sisu.inject") || name2.startsWith("org.sonatype.guice.bean.locators")) {
            return name2.endsWith("BeanLocator") || name2.endsWith("RankingFunction");
        }
        return "org.slf4j.Logger".equals(name2);
    }

    private static void addLegacyKeyAlias(Map<Key<?>, Key<?>> aliases, Class<?> clazz) throws ClassNotFoundException {
        String legacyName = "org.sonatype.guice.bean.locators." + clazz.getSimpleName();
        Class<?> legacyType = ElementAnalyzer.class.getClassLoader().loadClass(legacyName);
        if (clazz.isAssignableFrom(legacyType)) {
            aliases.put(Key.get(legacyType), Key.get(clazz));
        }
    }
}

