/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.sisu.launch;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import junit.framework.TestCase;
import org.jetbrains.kotlin.com.google.inject.Binder;
import org.jetbrains.kotlin.com.google.inject.Guice;
import org.jetbrains.kotlin.com.google.inject.Key;
import org.jetbrains.kotlin.com.google.inject.Module;
import org.jetbrains.kotlin.com.google.inject.name.Names;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.MutableBeanLocator;
import org.jetbrains.kotlin.org.eclipse.sisu.space.BeanScanning;
import org.jetbrains.kotlin.org.eclipse.sisu.space.ClassSpace;
import org.jetbrains.kotlin.org.eclipse.sisu.space.SpaceModule;
import org.jetbrains.kotlin.org.eclipse.sisu.space.URLClassSpace;
import org.jetbrains.kotlin.org.eclipse.sisu.wire.ParameterKeys;
import org.jetbrains.kotlin.org.eclipse.sisu.wire.WireModule;

public abstract class InjectedTestCase
extends TestCase
implements Module {
    private String basedir;
    @Inject
    private MutableBeanLocator locator;

    @Override
    protected void setUp() throws Exception {
        Guice.createInjector(new WireModule(new SetUpModule(), this.spaceModule()));
    }

    @Override
    protected void tearDown() throws Exception {
        this.locator.clear();
    }

    public SpaceModule spaceModule() {
        return new SpaceModule(this.space(), this.scanning());
    }

    public ClassSpace space() {
        return new URLClassSpace(this.getClass().getClassLoader());
    }

    public BeanScanning scanning() {
        return BeanScanning.CACHE;
    }

    @Override
    public void configure(Binder binder) {
    }

    public void configure(Properties properties2) {
    }

    public final <T> T lookup(Class<T> type2) {
        return this.lookup(Key.get(type2));
    }

    public final <T> T lookup(Class<T> type2, String name2) {
        return this.lookup(type2, Names.named(name2));
    }

    public final <T> T lookup(Class<T> type2, Class<? extends Annotation> qualifier) {
        return this.lookup(Key.get(type2, qualifier));
    }

    public final <T> T lookup(Class<T> type2, Annotation qualifier) {
        return this.lookup(Key.get(type2, qualifier));
    }

    public final String getBasedir() {
        if (this.basedir == null) {
            this.basedir = System.getProperty("basedir", new File("").getAbsolutePath());
        }
        return this.basedir;
    }

    private <T> T lookup(Key<T> key) {
        Iterator i = this.locator.locate(key).iterator();
        return i.hasNext() ? (T)((Map.Entry)i.next()).getValue() : null;
    }

    final class SetUpModule
    implements Module {
        SetUpModule() {
        }

        @Override
        public void configure(Binder binder) {
            binder.install(InjectedTestCase.this);
            Properties properties2 = new Properties();
            properties2.put("basedir", InjectedTestCase.this.getBasedir());
            InjectedTestCase.this.configure(properties2);
            binder.bind(ParameterKeys.PROPERTIES).toInstance(properties2);
            binder.requestInjection(InjectedTestCase.this);
        }
    }
}

