/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.util.graph.transformer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.kotlin.org.eclipse.aether.RepositoryException;
import org.jetbrains.kotlin.org.eclipse.aether.collection.DependencyGraphTransformationContext;
import org.jetbrains.kotlin.org.eclipse.aether.collection.DependencyGraphTransformer;
import org.jetbrains.kotlin.org.eclipse.aether.graph.DependencyNode;
import org.jetbrains.kotlin.org.eclipse.aether.util.graph.transformer.ConflictMarker;
import org.jetbrains.kotlin.org.eclipse.aether.util.graph.transformer.TransformationContextKeys;

public final class ConflictIdSorter
implements DependencyGraphTransformer {
    @Override
    public DependencyNode transformGraph(DependencyNode node, DependencyGraphTransformationContext context2) throws RepositoryException {
        Map conflictIds = (Map)context2.get(TransformationContextKeys.CONFLICT_IDS);
        if (conflictIds == null) {
            ConflictMarker marker = new ConflictMarker();
            marker.transformGraph(node, context2);
            conflictIds = (Map)context2.get(TransformationContextKeys.CONFLICT_IDS);
        }
        Map stats = (Map)context2.get(TransformationContextKeys.STATS);
        long time1 = System.nanoTime();
        LinkedHashMap<Object, ConflictId> ids = new LinkedHashMap<Object, ConflictId>(256);
        ConflictId id = null;
        Object key = conflictIds.get(node);
        if (key != null) {
            id = new ConflictId(key, 0);
            ids.put(key, id);
        }
        IdentityHashMap<DependencyNode, Object> visited2 = new IdentityHashMap<DependencyNode, Object>(conflictIds.size());
        this.buildConflitIdDAG(ids, node, id, 0, visited2, conflictIds);
        long time2 = System.nanoTime();
        int cycles = this.topsortConflictIds(ids.values(), context2);
        if (stats != null) {
            long time3 = System.nanoTime();
            stats.put("ConflictIdSorter.graphTime", time2 - time1);
            stats.put("ConflictIdSorter.topsortTime", time3 - time2);
            stats.put("ConflictIdSorter.conflictIdCount", ids.size());
            stats.put("ConflictIdSorter.conflictIdCycleCount", cycles);
        }
        return node;
    }

    private void buildConflitIdDAG(Map<Object, ConflictId> ids, DependencyNode node, ConflictId id, int depth, Map<DependencyNode, Object> visited2, Map<?, ?> conflictIds) {
        if (visited2.put(node, Boolean.TRUE) != null) {
            return;
        }
        ++depth;
        for (DependencyNode child : node.getChildren()) {
            Object key = conflictIds.get(child);
            ConflictId childId = ids.get(key);
            if (childId == null) {
                childId = new ConflictId(key, depth);
                ids.put(key, childId);
            } else {
                childId.pullup(depth);
            }
            if (id != null) {
                id.add(childId);
            }
            this.buildConflitIdDAG(ids, child, childId, depth, visited2, conflictIds);
        }
    }

    private int topsortConflictIds(Collection<ConflictId> conflictIds, DependencyGraphTransformationContext context2) {
        boolean cycle;
        ArrayList<Object> sorted2 = new ArrayList<Object>(conflictIds.size());
        RootQueue roots2 = new RootQueue(conflictIds.size() / 2);
        for (ConflictId id : conflictIds) {
            if (id.inDegree > 0) continue;
            roots2.add(id);
        }
        this.processRoots(sorted2, roots2);
        boolean bl = cycle = sorted2.size() < conflictIds.size();
        while (sorted2.size() < conflictIds.size()) {
            ConflictId nearest = null;
            for (ConflictId id : conflictIds) {
                if (id.inDegree <= 0 || nearest != null && id.minDepth >= nearest.minDepth && (id.minDepth != nearest.minDepth || id.inDegree >= nearest.inDegree)) continue;
                nearest = id;
            }
            nearest.inDegree = 0;
            roots2.add(nearest);
            this.processRoots(sorted2, roots2);
        }
        Collection<Object> cycles = Collections.emptySet();
        if (cycle) {
            cycles = this.findCycles(conflictIds);
        }
        context2.put(TransformationContextKeys.SORTED_CONFLICT_IDS, sorted2);
        context2.put(TransformationContextKeys.CYCLIC_CONFLICT_IDS, cycles);
        return cycles.size();
    }

    private void processRoots(List<Object> sorted2, RootQueue roots2) {
        while (!roots2.isEmpty()) {
            ConflictId root2 = roots2.remove();
            sorted2.add(root2.key);
            for (ConflictId child : root2.children) {
                --child.inDegree;
                if (child.inDegree != 0) continue;
                roots2.add(child);
            }
        }
    }

    private Collection<Collection<Object>> findCycles(Collection<ConflictId> conflictIds) {
        HashSet<Collection<Object>> cycles = new HashSet<Collection<Object>>();
        HashMap<Object, Integer> stack = new HashMap<Object, Integer>(128);
        IdentityHashMap<ConflictId, Object> visited2 = new IdentityHashMap<ConflictId, Object>(conflictIds.size());
        for (ConflictId id : conflictIds) {
            this.findCycles(id, visited2, stack, cycles);
        }
        return cycles;
    }

    private void findCycles(ConflictId id, Map<ConflictId, Object> visited2, Map<Object, Integer> stack, Collection<Collection<Object>> cycles) {
        Integer depth = stack.put(id.key, stack.size());
        if (depth != null) {
            stack.put(id.key, depth);
            HashSet<Object> cycle = new HashSet<Object>();
            for (Map.Entry<Object, Integer> entry : stack.entrySet()) {
                if (entry.getValue() < depth) continue;
                cycle.add(entry.getKey());
            }
            cycles.add(cycle);
        } else {
            if (visited2.put(id, Boolean.TRUE) == null) {
                for (ConflictId childId : id.children) {
                    this.findCycles(childId, visited2, stack, cycles);
                }
            }
            stack.remove(id.key);
        }
    }

    static final class RootQueue {
        private int nextOut;
        private int nextIn;
        private ConflictId[] ids;

        RootQueue(int capacity) {
            this.ids = new ConflictId[capacity + 16];
        }

        boolean isEmpty() {
            return this.nextOut >= this.nextIn;
        }

        void add(ConflictId id) {
            if (this.nextOut >= this.nextIn && this.nextOut > 0) {
                this.nextIn -= this.nextOut;
                this.nextOut = 0;
            }
            if (this.nextIn >= this.ids.length) {
                ConflictId[] tmp = new ConflictId[this.ids.length + this.ids.length / 2 + 16];
                System.arraycopy(this.ids, this.nextOut, tmp, 0, this.nextIn - this.nextOut);
                this.ids = tmp;
                this.nextIn -= this.nextOut;
                this.nextOut = 0;
            }
            for (int i = this.nextIn - 1; i >= this.nextOut && id.minDepth < this.ids[i].minDepth; --i) {
                this.ids[i + 1] = this.ids[i];
            }
            this.ids[i + 1] = id;
            ++this.nextIn;
        }

        ConflictId remove() {
            return this.ids[this.nextOut++];
        }
    }

    static final class ConflictId {
        final Object key;
        Collection<ConflictId> children = Collections.emptySet();
        int inDegree;
        int minDepth;

        ConflictId(Object key, int depth) {
            this.key = key;
            this.minDepth = depth;
        }

        public void add(ConflictId child) {
            if (this.children.isEmpty()) {
                this.children = new HashSet<ConflictId>();
            }
            if (this.children.add(child)) {
                ++child.inDegree;
            }
        }

        public void pullup(int depth) {
            if (depth < this.minDepth) {
                this.minDepth = depth++;
                for (ConflictId child : this.children) {
                    child.pullup(depth);
                }
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ConflictId)) {
                return false;
            }
            ConflictId that = (ConflictId)obj;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public String toString() {
            return this.key + " @ " + this.minDepth + " <" + this.inDegree;
        }
    }
}

