/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.transfer;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.transfer.TransferResource;

public final class TransferEvent {
    private final EventType type;
    private final RequestType requestType;
    private final RepositorySystemSession session;
    private final TransferResource resource;
    private final ByteBuffer dataBuffer;
    private final long transferredBytes;
    private final Exception exception;

    TransferEvent(Builder builder2) {
        this.type = builder2.type;
        this.requestType = builder2.requestType;
        this.session = builder2.session;
        this.resource = builder2.resource;
        this.dataBuffer = builder2.dataBuffer;
        this.transferredBytes = builder2.transferredBytes;
        this.exception = builder2.exception;
    }

    public EventType getType() {
        return this.type;
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    public TransferResource getResource() {
        return this.resource;
    }

    public String toString() {
        return (Object)((Object)this.getRequestType()) + " " + (Object)((Object)this.getType()) + " " + this.getResource();
    }

    public static final class Builder {
        EventType type;
        RequestType requestType;
        RepositorySystemSession session;
        TransferResource resource;
        ByteBuffer dataBuffer;
        long transferredBytes;
        Exception exception;

        public Builder(RepositorySystemSession session2, TransferResource resource) {
            this.session = Objects.requireNonNull(session2, "repository system session cannot be null");
            this.resource = Objects.requireNonNull(resource, "transfer resource cannot be null");
            this.type = EventType.INITIATED;
            this.requestType = RequestType.GET;
        }

        public Builder resetType(EventType type2) {
            this.type = Objects.requireNonNull(type2, "event type cannot be null");
            this.dataBuffer = null;
            this.exception = null;
            switch (type2) {
                case INITIATED: 
                case STARTED: {
                    this.transferredBytes = 0L;
                }
            }
            return this;
        }

        public Builder setRequestType(RequestType requestType) {
            this.requestType = Objects.requireNonNull(requestType, "request type cannot be null");
            return this;
        }

        public Builder setTransferredBytes(long transferredBytes) {
            if (transferredBytes < 0L) {
                throw new IllegalArgumentException("number of transferred bytes cannot be negative");
            }
            this.transferredBytes = transferredBytes;
            return this;
        }

        public Builder addTransferredBytes(long transferredBytes) {
            if (transferredBytes < 0L) {
                throw new IllegalArgumentException("number of transferred bytes cannot be negative");
            }
            this.transferredBytes += transferredBytes;
            return this;
        }

        public Builder setDataBuffer(ByteBuffer dataBuffer) {
            this.dataBuffer = dataBuffer;
            return this;
        }

        public Builder setException(Exception exception) {
            this.exception = exception;
            return this;
        }

        public TransferEvent build() {
            return new TransferEvent(this);
        }
    }

    public static final class RequestType
    extends Enum<RequestType> {
        public static final /* enum */ RequestType GET = new RequestType();
        public static final /* enum */ RequestType GET_EXISTENCE = new RequestType();
        public static final /* enum */ RequestType PUT = new RequestType();
        private static final /* synthetic */ RequestType[] $VALUES;

        public static RequestType[] values() {
            return (RequestType[])$VALUES.clone();
        }

        static {
            $VALUES = new RequestType[]{GET, GET_EXISTENCE, PUT};
        }
    }

    public static final class EventType
    extends Enum<EventType> {
        public static final /* enum */ EventType INITIATED = new EventType();
        public static final /* enum */ EventType STARTED = new EventType();
        public static final /* enum */ EventType PROGRESSED = new EventType();
        public static final /* enum */ EventType CORRUPTED = new EventType();
        public static final /* enum */ EventType SUCCEEDED = new EventType();
        public static final /* enum */ EventType FAILED = new EventType();
        private static final /* synthetic */ EventType[] $VALUES;

        public static EventType[] values() {
            return (EventType[])$VALUES.clone();
        }

        static {
            $VALUES = new EventType[]{INITIATED, STARTED, PROGRESSED, CORRUPTED, SUCCEEDED, FAILED};
        }
    }
}

