/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.transfer;

import org.jetbrains.kotlin.org.eclipse.aether.RepositoryException;
import org.jetbrains.kotlin.org.eclipse.aether.metadata.Metadata;
import org.jetbrains.kotlin.org.eclipse.aether.repository.RemoteRepository;

public class MetadataTransferException
extends RepositoryException {
    private final transient Metadata metadata;
    private final transient RemoteRepository repository;
    private final boolean fromCache;

    static String getString(String prefix, RemoteRepository repository) {
        if (repository == null) {
            return "";
        }
        return prefix + repository.getId() + " (" + repository.getUrl() + ")";
    }

    public MetadataTransferException(Metadata metadata2, RemoteRepository repository, String message2) {
        this(metadata2, repository, message2, false);
    }

    public MetadataTransferException(Metadata metadata2, RemoteRepository repository, String message2, boolean fromCache) {
        super(message2);
        this.metadata = metadata2;
        this.repository = repository;
        this.fromCache = fromCache;
    }

    public MetadataTransferException(Metadata metadata2, RemoteRepository repository, Throwable cause) {
        this(metadata2, repository, "Could not transfer metadata " + metadata2 + MetadataTransferException.getString(" from/to ", repository) + MetadataTransferException.getMessage(": ", cause), cause);
    }

    public MetadataTransferException(Metadata metadata2, RemoteRepository repository, String message2, Throwable cause) {
        super(message2, cause);
        this.metadata = metadata2;
        this.repository = repository;
        this.fromCache = false;
    }
}

