/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.http.client.protocol;

import java.net.URI;
import java.util.List;
import org.jetbrains.kotlin.org.apache.http.auth.AuthSchemeProvider;
import org.jetbrains.kotlin.org.apache.http.auth.AuthState;
import org.jetbrains.kotlin.org.apache.http.client.AuthCache;
import org.jetbrains.kotlin.org.apache.http.client.CookieStore;
import org.jetbrains.kotlin.org.apache.http.client.CredentialsProvider;
import org.jetbrains.kotlin.org.apache.http.client.config.RequestConfig;
import org.jetbrains.kotlin.org.apache.http.config.Lookup;
import org.jetbrains.kotlin.org.apache.http.conn.routing.HttpRoute;
import org.jetbrains.kotlin.org.apache.http.conn.routing.RouteInfo;
import org.jetbrains.kotlin.org.apache.http.cookie.CookieOrigin;
import org.jetbrains.kotlin.org.apache.http.cookie.CookieSpec;
import org.jetbrains.kotlin.org.apache.http.cookie.CookieSpecProvider;
import org.jetbrains.kotlin.org.apache.http.protocol.BasicHttpContext;
import org.jetbrains.kotlin.org.apache.http.protocol.HttpContext;
import org.jetbrains.kotlin.org.apache.http.protocol.HttpCoreContext;

public class HttpClientContext
extends HttpCoreContext {
    public static HttpClientContext adapt(HttpContext context2) {
        return context2 instanceof HttpClientContext ? (HttpClientContext)context2 : new HttpClientContext(context2);
    }

    public static HttpClientContext create() {
        return new HttpClientContext(new BasicHttpContext());
    }

    public HttpClientContext(HttpContext context2) {
        super(context2);
    }

    public HttpClientContext() {
    }

    public RouteInfo getHttpRoute() {
        return this.getAttribute("http.route", HttpRoute.class);
    }

    public List<URI> getRedirectLocations() {
        return this.getAttribute("http.protocol.redirect-locations", List.class);
    }

    public CookieStore getCookieStore() {
        return this.getAttribute("http.cookie-store", CookieStore.class);
    }

    public CookieSpec getCookieSpec() {
        return this.getAttribute("http.cookie-spec", CookieSpec.class);
    }

    public CookieOrigin getCookieOrigin() {
        return this.getAttribute("http.cookie-origin", CookieOrigin.class);
    }

    private <T> Lookup<T> getLookup(String name2, Class<T> clazz) {
        return this.getAttribute(name2, Lookup.class);
    }

    public Lookup<CookieSpecProvider> getCookieSpecRegistry() {
        return this.getLookup("http.cookiespec-registry", CookieSpecProvider.class);
    }

    public Lookup<AuthSchemeProvider> getAuthSchemeRegistry() {
        return this.getLookup("http.authscheme-registry", AuthSchemeProvider.class);
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.getAttribute("http.auth.credentials-provider", CredentialsProvider.class);
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.setAttribute("http.auth.credentials-provider", credentialsProvider);
    }

    public AuthCache getAuthCache() {
        return this.getAttribute("http.auth.auth-cache", AuthCache.class);
    }

    public void setAuthCache(AuthCache authCache) {
        this.setAttribute("http.auth.auth-cache", authCache);
    }

    public AuthState getTargetAuthState() {
        return this.getAttribute("http.auth.target-scope", AuthState.class);
    }

    public AuthState getProxyAuthState() {
        return this.getAttribute("http.auth.proxy-scope", AuthState.class);
    }

    public Object getUserToken() {
        return this.getAttribute("http.user-token");
    }

    public RequestConfig getRequestConfig() {
        RequestConfig config = this.getAttribute("http.request-config", RequestConfig.class);
        return config != null ? config : RequestConfig.DEFAULT;
    }

    public void setRequestConfig(RequestConfig config) {
        this.setAttribute("http.request-config", config);
    }
}

