/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects;

import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.LongCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.Object2LongFunction;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectSet;

public interface Object2LongMap<K>
extends Object2LongFunction<K>,
Map<K, Long> {
    @Override
    public int size();

    @Override
    default public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long defaultReturnValue();

    public ObjectSet<Entry<K>> object2LongEntrySet();

    @Override
    @Deprecated
    default public ObjectSet<Map.Entry<K, Long>> entrySet() {
        return this.object2LongEntrySet();
    }

    @Override
    @Deprecated
    default public Long put(K key, Long value2) {
        return Object2LongFunction.super.put(key, value2);
    }

    @Override
    @Deprecated
    default public Long get(Object key) {
        return Object2LongFunction.super.get(key);
    }

    @Override
    @Deprecated
    default public Long remove(Object key) {
        return Object2LongFunction.super.remove(key);
    }

    @Override
    public ObjectSet<K> keySet();

    public LongCollection values();

    @Override
    public boolean containsKey(Object var1);

    public boolean containsValue(long var1);

    @Override
    @Deprecated
    default public boolean containsValue(Object value2) {
        return value2 == null ? false : this.containsValue((Long)value2);
    }

    @Override
    default public long getOrDefault(Object key, long defaultValue2) {
        long v = this.getLong(key);
        return v != this.defaultReturnValue() || this.containsKey(key) ? v : defaultValue2;
    }

    default public long computeLong(K key, BiFunction<? super K, ? super Long, ? extends Long> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        long oldValue = this.getLong(key);
        long drv = this.defaultReturnValue();
        boolean contained = oldValue != drv || this.containsKey(key);
        Long newValue2 = remappingFunction.apply(key, contained ? Long.valueOf(oldValue) : null);
        if (newValue2 == null) {
            if (contained) {
                this.removeLong(key);
            }
            return drv;
        }
        long newVal = newValue2;
        this.put(key, newVal);
        return newVal;
    }

    @Override
    @Deprecated
    default public Long getOrDefault(Object key, Long defaultValue2) {
        return Map.super.getOrDefault(key, defaultValue2);
    }

    @Override
    @Deprecated
    default public Long putIfAbsent(K key, Long value2) {
        return Map.super.putIfAbsent(key, value2);
    }

    @Override
    @Deprecated
    default public boolean remove(Object key, Object value2) {
        return Map.super.remove(key, value2);
    }

    @Override
    @Deprecated
    default public boolean replace(K key, Long oldValue, Long newValue2) {
        return Map.super.replace(key, oldValue, newValue2);
    }

    @Override
    @Deprecated
    default public Long replace(K key, Long value2) {
        return Map.super.replace(key, value2);
    }

    @Override
    @Deprecated
    default public Long merge(K key, Long value2, BiFunction<? super Long, ? super Long, ? extends Long> remappingFunction) {
        return Map.super.merge(key, value2, remappingFunction);
    }

    public static interface Entry<K>
    extends Map.Entry<K, Long> {
        public long getLongValue();

        @Override
        public long setValue(long var1);

        @Override
        @Deprecated
        default public Long getValue() {
            return this.getLongValue();
        }

        @Override
        @Deprecated
        default public Long setValue(Long value2) {
            return this.setValue((long)value2);
        }
    }

    public static interface FastEntrySet<K>
    extends ObjectSet<Entry<K>> {
        public ObjectIterator<Entry<K>> fastIterator();
    }
}

