/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.builtins;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.ArrayIteratorsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.CharRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterMethodNotFoundError;
import org.jetbrains.kotlin.ir.interpreter.proxy.Proxy;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\u001a6\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0001H\u0000\u001aF\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\u00012\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0000\u001a$\u0010\u000b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001H\u0000\u00a8\u0006\r"}, d2={"interpretBinaryFunction", "", "name", "", "typeA", "typeB", "a", "b", "interpretTernaryFunction", "typeC", "c", "interpretUnaryFunction", "type", "ir.interpreter"})
public final class IrBuiltInsMapGeneratedKt {
    @Nullable
    public static final Object interpretUnaryFunction(@NotNull String name2, @NotNull String type2, @Nullable Object a) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(type2, "type");
        switch (name2) {
            case "hashCode": {
                switch (type2) {
                    case "Boolean": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                        }
                        return Boolean.hashCode((Boolean)a);
                    }
                    case "Char": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Char");
                        }
                        return Character.hashCode(((Character)a).charValue());
                    }
                    case "Byte": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                        }
                        return Byte.hashCode((Byte)a);
                    }
                    case "Short": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                        }
                        return Short.hashCode((Short)a);
                    }
                    case "Int": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                        }
                        return Integer.hashCode((Integer)a);
                    }
                    case "Float": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                        }
                        return Float.hashCode(((Float)a).floatValue());
                    }
                    case "Long": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                        }
                        return Long.hashCode((Long)a);
                    }
                    case "Double": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                        }
                        return Double.hashCode((Double)a);
                    }
                    case "String": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                        }
                        return ((String)a).hashCode();
                    }
                    case "Any": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Any");
                        }
                        return a.hashCode();
                    }
                }
                break;
            }
            case "not": {
                String string2 = type2;
                if (!Intrinsics.areEqual(string2, "Boolean")) break;
                if (a == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                }
                return (Boolean)a == false;
            }
            case "toString": {
                switch (type2) {
                    case "Boolean": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                        }
                        return String.valueOf((Boolean)a);
                    }
                    case "Char": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Char");
                        }
                        return String.valueOf(((Character)a).charValue());
                    }
                    case "Byte": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                        }
                        return String.valueOf(((Byte)a).byteValue());
                    }
                    case "Short": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                        }
                        return String.valueOf(((Short)a).shortValue());
                    }
                    case "Int": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                        }
                        return String.valueOf((Integer)a);
                    }
                    case "Float": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                        }
                        return String.valueOf(((Float)a).floatValue());
                    }
                    case "Long": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                        }
                        return String.valueOf((Long)a);
                    }
                    case "Double": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                        }
                        return String.valueOf((Double)a);
                    }
                    case "String": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                        }
                        return ((String)a).toString();
                    }
                    case "Any": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Any");
                        }
                        return a.toString();
                    }
                    case "Any?": {
                        Object object = a;
                        return object == null ? "null" : object.toString();
                    }
                }
                break;
            }
            case "dec": {
                switch (type2) {
                    case "Char": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Char");
                        }
                        return Character.valueOf((char)(((Character)a).charValue() + -1));
                    }
                    case "Byte": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                        }
                        return (byte)((Byte)a + -1);
                    }
                    case "Short": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                        }
                        return (short)((Short)a + -1);
                    }
                    case "Int": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                        }
                        return (Integer)a + -1;
                    }
                    case "Float": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                        }
                        return Float.valueOf(((Float)a).floatValue() + -1.0f);
                    }
                    case "Long": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                        }
                        return (Long)a + -1L;
                    }
                    case "Double": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                        }
                        return (Double)a + -1.0;
                    }
                }
                break;
            }
            case "inc": {
                switch (type2) {
                    case "Char": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Char");
                        }
                        return Character.valueOf((char)(((Character)a).charValue() + '\u0001'));
                    }
                    case "Byte": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                        }
                        return (byte)((Byte)a + 1);
                    }
                    case "Short": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                        }
                        return (short)((Short)a + 1);
                    }
                    case "Int": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                        }
                        return (Integer)a + 1;
                    }
                    case "Float": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                        }
                        return Float.valueOf(((Float)a).floatValue() + 1.0f);
                    }
                    case "Long": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                        }
                        return (Long)a + 1L;
                    }
                    case "Double": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                        }
                        return (Double)a + 1.0;
                    }
                }
                break;
            }
            case "toByte": {
                switch (type2) {
                    case "Char": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Char");
                        }
                        return (byte)((Character)a).charValue();
                    }
                    case "Byte": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                        }
                        return (byte)((Byte)a);
                    }
                    case "Short": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                        }
                        return (byte)((Short)a).shortValue();
                    }
                    case "Int": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                        }
                        return (byte)((Integer)a).intValue();
                    }
                    case "Float": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                        }
                        return (byte)((Float)a).floatValue();
                    }
                    case "Long": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                        }
                        return (byte)((Long)a).longValue();
                    }
                    case "Double": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                        }
                        return (byte)((Double)a).doubleValue();
                    }
                    case "Number": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                        }
                        return ((Number)a).byteValue();
                    }
                }
                break;
            }
            case "toChar": {
                switch (type2) {
                    case "Char": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Char");
                        }
                        return Character.valueOf(((Character)a).charValue());
                    }
                    case "Byte": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                        }
                        return Character.valueOf((char)((Byte)a).byteValue());
                    }
                    case "Short": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                        }
                        return Character.valueOf((char)((Short)a).shortValue());
                    }
                    case "Int": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                        }
                        return Character.valueOf((char)((Integer)a).intValue());
                    }
                    case "Float": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                        }
                        return Character.valueOf((char)((Float)a).floatValue());
                    }
                    case "Long": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                        }
                        return Character.valueOf((char)((Long)a).longValue());
                    }
                    case "Double": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                        }
                        return Character.valueOf((char)((Double)a).doubleValue());
                    }
                    case "Number": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                        }
                        return Character.valueOf((char)((Number)a).intValue());
                    }
                }
                break;
            }
            case "toDouble": {
                switch (type2) {
                    case "Char": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Char");
                        }
                        return (double)((Character)a).charValue();
                    }
                    case "Byte": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                        }
                        return (double)((Byte)a).byteValue();
                    }
                    case "Short": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                        }
                        return (double)((Short)a).shortValue();
                    }
                    case "Int": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                        }
                        return (double)((Integer)a).intValue();
                    }
                    case "Float": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                        }
                        return (double)((Float)a).floatValue();
                    }
                    case "Long": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                        }
                        return (double)((Long)a).longValue();
                    }
                    case "Double": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                        }
                        return (double)((Double)a);
                    }
                    case "Number": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                        }
                        return ((Number)a).doubleValue();
                    }
                }
                break;
            }
            case "toFloat": {
                switch (type2) {
                    case "Char": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Char");
                        }
                        return Float.valueOf(((Character)a).charValue());
                    }
                    case "Byte": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                        }
                        return Float.valueOf(((Byte)a).byteValue());
                    }
                    case "Short": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                        }
                        return Float.valueOf(((Short)a).shortValue());
                    }
                    case "Int": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                        }
                        return Float.valueOf(((Integer)a).intValue());
                    }
                    case "Float": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                        }
                        return Float.valueOf(((Float)a).floatValue());
                    }
                    case "Long": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                        }
                        return Float.valueOf(((Long)a).longValue());
                    }
                    case "Double": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                        }
                        return Float.valueOf((float)((Double)a).doubleValue());
                    }
                    case "Number": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                        }
                        return Float.valueOf(((Number)a).floatValue());
                    }
                }
                break;
            }
            case "toInt": {
                switch (type2) {
                    case "Char": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Char");
                        }
                        return (int)((Character)a).charValue();
                    }
                    case "Byte": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                        }
                        return (int)((Byte)a).byteValue();
                    }
                    case "Short": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                        }
                        return (int)((Short)a).shortValue();
                    }
                    case "Int": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                        }
                        return (int)((Integer)a);
                    }
                    case "Float": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                        }
                        return (int)((Float)a).floatValue();
                    }
                    case "Long": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                        }
                        return (int)((Long)a).longValue();
                    }
                    case "Double": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                        }
                        return (int)((Double)a).doubleValue();
                    }
                    case "Number": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                        }
                        return ((Number)a).intValue();
                    }
                }
                break;
            }
            case "toLong": {
                switch (type2) {
                    case "Char": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Char");
                        }
                        return (long)((Character)a).charValue();
                    }
                    case "Byte": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                        }
                        return (long)((Byte)a).byteValue();
                    }
                    case "Short": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                        }
                        return (long)((Short)a).shortValue();
                    }
                    case "Int": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                        }
                        return (long)((Integer)a).intValue();
                    }
                    case "Float": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                        }
                        return (long)((Float)a).floatValue();
                    }
                    case "Long": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                        }
                        return (long)((Long)a);
                    }
                    case "Double": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                        }
                        return (long)((Double)a).doubleValue();
                    }
                    case "Number": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                        }
                        return ((Number)a).longValue();
                    }
                }
                break;
            }
            case "toShort": {
                switch (type2) {
                    case "Char": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Char");
                        }
                        return (short)((Character)a).charValue();
                    }
                    case "Byte": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                        }
                        return (short)((Byte)a).byteValue();
                    }
                    case "Short": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                        }
                        return (short)((Short)a);
                    }
                    case "Int": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                        }
                        return (short)((Integer)a).intValue();
                    }
                    case "Float": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                        }
                        return (short)((Float)a).floatValue();
                    }
                    case "Long": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                        }
                        return (short)((Long)a).longValue();
                    }
                    case "Double": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                        }
                        return (short)((Double)a).doubleValue();
                    }
                    case "Number": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                        }
                        return ((Number)a).shortValue();
                    }
                }
                break;
            }
            case "unaryMinus": {
                switch (type2) {
                    case "Byte": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                        }
                        return (int)(-((Byte)a).byteValue());
                    }
                    case "Short": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                        }
                        return (int)(-((Short)a).shortValue());
                    }
                    case "Int": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                        }
                        return -((Integer)a).intValue();
                    }
                    case "Float": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                        }
                        return Float.valueOf(-((Float)a).floatValue());
                    }
                    case "Long": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                        }
                        return -((Long)a).longValue();
                    }
                    case "Double": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                        }
                        return -((Double)a).doubleValue();
                    }
                }
                break;
            }
            case "unaryPlus": {
                switch (type2) {
                    case "Byte": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                        }
                        return (int)((Byte)a).byteValue();
                    }
                    case "Short": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                        }
                        return (int)((Short)a).shortValue();
                    }
                    case "Int": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                        }
                        return (int)((Integer)a);
                    }
                    case "Float": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                        }
                        return Float.valueOf(((Float)a).floatValue());
                    }
                    case "Long": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                        }
                        return (long)((Long)a);
                    }
                    case "Double": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                        }
                        return (double)((Double)a);
                    }
                }
                break;
            }
            case "inv": {
                String string3 = type2;
                if (Intrinsics.areEqual(string3, "Int")) {
                    if (a == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    return ~((Integer)a).intValue();
                }
                if (!Intrinsics.areEqual(string3, "Long")) break;
                if (a == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                }
                return (Long)a ^ 0xFFFFFFFFFFFFFFFFL;
            }
            case "length": {
                String string4 = type2;
                if (Intrinsics.areEqual(string4, "String")) {
                    if (a == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    return ((String)a).length();
                }
                if (!Intrinsics.areEqual(string4, "CharSequence")) break;
                if (a == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                return ((CharSequence)a).length();
            }
            case "cause": {
                String string5 = type2;
                if (!Intrinsics.areEqual(string5, "Throwable")) break;
                if (a == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Throwable");
                }
                return ((Throwable)a).getCause();
            }
            case "message": {
                String string6 = type2;
                if (!Intrinsics.areEqual(string6, "Throwable")) break;
                if (a == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Throwable");
                }
                return ((Throwable)a).getMessage();
            }
            case "size": {
                switch (type2) {
                    case "BooleanArray": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.BooleanArray");
                        }
                        return ((boolean[])a).length;
                    }
                    case "CharArray": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharArray");
                        }
                        return ((char[])a).length;
                    }
                    case "ByteArray": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.ByteArray");
                        }
                        return ((byte[])a).length;
                    }
                    case "ShortArray": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.ShortArray");
                        }
                        return ((short[])a).length;
                    }
                    case "IntArray": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.IntArray");
                        }
                        return ((int[])a).length;
                    }
                    case "FloatArray": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.FloatArray");
                        }
                        return ((float[])a).length;
                    }
                    case "LongArray": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.LongArray");
                        }
                        return ((long[])a).length;
                    }
                    case "DoubleArray": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.DoubleArray");
                        }
                        return ((double[])a).length;
                    }
                    case "Array": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
                        }
                        return ((Object[])a).length;
                    }
                }
                break;
            }
            case "iterator": {
                switch (type2) {
                    case "BooleanArray": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.BooleanArray");
                        }
                        return ArrayIteratorsKt.iterator((boolean[])a);
                    }
                    case "CharArray": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharArray");
                        }
                        return ArrayIteratorsKt.iterator((char[])a);
                    }
                    case "ByteArray": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.ByteArray");
                        }
                        return ArrayIteratorsKt.iterator((byte[])a);
                    }
                    case "ShortArray": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.ShortArray");
                        }
                        return ArrayIteratorsKt.iterator((short[])a);
                    }
                    case "IntArray": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.IntArray");
                        }
                        return ArrayIteratorsKt.iterator((int[])a);
                    }
                    case "FloatArray": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.FloatArray");
                        }
                        return ArrayIteratorsKt.iterator((float[])a);
                    }
                    case "LongArray": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.LongArray");
                        }
                        return ArrayIteratorsKt.iterator((long[])a);
                    }
                    case "DoubleArray": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.DoubleArray");
                        }
                        return ArrayIteratorsKt.iterator((double[])a);
                    }
                    case "Array": {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
                        }
                        return ArrayIteratorKt.iterator((Object[])a);
                    }
                }
                break;
            }
            case "CHECK_NOT_NULL": {
                String string7 = type2;
                if (!Intrinsics.areEqual(string7, "T0?")) break;
                Object object = a;
                Intrinsics.checkNotNull(object);
                return object;
            }
        }
        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + type2 + ')');
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static final Object interpretBinaryFunction(@NotNull String name2, @NotNull String typeA, @NotNull String typeB, @Nullable Object a, @Nullable Object b) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(typeA, "typeA");
        Intrinsics.checkNotNullParameter(typeB, "typeB");
        switch (name2) {
            case "and": {
                switch (typeA) {
                    case "Boolean": {
                        if (!Intrinsics.areEqual(typeB, "Boolean")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                        }
                        if (b != null) return (Boolean)a & (Boolean)b;
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                    }
                    case "Int": {
                        if (!Intrinsics.areEqual(typeB, "Int")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                        }
                        if (b != null) return (Integer)a & (Integer)b;
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    case "Long": {
                        if (!Intrinsics.areEqual(typeB, "Long")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                        }
                        if (b != null) return (Long)a & (Long)b;
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                    }
                }
                throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
            }
            case "compareTo": {
                switch (typeA) {
                    case "Boolean": {
                        if (!Intrinsics.areEqual(typeB, "Boolean")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                        }
                        if (b != null) return Intrinsics.compare(((Boolean)a).booleanValue() ? 1 : 0, ((Boolean)b).booleanValue() ? 1 : 0);
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                    }
                    case "Char": {
                        if (!Intrinsics.areEqual(typeB, "Char")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Char");
                        }
                        if (b != null) return Intrinsics.compare(((Character)a).charValue(), ((Character)b).charValue());
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Char");
                    }
                    case "Byte": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return Intrinsics.compare(((Byte)a).byteValue(), ((Byte)b).byteValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Double": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return Double.compare(((Byte)a).byteValue(), (Double)b);
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                            }
                            case "Float": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return Float.compare(((Byte)a).byteValue(), ((Float)b).floatValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return Intrinsics.compare(((Byte)a).byteValue(), (Integer)b);
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return Intrinsics.compare((long)((Byte)a).byteValue(), (Long)b);
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return Intrinsics.compare(((Byte)a).byteValue(), ((Short)b).shortValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Short": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return Intrinsics.compare(((Short)a).shortValue(), ((Byte)b).byteValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Double": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return Double.compare(((Short)a).shortValue(), (Double)b);
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                            }
                            case "Float": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return Float.compare(((Short)a).shortValue(), ((Float)b).floatValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return Intrinsics.compare(((Short)a).shortValue(), (Integer)b);
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return Intrinsics.compare((long)((Short)a).shortValue(), (Long)b);
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return Intrinsics.compare(((Short)a).shortValue(), ((Short)b).shortValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Int": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return Intrinsics.compare((Integer)a, ((Byte)b).byteValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Double": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return Double.compare(((Integer)a).intValue(), (Double)b);
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                            }
                            case "Float": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return Float.compare(((Integer)a).intValue(), ((Float)b).floatValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return Intrinsics.compare((Integer)a, (Integer)b);
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return Intrinsics.compare((long)((Integer)a).intValue(), (Long)b);
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return Intrinsics.compare((Integer)a, ((Short)b).shortValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Float": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                                }
                                if (b != null) return Float.compare(((Float)a).floatValue(), ((Byte)b).byteValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Double": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                                }
                                if (b != null) return Double.compare(((Float)a).floatValue(), (Double)b);
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                            }
                            case "Float": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                                }
                                if (b != null) return Float.compare(((Float)a).floatValue(), ((Float)b).floatValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                                }
                                if (b != null) return Float.compare(((Float)a).floatValue(), ((Integer)b).intValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                                }
                                if (b != null) return Float.compare(((Float)a).floatValue(), ((Long)b).longValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                                }
                                if (b != null) return Float.compare(((Float)a).floatValue(), ((Short)b).shortValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Long": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return Intrinsics.compare((Long)a, (long)((Byte)b).byteValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Double": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return Double.compare(((Long)a).longValue(), (Double)b);
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                            }
                            case "Float": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return Float.compare(((Long)a).longValue(), ((Float)b).floatValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return Intrinsics.compare((Long)a, (long)((Integer)b).intValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return Intrinsics.compare((Long)a, (Long)b);
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return Intrinsics.compare((Long)a, (long)((Short)b).shortValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Double": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                                }
                                if (b != null) return Double.compare((Double)a, ((Byte)b).byteValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Double": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                                }
                                if (b != null) return Double.compare((Double)a, (Double)b);
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                            }
                            case "Float": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                                }
                                if (b != null) return Double.compare((Double)a, ((Float)b).floatValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                                }
                                if (b != null) return Double.compare((Double)a, ((Integer)b).intValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                                }
                                if (b != null) return Double.compare((Double)a, ((Long)b).longValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                                }
                                if (b != null) return Double.compare((Double)a, ((Short)b).shortValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "String": {
                        if (!Intrinsics.areEqual(typeB, "String")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                        }
                        if (b != null) return ((String)a).compareTo((String)b);
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    case "Comparable": {
                        if (!Intrinsics.areEqual(typeB, "T")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a != null) return ((Comparable)a).compareTo(b);
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Comparable<kotlin.Any?>");
                    }
                }
                throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
            }
            case "equals": {
                switch (typeA) {
                    case "Boolean": {
                        if (!Intrinsics.areEqual(typeB, "Any?")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a != null) return ((Object)((Boolean)a)).equals(b);
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                    }
                    case "Char": {
                        if (!Intrinsics.areEqual(typeB, "Any?")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a != null) return ((Object)Character.valueOf(((Character)a).charValue())).equals(b);
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Char");
                    }
                    case "Byte": {
                        if (!Intrinsics.areEqual(typeB, "Any?")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a != null) return ((Object)((Byte)a)).equals(b);
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                    }
                    case "Short": {
                        if (!Intrinsics.areEqual(typeB, "Any?")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a != null) return ((Object)((Short)a)).equals(b);
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                    }
                    case "Int": {
                        if (!Intrinsics.areEqual(typeB, "Any?")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a != null) return ((Object)((Integer)a)).equals(b);
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    case "Float": {
                        if (!Intrinsics.areEqual(typeB, "Any?")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a != null) return ((Object)Float.valueOf(((Float)a).floatValue())).equals(b);
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                    }
                    case "Long": {
                        if (!Intrinsics.areEqual(typeB, "Any?")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a != null) return ((Object)((Long)a)).equals(b);
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                    }
                    case "Double": {
                        if (!Intrinsics.areEqual(typeB, "Any?")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a != null) return ((Object)((Double)a)).equals(b);
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                    }
                    case "String": {
                        if (!Intrinsics.areEqual(typeB, "Any?")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a != null) return ((String)a).equals(b);
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    case "Any": {
                        if (!Intrinsics.areEqual(typeB, "Any?")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a != null) return a.equals(b);
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Any");
                    }
                }
                throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
            }
            case "or": {
                switch (typeA) {
                    case "Boolean": {
                        if (!Intrinsics.areEqual(typeB, "Boolean")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                        }
                        if (b != null) return (Boolean)a | (Boolean)b;
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                    }
                    case "Int": {
                        if (!Intrinsics.areEqual(typeB, "Int")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                        }
                        if (b != null) return (Integer)a | (Integer)b;
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    case "Long": {
                        if (!Intrinsics.areEqual(typeB, "Long")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                        }
                        if (b != null) return (Long)a | (Long)b;
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                    }
                }
                throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
            }
            case "xor": {
                switch (typeA) {
                    case "Boolean": {
                        if (!Intrinsics.areEqual(typeB, "Boolean")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                        }
                        if (b != null) return (Boolean)a ^ (Boolean)b;
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                    }
                    case "Int": {
                        if (!Intrinsics.areEqual(typeB, "Int")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                        }
                        if (b != null) return (Integer)a ^ (Integer)b;
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    case "Long": {
                        if (!Intrinsics.areEqual(typeB, "Long")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                        }
                        if (b != null) return (Long)a ^ (Long)b;
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                    }
                }
                throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
            }
            case "minus": {
                switch (typeA) {
                    case "Char": {
                        String string2 = typeB;
                        if (Intrinsics.areEqual(string2, "Char")) {
                            if (a == null) {
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Char");
                            }
                            if (b != null) return ((Character)a).charValue() - ((Character)b).charValue();
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Char");
                        }
                        if (!Intrinsics.areEqual(string2, "Int")) break;
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Char");
                        }
                        if (b != null) return Character.valueOf((char)(((Character)a).charValue() - (Integer)b));
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    case "Byte": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return (Byte)a - (Byte)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Double": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return (double)((Byte)a).byteValue() - (Double)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                            }
                            case "Float": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return Float.valueOf((float)((Byte)a).byteValue() - ((Float)b).floatValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return (Byte)a - (Integer)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return (long)((Byte)a).byteValue() - (Long)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return (Byte)a - (Short)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Short": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return (Short)a - (Byte)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Double": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return (double)((Short)a).shortValue() - (Double)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                            }
                            case "Float": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return Float.valueOf((float)((Short)a).shortValue() - ((Float)b).floatValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return (Short)a - (Integer)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return (long)((Short)a).shortValue() - (Long)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return (Short)a - (Short)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Int": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return (Integer)a - (Byte)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Double": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return (double)((Integer)a).intValue() - (Double)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                            }
                            case "Float": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return Float.valueOf((float)((Integer)a).intValue() - ((Float)b).floatValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return (Integer)a - (Integer)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return (long)((Integer)a).intValue() - (Long)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return (Integer)a - (Short)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Float": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                                }
                                if (b != null) return Float.valueOf(((Float)a).floatValue() - (float)((Byte)b).byteValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Double": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                                }
                                if (b != null) return (double)((Float)a).floatValue() - (Double)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                            }
                            case "Float": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                                }
                                if (b != null) return Float.valueOf(((Float)a).floatValue() - ((Float)b).floatValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                                }
                                if (b != null) return Float.valueOf(((Float)a).floatValue() - (float)((Integer)b).intValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                                }
                                if (b != null) return Float.valueOf(((Float)a).floatValue() - (float)((Long)b).longValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                                }
                                if (b != null) return Float.valueOf(((Float)a).floatValue() - (float)((Short)b).shortValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Long": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return (Long)a - (long)((Byte)b).byteValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Double": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return (double)((Long)a).longValue() - (Double)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                            }
                            case "Float": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return Float.valueOf((float)((Long)a).longValue() - ((Float)b).floatValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return (Long)a - (long)((Integer)b).intValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return (Long)a - (Long)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return (Long)a - (long)((Short)b).shortValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Double": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                                }
                                if (b != null) return (Double)a - (double)((Byte)b).byteValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Double": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                                }
                                if (b != null) return (Double)a - (Double)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                            }
                            case "Float": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                                }
                                if (b != null) return (Double)a - (double)((Float)b).floatValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                                }
                                if (b != null) return (Double)a - (double)((Integer)b).intValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                                }
                                if (b != null) return (Double)a - (double)((Long)b).longValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                                }
                                if (b != null) return (Double)a - (double)((Short)b).shortValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                }
                throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
            }
            case "plus": {
                switch (typeA) {
                    case "Char": {
                        if (!Intrinsics.areEqual(typeB, "Int")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Char");
                        }
                        if (b != null) return Character.valueOf((char)(((Character)a).charValue() + (Integer)b));
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    case "Byte": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return (Byte)a + (Byte)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Double": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return (double)((Byte)a).byteValue() + (Double)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                            }
                            case "Float": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return Float.valueOf((float)((Byte)a).byteValue() + ((Float)b).floatValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return (Byte)a + (Integer)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return (long)((Byte)a).byteValue() + (Long)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return (Byte)a + (Short)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Short": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return (Short)a + (Byte)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Double": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return (double)((Short)a).shortValue() + (Double)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                            }
                            case "Float": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return Float.valueOf((float)((Short)a).shortValue() + ((Float)b).floatValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return (Short)a + (Integer)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return (long)((Short)a).shortValue() + (Long)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return (Short)a + (Short)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Int": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return (Integer)a + (Byte)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Double": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return (double)((Integer)a).intValue() + (Double)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                            }
                            case "Float": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return Float.valueOf((float)((Integer)a).intValue() + ((Float)b).floatValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return (Integer)a + (Integer)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return (long)((Integer)a).intValue() + (Long)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return (Integer)a + (Short)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Float": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                                }
                                if (b != null) return Float.valueOf(((Float)a).floatValue() + (float)((Byte)b).byteValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Double": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                                }
                                if (b != null) return (double)((Float)a).floatValue() + (Double)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                            }
                            case "Float": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                                }
                                if (b != null) return Float.valueOf(((Float)a).floatValue() + ((Float)b).floatValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                                }
                                if (b != null) return Float.valueOf(((Float)a).floatValue() + (float)((Integer)b).intValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                                }
                                if (b != null) return Float.valueOf(((Float)a).floatValue() + (float)((Long)b).longValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                                }
                                if (b != null) return Float.valueOf(((Float)a).floatValue() + (float)((Short)b).shortValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Long": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return (Long)a + (long)((Byte)b).byteValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Double": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return (double)((Long)a).longValue() + (Double)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                            }
                            case "Float": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return Float.valueOf((float)((Long)a).longValue() + ((Float)b).floatValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return (Long)a + (long)((Integer)b).intValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return (Long)a + (Long)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return (Long)a + (long)((Short)b).shortValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Double": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                                }
                                if (b != null) return (Double)a + (double)((Byte)b).byteValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Double": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                                }
                                if (b != null) return (Double)a + (Double)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                            }
                            case "Float": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                                }
                                if (b != null) return (Double)a + (double)((Float)b).floatValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                                }
                                if (b != null) return (Double)a + (double)((Integer)b).intValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                                }
                                if (b != null) return (Double)a + (double)((Long)b).longValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                                }
                                if (b != null) return (Double)a + (double)((Short)b).shortValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "String": {
                        if (!Intrinsics.areEqual(typeB, "Any?")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a != null) return Intrinsics.stringPlus((String)a, b);
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                }
                throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
            }
            case "rangeTo": {
                switch (typeA) {
                    case "Char": {
                        if (!Intrinsics.areEqual(typeB, "Char")) break;
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Char");
                        }
                        if (b != null) return new CharRange(((Character)a).charValue(), ((Character)b).charValue());
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Char");
                    }
                    case "Byte": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return new IntRange(((Byte)a).byteValue(), ((Byte)b).byteValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return new IntRange(((Byte)a).byteValue(), (Integer)b);
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return new LongRange(((Byte)a).byteValue(), (Long)b);
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return new IntRange(((Byte)a).byteValue(), ((Short)b).shortValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Short": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return new IntRange(((Short)a).shortValue(), ((Byte)b).byteValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return new IntRange(((Short)a).shortValue(), (Integer)b);
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return new LongRange(((Short)a).shortValue(), (Long)b);
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return new IntRange(((Short)a).shortValue(), ((Short)b).shortValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Int": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return new IntRange((Integer)a, ((Byte)b).byteValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return new IntRange((Integer)a, (Integer)b);
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return new LongRange(((Integer)a).intValue(), (Long)b);
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return new IntRange((Integer)a, ((Short)b).shortValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Long": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return new LongRange((Long)a, ((Byte)b).byteValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return new LongRange((Long)a, ((Integer)b).intValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return new LongRange((Long)a, (Long)b);
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return new LongRange((Long)a, ((Short)b).shortValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                }
                throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
            }
            case "div": {
                switch (typeA) {
                    case "Byte": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return (Byte)a / (Byte)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Double": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return (double)((Byte)a).byteValue() / (Double)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                            }
                            case "Float": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return Float.valueOf((float)((Byte)a).byteValue() / ((Float)b).floatValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return (Byte)a / (Integer)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return (long)((Byte)a).byteValue() / (Long)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return (Byte)a / (Short)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Short": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return (Short)a / (Byte)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Double": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return (double)((Short)a).shortValue() / (Double)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                            }
                            case "Float": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return Float.valueOf((float)((Short)a).shortValue() / ((Float)b).floatValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return (Short)a / (Integer)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return (long)((Short)a).shortValue() / (Long)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return (Short)a / (Short)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Int": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return (Integer)a / (Byte)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Double": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return (double)((Integer)a).intValue() / (Double)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                            }
                            case "Float": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return Float.valueOf((float)((Integer)a).intValue() / ((Float)b).floatValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return (Integer)a / (Integer)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return (long)((Integer)a).intValue() / (Long)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return (Integer)a / (Short)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Float": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                                }
                                if (b != null) return Float.valueOf(((Float)a).floatValue() / (float)((Byte)b).byteValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Double": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                                }
                                if (b != null) return (double)((Float)a).floatValue() / (Double)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                            }
                            case "Float": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                                }
                                if (b != null) return Float.valueOf(((Float)a).floatValue() / ((Float)b).floatValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                                }
                                if (b != null) return Float.valueOf(((Float)a).floatValue() / (float)((Integer)b).intValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                                }
                                if (b != null) return Float.valueOf(((Float)a).floatValue() / (float)((Long)b).longValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                                }
                                if (b != null) return Float.valueOf(((Float)a).floatValue() / (float)((Short)b).shortValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Long": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return (Long)a / (long)((Byte)b).byteValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Double": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return (double)((Long)a).longValue() / (Double)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                            }
                            case "Float": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return Float.valueOf((float)((Long)a).longValue() / ((Float)b).floatValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return (Long)a / (long)((Integer)b).intValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return (Long)a / (Long)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return (Long)a / (long)((Short)b).shortValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Double": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                                }
                                if (b != null) return (Double)a / (double)((Byte)b).byteValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Double": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                                }
                                if (b != null) return (Double)a / (Double)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                            }
                            case "Float": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                                }
                                if (b != null) return (Double)a / (double)((Float)b).floatValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                                }
                                if (b != null) return (Double)a / (double)((Integer)b).intValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                                }
                                if (b != null) return (Double)a / (double)((Long)b).longValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                                }
                                if (b != null) return (Double)a / (double)((Short)b).shortValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                }
                throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
            }
            case "rem": {
                switch (typeA) {
                    case "Byte": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return (Byte)a % (Byte)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Double": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return (double)((Byte)a).byteValue() % (Double)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                            }
                            case "Float": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return Float.valueOf((float)((Byte)a).byteValue() % ((Float)b).floatValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return (Byte)a % (Integer)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return (long)((Byte)a).byteValue() % (Long)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return (Byte)a % (Short)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Short": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return (Short)a % (Byte)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Double": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return (double)((Short)a).shortValue() % (Double)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                            }
                            case "Float": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return Float.valueOf((float)((Short)a).shortValue() % ((Float)b).floatValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return (Short)a % (Integer)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return (long)((Short)a).shortValue() % (Long)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return (Short)a % (Short)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Int": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return (Integer)a % (Byte)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Double": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return (double)((Integer)a).intValue() % (Double)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                            }
                            case "Float": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return Float.valueOf((float)((Integer)a).intValue() % ((Float)b).floatValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return (Integer)a % (Integer)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return (long)((Integer)a).intValue() % (Long)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return (Integer)a % (Short)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Float": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                                }
                                if (b != null) return Float.valueOf(((Float)a).floatValue() % (float)((Byte)b).byteValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Double": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                                }
                                if (b != null) return (double)((Float)a).floatValue() % (Double)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                            }
                            case "Float": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                                }
                                if (b != null) return Float.valueOf(((Float)a).floatValue() % ((Float)b).floatValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                                }
                                if (b != null) return Float.valueOf(((Float)a).floatValue() % (float)((Integer)b).intValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                                }
                                if (b != null) return Float.valueOf(((Float)a).floatValue() % (float)((Long)b).longValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                                }
                                if (b != null) return Float.valueOf(((Float)a).floatValue() % (float)((Short)b).shortValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Long": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return (Long)a % (long)((Byte)b).byteValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Double": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return (double)((Long)a).longValue() % (Double)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                            }
                            case "Float": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return Float.valueOf((float)((Long)a).longValue() % ((Float)b).floatValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return (Long)a % (long)((Integer)b).intValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return (Long)a % (Long)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return (Long)a % (long)((Short)b).shortValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Double": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                                }
                                if (b != null) return (Double)a % (double)((Byte)b).byteValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Double": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                                }
                                if (b != null) return (Double)a % (Double)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                            }
                            case "Float": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                                }
                                if (b != null) return (Double)a % (double)((Float)b).floatValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                                }
                                if (b != null) return (Double)a % (double)((Integer)b).intValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                                }
                                if (b != null) return (Double)a % (double)((Long)b).longValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                                }
                                if (b != null) return (Double)a % (double)((Short)b).shortValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                }
                throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
            }
            case "times": {
                switch (typeA) {
                    case "Byte": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return (Byte)a * (Byte)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Double": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return (double)((Byte)a).byteValue() * (Double)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                            }
                            case "Float": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return Float.valueOf((float)((Byte)a).byteValue() * ((Float)b).floatValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return (Byte)a * (Integer)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return (long)((Byte)a).byteValue() * (Long)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                if (b != null) return (Byte)a * (Short)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Short": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return (Short)a * (Byte)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Double": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return (double)((Short)a).shortValue() * (Double)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                            }
                            case "Float": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return Float.valueOf((float)((Short)a).shortValue() * ((Float)b).floatValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return (Short)a * (Integer)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return (long)((Short)a).shortValue() * (Long)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                if (b != null) return (Short)a * (Short)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Int": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return (Integer)a * (Byte)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Double": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return (double)((Integer)a).intValue() * (Double)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                            }
                            case "Float": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return Float.valueOf((float)((Integer)a).intValue() * ((Float)b).floatValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return (Integer)a * (Integer)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return (long)((Integer)a).intValue() * (Long)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                if (b != null) return (Integer)a * (Short)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Float": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                                }
                                if (b != null) return Float.valueOf(((Float)a).floatValue() * (float)((Byte)b).byteValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Double": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                                }
                                if (b != null) return (double)((Float)a).floatValue() * (Double)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                            }
                            case "Float": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                                }
                                if (b != null) return Float.valueOf(((Float)a).floatValue() * ((Float)b).floatValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                                }
                                if (b != null) return Float.valueOf(((Float)a).floatValue() * (float)((Integer)b).intValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                                }
                                if (b != null) return Float.valueOf(((Float)a).floatValue() * (float)((Long)b).longValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                                }
                                if (b != null) return Float.valueOf(((Float)a).floatValue() * (float)((Short)b).shortValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Long": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return (Long)a * (long)((Byte)b).byteValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Double": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return (double)((Long)a).longValue() * (Double)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                            }
                            case "Float": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return Float.valueOf((float)((Long)a).longValue() * ((Float)b).floatValue());
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return (Long)a * (long)((Integer)b).intValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return (Long)a * (Long)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                if (b != null) return (Long)a * (long)((Short)b).shortValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Double": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                                }
                                if (b != null) return (Double)a * (double)((Byte)b).byteValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                            }
                            case "Double": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                                }
                                if (b != null) return (Double)a * (Double)b;
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                            }
                            case "Float": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                                }
                                if (b != null) return (Double)a * (double)((Float)b).floatValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                                }
                                if (b != null) return (Double)a * (double)((Integer)b).intValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                                }
                                if (b != null) return (Double)a * (double)((Long)b).longValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                                }
                                if (b != null) return (Double)a * (double)((Short)b).shortValue();
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                }
                throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
            }
            case "shl": {
                String string3 = typeA;
                if (Intrinsics.areEqual(string3, "Int")) {
                    if (!Intrinsics.areEqual(typeB, "Int")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    if (a == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    if (b != null) return (Integer)a << (Integer)b;
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                if (!Intrinsics.areEqual(string3, "Long")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                if (!Intrinsics.areEqual(typeB, "Int")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                if (a == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                }
                if (b != null) return (Long)a << (Integer)b;
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
            }
            case "shr": {
                String string4 = typeA;
                if (Intrinsics.areEqual(string4, "Int")) {
                    if (!Intrinsics.areEqual(typeB, "Int")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    if (a == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    if (b != null) return (Integer)a >> (Integer)b;
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                if (!Intrinsics.areEqual(string4, "Long")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                if (!Intrinsics.areEqual(typeB, "Int")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                if (a == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                }
                if (b != null) return (Long)a >> (Integer)b;
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
            }
            case "ushr": {
                String string5 = typeA;
                if (Intrinsics.areEqual(string5, "Int")) {
                    if (!Intrinsics.areEqual(typeB, "Int")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    if (a == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    if (b != null) return (Integer)a >>> (Integer)b;
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                if (!Intrinsics.areEqual(string5, "Long")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                if (!Intrinsics.areEqual(typeB, "Int")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                if (a == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                }
                if (b != null) return (Long)a >>> (Integer)b;
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
            }
            case "get": {
                switch (typeA) {
                    case "String": {
                        if (!Intrinsics.areEqual(typeB, "Int")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                        }
                        if (b != null) return Character.valueOf(((String)a).charAt((Integer)b));
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    case "CharSequence": {
                        if (!Intrinsics.areEqual(typeB, "Int")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        if (b != null) return Character.valueOf(((CharSequence)a).charAt((Integer)b));
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    case "BooleanArray": {
                        if (!Intrinsics.areEqual(typeB, "Int")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.BooleanArray");
                        }
                        if (b != null) return ((boolean[])a)[(Integer)b];
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    case "CharArray": {
                        if (!Intrinsics.areEqual(typeB, "Int")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharArray");
                        }
                        if (b != null) return Character.valueOf(((char[])a)[(Integer)b]);
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    case "ByteArray": {
                        if (!Intrinsics.areEqual(typeB, "Int")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.ByteArray");
                        }
                        if (b != null) return ((byte[])a)[(Integer)b];
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    case "ShortArray": {
                        if (!Intrinsics.areEqual(typeB, "Int")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.ShortArray");
                        }
                        if (b != null) return ((short[])a)[(Integer)b];
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    case "IntArray": {
                        if (!Intrinsics.areEqual(typeB, "Int")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.IntArray");
                        }
                        if (b != null) return ((int[])a)[(Integer)b];
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    case "FloatArray": {
                        if (!Intrinsics.areEqual(typeB, "Int")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.FloatArray");
                        }
                        if (b != null) return Float.valueOf(((float[])a)[(Integer)b]);
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    case "LongArray": {
                        if (!Intrinsics.areEqual(typeB, "Int")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.LongArray");
                        }
                        if (b != null) return ((long[])a)[(Integer)b];
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    case "DoubleArray": {
                        if (!Intrinsics.areEqual(typeB, "Int")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.DoubleArray");
                        }
                        if (b != null) return ((double[])a)[(Integer)b];
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    case "Array": {
                        if (!Intrinsics.areEqual(typeB, "Int")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
                        }
                        if (b != null) return ((Object[])a)[(Integer)b];
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                }
                throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
            }
            case "less": {
                switch (typeA) {
                    case "Char": {
                        boolean bl;
                        if (!Intrinsics.areEqual(typeB, "Char")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Char");
                        }
                        if (b == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Char");
                        }
                        if (Intrinsics.compare(((Character)a).charValue(), ((Character)b).charValue()) < 0) {
                            bl = true;
                            return bl;
                        }
                        bl = false;
                        return bl;
                    }
                    case "Byte": {
                        boolean bl;
                        if (!Intrinsics.areEqual(typeB, "Byte")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                        }
                        if (b == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                        }
                        if ((Byte)a < (Byte)b) {
                            bl = true;
                            return bl;
                        }
                        bl = false;
                        return bl;
                    }
                    case "Short": {
                        boolean bl;
                        if (!Intrinsics.areEqual(typeB, "Short")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                        }
                        if (b == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                        }
                        if ((Short)a < (Short)b) {
                            bl = true;
                            return bl;
                        }
                        bl = false;
                        return bl;
                    }
                    case "Int": {
                        boolean bl;
                        if (!Intrinsics.areEqual(typeB, "Int")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                        }
                        if (b == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                        }
                        if ((Integer)a < (Integer)b) {
                            bl = true;
                            return bl;
                        }
                        bl = false;
                        return bl;
                    }
                    case "Float": {
                        boolean bl;
                        if (!Intrinsics.areEqual(typeB, "Float")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                        }
                        if (b == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                        }
                        if (((Float)a).floatValue() < ((Float)b).floatValue()) {
                            bl = true;
                            return bl;
                        }
                        bl = false;
                        return bl;
                    }
                    case "Long": {
                        boolean bl;
                        if (!Intrinsics.areEqual(typeB, "Long")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                        }
                        if (b == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                        }
                        if ((Long)a < (Long)b) {
                            bl = true;
                            return bl;
                        }
                        bl = false;
                        return bl;
                    }
                    case "Double": {
                        boolean bl;
                        if (!Intrinsics.areEqual(typeB, "Double")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                        }
                        if (b == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                        }
                        if ((Double)a < (Double)b) {
                            bl = true;
                            return bl;
                        }
                        bl = false;
                        return bl;
                    }
                }
                throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
            }
            case "lessOrEqual": {
                switch (typeA) {
                    case "Char": {
                        boolean bl;
                        if (!Intrinsics.areEqual(typeB, "Char")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Char");
                        }
                        if (b == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Char");
                        }
                        if (Intrinsics.compare(((Character)a).charValue(), ((Character)b).charValue()) <= 0) {
                            bl = true;
                            return bl;
                        }
                        bl = false;
                        return bl;
                    }
                    case "Byte": {
                        boolean bl;
                        if (!Intrinsics.areEqual(typeB, "Byte")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                        }
                        if (b == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                        }
                        if ((Byte)a <= (Byte)b) {
                            bl = true;
                            return bl;
                        }
                        bl = false;
                        return bl;
                    }
                    case "Short": {
                        boolean bl;
                        if (!Intrinsics.areEqual(typeB, "Short")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                        }
                        if (b == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                        }
                        if ((Short)a <= (Short)b) {
                            bl = true;
                            return bl;
                        }
                        bl = false;
                        return bl;
                    }
                    case "Int": {
                        boolean bl;
                        if (!Intrinsics.areEqual(typeB, "Int")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                        }
                        if (b == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                        }
                        if ((Integer)a <= (Integer)b) {
                            bl = true;
                            return bl;
                        }
                        bl = false;
                        return bl;
                    }
                    case "Float": {
                        boolean bl;
                        if (!Intrinsics.areEqual(typeB, "Float")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                        }
                        if (b == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                        }
                        if (((Float)a).floatValue() <= ((Float)b).floatValue()) {
                            bl = true;
                            return bl;
                        }
                        bl = false;
                        return bl;
                    }
                    case "Long": {
                        boolean bl;
                        if (!Intrinsics.areEqual(typeB, "Long")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                        }
                        if (b == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                        }
                        if ((Long)a <= (Long)b) {
                            bl = true;
                            return bl;
                        }
                        bl = false;
                        return bl;
                    }
                    case "Double": {
                        boolean bl;
                        if (!Intrinsics.areEqual(typeB, "Double")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                        }
                        if (b == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                        }
                        if ((Double)a <= (Double)b) {
                            bl = true;
                            return bl;
                        }
                        bl = false;
                        return bl;
                    }
                }
                throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
            }
            case "greater": {
                switch (typeA) {
                    case "Char": {
                        boolean bl;
                        if (!Intrinsics.areEqual(typeB, "Char")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Char");
                        }
                        if (b == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Char");
                        }
                        if (Intrinsics.compare(((Character)a).charValue(), ((Character)b).charValue()) > 0) {
                            bl = true;
                            return bl;
                        }
                        bl = false;
                        return bl;
                    }
                    case "Byte": {
                        boolean bl;
                        if (!Intrinsics.areEqual(typeB, "Byte")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                        }
                        if (b == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                        }
                        if ((Byte)a > (Byte)b) {
                            bl = true;
                            return bl;
                        }
                        bl = false;
                        return bl;
                    }
                    case "Short": {
                        boolean bl;
                        if (!Intrinsics.areEqual(typeB, "Short")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                        }
                        if (b == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                        }
                        if ((Short)a > (Short)b) {
                            bl = true;
                            return bl;
                        }
                        bl = false;
                        return bl;
                    }
                    case "Int": {
                        boolean bl;
                        if (!Intrinsics.areEqual(typeB, "Int")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                        }
                        if (b == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                        }
                        if ((Integer)a > (Integer)b) {
                            bl = true;
                            return bl;
                        }
                        bl = false;
                        return bl;
                    }
                    case "Float": {
                        boolean bl;
                        if (!Intrinsics.areEqual(typeB, "Float")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                        }
                        if (b == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                        }
                        if (((Float)a).floatValue() > ((Float)b).floatValue()) {
                            bl = true;
                            return bl;
                        }
                        bl = false;
                        return bl;
                    }
                    case "Long": {
                        boolean bl;
                        if (!Intrinsics.areEqual(typeB, "Long")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                        }
                        if (b == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                        }
                        if ((Long)a > (Long)b) {
                            bl = true;
                            return bl;
                        }
                        bl = false;
                        return bl;
                    }
                    case "Double": {
                        boolean bl;
                        if (!Intrinsics.areEqual(typeB, "Double")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                        }
                        if (b == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                        }
                        if ((Double)a > (Double)b) {
                            bl = true;
                            return bl;
                        }
                        bl = false;
                        return bl;
                    }
                }
                throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
            }
            case "greaterOrEqual": {
                switch (typeA) {
                    case "Char": {
                        boolean bl;
                        if (!Intrinsics.areEqual(typeB, "Char")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Char");
                        }
                        if (b == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Char");
                        }
                        if (Intrinsics.compare(((Character)a).charValue(), ((Character)b).charValue()) >= 0) {
                            bl = true;
                            return bl;
                        }
                        bl = false;
                        return bl;
                    }
                    case "Byte": {
                        boolean bl;
                        if (!Intrinsics.areEqual(typeB, "Byte")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                        }
                        if (b == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                        }
                        if ((Byte)a >= (Byte)b) {
                            bl = true;
                            return bl;
                        }
                        bl = false;
                        return bl;
                    }
                    case "Short": {
                        boolean bl;
                        if (!Intrinsics.areEqual(typeB, "Short")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                        }
                        if (b == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                        }
                        if ((Short)a >= (Short)b) {
                            bl = true;
                            return bl;
                        }
                        bl = false;
                        return bl;
                    }
                    case "Int": {
                        boolean bl;
                        if (!Intrinsics.areEqual(typeB, "Int")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                        }
                        if (b == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                        }
                        if ((Integer)a >= (Integer)b) {
                            bl = true;
                            return bl;
                        }
                        bl = false;
                        return bl;
                    }
                    case "Float": {
                        boolean bl;
                        if (!Intrinsics.areEqual(typeB, "Float")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                        }
                        if (b == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                        }
                        if (((Float)a).floatValue() >= ((Float)b).floatValue()) {
                            bl = true;
                            return bl;
                        }
                        bl = false;
                        return bl;
                    }
                    case "Long": {
                        boolean bl;
                        if (!Intrinsics.areEqual(typeB, "Long")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                        }
                        if (b == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                        }
                        if ((Long)a >= (Long)b) {
                            bl = true;
                            return bl;
                        }
                        bl = false;
                        return bl;
                    }
                    case "Double": {
                        boolean bl;
                        if (!Intrinsics.areEqual(typeB, "Double")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                        }
                        if (b == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                        }
                        if ((Double)a >= (Double)b) {
                            bl = true;
                            return bl;
                        }
                        bl = false;
                        return bl;
                    }
                }
                throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
            }
            case "EQEQ": {
                String string6 = typeA;
                if (!Intrinsics.areEqual(string6, "Any?")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                if (!Intrinsics.areEqual(typeB, "Any?")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                return Intrinsics.areEqual(a, b);
            }
            case "EQEQEQ": {
                boolean bl;
                String string7 = typeA;
                if (!Intrinsics.areEqual(string7, "Any?")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                if (!Intrinsics.areEqual(typeB, "Any?")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                if (a instanceof Proxy && b instanceof Proxy) {
                    if (((Proxy)a).getState() == ((Proxy)b).getState()) {
                        bl = true;
                        return bl;
                    }
                    bl = false;
                    return bl;
                }
                if (a == b) {
                    bl = true;
                    return bl;
                }
                bl = false;
                return bl;
            }
            case "ieee754equals": {
                String string8 = typeA;
                if (Intrinsics.areEqual(string8, "Float?")) {
                    if (!Intrinsics.areEqual(typeB, "Float?")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    return Intrinsics.areEqual((Float)a, (Float)b);
                }
                if (!Intrinsics.areEqual(string8, "Double?")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                if (!Intrinsics.areEqual(typeB, "Double?")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                return Intrinsics.areEqual((Double)a, (Double)b);
            }
            case "ANDAND": {
                boolean bl;
                String string9 = typeA;
                if (!Intrinsics.areEqual(string9, "Boolean")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                if (!Intrinsics.areEqual(typeB, "Boolean")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                if (a == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                }
                if (((Boolean)a).booleanValue()) {
                    if (b == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                    }
                    if (((Boolean)b).booleanValue()) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
            case "OROR": {
                boolean bl;
                String string10 = typeA;
                if (!Intrinsics.areEqual(string10, "Boolean")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                if (!Intrinsics.areEqual(typeB, "Boolean")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                if (a == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                }
                if (!((Boolean)a).booleanValue()) {
                    if (b == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                    }
                    if (!((Boolean)b).booleanValue()) {
                        bl = false;
                        return bl;
                    }
                }
                bl = true;
                return bl;
            }
            case "mod": {
                switch (typeA) {
                    case "Byte": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                byte by = (Byte)a;
                                if (b == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                byte by2 = (Byte)b;
                                int n = by % by2;
                                return (byte)(n + (by2 & ((n ^ by2) & (n | -n)) >> 31));
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                byte by = (Byte)a;
                                if (b == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                short s = (Short)b;
                                int n = by % s;
                                return (short)(n + (s & ((n ^ s) & (n | -n)) >> 31));
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                byte by = (Byte)a;
                                if (b == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                int n = (Integer)b;
                                byte by3 = by;
                                int n2 = by3 % n;
                                return n2 + (n & ((n2 ^ n) & (n2 | -n2)) >> 31);
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                byte by = (Byte)a;
                                if (b == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                long l = (Long)b;
                                long l2 = by;
                                long l3 = l2 % l;
                                return l3 + (l & ((l3 ^ l) & (l3 | -l3)) >> 63);
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Short": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                short s = (Short)a;
                                if (b == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                byte by = (Byte)b;
                                int n = s % by;
                                return (byte)(n + (by & ((n ^ by) & (n | -n)) >> 31));
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                short s = (Short)a;
                                if (b == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                short s2 = (Short)b;
                                int n = s % s2;
                                return (short)(n + (s2 & ((n ^ s2) & (n | -n)) >> 31));
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                short s = (Short)a;
                                if (b == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                int n = (Integer)b;
                                short s3 = s;
                                int n3 = s3 % n;
                                return n3 + (n & ((n3 ^ n) & (n3 | -n3)) >> 31);
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                short s = (Short)a;
                                if (b == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                long l = (Long)b;
                                long l4 = s;
                                long l5 = l4 % l;
                                return l5 + (l & ((l5 ^ l) & (l5 | -l5)) >> 63);
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Int": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                int n = (Integer)a;
                                if (b == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                byte by = (Byte)b;
                                int n4 = n % by;
                                return (byte)(n4 + (by & ((n4 ^ by) & (n4 | -n4)) >> 31));
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                int n = (Integer)a;
                                if (b == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                short s = (Short)b;
                                int n5 = n % s;
                                return (short)(n5 + (s & ((n5 ^ s) & (n5 | -n5)) >> 31));
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                int n = (Integer)a;
                                if (b == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                int n6 = (Integer)b;
                                int n7 = n % n6;
                                return n7 + (n6 & ((n7 ^ n6) & (n7 | -n7)) >> 31);
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                int n = (Integer)a;
                                if (b == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                long l = (Long)b;
                                long l6 = n;
                                long l7 = l6 % l;
                                return l7 + (l & ((l7 ^ l) & (l7 | -l7)) >> 63);
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Long": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                long l = (Long)a;
                                if (b == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                long l8 = ((Byte)b).byteValue();
                                long l9 = l % l8;
                                return (byte)(l9 + (l8 & ((l9 ^ l8) & (l9 | -l9)) >> 63));
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                long l = (Long)a;
                                if (b == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                long l10 = ((Short)b).shortValue();
                                long l11 = l % l10;
                                return (short)(l11 + (l10 & ((l11 ^ l10) & (l11 | -l11)) >> 63));
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                long l = (Long)a;
                                if (b == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                long l12 = ((Integer)b).intValue();
                                long l13 = l % l12;
                                return (int)(l13 + (l12 & ((l13 ^ l12) & (l13 | -l13)) >> 63));
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                long l = (Long)a;
                                if (b == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                long l14 = (Long)b;
                                long l15 = l % l14;
                                return l15 + (l14 & ((l15 ^ l14) & (l15 | -l15)) >> 63);
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Float": {
                        double d;
                        String string11 = typeB;
                        if (Intrinsics.areEqual(string11, "Float")) {
                            float f;
                            if (a == null) {
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                            }
                            float f2 = ((Float)a).floatValue();
                            if (b == null) {
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                            }
                            float f3 = ((Float)b).floatValue();
                            float f4 = f2 % f3;
                            if (!(f4 == 0.0f) && !(Math.signum(f4) == Math.signum(f3))) {
                                f = f4 + f3;
                                return Float.valueOf(f);
                            }
                            f = f4;
                            return Float.valueOf(f);
                        }
                        if (!Intrinsics.areEqual(string11, "Double")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                        }
                        float f = ((Float)a).floatValue();
                        if (b == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                        }
                        double d2 = f;
                        double d3 = (Double)b;
                        double d4 = d2 % d3;
                        if (!(d4 == 0.0) && !(Math.signum(d4) == Math.signum(d3))) {
                            d = d4 + d3;
                            return d;
                        }
                        d = d4;
                        return d;
                    }
                    case "Double": {
                        double d;
                        String string12 = typeB;
                        if (Intrinsics.areEqual(string12, "Float")) {
                            double d5;
                            if (a == null) {
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                            }
                            double d6 = (Double)a;
                            if (b == null) {
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                            }
                            double d7 = ((Float)b).floatValue();
                            double d8 = d6 % d7;
                            if (!(d8 == 0.0) && !(Math.signum(d8) == Math.signum(d7))) {
                                d5 = d8 + d7;
                                return d5;
                            }
                            d5 = d8;
                            return d5;
                        }
                        if (!Intrinsics.areEqual(string12, "Double")) throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                        }
                        double d9 = (Double)a;
                        if (b == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                        }
                        double d10 = (Double)b;
                        double d11 = d9 % d10;
                        if (!(d11 == 0.0) && !(Math.signum(d11) == Math.signum(d10))) {
                            d = d11 + d10;
                            return d;
                        }
                        d = d11;
                        return d;
                    }
                }
                throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
            }
            case "floorDiv": {
                switch (typeA) {
                    case "Byte": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                byte by = (Byte)a;
                                if (b == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                byte by4 = (Byte)b;
                                int n = by / by4;
                                if ((by ^ by4) >= 0) return n;
                                if (n * by4 == by) return n;
                                int n8 = n;
                                n = n8 + -1;
                                return n;
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                byte by = (Byte)a;
                                if (b == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                short s = (Short)b;
                                int n = by / s;
                                if ((by ^ s) >= 0) return n;
                                if (n * s == by) return n;
                                int n9 = n;
                                n = n9 + -1;
                                return n;
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                byte by = (Byte)a;
                                if (b == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                int n = (Integer)b;
                                byte by5 = by;
                                int n10 = by5 / n;
                                if ((by5 ^ n) >= 0) return n10;
                                if (n10 * n == by5) return n10;
                                int n11 = n10;
                                n10 = n11 + -1;
                                return n10;
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                byte by = (Byte)a;
                                if (b == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                long l = (Long)b;
                                long l16 = by;
                                long l17 = l16 / l;
                                if ((l16 ^ l) >= 0L) return l17;
                                if (l17 * l == l16) return l17;
                                long l18 = l17;
                                l17 = l18 + -1L;
                                return l17;
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Short": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                short s = (Short)a;
                                if (b == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                byte by = (Byte)b;
                                int n = s / by;
                                if ((s ^ by) >= 0) return n;
                                if (n * by == s) return n;
                                int n12 = n;
                                n = n12 + -1;
                                return n;
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                short s = (Short)a;
                                if (b == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                short s4 = (Short)b;
                                int n = s / s4;
                                if ((s ^ s4) >= 0) return n;
                                if (n * s4 == s) return n;
                                int n13 = n;
                                n = n13 + -1;
                                return n;
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                short s = (Short)a;
                                if (b == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                int n = (Integer)b;
                                short s5 = s;
                                int n14 = s5 / n;
                                if ((s5 ^ n) >= 0) return n14;
                                if (n14 * n == s5) return n14;
                                int n15 = n14;
                                n14 = n15 + -1;
                                return n14;
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                short s = (Short)a;
                                if (b == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                long l = (Long)b;
                                long l19 = s;
                                long l20 = l19 / l;
                                if ((l19 ^ l) >= 0L) return l20;
                                if (l20 * l == l19) return l20;
                                long l21 = l20;
                                l20 = l21 + -1L;
                                return l20;
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Int": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                int n = (Integer)a;
                                if (b == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                byte by = (Byte)b;
                                int n16 = n / by;
                                if ((n ^ by) >= 0) return n16;
                                if (n16 * by == n) return n16;
                                int n17 = n16;
                                n16 = n17 + -1;
                                return n16;
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                int n = (Integer)a;
                                if (b == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                short s = (Short)b;
                                int n18 = n / s;
                                if ((n ^ s) >= 0) return n18;
                                if (n18 * s == n) return n18;
                                int n19 = n18;
                                n18 = n19 + -1;
                                return n18;
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                int n = (Integer)a;
                                if (b == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                int n20 = (Integer)b;
                                int n21 = n / n20;
                                if ((n ^ n20) >= 0) return n21;
                                if (n21 * n20 == n) return n21;
                                int n22 = n21;
                                n21 = n22 + -1;
                                return n21;
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                int n = (Integer)a;
                                if (b == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                long l = (Long)b;
                                long l22 = n;
                                long l23 = l22 / l;
                                if ((l22 ^ l) >= 0L) return l23;
                                if (l23 * l == l22) return l23;
                                long l24 = l23;
                                l23 = l24 + -1L;
                                return l23;
                            }
                        }
                        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
                    }
                    case "Long": {
                        switch (typeB) {
                            case "Byte": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                long l = (Long)a;
                                if (b == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                                }
                                long l25 = ((Byte)b).byteValue();
                                long l26 = l / l25;
                                if ((l ^ l25) >= 0L) return l26;
                                if (l26 * l25 == l) return l26;
                                long l27 = l26;
                                l26 = l27 + -1L;
                                return l26;
                            }
                            case "Short": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                long l = (Long)a;
                                if (b == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                                }
                                long l28 = ((Short)b).shortValue();
                                long l29 = l / l28;
                                if ((l ^ l28) >= 0L) return l29;
                                if (l29 * l28 == l) return l29;
                                long l30 = l29;
                                l29 = l30 + -1L;
                                return l29;
                            }
                            case "Int": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                long l = (Long)a;
                                if (b == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                                }
                                long l31 = ((Integer)b).intValue();
                                long l32 = l / l31;
                                if ((l ^ l31) >= 0L) return l32;
                                if (l32 * l31 == l) return l32;
                                long l33 = l32;
                                l32 = l33 + -1L;
                                return l32;
                            }
                            case "Long": {
                                if (a == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                long l = (Long)a;
                                if (b == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                                }
                                long l34 = (Long)b;
                                long l35 = l / l34;
                                if ((l ^ l34) >= 0L) return l35;
                                if (l35 * l34 == l) return l35;
                                long l36 = l35;
                                l35 = l36 + -1L;
                                return l35;
                            }
                        }
                    }
                }
                throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
            }
        }
        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ')');
    }

    @NotNull
    public static final Object interpretTernaryFunction(@NotNull String name2, @NotNull String typeA, @NotNull String typeB, @NotNull String typeC, @Nullable Object a, @Nullable Object b, @Nullable Object c) {
        block68: {
            String string2;
            block67: {
                Intrinsics.checkNotNullParameter(name2, "name");
                Intrinsics.checkNotNullParameter(typeA, "typeA");
                Intrinsics.checkNotNullParameter(typeB, "typeB");
                Intrinsics.checkNotNullParameter(typeC, "typeC");
                string2 = name2;
                if (!Intrinsics.areEqual(string2, "subSequence")) break block67;
                String string3 = typeA;
                if (Intrinsics.areEqual(string3, "String")) {
                    if (Intrinsics.areEqual(typeB, "Int") && Intrinsics.areEqual(typeC, "Int")) {
                        if (a == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                        }
                        if (b == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                        }
                        if (c == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                        }
                        return ((String)a).subSequence((Integer)b, (Integer)c);
                    }
                } else if (Intrinsics.areEqual(string3, "CharSequence") && Intrinsics.areEqual(typeB, "Int") && Intrinsics.areEqual(typeC, "Int")) {
                    if (a == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    if (b == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    if (c == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    return ((CharSequence)a).subSequence((Integer)b, (Integer)c);
                }
                break block68;
            }
            if (!Intrinsics.areEqual(string2, "set")) break block68;
            switch (typeA) {
                case "BooleanArray": {
                    if (!Intrinsics.areEqual(typeB, "Int") || !Intrinsics.areEqual(typeC, "Boolean")) break;
                    if (a == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.BooleanArray");
                    }
                    if (b == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    if (c == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                    }
                    ((boolean[])a)[((Integer)b).intValue()] = (Boolean)c;
                    return Unit.INSTANCE;
                }
                case "CharArray": {
                    if (!Intrinsics.areEqual(typeB, "Int") || !Intrinsics.areEqual(typeC, "Char")) break;
                    if (a == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharArray");
                    }
                    if (b == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    if (c == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Char");
                    }
                    ((char[])a)[((Integer)b).intValue()] = ((Character)c).charValue();
                    return Unit.INSTANCE;
                }
                case "ByteArray": {
                    if (!Intrinsics.areEqual(typeB, "Int") || !Intrinsics.areEqual(typeC, "Byte")) break;
                    if (a == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.ByteArray");
                    }
                    if (b == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    if (c == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                    }
                    ((byte[])a)[((Integer)b).intValue()] = (Byte)c;
                    return Unit.INSTANCE;
                }
                case "ShortArray": {
                    if (!Intrinsics.areEqual(typeB, "Int") || !Intrinsics.areEqual(typeC, "Short")) break;
                    if (a == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.ShortArray");
                    }
                    if (b == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    if (c == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                    }
                    ((short[])a)[((Integer)b).intValue()] = (Short)c;
                    return Unit.INSTANCE;
                }
                case "IntArray": {
                    if (!Intrinsics.areEqual(typeB, "Int") || !Intrinsics.areEqual(typeC, "Int")) break;
                    if (a == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.IntArray");
                    }
                    if (b == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    if (c == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    ((int[])a)[((Integer)b).intValue()] = (Integer)c;
                    return Unit.INSTANCE;
                }
                case "FloatArray": {
                    if (!Intrinsics.areEqual(typeB, "Int") || !Intrinsics.areEqual(typeC, "Float")) break;
                    if (a == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.FloatArray");
                    }
                    if (b == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    if (c == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                    }
                    ((float[])a)[((Integer)b).intValue()] = ((Float)c).floatValue();
                    return Unit.INSTANCE;
                }
                case "LongArray": {
                    if (!Intrinsics.areEqual(typeB, "Int") || !Intrinsics.areEqual(typeC, "Long")) break;
                    if (a == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.LongArray");
                    }
                    if (b == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    if (c == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                    }
                    ((long[])a)[((Integer)b).intValue()] = (Long)c;
                    return Unit.INSTANCE;
                }
                case "DoubleArray": {
                    if (!Intrinsics.areEqual(typeB, "Int") || !Intrinsics.areEqual(typeC, "Double")) break;
                    if (a == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.DoubleArray");
                    }
                    if (b == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    if (c == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                    }
                    ((double[])a)[((Integer)b).intValue()] = (Double)c;
                    return Unit.INSTANCE;
                }
                case "Array": {
                    if (!Intrinsics.areEqual(typeB, "Int") || !Intrinsics.areEqual(typeC, "T")) break;
                    if (a == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
                    }
                    if (b == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    ((Object[])a)[((Integer)b).intValue()] = c;
                    return Unit.INSTANCE;
                }
            }
        }
        throw new InterpreterMethodNotFoundError("Unknown function: " + name2 + '(' + typeA + ", " + typeB + ", " + typeC + ')');
    }
}

