/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.builder;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableSet;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.FirExpressionRef;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirFunctionTarget;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElementKt;
import org.jetbrains.kotlin.fir.FirTargetElement;
import org.jetbrains.kotlin.fir.builder.CharacterWithDiagnostic;
import org.jetbrains.kotlin.fir.builder.FirAnnotationContainerBuilder;
import org.jetbrains.kotlin.fir.contracts.FirContractDescription;
import org.jetbrains.kotlin.fir.contracts.builder.FirLegacyRawContractDescriptionBuilder;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.builder.FirAnonymousObjectBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirClassBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirPropertyAccessorBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirPropertyBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirRegularClassBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirValueParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyAccessor;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArgumentUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirBinaryLogicExpression;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirCheckedSafeCallSubject;
import org.jetbrains.kotlin.fir.expressions.FirComparisonExpression;
import org.jetbrains.kotlin.fir.expressions.FirElvisExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCallOrigin;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirSafeCallExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.LogicOperationKind;
import org.jetbrains.kotlin.fir.expressions.builder.FirArgumentListBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirBinaryLogicExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCallableReferenceAccessBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCheckedSafeCallSubjectBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirComparisonExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirConstExpressionBuilderKt;
import org.jetbrains.kotlin.fir.expressions.builder.FirElvisExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirExpressionStubBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirFunctionCallBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirPropertyAccessExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirReturnExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirSafeCallExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirThisReceiverExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirWrappedDelegateExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import org.jetbrains.kotlin.fir.expressions.impl.FirStubStatement;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.builder.FirDelegateFieldReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirImplicitThisReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirResolvedNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirSimpleNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.SymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirDelegateFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.builder.FirImplicitTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBuiltinTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitKMutableProperty0TypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitKMutableProperty1TypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitKMutableProperty2TypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitKProperty0TypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitKProperty1TypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitKProperty2TypeRef;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.ConstantValueKind;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u00c8\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a.\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u00012\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u001a\u0018\u0010\u001b\u001a\u00020\u00142\b\u0010\u001c\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001d\u001a\u00020\u001e\u001a(\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00162\u0006\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020$\u001a4\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u00012\u0006\u0010#\u001a\u00020$2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&\u001a\u0010\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020)H\u0000\u001a\u0016\u0010*\u001a\u00020\u0003*\u00020$2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0012H\u0002\u001a0\u0010+\u001a\u00020,*\u00020$2\b\u0010-\u001a\u0004\u0018\u00010\u00162\b\u0010.\u001a\u0004\u0018\u00010\u00162\u0006\u0010/\u001a\u00020$2\u0006\u00100\u001a\u00020\u0001H\u0002\u001a\u001c\u00101\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u000103\u0012\u0006\u0012\u0004\u0018\u00010402*\u0004\u0018\u000103\u001aS\u00105\u001a\u000206*\u0002072\b\u00108\u001a\u0004\u0018\u0001092\u0006\u0010 \u001a\u00020!2\f\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010:\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\u00032\b\u0010<\u001a\u0004\u0018\u00010$\u00a2\u0006\u0002\u0010=\u001a.\u0010>\u001a\u00020?*\u00020$2\u0006\u0010/\u001a\u00020$2\u0006\u0010@\u001a\u00020A2\b\u0010.\u001a\u0004\u0018\u00010\u00162\b\u0010-\u001a\u0004\u0018\u00010\u0016\u001a.\u0010B\u001a\u00020,*\u00020$2\u0006\u0010/\u001a\u00020$2\u0006\u0010C\u001a\u00020\u00032\b\u0010.\u001a\u0004\u0018\u00010\u00162\b\u0010-\u001a\u0004\u0018\u00010\u0016\u001a$\u0010D\u001a\u00020E*\u00020$2\u0006\u0010F\u001a\u00020$2\u0006\u0010G\u001a\u00020\u00032\b\u0010.\u001a\u0004\u0018\u00010\u0016\u001a\u001c\u0010H\u001a\u00020I*\u00020$2\u0006\u0010F\u001a\u00020$2\b\u0010.\u001a\u0004\u0018\u00010\u0016\u001a\n\u0010J\u001a\u00020\u0003*\u000203\u001a\n\u0010K\u001a\u00020\u0010*\u00020\u0012\u001a\f\u0010L\u001a\u0004\u0018\u00010\u0001*\u00020A\u001a\n\u0010M\u001a\u00020N*\u00020A\u001a\f\u0010O\u001a\u0004\u0018\u00010\u0001*\u00020A\u001a\u001a\u0010P\u001a\u00020Q*\u00020R2\u0006\u0010<\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u0016\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0002\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0005\"\u0017\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u001b\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006S"}, d2={"DELEGATED_SETTER_PARAM", "Lorg/jetbrains/kotlin/name/Name;", "isUnderscore", "", "", "(Ljava/lang/CharSequence;)Z", "ownerRegularClassTypeParametersCount", "", "Lorg/jetbrains/kotlin/fir/declarations/builder/FirClassBuilder;", "getOwnerRegularClassTypeParametersCount", "(Lorg/jetbrains/kotlin/fir/declarations/builder/FirClassBuilder;)Ljava/lang/Integer;", "ownerRegularOrAnonymousObjectSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "getOwnerRegularOrAnonymousObjectSymbol", "(Lorg/jetbrains/kotlin/fir/declarations/builder/FirClassBuilder;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "escapedStringToCharacter", "Lorg/jetbrains/kotlin/fir/builder/CharacterWithDiagnostic;", "text", "", "generateAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "qualifiedSource", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "calleeReferenceSource", "name", "diagnostic", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "generateResolvedAccessExpression", "source", "variable", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "generateTemporaryVariable", "moduleData", "Lorg/jetbrains/kotlin/fir/FirModuleData;", "specialName", "initializer", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "translateEscape", "c", "", "checkReceiver", "createConventionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "operationReferenceSource", "baseSource", "argument", "conventionName", "extractContractDescriptionIfPossible", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "Lorg/jetbrains/kotlin/fir/contracts/FirContractDescription;", "generateAccessorsByDelegate", "", "Lorg/jetbrains/kotlin/fir/declarations/builder/FirPropertyBuilder;", "delegateBuilder", "Lorg/jetbrains/kotlin/fir/expressions/builder/FirWrappedDelegateExpressionBuilder;", "isExtension", "stubMode", "receiver", "(Lorg/jetbrains/kotlin/fir/declarations/builder/FirPropertyBuilder;Lorg/jetbrains/kotlin/fir/expressions/builder/FirWrappedDelegateExpressionBuilder;Lorg/jetbrains/kotlin/fir/FirModuleData;Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;Ljava/lang/Integer;ZZLorg/jetbrains/kotlin/fir/expressions/FirExpression;)V", "generateComparisonExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirComparisonExpression;", "operatorToken", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "generateContainsOperation", "inverted", "generateLazyLogicalOperation", "Lorg/jetbrains/kotlin/fir/expressions/FirBinaryLogicExpression;", "other", "isAnd", "generateNotNullOrOther", "Lorg/jetbrains/kotlin/fir/expressions/FirElvisExpression;", "isContractPresentFirCheck", "parseCharacter", "toBinaryName", "toFirOperation", "Lorg/jetbrains/kotlin/fir/expressions/FirOperation;", "toUnaryName", "wrapWithSafeCall", "Lorg/jetbrains/kotlin/fir/expressions/FirSafeCallExpression;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccess;", "raw-fir.common"})
public final class ConversionUtilsKt {
    @NotNull
    private static final Name DELEGATED_SETTER_PARAM;

    @NotNull
    public static final CharacterWithDiagnostic parseCharacter(@NotNull String $this$parseCharacter) {
        Intrinsics.checkNotNullParameter($this$parseCharacter, "<this>");
        if ($this$parseCharacter.length() < 2 || $this$parseCharacter.charAt(0) != '\'' || $this$parseCharacter.charAt($this$parseCharacter.length() - 1) != '\'') {
            return new CharacterWithDiagnostic(DiagnosticKind.IncorrectCharacterLiteral);
        }
        String string2 = $this$parseCharacter.substring(1, $this$parseCharacter.length() - 1);
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        String text2 = string2;
        if (((CharSequence)text2).length() == 0) {
            return new CharacterWithDiagnostic(DiagnosticKind.EmptyCharacterLiteral);
        }
        return text2.charAt(0) != '\\' ? (text2.length() == 1 ? new CharacterWithDiagnostic(text2.charAt(0)) : new CharacterWithDiagnostic(DiagnosticKind.TooManyCharactersInCharacterLiteral)) : ConversionUtilsKt.escapedStringToCharacter(text2);
    }

    @NotNull
    public static final CharacterWithDiagnostic escapedStringToCharacter(@NotNull String text2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(text2, "text");
        boolean bl2 = bl = ((CharSequence)text2).length() > 0 && text2.charAt(0) == '\\';
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = Intrinsics.stringPlus("Only escaped sequences must be passed to this routine: ", text2);
            throw new AssertionError((Object)string2);
        }
        String string3 = text2.substring(1);
        Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).substring(startIndex)");
        String escape = string3;
        int n = escape.length();
        switch (n) {
            case 0: {
                return new CharacterWithDiagnostic(DiagnosticKind.IllegalEscape);
            }
            case 1: {
                return ConversionUtilsKt.translateEscape(escape.charAt(0));
            }
            case 5: {
                if (escape.charAt(0) != 'u') break;
                String string4 = escape.substring(1);
                Intrinsics.checkNotNullExpressionValue(string4, "this as java.lang.String).substring(startIndex)");
                Integer intValue = StringsKt.toIntOrNull(string4, 16);
                if (intValue == null) break;
                return new CharacterWithDiagnostic((char)intValue.intValue());
            }
        }
        return new CharacterWithDiagnostic(DiagnosticKind.IllegalEscape);
    }

    @NotNull
    public static final CharacterWithDiagnostic translateEscape(char c) {
        char c2 = c;
        return c2 == 't' ? new CharacterWithDiagnostic('\t') : (c2 == 'b' ? new CharacterWithDiagnostic('\b') : (c2 == 'n' ? new CharacterWithDiagnostic('\n') : (c2 == 'r' ? new CharacterWithDiagnostic('\r') : (c2 == '\'' ? new CharacterWithDiagnostic('\'') : (c2 == '\"' ? new CharacterWithDiagnostic('\"') : (c2 == '\\' ? new CharacterWithDiagnostic('\\') : (c2 == '$' ? new CharacterWithDiagnostic('$') : new CharacterWithDiagnostic(DiagnosticKind.IllegalEscape))))))));
    }

    @Nullable
    public static final Name toBinaryName(@NotNull IElementType $this$toBinaryName) {
        Intrinsics.checkNotNullParameter($this$toBinaryName, "<this>");
        Map<KtSingleValueToken, Name> map2 = OperatorConventions.BINARY_OPERATION_NAMES;
        Intrinsics.checkNotNullExpressionValue(map2, "BINARY_OPERATION_NAMES");
        map2 = map2;
        return map2.get($this$toBinaryName);
    }

    @Nullable
    public static final Name toUnaryName(@NotNull IElementType $this$toUnaryName) {
        Intrinsics.checkNotNullParameter($this$toUnaryName, "<this>");
        Map<KtSingleValueToken, Name> map2 = OperatorConventions.UNARY_OPERATION_NAMES;
        Intrinsics.checkNotNullExpressionValue(map2, "UNARY_OPERATION_NAMES");
        map2 = map2;
        return map2.get($this$toUnaryName);
    }

    @NotNull
    public static final FirOperation toFirOperation(@NotNull IElementType $this$toFirOperation) {
        FirOperation firOperation;
        Intrinsics.checkNotNullParameter($this$toFirOperation, "<this>");
        IElementType iElementType = $this$toFirOperation;
        if (Intrinsics.areEqual(iElementType, KtTokens.LT)) {
            firOperation = FirOperation.LT;
        } else if (Intrinsics.areEqual(iElementType, KtTokens.GT)) {
            firOperation = FirOperation.GT;
        } else if (Intrinsics.areEqual(iElementType, KtTokens.LTEQ)) {
            firOperation = FirOperation.LT_EQ;
        } else if (Intrinsics.areEqual(iElementType, KtTokens.GTEQ)) {
            firOperation = FirOperation.GT_EQ;
        } else if (Intrinsics.areEqual(iElementType, KtTokens.EQEQ)) {
            firOperation = FirOperation.EQ;
        } else if (Intrinsics.areEqual(iElementType, KtTokens.EXCLEQ)) {
            firOperation = FirOperation.NOT_EQ;
        } else if (Intrinsics.areEqual(iElementType, KtTokens.EQEQEQ)) {
            firOperation = FirOperation.IDENTITY;
        } else if (Intrinsics.areEqual(iElementType, KtTokens.EXCLEQEQEQ)) {
            firOperation = FirOperation.NOT_IDENTITY;
        } else if (Intrinsics.areEqual(iElementType, KtTokens.EQ)) {
            firOperation = FirOperation.ASSIGN;
        } else if (Intrinsics.areEqual(iElementType, KtTokens.PLUSEQ)) {
            firOperation = FirOperation.PLUS_ASSIGN;
        } else if (Intrinsics.areEqual(iElementType, KtTokens.MINUSEQ)) {
            firOperation = FirOperation.MINUS_ASSIGN;
        } else if (Intrinsics.areEqual(iElementType, KtTokens.MULTEQ)) {
            firOperation = FirOperation.TIMES_ASSIGN;
        } else if (Intrinsics.areEqual(iElementType, KtTokens.DIVEQ)) {
            firOperation = FirOperation.DIV_ASSIGN;
        } else if (Intrinsics.areEqual(iElementType, KtTokens.PERCEQ)) {
            firOperation = FirOperation.REM_ASSIGN;
        } else if (Intrinsics.areEqual(iElementType, KtTokens.AS_KEYWORD)) {
            firOperation = FirOperation.AS;
        } else if (Intrinsics.areEqual(iElementType, KtTokens.AS_SAFE)) {
            firOperation = FirOperation.SAFE_AS;
        } else {
            throw new AssertionError((Object)$this$toFirOperation.toString());
        }
        return firOperation;
    }

    @NotNull
    public static final FirElvisExpression generateNotNullOrOther(@NotNull FirExpression $this$generateNotNullOrOther, @NotNull FirExpression other, @Nullable FirSourceElement baseSource) {
        FirElvisExpressionBuilder firElvisExpressionBuilder;
        Intrinsics.checkNotNullParameter($this$generateNotNullOrOther, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        boolean $i$f$buildElvisExpression = false;
        FirElvisExpressionBuilder $this$generateNotNullOrOther_u24lambda_u2d1 = firElvisExpressionBuilder = new FirElvisExpressionBuilder();
        boolean bl = false;
        $this$generateNotNullOrOther_u24lambda_u2d1.setSource(baseSource);
        $this$generateNotNullOrOther_u24lambda_u2d1.setLhs($this$generateNotNullOrOther);
        $this$generateNotNullOrOther_u24lambda_u2d1.setRhs(other);
        return firElvisExpressionBuilder.build();
    }

    @NotNull
    public static final FirBinaryLogicExpression generateLazyLogicalOperation(@NotNull FirExpression $this$generateLazyLogicalOperation, @NotNull FirExpression other, boolean isAnd, @Nullable FirSourceElement baseSource) {
        FirBinaryLogicExpressionBuilder firBinaryLogicExpressionBuilder;
        Intrinsics.checkNotNullParameter($this$generateLazyLogicalOperation, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        boolean $i$f$buildBinaryLogicExpression = false;
        FirBinaryLogicExpressionBuilder $this$generateLazyLogicalOperation_u24lambda_u2d2 = firBinaryLogicExpressionBuilder = new FirBinaryLogicExpressionBuilder();
        boolean bl = false;
        $this$generateLazyLogicalOperation_u24lambda_u2d2.setSource(baseSource);
        $this$generateLazyLogicalOperation_u24lambda_u2d2.setLeftOperand($this$generateLazyLogicalOperation);
        $this$generateLazyLogicalOperation_u24lambda_u2d2.setRightOperand(other);
        $this$generateLazyLogicalOperation_u24lambda_u2d2.setKind(isAnd ? LogicOperationKind.AND : LogicOperationKind.OR);
        return firBinaryLogicExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirFunctionCall generateContainsOperation(@NotNull FirExpression $this$generateContainsOperation, @NotNull FirExpression argument2, boolean inverted, @Nullable FirSourceElement baseSource, @Nullable FirSourceElement operationReferenceSource) {
        void $this$generateContainsOperation_u24lambda_u2d4_u24lambda_u2d3;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
        FirFunctionCallBuilder firFunctionCallBuilder;
        Intrinsics.checkNotNullParameter($this$generateContainsOperation, "<this>");
        Intrinsics.checkNotNullParameter(argument2, "argument");
        FirFunctionCall containsCall = ConversionUtilsKt.createConventionCall($this$generateContainsOperation, operationReferenceSource, baseSource, argument2, OperatorNameConventions.CONTAINS);
        if (!inverted) {
            return containsCall;
        }
        boolean $i$f$buildFunctionCall = false;
        FirFunctionCallBuilder $this$generateContainsOperation_u24lambda_u2d4 = firFunctionCallBuilder = new FirFunctionCallBuilder();
        boolean bl = false;
        FirSourceElement firSourceElement = baseSource;
        $this$generateContainsOperation_u24lambda_u2d4.setSource(firSourceElement == null ? null : FirSourceElementKt.fakeElement(firSourceElement, FirFakeSourceElementKind.DesugaredInvertedContains.INSTANCE));
        boolean $i$f$buildSimpleNamedReference = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
        FirFunctionCallBuilder firFunctionCallBuilder2 = $this$generateContainsOperation_u24lambda_u2d4;
        boolean bl2 = false;
        FirSourceElement firSourceElement2 = operationReferenceSource;
        $this$generateContainsOperation_u24lambda_u2d4_u24lambda_u2d3.setSource(firSourceElement2 == null ? null : FirSourceElementKt.fakeElement(firSourceElement2, FirFakeSourceElementKind.DesugaredInvertedContains.INSTANCE));
        $this$generateContainsOperation_u24lambda_u2d4_u24lambda_u2d3.setName(OperatorNameConventions.NOT);
        Unit unit2 = Unit.INSTANCE;
        firFunctionCallBuilder2.setCalleeReference(firSimpleNamedReferenceBuilder.build());
        $this$generateContainsOperation_u24lambda_u2d4.setExplicitReceiver(containsCall);
        $this$generateContainsOperation_u24lambda_u2d4.setOrigin(FirFunctionCallOrigin.Operator);
        return firFunctionCallBuilder.build();
    }

    @NotNull
    public static final FirComparisonExpression generateComparisonExpression(@NotNull FirExpression $this$generateComparisonExpression, @NotNull FirExpression argument2, @NotNull IElementType operatorToken, @Nullable FirSourceElement baseSource, @Nullable FirSourceElement operationReferenceSource) {
        FirComparisonExpressionBuilder firComparisonExpressionBuilder;
        FirOperation firOperation;
        Intrinsics.checkNotNullParameter($this$generateComparisonExpression, "<this>");
        Intrinsics.checkNotNullParameter(argument2, "argument");
        Intrinsics.checkNotNullParameter(operatorToken, "operatorToken");
        ImmutableSet<KtSingleValueToken> immutableSet = OperatorConventions.COMPARISON_OPERATIONS;
        Intrinsics.checkNotNullExpressionValue(immutableSet, "COMPARISON_OPERATIONS");
        boolean bl = CollectionsKt.contains((Iterable)immutableSet, operatorToken);
        if (!bl) {
            boolean $i$a$-require-ConversionUtilsKt$generateComparisonExpression$22 = false;
            String $i$a$-require-ConversionUtilsKt$generateComparisonExpression$22 = operatorToken + " is not in " + OperatorConventions.COMPARISON_OPERATIONS;
            throw new IllegalArgumentException($i$a$-require-ConversionUtilsKt$generateComparisonExpression$22.toString());
        }
        FirSourceElement $i$a$-require-ConversionUtilsKt$generateComparisonExpression$22 = baseSource;
        FirFunctionCall compareToCall = ConversionUtilsKt.createConventionCall($this$generateComparisonExpression, operationReferenceSource, $i$a$-require-ConversionUtilsKt$generateComparisonExpression$22 == null ? null : FirSourceElementKt.fakeElement($i$a$-require-ConversionUtilsKt$generateComparisonExpression$22, FirFakeSourceElementKind.GeneratedComparisonExpression.INSTANCE), argument2, OperatorNameConventions.COMPARE_TO);
        IElementType iElementType = operatorToken;
        if (Intrinsics.areEqual(iElementType, KtTokens.LT)) {
            firOperation = FirOperation.LT;
        } else if (Intrinsics.areEqual(iElementType, KtTokens.GT)) {
            firOperation = FirOperation.GT;
        } else if (Intrinsics.areEqual(iElementType, KtTokens.LTEQ)) {
            firOperation = FirOperation.LT_EQ;
        } else if (Intrinsics.areEqual(iElementType, KtTokens.GTEQ)) {
            firOperation = FirOperation.GT_EQ;
        } else {
            throw new IllegalStateException(Intrinsics.stringPlus("Unknown ", operatorToken).toString());
        }
        FirOperation firOperation2 = firOperation;
        boolean $i$f$buildComparisonExpression = false;
        FirComparisonExpressionBuilder $this$generateComparisonExpression_u24lambda_u2d6 = firComparisonExpressionBuilder = new FirComparisonExpressionBuilder();
        boolean bl2 = false;
        $this$generateComparisonExpression_u24lambda_u2d6.setSource(baseSource);
        $this$generateComparisonExpression_u24lambda_u2d6.setOperation(firOperation2);
        $this$generateComparisonExpression_u24lambda_u2d6.setCompareToCall(compareToCall);
        return firComparisonExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private static final FirFunctionCall createConventionCall(FirExpression $this$createConventionCall, FirSourceElement operationReferenceSource, FirSourceElement baseSource, FirExpression argument2, Name conventionName) {
        void $this$createConventionCall_u24lambda_u2d8_u24lambda_u2d7;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
        FirFunctionCallBuilder firFunctionCallBuilder;
        boolean $i$f$buildFunctionCall = false;
        FirFunctionCallBuilder $this$createConventionCall_u24lambda_u2d8 = firFunctionCallBuilder = new FirFunctionCallBuilder();
        boolean bl = false;
        $this$createConventionCall_u24lambda_u2d8.setSource(baseSource);
        boolean $i$f$buildSimpleNamedReference = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
        FirFunctionCallBuilder firFunctionCallBuilder2 = $this$createConventionCall_u24lambda_u2d8;
        boolean bl2 = false;
        $this$createConventionCall_u24lambda_u2d8_u24lambda_u2d7.setSource(operationReferenceSource);
        $this$createConventionCall_u24lambda_u2d8_u24lambda_u2d7.setName(conventionName);
        Unit unit2 = Unit.INSTANCE;
        firFunctionCallBuilder2.setCalleeReference(firSimpleNamedReferenceBuilder.build());
        $this$createConventionCall_u24lambda_u2d8.setExplicitReceiver($this$createConventionCall);
        $this$createConventionCall_u24lambda_u2d8.setArgumentList(FirArgumentUtilKt.buildUnaryArgumentList(argument2));
        $this$createConventionCall_u24lambda_u2d8.setOrigin(FirFunctionCallOrigin.Operator);
        return firFunctionCallBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirQualifiedAccessExpression generateAccessExpression(@Nullable FirSourceElement qualifiedSource, @Nullable FirSourceElement calleeReferenceSource, @NotNull Name name2, @Nullable ConeDiagnostic diagnostic) {
        FirSourceElement firSourceElement;
        void $this$generateAccessExpression_u24lambda_u2d10_u24lambda_u2d9;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder;
        Intrinsics.checkNotNullParameter(name2, "name");
        boolean $i$f$buildPropertyAccessExpression = false;
        FirPropertyAccessExpressionBuilder $this$generateAccessExpression_u24lambda_u2d10 = firPropertyAccessExpressionBuilder = new FirPropertyAccessExpressionBuilder();
        boolean bl = false;
        $this$generateAccessExpression_u24lambda_u2d10.setSource(qualifiedSource);
        boolean $i$f$buildSimpleNamedReference = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder2 = $this$generateAccessExpression_u24lambda_u2d10;
        boolean bl2 = false;
        $this$generateAccessExpression_u24lambda_u2d10_u24lambda_u2d9.setSource((FirSourceElement)(Intrinsics.areEqual(calleeReferenceSource, qualifiedSource) ? ((firSourceElement = calleeReferenceSource) == null ? null : FirSourceElementKt.fakeElement(firSourceElement, FirFakeSourceElementKind.ReferenceInAtomicQualifiedAccess.INSTANCE)) : calleeReferenceSource));
        $this$generateAccessExpression_u24lambda_u2d10_u24lambda_u2d9.setName(name2);
        Unit unit2 = Unit.INSTANCE;
        firPropertyAccessExpressionBuilder2.setCalleeReference(firSimpleNamedReferenceBuilder.build());
        if (diagnostic != null) {
            $this$generateAccessExpression_u24lambda_u2d10.getNonFatalDiagnostics().add(diagnostic);
        }
        return firPropertyAccessExpressionBuilder.build();
    }

    public static /* synthetic */ FirQualifiedAccessExpression generateAccessExpression$default(FirSourceElement firSourceElement, FirSourceElement firSourceElement2, Name name2, ConeDiagnostic coneDiagnostic, int n, Object object) {
        if ((n & 8) != 0) {
            coneDiagnostic = null;
        }
        return ConversionUtilsKt.generateAccessExpression(firSourceElement, firSourceElement2, name2, coneDiagnostic);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirQualifiedAccessExpression generateResolvedAccessExpression(@Nullable FirSourceElement source, @NotNull FirVariable variable2) {
        void $this$generateResolvedAccessExpression_u24lambda_u2d12_u24lambda_u2d11;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder;
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder;
        Intrinsics.checkNotNullParameter(variable2, "variable");
        boolean $i$f$buildPropertyAccessExpression = false;
        FirPropertyAccessExpressionBuilder $this$generateResolvedAccessExpression_u24lambda_u2d12 = firPropertyAccessExpressionBuilder = new FirPropertyAccessExpressionBuilder();
        boolean bl = false;
        $this$generateResolvedAccessExpression_u24lambda_u2d12.setSource(source);
        boolean $i$f$buildResolvedNamedReference = false;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder2 = firResolvedNamedReferenceBuilder = new FirResolvedNamedReferenceBuilder();
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder2 = $this$generateResolvedAccessExpression_u24lambda_u2d12;
        boolean bl2 = false;
        $this$generateResolvedAccessExpression_u24lambda_u2d12_u24lambda_u2d11.setSource(source);
        $this$generateResolvedAccessExpression_u24lambda_u2d12_u24lambda_u2d11.setName(variable2.getName());
        $this$generateResolvedAccessExpression_u24lambda_u2d12_u24lambda_u2d11.setResolvedSymbol((FirBasedSymbol)variable2.getSymbol());
        Unit unit2 = Unit.INSTANCE;
        firPropertyAccessExpressionBuilder2.setCalleeReference(firResolvedNamedReferenceBuilder.build());
        return firPropertyAccessExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirVariable generateTemporaryVariable(@NotNull FirModuleData moduleData2, @Nullable FirSourceElement source, @NotNull Name name2, @NotNull FirExpression initializer2, @Nullable FirTypeRef typeRef) {
        FirTypeRef firTypeRef;
        FirPropertyBuilder firPropertyBuilder;
        Intrinsics.checkNotNullParameter(moduleData2, "moduleData");
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(initializer2, "initializer");
        boolean $i$f$buildProperty = false;
        FirPropertyBuilder $this$generateTemporaryVariable_u24lambda_u2d14 = firPropertyBuilder = new FirPropertyBuilder();
        boolean bl = false;
        $this$generateTemporaryVariable_u24lambda_u2d14.setSource(source);
        $this$generateTemporaryVariable_u24lambda_u2d14.setModuleData(moduleData2);
        $this$generateTemporaryVariable_u24lambda_u2d14.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
        FirPropertyBuilder firPropertyBuilder2 = $this$generateTemporaryVariable_u24lambda_u2d14;
        FirTypeRef firTypeRef2 = typeRef;
        if (firTypeRef2 == null) {
            void $this$generateTemporaryVariable_u24lambda_u2d14_u24lambda_u2d13;
            FirImplicitTypeRefBuilder firImplicitTypeRefBuilder;
            boolean $i$f$buildImplicitTypeRef = false;
            FirImplicitTypeRefBuilder firImplicitTypeRefBuilder2 = firImplicitTypeRefBuilder = new FirImplicitTypeRefBuilder();
            FirPropertyBuilder firPropertyBuilder3 = firPropertyBuilder2;
            boolean bl2 = false;
            $this$generateTemporaryVariable_u24lambda_u2d14_u24lambda_u2d13.setSource(source);
            Unit unit2 = Unit.INSTANCE;
            firPropertyBuilder2 = firPropertyBuilder3;
            firTypeRef = firImplicitTypeRefBuilder.build();
        } else {
            firTypeRef = firTypeRef2;
        }
        firPropertyBuilder2.setReturnTypeRef(firTypeRef);
        $this$generateTemporaryVariable_u24lambda_u2d14.setName(name2);
        $this$generateTemporaryVariable_u24lambda_u2d14.setInitializer(initializer2);
        $this$generateTemporaryVariable_u24lambda_u2d14.setSymbol(new FirPropertySymbol(name2));
        $this$generateTemporaryVariable_u24lambda_u2d14.setVar(false);
        $this$generateTemporaryVariable_u24lambda_u2d14.setLocal(true);
        $this$generateTemporaryVariable_u24lambda_u2d14.setStatus(new FirDeclarationStatusImpl(Visibilities.Local.INSTANCE, Modality.FINAL));
        return firPropertyBuilder.build();
    }

    public static /* synthetic */ FirVariable generateTemporaryVariable$default(FirModuleData firModuleData, FirSourceElement firSourceElement, Name name2, FirExpression firExpression2, FirTypeRef firTypeRef, int n, Object object) {
        if ((n & 0x10) != 0) {
            firTypeRef = null;
        }
        return ConversionUtilsKt.generateTemporaryVariable(firModuleData, firSourceElement, name2, firExpression2, firTypeRef);
    }

    @NotNull
    public static final FirVariable generateTemporaryVariable(@NotNull FirModuleData moduleData2, @Nullable FirSourceElement source, @NotNull String specialName, @NotNull FirExpression initializer2) {
        Intrinsics.checkNotNullParameter(moduleData2, "moduleData");
        Intrinsics.checkNotNullParameter(specialName, "specialName");
        Intrinsics.checkNotNullParameter(initializer2, "initializer");
        Name name2 = Name.special('<' + specialName + '>');
        Intrinsics.checkNotNullExpressionValue(name2, "special(\"<$specialName>\")");
        return ConversionUtilsKt.generateTemporaryVariable$default(moduleData2, source, name2, initializer2, null, 16, null);
    }

    @Nullable
    public static final FirClassSymbol<?> getOwnerRegularOrAnonymousObjectSymbol(@NotNull FirClassBuilder $this$ownerRegularOrAnonymousObjectSymbol) {
        Intrinsics.checkNotNullParameter($this$ownerRegularOrAnonymousObjectSymbol, "<this>");
        FirClassBuilder firClassBuilder = $this$ownerRegularOrAnonymousObjectSymbol;
        return firClassBuilder instanceof FirAnonymousObjectBuilder ? (FirClassSymbol)((FirAnonymousObjectBuilder)$this$ownerRegularOrAnonymousObjectSymbol).getSymbol() : (firClassBuilder instanceof FirRegularClassBuilder ? (FirClassSymbol)((FirRegularClassBuilder)$this$ownerRegularOrAnonymousObjectSymbol).getSymbol() : null);
    }

    @Nullable
    public static final Integer getOwnerRegularClassTypeParametersCount(@NotNull FirClassBuilder $this$ownerRegularClassTypeParametersCount) {
        Intrinsics.checkNotNullParameter($this$ownerRegularClassTypeParametersCount, "<this>");
        return $this$ownerRegularClassTypeParametersCount instanceof FirRegularClassBuilder ? Integer.valueOf($this$ownerRegularClassTypeParametersCount.getTypeParameters().size()) : null;
    }

    /*
     * WARNING - void declaration
     */
    public static final void generateAccessorsByDelegate(@NotNull FirPropertyBuilder $this$generateAccessorsByDelegate, @Nullable FirWrappedDelegateExpressionBuilder delegateBuilder, @NotNull FirModuleData moduleData2, @Nullable FirClassSymbol<?> ownerRegularOrAnonymousObjectSymbol, @Nullable Integer ownerRegularClassTypeParametersCount, boolean isExtension, boolean stubMode, @Nullable FirExpression receiver) {
        Object object;
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
        Unit unit2;
        Object object2;
        Object object3;
        Object $this$generateAccessorsByDelegate_u24lambda_u2d31_u24lambda_u2d27;
        Object object4;
        Object object5;
        FirImplicitTypeRefBuilder firImplicitTypeRefBuilder;
        FirExpression firExpression2;
        FirWrappedDelegateExpressionBuilder firWrappedDelegateExpressionBuilder;
        Unit unit3;
        FirAnnotationContainerBuilder firAnnotationContainerBuilder;
        Object object6;
        FirDelegateFieldSymbol firDelegateFieldSymbol;
        Intrinsics.checkNotNullParameter($this$generateAccessorsByDelegate, "<this>");
        Intrinsics.checkNotNullParameter(moduleData2, "moduleData");
        if (delegateBuilder == null) {
            return;
        }
        FirDelegateFieldSymbol it = firDelegateFieldSymbol = new FirDelegateFieldSymbol($this$generateAccessorsByDelegate.getSymbol().getCallableId());
        boolean $i$a$-also-ConversionUtilsKt$generateAccessorsByDelegate$delegateFieldSymbol$22 = false;
        $this$generateAccessorsByDelegate.setDelegateFieldSymbol(it);
        FirDelegateFieldSymbol delegateFieldSymbol = firDelegateFieldSymbol;
        boolean isMember = ownerRegularOrAnonymousObjectSymbol != null;
        FirSourceElement $i$a$-also-ConversionUtilsKt$generateAccessorsByDelegate$delegateFieldSymbol$22 = delegateBuilder.getSource();
        FirSourceElement fakeSource = $i$a$-also-ConversionUtilsKt$generateAccessorsByDelegate$delegateFieldSymbol$22 == null ? null : FirSourceElementKt.fakeElement($i$a$-also-ConversionUtilsKt$generateAccessorsByDelegate$delegateFieldSymbol$22, FirFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE);
        boolean isVar = $this$generateAccessorsByDelegate.isVar();
        FirWrappedDelegateExpressionBuilder firWrappedDelegateExpressionBuilder2 = delegateBuilder;
        if (stubMode) {
            boolean $i$f$buildExpressionStub = false;
            object6 = new FirExpressionStubBuilder();
            FirExpressionStubBuilder firExpressionStubBuilder = object6;
            firAnnotationContainerBuilder = firWrappedDelegateExpressionBuilder2;
            unit3 = Unit.INSTANCE;
            firWrappedDelegateExpressionBuilder = firAnnotationContainerBuilder;
            firExpression2 = ((FirExpressionStubBuilder)object6).build();
        } else {
            void $this$generateAccessorsByDelegate_u24lambda_u2d26_u24lambda_u2d25;
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2;
            void $this$generateAccessorsByDelegate_u24lambda_u2d26;
            boolean $i$f$buildFunctionCall = false;
            FirFunctionCallBuilder $i$f$buildExpressionStub = new FirFunctionCallBuilder();
            object6 = $i$f$buildExpressionStub;
            firAnnotationContainerBuilder = firWrappedDelegateExpressionBuilder2;
            boolean bl3 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2d26.setExplicitReceiver(receiver);
            boolean $i$f$buildSimpleNamedReference = false;
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder3 = firSimpleNamedReferenceBuilder2 = new FirSimpleNamedReferenceBuilder();
            firImplicitTypeRefBuilder = $this$generateAccessorsByDelegate_u24lambda_u2d26;
            boolean bl2 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2d26_u24lambda_u2d25.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2d26_u24lambda_u2d25.setName(OperatorNameConventions.PROVIDE_DELEGATE);
            object5 = Unit.INSTANCE;
            ((FirFunctionCallBuilder)((Object)firImplicitTypeRefBuilder)).setCalleeReference(firSimpleNamedReferenceBuilder2.build());
            $this$generateAccessorsByDelegate_u24lambda_u2d26.setArgumentList(FirArgumentUtilKt.buildBinaryArgumentList(ConversionUtilsKt.generateAccessorsByDelegate$thisRef(isExtension, ownerRegularOrAnonymousObjectSymbol, fakeSource, $this$generateAccessorsByDelegate, ownerRegularClassTypeParametersCount, true), ConversionUtilsKt.generateAccessorsByDelegate$propertyRef(fakeSource, isMember, isExtension, isVar, $this$generateAccessorsByDelegate)));
            $this$generateAccessorsByDelegate_u24lambda_u2d26.setOrigin(FirFunctionCallOrigin.Operator);
            unit3 = Unit.INSTANCE;
            firWrappedDelegateExpressionBuilder = firAnnotationContainerBuilder;
            firExpression2 = $i$f$buildExpressionStub.build();
        }
        firWrappedDelegateExpressionBuilder.setDelegateProvider(firExpression2);
        $this$generateAccessorsByDelegate.setDelegate(delegateBuilder.build());
        if (stubMode) {
            return;
        }
        if ($this$generateAccessorsByDelegate.getGetter() == null || $this$generateAccessorsByDelegate.getGetter() instanceof FirDefaultPropertyAccessor) {
            void it2;
            void $this$generateAccessorsByDelegate_u24lambda_u2d31_u24lambda_u2d30_u24lambda_u2d29_u24lambda_u2d28;
            void $this$generateAccessorsByDelegate_u24lambda_u2d31_u24lambda_u2d30_u24lambda_u2d29;
            void $this$generateAccessorsByDelegate_u24lambda_u2d31_u24lambda_u2d30;
            boolean bl;
            FirDeclarationStatusImpl firDeclarationStatusImpl;
            void $this$generateAccessorsByDelegate_u24lambda_u2d31;
            FirPropertyAccessor $i$f$buildExpressionStub = $this$generateAccessorsByDelegate.getGetter();
            List<FirAnnotationCall> annotations2 = $i$f$buildExpressionStub == null ? null : $i$f$buildExpressionStub.getAnnotations();
            FirFunctionTarget returnTarget = new FirFunctionTarget(null, false);
            boolean $i$f$buildPropertyAccessor = false;
            Object bl3 = new FirPropertyAccessorBuilder();
            FirPropertyAccessorBuilder $i$f$buildSimpleNamedReference = bl3;
            firAnnotationContainerBuilder = $this$generateAccessorsByDelegate;
            boolean bl4 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2d31.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2d31.setModuleData(moduleData2);
            $this$generateAccessorsByDelegate_u24lambda_u2d31.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            boolean $i$f$buildImplicitTypeRef22 = false;
            firImplicitTypeRefBuilder = new FirImplicitTypeRefBuilder();
            Object bl2 = firImplicitTypeRefBuilder;
            object5 = $this$generateAccessorsByDelegate_u24lambda_u2d31;
            object4 = Unit.INSTANCE;
            ((FirPropertyAccessorBuilder)object5).setReturnTypeRef(firImplicitTypeRefBuilder.build());
            $this$generateAccessorsByDelegate_u24lambda_u2d31.setGetter(true);
            FirDeclarationStatusImpl $i$f$buildImplicitTypeRef22 = firDeclarationStatusImpl = new FirDeclarationStatusImpl(Visibilities.Unknown.INSTANCE, Modality.FINAL);
            object5 = $this$generateAccessorsByDelegate_u24lambda_u2d31;
            boolean $i$a$-apply-ConversionUtilsKt$generateAccessorsByDelegate$2$22 = false;
            bl2 = $this$generateAccessorsByDelegate.getGetter();
            if (bl2 == null) {
                bl = ((FirDeclarationStatusImpl)$this$generateAccessorsByDelegate_u24lambda_u2d31_u24lambda_u2d27).isInline();
            } else {
                FirDeclarationStatus firDeclarationStatus = ((FirPropertyAccessor)bl2).getStatus();
                bl = firDeclarationStatus.isInline();
            }
            ((FirDeclarationStatusImpl)$this$generateAccessorsByDelegate_u24lambda_u2d31_u24lambda_u2d27).setInline(bl);
            object4 = Unit.INSTANCE;
            ((FirPropertyAccessorBuilder)object5).setStatus(firDeclarationStatusImpl);
            $this$generateAccessorsByDelegate_u24lambda_u2d31.setSymbol(new FirPropertyAccessorSymbol());
            boolean $i$f$buildReturnExpression = false;
            Object $i$a$-apply-ConversionUtilsKt$generateAccessorsByDelegate$2$22 = $this$generateAccessorsByDelegate_u24lambda_u2d31_u24lambda_u2d27 = new FirReturnExpressionBuilder();
            object5 = $this$generateAccessorsByDelegate_u24lambda_u2d31;
            boolean bl5 = false;
            boolean $i$f$buildFunctionCall = false;
            object2 = object3 = new FirFunctionCallBuilder();
            unit2 = $this$generateAccessorsByDelegate_u24lambda_u2d31_u24lambda_u2d30;
            boolean bl6 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2d31_u24lambda_u2d30_u24lambda_u2d29.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2d31_u24lambda_u2d30_u24lambda_u2d29.setExplicitReceiver(ConversionUtilsKt.generateAccessorsByDelegate$delegateAccess(fakeSource, ownerRegularOrAnonymousObjectSymbol, delegateFieldSymbol, isExtension, $this$generateAccessorsByDelegate, ownerRegularClassTypeParametersCount));
            boolean $i$f$buildSimpleNamedReference2 = false;
            FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder4 = firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
            firPropertyAccessExpressionBuilder = $this$generateAccessorsByDelegate_u24lambda_u2d31_u24lambda_u2d30_u24lambda_u2d29;
            boolean bl7 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2d31_u24lambda_u2d30_u24lambda_u2d29_u24lambda_u2d28.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2d31_u24lambda_u2d30_u24lambda_u2d29_u24lambda_u2d28.setName(OperatorNameConventions.GET_VALUE);
            object = Unit.INSTANCE;
            ((FirFunctionCallBuilder)((Object)firPropertyAccessExpressionBuilder)).setCalleeReference(firSimpleNamedReferenceBuilder.build());
            $this$generateAccessorsByDelegate_u24lambda_u2d31_u24lambda_u2d30_u24lambda_u2d29.setArgumentList(FirArgumentUtilKt.buildBinaryArgumentList(ConversionUtilsKt.generateAccessorsByDelegate$thisRef$default(isExtension, ownerRegularOrAnonymousObjectSymbol, fakeSource, $this$generateAccessorsByDelegate, ownerRegularClassTypeParametersCount, false, 32, null), ConversionUtilsKt.generateAccessorsByDelegate$propertyRef(fakeSource, isMember, isExtension, isVar, $this$generateAccessorsByDelegate)));
            $this$generateAccessorsByDelegate_u24lambda_u2d31_u24lambda_u2d30_u24lambda_u2d29.setOrigin(FirFunctionCallOrigin.Operator);
            Unit unit4 = Unit.INSTANCE;
            ((FirReturnExpressionBuilder)((Object)unit2)).setResult(((FirFunctionCallBuilder)object3).build());
            $this$generateAccessorsByDelegate_u24lambda_u2d31_u24lambda_u2d30.setTarget(returnTarget);
            Unit unit5 = Unit.INSTANCE;
            FirStatement firStatement = ((FirReturnExpressionBuilder)$this$generateAccessorsByDelegate_u24lambda_u2d31_u24lambda_u2d27).build();
            ((FirPropertyAccessorBuilder)object5).setBody(new FirSingleExpressionBlock(firStatement));
            if (annotations2 != null) {
                $this$generateAccessorsByDelegate_u24lambda_u2d31.getAnnotations().addAll((Collection<FirAnnotationCall>)annotations2);
            }
            unit3 = Unit.INSTANCE;
            bl3 = object6 = ((FirPropertyAccessorBuilder)bl3).build();
            boolean bl8 = false;
            returnTarget.bind((FirTargetElement)it2);
            unit3 = Unit.INSTANCE;
            ((FirPropertyBuilder)firAnnotationContainerBuilder).setGetter((FirPropertyAccessor)object6);
        }
        if (isVar && ($this$generateAccessorsByDelegate.getSetter() == null || $this$generateAccessorsByDelegate.getSetter() instanceof FirDefaultPropertyAccessor)) {
            void $this$generateAccessorsByDelegate_u24lambda_u2d40_u24lambda_u2d39_u24lambda_u2d38_u24lambda_u2d37_u24lambda_u2d36;
            void $this$generateAccessorsByDelegate_u24lambda_u2d40_u24lambda_u2d39_u24lambda_u2d38_u24lambda_u2d37;
            FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder;
            void $this$generateAccessorsByDelegate_u24lambda_u2d40_u24lambda_u2d39_u24lambda_u2d38;
            Object $this$generateAccessorsByDelegate_u24lambda_u2d40_u24lambda_u2d39_u24lambda_u2d35;
            void $this$generateAccessorsByDelegate_u24lambda_u2d40_u24lambda_u2d39;
            Object object7;
            Object object8;
            boolean bl;
            void $this$generateAccessorsByDelegate_u24lambda_u2d40_u24lambda_u2d33;
            void $this$generateAccessorsByDelegate_u24lambda_u2d40;
            FirPropertyAccessor returnTarget = $this$generateAccessorsByDelegate.getSetter();
            List<FirAnnotationCall> annotations3 = returnTarget == null ? null : returnTarget.getAnnotations();
            boolean $i$f$buildPropertyAccessor = false;
            object6 = new FirPropertyAccessorBuilder();
            FirAnnotationContainerBuilder it2 = object6;
            firAnnotationContainerBuilder = $this$generateAccessorsByDelegate;
            boolean bl9 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2d40.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2d40.setModuleData(moduleData2);
            $this$generateAccessorsByDelegate_u24lambda_u2d40.setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            $this$generateAccessorsByDelegate_u24lambda_u2d40.setReturnTypeRef(moduleData2.getSession().getBuiltinTypes().getUnitType());
            $this$generateAccessorsByDelegate_u24lambda_u2d40.setGetter(false);
            FirDeclarationStatusImpl bl4 = new FirDeclarationStatusImpl(Visibilities.Unknown.INSTANCE, Modality.FINAL);
            $this$generateAccessorsByDelegate_u24lambda_u2d31_u24lambda_u2d27 = bl4;
            firImplicitTypeRefBuilder = $this$generateAccessorsByDelegate_u24lambda_u2d40;
            boolean bl10 = false;
            object5 = $this$generateAccessorsByDelegate.getSetter();
            if (object5 == null) {
                bl = $this$generateAccessorsByDelegate_u24lambda_u2d40_u24lambda_u2d33.isInline();
            } else {
                object4 = ((FirPropertyAccessor)object5).getStatus();
                bl = object4.isInline();
            }
            $this$generateAccessorsByDelegate_u24lambda_u2d40_u24lambda_u2d33.setInline(bl);
            Unit unit6 = Unit.INSTANCE;
            ((FirPropertyAccessorBuilder)((Object)firImplicitTypeRefBuilder)).setStatus(bl4);
            boolean $i$f$buildValueParameter22 = false;
            Object $this$generateAccessorsByDelegate_u24lambda_u2d40_u24lambda_u2d34 = object8 = new FirValueParameterBuilder();
            boolean bl11 = false;
            ((FirValueParameterBuilder)$this$generateAccessorsByDelegate_u24lambda_u2d40_u24lambda_u2d34).setSource(fakeSource);
            ((FirValueParameterBuilder)$this$generateAccessorsByDelegate_u24lambda_u2d40_u24lambda_u2d34).setModuleData(moduleData2);
            ((FirValueParameterBuilder)$this$generateAccessorsByDelegate_u24lambda_u2d40_u24lambda_u2d34).setOrigin(FirDeclarationOrigin.Source.INSTANCE);
            boolean $i$f$buildImplicitTypeRef = false;
            object3 = object7 = new FirImplicitTypeRefBuilder();
            object2 = $this$generateAccessorsByDelegate_u24lambda_u2d40_u24lambda_u2d34;
            unit2 = Unit.INSTANCE;
            ((FirValueParameterBuilder)object2).setReturnTypeRef(((FirImplicitTypeRefBuilder)object7).build());
            ((FirValueParameterBuilder)$this$generateAccessorsByDelegate_u24lambda_u2d40_u24lambda_u2d34).setName(DELEGATED_SETTER_PARAM);
            ((FirValueParameterBuilder)$this$generateAccessorsByDelegate_u24lambda_u2d40_u24lambda_u2d34).setSymbol(new FirValueParameterSymbol($this$generateAccessorsByDelegate.getName()));
            ((FirValueParameterBuilder)$this$generateAccessorsByDelegate_u24lambda_u2d40_u24lambda_u2d34).setCrossinline(false);
            ((FirValueParameterBuilder)$this$generateAccessorsByDelegate_u24lambda_u2d40_u24lambda_u2d34).setNoinline(false);
            ((FirValueParameterBuilder)$this$generateAccessorsByDelegate_u24lambda_u2d40_u24lambda_u2d34).setVararg(false);
            FirValueParameter parameter = ((FirValueParameterBuilder)object8).build();
            void $i$f$buildValueParameter22 = $this$generateAccessorsByDelegate_u24lambda_u2d40;
            object8 = $i$f$buildValueParameter22.getValueParameters();
            object8.add(parameter);
            $this$generateAccessorsByDelegate_u24lambda_u2d40.setSymbol(new FirPropertyAccessorSymbol());
            boolean $i$f$buildFunctionCall = false;
            $this$generateAccessorsByDelegate_u24lambda_u2d40_u24lambda_u2d34 = object8 = new FirFunctionCallBuilder();
            firImplicitTypeRefBuilder = $this$generateAccessorsByDelegate_u24lambda_u2d40;
            boolean bl12 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2d40_u24lambda_u2d39.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2d40_u24lambda_u2d39.setExplicitReceiver(ConversionUtilsKt.generateAccessorsByDelegate$delegateAccess(fakeSource, ownerRegularOrAnonymousObjectSymbol, delegateFieldSymbol, isExtension, $this$generateAccessorsByDelegate, ownerRegularClassTypeParametersCount));
            boolean $i$f$buildSimpleNamedReference = false;
            object3 = object7 = new FirSimpleNamedReferenceBuilder();
            object2 = $this$generateAccessorsByDelegate_u24lambda_u2d40_u24lambda_u2d39;
            boolean bl13 = false;
            ((FirSimpleNamedReferenceBuilder)$this$generateAccessorsByDelegate_u24lambda_u2d40_u24lambda_u2d39_u24lambda_u2d35).setSource(fakeSource);
            ((FirSimpleNamedReferenceBuilder)$this$generateAccessorsByDelegate_u24lambda_u2d40_u24lambda_u2d39_u24lambda_u2d35).setName(OperatorNameConventions.SET_VALUE);
            Unit unit7 = Unit.INSTANCE;
            ((FirFunctionCallBuilder)object2).setCalleeReference(((FirSimpleNamedReferenceBuilder)object7).build());
            boolean $i$f$buildArgumentList = false;
            $this$generateAccessorsByDelegate_u24lambda_u2d40_u24lambda_u2d39_u24lambda_u2d35 = object7 = new FirArgumentListBuilder();
            object2 = $this$generateAccessorsByDelegate_u24lambda_u2d40_u24lambda_u2d39;
            boolean bl14 = false;
            firSimpleNamedReferenceBuilder = $this$generateAccessorsByDelegate_u24lambda_u2d40_u24lambda_u2d39_u24lambda_u2d38;
            ((Collection)((FirArgumentListBuilder)((Object)firSimpleNamedReferenceBuilder)).getArguments()).add(ConversionUtilsKt.generateAccessorsByDelegate$thisRef$default(isExtension, ownerRegularOrAnonymousObjectSymbol, fakeSource, $this$generateAccessorsByDelegate, ownerRegularClassTypeParametersCount, false, 32, null));
            firSimpleNamedReferenceBuilder = $this$generateAccessorsByDelegate_u24lambda_u2d40_u24lambda_u2d39_u24lambda_u2d38;
            ((Collection)((FirArgumentListBuilder)((Object)firSimpleNamedReferenceBuilder)).getArguments()).add(ConversionUtilsKt.generateAccessorsByDelegate$propertyRef(fakeSource, isMember, isExtension, isVar, $this$generateAccessorsByDelegate));
            firSimpleNamedReferenceBuilder = $this$generateAccessorsByDelegate_u24lambda_u2d40_u24lambda_u2d39_u24lambda_u2d38;
            boolean $i$f$buildPropertyAccessExpression = false;
            FirPropertyAccessExpressionBuilder bl7 = firPropertyAccessExpressionBuilder = new FirPropertyAccessExpressionBuilder();
            object = ((FirArgumentListBuilder)((Object)firSimpleNamedReferenceBuilder)).getArguments();
            boolean bl15 = false;
            boolean $i$f$buildResolvedNamedReference = false;
            FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder2 = firResolvedNamedReferenceBuilder = new FirResolvedNamedReferenceBuilder();
            void var40_75 = $this$generateAccessorsByDelegate_u24lambda_u2d40_u24lambda_u2d39_u24lambda_u2d38_u24lambda_u2d37;
            boolean bl16 = false;
            $this$generateAccessorsByDelegate_u24lambda_u2d40_u24lambda_u2d39_u24lambda_u2d38_u24lambda_u2d37_u24lambda_u2d36.setSource(fakeSource);
            $this$generateAccessorsByDelegate_u24lambda_u2d40_u24lambda_u2d39_u24lambda_u2d38_u24lambda_u2d37_u24lambda_u2d36.setName(DELEGATED_SETTER_PARAM);
            $this$generateAccessorsByDelegate_u24lambda_u2d40_u24lambda_u2d39_u24lambda_u2d38_u24lambda_u2d37_u24lambda_u2d36.setResolvedSymbol(parameter.getSymbol());
            Unit unit8 = Unit.INSTANCE;
            var40_75.setCalleeReference(firResolvedNamedReferenceBuilder.build());
            Unit unit9 = Unit.INSTANCE;
            object.add(firPropertyAccessExpressionBuilder.build());
            unit7 = Unit.INSTANCE;
            ((FirFunctionCallBuilder)object2).setArgumentList(((FirArgumentListBuilder)object7).build());
            $this$generateAccessorsByDelegate_u24lambda_u2d40_u24lambda_u2d39.setOrigin(FirFunctionCallOrigin.Operator);
            Unit unit10 = Unit.INSTANCE;
            FirStatement firStatement = ((FirFunctionCallBuilder)object8).build();
            ((FirPropertyAccessorBuilder)((Object)firImplicitTypeRefBuilder)).setBody(new FirSingleExpressionBlock(firStatement));
            if (annotations3 != null) {
                $this$generateAccessorsByDelegate_u24lambda_u2d40.getAnnotations().addAll((Collection<FirAnnotationCall>)annotations3);
            }
            unit3 = Unit.INSTANCE;
            ((FirPropertyBuilder)firAnnotationContainerBuilder).setSetter(((FirPropertyAccessorBuilder)object6).build());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Pair<FirBlock, FirContractDescription> extractContractDescriptionIfPossible(@Nullable FirBlock $this$extractContractDescriptionIfPossible) {
        void $this$extractContractDescriptionIfPossible_u24lambda_u2d41;
        FirLegacyRawContractDescriptionBuilder firLegacyRawContractDescriptionBuilder;
        if ($this$extractContractDescriptionIfPossible == null) {
            return TuplesKt.to(null, null);
        }
        if (!ConversionUtilsKt.isContractPresentFirCheck($this$extractContractDescriptionIfPossible)) {
            return TuplesKt.to($this$extractContractDescriptionIfPossible, null);
        }
        FirFunctionCall contractCall = (FirFunctionCall)FirExpressionUtilKt.replaceFirstStatement($this$extractContractDescriptionIfPossible, FirStubStatement.INSTANCE);
        boolean $i$f$buildLegacyRawContractDescription = false;
        FirLegacyRawContractDescriptionBuilder firLegacyRawContractDescriptionBuilder2 = firLegacyRawContractDescriptionBuilder = new FirLegacyRawContractDescriptionBuilder();
        FirBlock firBlock = $this$extractContractDescriptionIfPossible;
        boolean bl = false;
        $this$extractContractDescriptionIfPossible_u24lambda_u2d41.setSource(contractCall.getSource());
        $this$extractContractDescriptionIfPossible_u24lambda_u2d41.setContractCall(contractCall);
        Unit unit2 = Unit.INSTANCE;
        return TuplesKt.to(firBlock, firLegacyRawContractDescriptionBuilder.build());
    }

    public static final boolean isContractPresentFirCheck(@NotNull FirBlock $this$isContractPresentFirCheck) {
        FirQualifiedAccessExpression firQualifiedAccessExpression;
        FirFunctionCall firFunctionCall;
        Intrinsics.checkNotNullParameter($this$isContractPresentFirCheck, "<this>");
        FirStatement firStatement = CollectionsKt.firstOrNull($this$isContractPresentFirCheck.getStatements());
        if (firStatement == null) {
            return false;
        }
        FirStatement firstStatement = firStatement;
        FirFunctionCall firFunctionCall2 = firFunctionCall = firstStatement instanceof FirFunctionCall ? (FirFunctionCall)firstStatement : null;
        if (firFunctionCall == null) {
            return false;
        }
        FirFunctionCall contractCall = firFunctionCall;
        if (!Intrinsics.areEqual(contractCall.getCalleeReference().getName().asString(), "contract")) {
            return false;
        }
        FirExpression firExpression2 = contractCall.getExplicitReceiver();
        FirQualifiedAccessExpression firQualifiedAccessExpression2 = firQualifiedAccessExpression = firExpression2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression2 : null;
        if (firQualifiedAccessExpression == null) {
            return true;
        }
        FirQualifiedAccessExpression receiver = firQualifiedAccessExpression;
        if (!ConversionUtilsKt.checkReceiver(contractCall, "contracts")) {
            return false;
        }
        if (!ConversionUtilsKt.checkReceiver(receiver, "kotlin")) {
            return false;
        }
        FirExpression firExpression3 = receiver.getExplicitReceiver();
        FirExpression firExpression4 = firExpression2 = firExpression3 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression3 : null;
        if (firExpression2 == null) {
            return false;
        }
        FirExpression receiverOfReceiver = firExpression2;
        return ((FirQualifiedAccessExpression)receiverOfReceiver).getExplicitReceiver() == null;
    }

    private static final boolean checkReceiver(FirExpression $this$checkReceiver, String name2) {
        FirNamedReference firNamedReference;
        FirQualifiedAccessExpression firQualifiedAccessExpression;
        if (!($this$checkReceiver instanceof FirQualifiedAccessExpression)) {
            return false;
        }
        Object object = ((FirQualifiedAccessExpression)$this$checkReceiver).getExplicitReceiver();
        FirQualifiedAccessExpression firQualifiedAccessExpression2 = firQualifiedAccessExpression = object instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)object : null;
        if (firQualifiedAccessExpression == null) {
            return false;
        }
        FirQualifiedAccessExpression receiver = firQualifiedAccessExpression;
        Object object2 = receiver.getCalleeReference();
        FirNamedReference firNamedReference2 = firNamedReference = object2 instanceof FirNamedReference ? (FirNamedReference)object2 : null;
        if (firNamedReference == null) {
            return false;
        }
        object2 = firNamedReference.getName();
        object = ((Name)object2).asString();
        Intrinsics.checkNotNullExpressionValue(object, "(receiver.calleeReferenc\u2026sString() ?: return false");
        Object receiverName = object;
        return Intrinsics.areEqual(receiverName, name2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirSafeCallExpression wrapWithSafeCall(@NotNull FirQualifiedAccess $this$wrapWithSafeCall, @NotNull FirExpression receiver, @NotNull FirSourceElement source) {
        void $this$wrapWithSafeCall_u24lambda_u2d45_u24lambda_u2d44;
        FirExpressionRef<FirCheckedSafeCallSubject> $this$wrapWithSafeCall_u24lambda_u2d43_u24lambda_u2d42;
        Intrinsics.checkNotNullParameter($this$wrapWithSafeCall, "<this>");
        Intrinsics.checkNotNullParameter(receiver, "receiver");
        Intrinsics.checkNotNullParameter(source, "source");
        boolean $i$f$buildCheckedSafeCallSubject = false;
        FirAnnotationContainerBuilder firAnnotationContainerBuilder = new FirCheckedSafeCallSubjectBuilder();
        FirCheckedSafeCallSubjectBuilder $this$wrapWithSafeCall_u24lambda_u2d43 = firAnnotationContainerBuilder;
        boolean bl = false;
        FirExpressionRef<FirCheckedSafeCallSubject> firExpressionRef = new FirExpressionRef<FirExpression>();
        FirExpressionRef<FirExpression> firExpressionRef2 = firExpressionRef;
        FirAnnotationContainerBuilder firAnnotationContainerBuilder2 = $this$wrapWithSafeCall_u24lambda_u2d43;
        boolean bl2 = false;
        $this$wrapWithSafeCall_u24lambda_u2d43_u24lambda_u2d42.bind((FirCheckedSafeCallSubject)receiver);
        Unit unit2 = Unit.INSTANCE;
        ((FirCheckedSafeCallSubjectBuilder)firAnnotationContainerBuilder2).setOriginalReceiverRef(firExpressionRef);
        firExpressionRef = receiver.getSource();
        $this$wrapWithSafeCall_u24lambda_u2d43.setSource(firExpressionRef == null ? null : FirSourceElementKt.fakeElement((FirSourceElement)((Object)firExpressionRef), FirFakeSourceElementKind.CheckedSafeCallSubject.INSTANCE));
        FirCheckedSafeCallSubject checkedSafeCallSubject = ((FirCheckedSafeCallSubjectBuilder)firAnnotationContainerBuilder).build();
        $this$wrapWithSafeCall.replaceExplicitReceiver(checkedSafeCallSubject);
        boolean $i$f$buildSafeCallExpression = false;
        FirAnnotationContainerBuilder $this$wrapWithSafeCall_u24lambda_u2d45 = firAnnotationContainerBuilder = new FirSafeCallExpressionBuilder();
        boolean bl3 = false;
        ((FirSafeCallExpressionBuilder)$this$wrapWithSafeCall_u24lambda_u2d45).setReceiver(receiver);
        $this$wrapWithSafeCall_u24lambda_u2d43_u24lambda_u2d42 = firExpressionRef = new FirExpressionRef<FirCheckedSafeCallSubject>();
        firAnnotationContainerBuilder2 = $this$wrapWithSafeCall_u24lambda_u2d45;
        boolean bl4 = false;
        $this$wrapWithSafeCall_u24lambda_u2d45_u24lambda_u2d44.bind((FirExpression)checkedSafeCallSubject);
        unit2 = Unit.INSTANCE;
        ((FirSafeCallExpressionBuilder)firAnnotationContainerBuilder2).setCheckedSubjectRef(firExpressionRef);
        ((FirSafeCallExpressionBuilder)$this$wrapWithSafeCall_u24lambda_u2d45).setRegularQualifiedAccess($this$wrapWithSafeCall);
        ((FirSafeCallExpressionBuilder)$this$wrapWithSafeCall_u24lambda_u2d45).setSource(source);
        return ((FirSafeCallExpressionBuilder)firAnnotationContainerBuilder).build();
    }

    public static final boolean isUnderscore(@NotNull CharSequence $this$isUnderscore) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter($this$isUnderscore, "<this>");
            CharSequence $this$all$iv = $this$isUnderscore;
            boolean $i$f$all = false;
            CharSequence charSequence2 = $this$all$iv;
            for (int i = 0; i < charSequence2.length(); ++i) {
                char element$iv = charSequence2.charAt(i);
                char it = element$iv;
                boolean bl2 = false;
                if (it == '_') continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final FirExpression generateAccessorsByDelegate$thisRef(boolean $isExtension, FirClassSymbol<?> $ownerRegularOrAnonymousObjectSymbol, FirSourceElement fakeSource, FirPropertyBuilder $this_generateAccessorsByDelegate, Integer $ownerRegularClassTypeParametersCount, boolean forDispatchReceiver) {
        FirExpression firExpression2;
        if ($isExtension && !forDispatchReceiver) {
            void $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d17_u24lambda_u2d16;
            FirImplicitThisReferenceBuilder firImplicitThisReferenceBuilder;
            FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder;
            boolean $i$f$buildThisReceiverExpression = false;
            FirThisReceiverExpressionBuilder $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d17 = firThisReceiverExpressionBuilder = new FirThisReceiverExpressionBuilder();
            boolean bl = false;
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d17.setSource(fakeSource);
            boolean $i$f$buildImplicitThisReference = false;
            FirImplicitThisReferenceBuilder firImplicitThisReferenceBuilder2 = firImplicitThisReferenceBuilder = new FirImplicitThisReferenceBuilder();
            FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder2 = $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d17;
            boolean bl2 = false;
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d17_u24lambda_u2d16.setBoundSymbol($this_generateAccessorsByDelegate.getSymbol());
            Unit unit2 = Unit.INSTANCE;
            firThisReceiverExpressionBuilder2.setCalleeReference(firImplicitThisReferenceBuilder.build());
            firExpression2 = firThisReceiverExpressionBuilder.build();
        } else if ($ownerRegularOrAnonymousObjectSymbol != null) {
            void $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d20_u24lambda_u2d19;
            Object $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d20_u24lambda_u2d18;
            FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder;
            boolean $i$f$buildThisReceiverExpression = false;
            FirThisReceiverExpressionBuilder $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d20 = firThisReceiverExpressionBuilder = new FirThisReceiverExpressionBuilder();
            boolean bl = false;
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d20.setSource(fakeSource);
            boolean $i$f$buildImplicitThisReference = false;
            Object object = new FirImplicitThisReferenceBuilder();
            FirImplicitThisReferenceBuilder $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d17_u24lambda_u2d16 = object;
            FirThisReceiverExpressionBuilder firThisReceiverExpressionBuilder3 = $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d20;
            boolean bl3 = false;
            ((FirImplicitThisReferenceBuilder)$this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d20_u24lambda_u2d18).setBoundSymbol((FirBasedSymbol)$ownerRegularOrAnonymousObjectSymbol);
            Unit unit3 = Unit.INSTANCE;
            firThisReceiverExpressionBuilder3.setCalleeReference(((FirImplicitThisReferenceBuilder)object).build());
            boolean $i$f$buildResolvedTypeRef = false;
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d20_u24lambda_u2d18 = object = new FirResolvedTypeRefBuilder();
            firThisReceiverExpressionBuilder3 = $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d20;
            boolean bl4 = false;
            Integer n = $ownerRegularClassTypeParametersCount;
            int typeParameterNumber = n == null ? 0 : n;
            $this$generateAccessorsByDelegate_u24thisRef_u24lambda_u2d20_u24lambda_u2d19.setType(SymbolUtilsKt.constructStarProjectedType($ownerRegularOrAnonymousObjectSymbol, typeParameterNumber));
            unit3 = Unit.INSTANCE;
            firThisReceiverExpressionBuilder3.setTypeRef(((FirResolvedTypeRefBuilder)object).build());
            firExpression2 = firThisReceiverExpressionBuilder.build();
        } else {
            firExpression2 = FirConstExpressionBuilderKt.buildConstExpression$default(null, ConstantValueKind.Null.INSTANCE, null, null, false, 24, null);
        }
        return firExpression2;
    }

    static /* synthetic */ FirExpression generateAccessorsByDelegate$thisRef$default(boolean bl, FirClassSymbol firClassSymbol, FirSourceElement firSourceElement, FirPropertyBuilder firPropertyBuilder, Integer n, boolean bl2, int n2, Object object) {
        if ((n2 & 0x20) != 0) {
            bl2 = false;
        }
        return ConversionUtilsKt.generateAccessorsByDelegate$thisRef(bl, firClassSymbol, firSourceElement, firPropertyBuilder, n, bl2);
    }

    /*
     * WARNING - void declaration
     */
    private static final FirPropertyAccessExpression generateAccessorsByDelegate$delegateAccess(FirSourceElement fakeSource, FirClassSymbol<?> $ownerRegularOrAnonymousObjectSymbol, FirDelegateFieldSymbol delegateFieldSymbol, boolean $isExtension, FirPropertyBuilder $this_generateAccessorsByDelegate, Integer $ownerRegularClassTypeParametersCount) {
        void $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2d22_u24lambda_u2d21;
        FirDelegateFieldReferenceBuilder firDelegateFieldReferenceBuilder;
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder;
        boolean $i$f$buildPropertyAccessExpression = false;
        FirPropertyAccessExpressionBuilder $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2d22 = firPropertyAccessExpressionBuilder = new FirPropertyAccessExpressionBuilder();
        boolean bl = false;
        $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2d22.setSource(fakeSource);
        boolean $i$f$buildDelegateFieldReference = false;
        FirDelegateFieldReferenceBuilder firDelegateFieldReferenceBuilder2 = firDelegateFieldReferenceBuilder = new FirDelegateFieldReferenceBuilder();
        FirPropertyAccessExpressionBuilder firPropertyAccessExpressionBuilder2 = $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2d22;
        boolean bl2 = false;
        $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2d22_u24lambda_u2d21.setResolvedSymbol(delegateFieldSymbol);
        Unit unit2 = Unit.INSTANCE;
        firPropertyAccessExpressionBuilder2.setCalleeReference(firDelegateFieldReferenceBuilder.build());
        if ($ownerRegularOrAnonymousObjectSymbol != null) {
            $this$generateAccessorsByDelegate_u24delegateAccess_u24lambda_u2d22.setDispatchReceiver(ConversionUtilsKt.generateAccessorsByDelegate$thisRef($isExtension, $ownerRegularOrAnonymousObjectSymbol, fakeSource, $this_generateAccessorsByDelegate, $ownerRegularClassTypeParametersCount, true));
        }
        return firPropertyAccessExpressionBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private static final FirCallableReferenceAccess generateAccessorsByDelegate$propertyRef(FirSourceElement fakeSource, boolean isMember, boolean $isExtension, boolean isVar, FirPropertyBuilder $this_generateAccessorsByDelegate) {
        void $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2d24_u24lambda_u2d23;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder;
        FirCallableReferenceAccessBuilder firCallableReferenceAccessBuilder;
        boolean $i$f$buildCallableReferenceAccess = false;
        FirCallableReferenceAccessBuilder $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2d24 = firCallableReferenceAccessBuilder = new FirCallableReferenceAccessBuilder();
        boolean bl = false;
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2d24.setSource(fakeSource);
        boolean $i$f$buildResolvedNamedReference = false;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder2 = firResolvedNamedReferenceBuilder = new FirResolvedNamedReferenceBuilder();
        FirCallableReferenceAccessBuilder firCallableReferenceAccessBuilder2 = $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2d24;
        boolean bl2 = false;
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2d24_u24lambda_u2d23.setSource(fakeSource);
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2d24_u24lambda_u2d23.setName($this_generateAccessorsByDelegate.getName());
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2d24_u24lambda_u2d23.setResolvedSymbol($this_generateAccessorsByDelegate.getSymbol());
        Unit unit2 = Unit.INSTANCE;
        firCallableReferenceAccessBuilder2.setCalleeReference(firResolvedNamedReferenceBuilder.build());
        $this$generateAccessorsByDelegate_u24propertyRef_u24lambda_u2d24.setTypeRef(!isMember && !$isExtension ? (FirTypeRef)(isVar ? (FirImplicitBuiltinTypeRef)new FirImplicitKMutableProperty0TypeRef(null, ConeStarProjection.INSTANCE) : (FirImplicitBuiltinTypeRef)new FirImplicitKProperty0TypeRef(null, ConeStarProjection.INSTANCE)) : (isMember && $isExtension ? (FirTypeRef)(isVar ? (FirImplicitBuiltinTypeRef)new FirImplicitKMutableProperty2TypeRef(null, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE) : (FirImplicitBuiltinTypeRef)new FirImplicitKProperty2TypeRef(null, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE)) : (FirTypeRef)(isVar ? (FirImplicitBuiltinTypeRef)new FirImplicitKMutableProperty1TypeRef(null, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE) : (FirImplicitBuiltinTypeRef)new FirImplicitKProperty1TypeRef(null, ConeStarProjection.INSTANCE, ConeStarProjection.INSTANCE))));
        return firCallableReferenceAccessBuilder.build();
    }

    static {
        Name name2 = Name.special("<set-?>");
        Intrinsics.checkNotNullExpressionValue(name2, "special(\"<set-?>\")");
        DELEGATED_SETTER_PARAM = name2;
    }
}

