/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.diagnostics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticWithParameters2;
import org.jetbrains.kotlin.fir.analysis.diagnostics.LightTreePositioningStrategies;
import org.jetbrains.kotlin.fir.analysis.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.LightTreePositioningStrategy;
import org.jetbrains.kotlin.fir.analysis.diagnostics.LightTreePositioningStrategyKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.UnreachableCodeLightTreeHelper;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000;\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\bJ\n\u0002\b8\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001O\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\u0091\u0001\u0092\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u008e\u0001\u001a\u0005\u0018\u00010\u008c\u0001*\n\u0012\u0005\u0012\u00030\u008c\u00010\u008f\u00012\b\u0010\u0090\u0001\u001a\u00030\u008c\u0001H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0017\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0012\u0010\u0002\u001a\u0004\b\u0013\u0010\u0006R\u0011\u0010\u0014\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0006R\u0011\u0010\u0016\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0006R\u0011\u0010\u0018\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0006R\u0011\u0010\u001a\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0006R\u0011\u0010\u001c\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0006R\u0011\u0010\u001e\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0006R\u0011\u0010 \u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0006R\u0011\u0010\"\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0006R\u0011\u0010$\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0006R\u0011\u0010&\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0006R\u0011\u0010(\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0006R\u0011\u0010*\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0006R\u0011\u0010,\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0006R\u0011\u0010.\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u0006R\u0011\u00100\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u0006R\u0011\u00102\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u0006R\u0011\u00104\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u0006R\u0011\u00106\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\u0006R\u0011\u00108\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010\u0006R\u0011\u0010:\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010\u0006R\u0011\u0010<\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010\u0006R\u0011\u0010>\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010\u0006R\u0011\u0010@\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010\u0006R\u0011\u0010B\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010\u0006R\u0011\u0010D\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010\u0006R\u0011\u0010F\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010\u0006R\u0011\u0010H\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010\u0006R\u0011\u0010J\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010\u0006R\u0011\u0010L\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010\u0006R\u0010\u0010N\u001a\u00020OX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010PR\u0011\u0010Q\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u0010\u0006R\u0011\u0010S\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bT\u0010\u0006R\u0011\u0010U\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bV\u0010\u0006R\u0011\u0010W\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bX\u0010\u0006R\u0011\u0010Y\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bZ\u0010\u0006R\u0011\u0010[\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\\\u0010\u0006R\u0011\u0010]\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b^\u0010\u0006R\u0011\u0010_\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b`\u0010\u0006R\u0011\u0010a\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bb\u0010\u0006R\u0011\u0010c\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bd\u0010\u0006R\u0011\u0010e\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bf\u0010\u0006R\u0011\u0010g\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bh\u0010\u0006R\u0011\u0010i\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bj\u0010\u0006R\u0011\u0010k\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bl\u0010\u0006R\u0011\u0010m\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bn\u0010\u0006R\u0011\u0010o\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bp\u0010\u0006R\u0011\u0010q\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\br\u0010\u0006R\u000e\u0010s\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bu\u0010\u0006R\u0011\u0010v\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bw\u0010\u0006R\u0011\u0010x\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\by\u0010\u0006R\u0011\u0010z\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b{\u0010\u0006R\u0011\u0010|\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b}\u0010\u0006R\u0011\u0010~\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u007f\u0010\u0006R\u0013\u0010\u0080\u0001\u001a\u00020\u0004\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0081\u0001\u0010\u0006R\u0013\u0010\u0082\u0001\u001a\u00020\u0004\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0083\u0001\u0010\u0006R\u0013\u0010\u0084\u0001\u001a\u00020\u0004\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0085\u0001\u0010\u0006R!\u0010\u0086\u0001\u001a\u0014\u0012\u000f\u0012\r \u0089\u0001*\u0005\u0018\u00010\u0088\u00010\u0088\u00010\u0087\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u008a\u0001\u001a\u00030\u008b\u0001*\u00030\u008c\u00018BX\u0082\u0004\u00a2\u0006\b\u001a\u0006\b\u008a\u0001\u0010\u008d\u0001\u00a8\u0006\u0093\u0001"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/diagnostics/LightTreePositioningStrategies;", "", "()V", "ABSTRACT_MODIFIER", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/LightTreePositioningStrategy;", "getABSTRACT_MODIFIER", "()Lorg/jetbrains/kotlin/fir/analysis/diagnostics/LightTreePositioningStrategy;", "ACTUAL_DECLARATION_NAME", "getACTUAL_DECLARATION_NAME", "ANNOTATION_USE_SITE", "getANNOTATION_USE_SITE", "ARRAY_ACCESS", "getARRAY_ACCESS", "ASSIGNMENT_LHS", "getASSIGNMENT_LHS", "AS_TYPE", "getAS_TYPE", "COMMAS", "getCOMMAS$annotations", "getCOMMAS", "COMPANION_OBJECT", "getCOMPANION_OBJECT", "CONST_MODIFIER", "getCONST_MODIFIER", "DATA_MODIFIER", "getDATA_MODIFIER", "DECLARATION_NAME", "getDECLARATION_NAME", "DECLARATION_RETURN_TYPE", "getDECLARATION_RETURN_TYPE", "DECLARATION_SIGNATURE", "getDECLARATION_SIGNATURE", "DECLARATION_SIGNATURE_OR_DEFAULT", "getDECLARATION_SIGNATURE_OR_DEFAULT", "DECLARATION_WITH_BODY", "getDECLARATION_WITH_BODY", "DEFAULT", "getDEFAULT", "DOT_BY_QUALIFIED", "getDOT_BY_QUALIFIED", "ELSE_ENTRY", "getELSE_ENTRY", "ENUM_MODIFIER", "getENUM_MODIFIER", "FUN_INTERFACE", "getFUN_INTERFACE", "FUN_MODIFIER", "getFUN_MODIFIER", "IF_EXPRESSION", "getIF_EXPRESSION", "IMPORT_LAST_NAME", "getIMPORT_LAST_NAME", "INLINE_OR_VALUE_MODIFIER", "getINLINE_OR_VALUE_MODIFIER", "INLINE_PARAMETER_MODIFIER", "getINLINE_PARAMETER_MODIFIER", "INNER_MODIFIER", "getINNER_MODIFIER", "LABEL", "getLABEL", "LAST_CHILD", "getLAST_CHILD", "LATEINIT_MODIFIER", "getLATEINIT_MODIFIER", "LONG_LITERAL_SUFFIX", "getLONG_LITERAL_SUFFIX", "MODALITY_MODIFIER", "getMODALITY_MODIFIER", "NAME_IDENTIFIER", "getNAME_IDENTIFIER", "NAME_OF_NAMED_ARGUMENT", "getNAME_OF_NAMED_ARGUMENT", "NON_FINAL_MODIFIER_OR_NAME", "getNON_FINAL_MODIFIER_OR_NAME", "NOT_SUPPORTED_IN_INLINE_MOST_RELEVANT", "getNOT_SUPPORTED_IN_INLINE_MOST_RELEVANT", "OPEN_MODIFIER", "getOPEN_MODIFIER", "OPERATION_TO_END", "org/jetbrains/kotlin/fir/analysis/diagnostics/LightTreePositioningStrategies$OPERATION_TO_END$1", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/LightTreePositioningStrategies$OPERATION_TO_END$1;", "OPERATOR", "getOPERATOR", "OPERATOR_MODIFIER", "getOPERATOR_MODIFIER", "OVERRIDE_MODIFIER", "getOVERRIDE_MODIFIER", "PARAMETER_DEFAULT_VALUE", "getPARAMETER_DEFAULT_VALUE", "PARAMETER_VARARG_MODIFIER", "getPARAMETER_VARARG_MODIFIER", "PRIVATE_MODIFIER", "getPRIVATE_MODIFIER", "QUESTION_MARK_BY_TYPE", "getQUESTION_MARK_BY_TYPE", "REFERENCED_NAME_BY_QUALIFIED", "getREFERENCED_NAME_BY_QUALIFIED", "REFERENCE_BY_QUALIFIED", "getREFERENCE_BY_QUALIFIED", "REIFIED_MODIFIER", "getREIFIED_MODIFIER", "RETURN_WITH_LABEL", "getRETURN_WITH_LABEL", "SAFE_ACCESS", "getSAFE_ACCESS", "SECONDARY_CONSTRUCTOR_DELEGATION_CALL", "getSECONDARY_CONSTRUCTOR_DELEGATION_CALL", "SELECTOR_BY_QUALIFIED", "getSELECTOR_BY_QUALIFIED", "SPREAD_OPERATOR", "getSPREAD_OPERATOR", "SUPERTYPES_LIST", "getSUPERTYPES_LIST", "SUSPEND_MODIFIER", "getSUSPEND_MODIFIER", "SUSPEND_OR_FUN_MODIFIER", "TYPE_PARAMETERS_LIST", "getTYPE_PARAMETERS_LIST", "UNREACHABLE_CODE", "getUNREACHABLE_CODE", "USELESS_ELVIS", "getUSELESS_ELVIS", "VALUE_ARGUMENTS", "getVALUE_ARGUMENTS", "VAL_OR_VAR_NODE", "getVAL_OR_VAR_NODE", "VARIANCE_MODIFIER", "getVARIANCE_MODIFIER", "VISIBILITY_MODIFIER", "getVISIBILITY_MODIFIER", "WHEN_EXPRESSION", "getWHEN_EXPRESSION", "WHOLE_ELEMENT", "getWHOLE_ELEMENT", "nodeTypesWithOperation", "", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "isDeclaration", "", "Lorg/jetbrains/kotlin/com/intellij/lang/LighterASTNode;", "(Lcom/intellij/lang/LighterASTNode;)Z", "referencedTypeExpression", "Lorg/jetbrains/kotlin/com/intellij/util/diff/FlyweightCapableTreeStructure;", "node", "FindReferencePositioningStrategy", "ModifierSetBasedLightTreePositioningStrategy", "checkers"})
public final class LightTreePositioningStrategies {
    @NotNull
    public static final LightTreePositioningStrategies INSTANCE = new LightTreePositioningStrategies();
    @NotNull
    private static final LightTreePositioningStrategy DEFAULT = new LightTreePositioningStrategy(){

        @NotNull
        public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            Intrinsics.checkNotNullParameter(node, "node");
            Intrinsics.checkNotNullParameter(tree, "tree");
            IElementType iElementType = node.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.OBJECT_LITERAL)) {
                KtKeywordToken ktKeywordToken = KtTokens.OBJECT_KEYWORD;
                Intrinsics.checkNotNullExpressionValue(ktKeywordToken, "OBJECT_KEYWORD");
                LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.findDescendantByType(tree, node, ktKeywordToken);
                Intrinsics.checkNotNull(lighterASTNode2);
                LighterASTNode objectKeyword = lighterASTNode2;
                return LightTreePositioningStrategyKt.markElement(objectKeyword, startOffset, endOffset, tree, node);
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.OBJECT_DECLARATION)) {
                LighterASTNode lighterASTNode3 = LightTreePositioningStrategiesKt.access$objectKeyword(tree, node);
                Intrinsics.checkNotNull(lighterASTNode3);
                LighterASTNode objectKeyword = lighterASTNode3;
                LighterASTNode lighterASTNode4 = LightTreePositioningStrategiesKt.nameIdentifier(tree, node);
                return LightTreePositioningStrategyKt.markRange(objectKeyword, lighterASTNode4 == null ? objectKeyword : lighterASTNode4, startOffset, endOffset, tree, node);
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.CONSTRUCTOR_DELEGATION_CALL)) {
                return LightTreePositioningStrategies.INSTANCE.getSECONDARY_CONSTRUCTOR_DELEGATION_CALL().mark(node, startOffset, endOffset, tree);
            }
            return super.mark(node, startOffset, endOffset, tree);
        }
    };
    @NotNull
    private static final LightTreePositioningStrategy SUPERTYPES_LIST = new LightTreePositioningStrategy(){

        @NotNull
        public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            Intrinsics.checkNotNullParameter(node, "node");
            Intrinsics.checkNotNullParameter(tree, "tree");
            LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.access$supertypesList(tree, node);
            LighterASTNode target = lighterASTNode2 == null ? node : lighterASTNode2;
            return LightTreePositioningStrategyKt.markElement(target, startOffset, endOffset, tree, node);
        }
    };
    @NotNull
    private static final LightTreePositioningStrategy VAL_OR_VAR_NODE = new LightTreePositioningStrategy(){

        @NotNull
        public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            Intrinsics.checkNotNullParameter(node, "node");
            Intrinsics.checkNotNullParameter(tree, "tree");
            LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.valOrVarKeyword(tree, node);
            LighterASTNode target = lighterASTNode2 == null ? node : lighterASTNode2;
            return LightTreePositioningStrategyKt.markElement(target, startOffset, endOffset, tree, node);
        }
    };
    @NotNull
    private static final LightTreePositioningStrategy COMPANION_OBJECT = new LightTreePositioningStrategy(){

        @NotNull
        public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            Intrinsics.checkNotNullParameter(node, "node");
            Intrinsics.checkNotNullParameter(tree, "tree");
            LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.access$companionKeyword(tree, node);
            LighterASTNode target = lighterASTNode2 == null ? node : lighterASTNode2;
            return LightTreePositioningStrategyKt.markElement(target, startOffset, endOffset, tree, node);
        }
    };
    @NotNull
    private static final LightTreePositioningStrategy SECONDARY_CONSTRUCTOR_DELEGATION_CALL = new LightTreePositioningStrategy(){

        @NotNull
        public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            Intrinsics.checkNotNullParameter(node, "node");
            Intrinsics.checkNotNullParameter(tree, "tree");
            IElementType iElementType = node.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.SECONDARY_CONSTRUCTOR)) {
                LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.access$valueParameterList(tree, node);
                if (lighterASTNode2 == null) {
                    return LightTreePositioningStrategyKt.markElement$default(node, startOffset, endOffset, tree, null, 16, null);
                }
                LighterASTNode valueParameterList = lighterASTNode2;
                LighterASTNode lighterASTNode3 = LightTreePositioningStrategiesKt.access$constructorKeyword(tree, node);
                Intrinsics.checkNotNull(lighterASTNode3);
                lighterASTNode2 = LightTreePositioningStrategiesKt.access$lastChild(tree, valueParameterList);
                return LightTreePositioningStrategyKt.markRange(lighterASTNode3, lighterASTNode2 == null ? valueParameterList : lighterASTNode2, startOffset, endOffset, tree, node);
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.CONSTRUCTOR_DELEGATION_CALL)) {
                Object object = KtNodeTypes.CONSTRUCTOR_DELEGATION_REFERENCE;
                Intrinsics.checkNotNullExpressionValue(object, "CONSTRUCTOR_DELEGATION_REFERENCE");
                LighterASTNode delegationReference = LightTreePositioningStrategiesKt.findChildByType(tree, node, (IElementType)object);
                if (delegationReference != null && LightTreePositioningStrategiesKt.access$firstChild(tree, delegationReference) == null) {
                    IElementType iElementType2 = KtNodeTypes.SECONDARY_CONSTRUCTOR;
                    Intrinsics.checkNotNullExpressionValue(iElementType2, "SECONDARY_CONSTRUCTOR");
                    LighterASTNode lighterASTNode4 = LightTreePositioningStrategiesKt.findParentOfType$default(tree, node, iElementType2, false, 4, null);
                    Intrinsics.checkNotNull(lighterASTNode4);
                    LighterASTNode constructor2 = lighterASTNode4;
                    LighterASTNode lighterASTNode5 = LightTreePositioningStrategiesKt.access$valueParameterList(tree, constructor2);
                    if (lighterASTNode5 == null) {
                        return LightTreePositioningStrategyKt.markElement(constructor2, startOffset, endOffset, tree, node);
                    }
                    LighterASTNode valueParameterList = lighterASTNode5;
                    LighterASTNode lighterASTNode6 = LightTreePositioningStrategiesKt.access$constructorKeyword(tree, constructor2);
                    Intrinsics.checkNotNull(lighterASTNode6);
                    lighterASTNode5 = LightTreePositioningStrategiesKt.access$lastChild(tree, valueParameterList);
                    return LightTreePositioningStrategyKt.markRange(lighterASTNode6, lighterASTNode5 == null ? valueParameterList : lighterASTNode5, startOffset, endOffset, tree, node);
                }
                object = delegationReference;
                return LightTreePositioningStrategyKt.markElement((LighterASTNode)(object == null ? node : object), startOffset, endOffset, tree, node);
            }
            throw new IllegalStateException(Intrinsics.stringPlus("unexpected element ", node).toString());
        }
    };
    @NotNull
    private static final LightTreePositioningStrategy DECLARATION_RETURN_TYPE = new LightTreePositioningStrategy(){

        @NotNull
        public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            Intrinsics.checkNotNullParameter(node, "node");
            Intrinsics.checkNotNullParameter(tree, "tree");
            return LightTreePositioningStrategyKt.markElement(this.getElementToMark(node, tree), startOffset, endOffset, tree, node);
        }

        public boolean isValid(@NotNull LighterASTNode node, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            Intrinsics.checkNotNullParameter(node, "node");
            Intrinsics.checkNotNullParameter(tree, "tree");
            return super.isValid(this.getElementToMark(node, tree), tree);
        }

        private final LighterASTNode getElementToMark(LighterASTNode node, FlyweightCapableTreeStructure<LighterASTNode> tree) {
            LighterASTNode lighterASTNode2;
            Pair<LighterASTNode, LighterASTNode> pair = Intrinsics.areEqual(node.getTokenType(), KtNodeTypes.PROPERTY_ACCESSOR) ? TuplesKt.to(LightTreePositioningStrategiesKt.access$typeReference(tree, node), LightTreePositioningStrategiesKt.access$accessorNamePlaceholder(tree, node)) : (LightTreePositioningStrategies.access$isDeclaration(LightTreePositioningStrategies.INSTANCE, node) ? TuplesKt.to(LightTreePositioningStrategiesKt.access$typeReference(tree, node), LightTreePositioningStrategiesKt.nameIdentifier(tree, node)) : TuplesKt.to(null, null));
            LighterASTNode returnTypeRef = pair.component1();
            LighterASTNode nameIdentifierOrPlaceHolder = pair.component2();
            LighterASTNode lighterASTNode3 = returnTypeRef;
            return lighterASTNode3 == null ? ((lighterASTNode2 = nameIdentifierOrPlaceHolder) == null ? node : lighterASTNode2) : lighterASTNode3;
        }
    };
    @NotNull
    private static final LightTreePositioningStrategy DECLARATION_NAME = new LightTreePositioningStrategy(){

        @NotNull
        public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            Intrinsics.checkNotNullParameter(node, "node");
            Intrinsics.checkNotNullParameter(tree, "tree");
            LighterASTNode nameIdentifier = LightTreePositioningStrategiesKt.nameIdentifier(tree, node);
            if (nameIdentifier != null) {
                if (Intrinsics.areEqual(node.getTokenType(), KtNodeTypes.CLASS) || Intrinsics.areEqual(node.getTokenType(), KtNodeTypes.OBJECT_DECLARATION)) {
                    LighterASTNode lighterASTNode2;
                    Object object;
                    LighterASTNode lighterASTNode3;
                    LighterASTNode lighterASTNode4 = LightTreePositioningStrategiesKt.access$modifierList(tree, node);
                    if (lighterASTNode4 == null) {
                        lighterASTNode3 = null;
                    } else {
                        object = lighterASTNode4;
                        LighterASTNode modifierList2 = object;
                        boolean bl = false;
                        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.ENUM_KEYWORD;
                        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken, "ENUM_KEYWORD");
                        lighterASTNode3 = LightTreePositioningStrategiesKt.findChildByType(tree, modifierList2, ktModifierKeywordToken);
                    }
                    LighterASTNode lighterASTNode5 = lighterASTNode3;
                    if (lighterASTNode5 == null) {
                        IElementType[] iElementTypeArray = new IElementType[]{KtTokens.CLASS_KEYWORD, KtTokens.OBJECT_KEYWORD};
                        object = TokenSet.create(iElementTypeArray);
                        Intrinsics.checkNotNullExpressionValue(object, "create(KtTokens.CLASS_KE\u2026 KtTokens.OBJECT_KEYWORD)");
                        lighterASTNode4 = LightTreePositioningStrategiesKt.findChildByType(tree, node, (TokenSet)object);
                        lighterASTNode2 = lighterASTNode4 == null ? node : lighterASTNode4;
                    } else {
                        lighterASTNode2 = lighterASTNode5;
                    }
                    LighterASTNode startElement = lighterASTNode2;
                    return LightTreePositioningStrategyKt.markRange(startElement, nameIdentifier, startOffset, endOffset, tree, node);
                }
                return LightTreePositioningStrategyKt.markElement(nameIdentifier, startOffset, endOffset, tree, node);
            }
            if (Intrinsics.areEqual(node.getTokenType(), KtNodeTypes.FUN)) {
                return LightTreePositioningStrategies.INSTANCE.getDECLARATION_SIGNATURE().mark(node, startOffset, endOffset, tree);
            }
            return LightTreePositioningStrategies.INSTANCE.getDEFAULT().mark(node, startOffset, endOffset, tree);
        }

        public boolean isValid(@NotNull LighterASTNode node, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            Intrinsics.checkNotNullParameter(node, "node");
            Intrinsics.checkNotNullParameter(tree, "tree");
            if (!(Intrinsics.areEqual(node.getTokenType(), KtNodeTypes.OBJECT_DECLARATION) || Intrinsics.areEqual(node.getTokenType(), KtNodeTypes.FUN) || Intrinsics.areEqual(node.getTokenType(), KtNodeTypes.SECONDARY_CONSTRUCTOR) || Intrinsics.areEqual(node.getTokenType(), KtNodeTypes.OBJECT_LITERAL) || LightTreePositioningStrategiesKt.nameIdentifier(tree, node) != null)) {
                return false;
            }
            return super.isValid(node, tree);
        }
    };
    @NotNull
    private static final LightTreePositioningStrategy ACTUAL_DECLARATION_NAME = new LightTreePositioningStrategy(){

        @NotNull
        public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            Intrinsics.checkNotNullParameter(node, "node");
            Intrinsics.checkNotNullParameter(tree, "tree");
            LighterASTNode nameIdentifier = LightTreePositioningStrategiesKt.nameIdentifier(tree, node);
            if (nameIdentifier != null) {
                return LightTreePositioningStrategyKt.markElement(nameIdentifier, startOffset, endOffset, tree, node);
            }
            return LightTreePositioningStrategies.INSTANCE.getDEFAULT().mark(node, startOffset, endOffset, tree);
        }
    };
    @NotNull
    private static final LightTreePositioningStrategy DECLARATION_SIGNATURE = new LightTreePositioningStrategy(){

        @NotNull
        public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            Intrinsics.checkNotNullParameter(node, "node");
            Intrinsics.checkNotNullParameter(tree, "tree");
            IElementType iElementType = node.getTokenType();
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.PRIMARY_CONSTRUCTOR) ? true : Intrinsics.areEqual(iElementType, KtNodeTypes.SECONDARY_CONSTRUCTOR)) {
                LighterASTNode lighterASTNode2;
                LighterASTNode lighterASTNode3;
                LighterASTNode lighterASTNode4;
                LighterASTNode lighterASTNode5 = LightTreePositioningStrategiesKt.access$constructorKeyword(tree, node);
                if (lighterASTNode5 == null) {
                    lighterASTNode4 = LightTreePositioningStrategiesKt.access$valueParameterList(tree, node);
                    if (lighterASTNode4 == null) {
                        return LightTreePositioningStrategyKt.markElement$default(node, startOffset, endOffset, tree, null, 16, null);
                    }
                    lighterASTNode3 = lighterASTNode4;
                } else {
                    lighterASTNode3 = lighterASTNode5;
                }
                LighterASTNode begin = lighterASTNode3;
                lighterASTNode4 = LightTreePositioningStrategiesKt.access$valueParameterList(tree, node);
                if (lighterASTNode4 == null) {
                    LighterASTNode lighterASTNode6 = LightTreePositioningStrategiesKt.access$constructorKeyword(tree, node);
                    if (lighterASTNode6 == null) {
                        return LightTreePositioningStrategyKt.markElement$default(node, startOffset, endOffset, tree, null, 16, null);
                    }
                    lighterASTNode2 = lighterASTNode6;
                } else {
                    lighterASTNode2 = lighterASTNode4;
                }
                LighterASTNode end = lighterASTNode2;
                return LightTreePositioningStrategyKt.markRange(begin, end, startOffset, endOffset, tree, node);
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.FUN) ? true : Intrinsics.areEqual(iElementType, KtNodeTypes.FUNCTION_LITERAL)) {
                LighterASTNode endOfSignatureElement;
                LighterASTNode lighterASTNode7;
                LighterASTNode lighterASTNode8;
                LighterASTNode end = LightTreePositioningStrategiesKt.access$typeReference(tree, node);
                LighterASTNode lighterASTNode9 = end == null ? ((lighterASTNode8 = LightTreePositioningStrategiesKt.access$valueParameterList(tree, node)) == null ? ((lighterASTNode7 = LightTreePositioningStrategiesKt.nameIdentifier(tree, node)) == null ? node : lighterASTNode7) : lighterASTNode8) : (endOfSignatureElement = end);
                LighterASTNode startElement = Intrinsics.areEqual(node.getTokenType(), KtNodeTypes.FUNCTION_LITERAL) ? ((lighterASTNode8 = LightTreePositioningStrategiesKt.access$receiverTypeReference(tree, node)) == null ? ((lighterASTNode7 = LightTreePositioningStrategiesKt.access$valueParameterList(tree, node)) == null ? node : lighterASTNode7) : lighterASTNode8) : node;
                return LightTreePositioningStrategyKt.markRange(startElement, endOfSignatureElement, startOffset, endOffset, tree, node);
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.PROPERTY)) {
                LighterASTNode lighterASTNode10;
                LighterASTNode startElement = LightTreePositioningStrategiesKt.access$typeReference(tree, node);
                LighterASTNode endOfSignatureElement = startElement == null ? ((lighterASTNode10 = LightTreePositioningStrategiesKt.nameIdentifier(tree, node)) == null ? node : lighterASTNode10) : startElement;
                return LightTreePositioningStrategyKt.markRange(node, endOfSignatureElement, startOffset, endOffset, tree, node);
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.PROPERTY_ACCESSOR)) {
                LighterASTNode lighterASTNode11;
                LighterASTNode startElement = LightTreePositioningStrategiesKt.access$typeReference(tree, node);
                LighterASTNode endOfSignatureElement = startElement == null ? ((lighterASTNode11 = LightTreePositioningStrategiesKt.access$rightParenthesis(tree, node)) == null ? LightTreePositioningStrategiesKt.access$accessorNamePlaceholder(tree, node) : lighterASTNode11) : startElement;
                return LightTreePositioningStrategyKt.markRange(node, endOfSignatureElement, startOffset, endOffset, tree, node);
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.CLASS)) {
                LighterASTNode lighterASTNode12;
                LighterASTNode startElement = LightTreePositioningStrategiesKt.nameIdentifier(tree, node);
                if (startElement == null) {
                    return LightTreePositioningStrategyKt.markElement$default(node, startOffset, endOffset, tree, null, 16, null);
                }
                LighterASTNode nameAsDeclaration = startElement;
                LighterASTNode lighterASTNode13 = LightTreePositioningStrategiesKt.access$primaryConstructor(tree, node);
                if (lighterASTNode13 == null) {
                    lighterASTNode12 = null;
                } else {
                    LighterASTNode lighterASTNode14;
                    LighterASTNode constructor2 = lighterASTNode14 = lighterASTNode13;
                    boolean bl = false;
                    lighterASTNode12 = LightTreePositioningStrategiesKt.access$valueParameterList(tree, constructor2);
                }
                LighterASTNode lighterASTNode15 = lighterASTNode12;
                if (lighterASTNode15 == null) {
                    return LightTreePositioningStrategyKt.markElement(nameAsDeclaration, startOffset, endOffset, tree, node);
                }
                LighterASTNode primaryConstructorParameterList = lighterASTNode15;
                return LightTreePositioningStrategyKt.markRange(nameAsDeclaration, primaryConstructorParameterList, startOffset, endOffset, tree, node);
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.OBJECT_DECLARATION)) {
                return LightTreePositioningStrategies.INSTANCE.getDECLARATION_NAME().mark(node, startOffset, endOffset, tree);
            }
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.CLASS_INITIALIZER)) {
                LighterASTNode lighterASTNode16 = LightTreePositioningStrategiesKt.access$initKeyword(tree, node);
                Intrinsics.checkNotNull(lighterASTNode16);
                return LightTreePositioningStrategyKt.markElement(lighterASTNode16, startOffset, endOffset, tree, node);
            }
            return super.mark(node, startOffset, endOffset, tree);
        }
    };
    @NotNull
    private static final LightTreePositioningStrategy DECLARATION_SIGNATURE_OR_DEFAULT = new LightTreePositioningStrategy(){

        @NotNull
        public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            Intrinsics.checkNotNullParameter(node, "node");
            Intrinsics.checkNotNullParameter(tree, "tree");
            return LightTreePositioningStrategies.access$isDeclaration(LightTreePositioningStrategies.INSTANCE, node) ? LightTreePositioningStrategies.INSTANCE.getDECLARATION_SIGNATURE().mark(node, startOffset, endOffset, tree) : LightTreePositioningStrategies.INSTANCE.getDEFAULT().mark(node, startOffset, endOffset, tree);
        }
    };
    @NotNull
    private static final LightTreePositioningStrategy LAST_CHILD = new LightTreePositioningStrategy(){

        @NotNull
        public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            Intrinsics.checkNotNullParameter(node, "node");
            Intrinsics.checkNotNullParameter(tree, "tree");
            LighterASTNode value2 = LightTreePositioningStrategyKt.nonFillerLastChildOrSelf(node, tree);
            return LightTreePositioningStrategyKt.markElement(value2, startOffset, endOffset, tree, node);
        }
    };
    @NotNull
    private static final LightTreePositioningStrategy VISIBILITY_MODIFIER;
    @NotNull
    private static final LightTreePositioningStrategy MODALITY_MODIFIER;
    @NotNull
    private static final LightTreePositioningStrategy ABSTRACT_MODIFIER;
    @NotNull
    private static final LightTreePositioningStrategy OPEN_MODIFIER;
    @NotNull
    private static final LightTreePositioningStrategy OVERRIDE_MODIFIER;
    @NotNull
    private static final LightTreePositioningStrategy PRIVATE_MODIFIER;
    @NotNull
    private static final LightTreePositioningStrategy LATEINIT_MODIFIER;
    @NotNull
    private static final LightTreePositioningStrategy VARIANCE_MODIFIER;
    @NotNull
    private static final LightTreePositioningStrategy CONST_MODIFIER;
    @NotNull
    private static final LightTreePositioningStrategy FUN_MODIFIER;
    @NotNull
    private static final LightTreePositioningStrategy SUSPEND_MODIFIER;
    @NotNull
    private static final LightTreePositioningStrategy SUSPEND_OR_FUN_MODIFIER;
    @NotNull
    private static final LightTreePositioningStrategy INLINE_OR_VALUE_MODIFIER;
    @NotNull
    private static final LightTreePositioningStrategy INNER_MODIFIER;
    @NotNull
    private static final LightTreePositioningStrategy DATA_MODIFIER;
    @NotNull
    private static final LightTreePositioningStrategy OPERATOR_MODIFIER;
    @NotNull
    private static final LightTreePositioningStrategy ENUM_MODIFIER;
    @NotNull
    private static final LightTreePositioningStrategy INLINE_PARAMETER_MODIFIER;
    @NotNull
    private static final LightTreePositioningStrategy OPERATOR;
    @NotNull
    private static final LightTreePositioningStrategy PARAMETER_DEFAULT_VALUE;
    @NotNull
    private static final LightTreePositioningStrategy PARAMETER_VARARG_MODIFIER;
    @NotNull
    private static final LightTreePositioningStrategy NAME_OF_NAMED_ARGUMENT;
    @NotNull
    private static final LightTreePositioningStrategy VALUE_ARGUMENTS;
    @NotNull
    private static final LightTreePositioningStrategy DOT_BY_QUALIFIED;
    @NotNull
    private static final LightTreePositioningStrategy SELECTOR_BY_QUALIFIED;
    @NotNull
    private static final LightTreePositioningStrategy FUN_INTERFACE;
    @NotNull
    private static final LightTreePositioningStrategy REFERENCE_BY_QUALIFIED;
    @NotNull
    private static final LightTreePositioningStrategy REFERENCED_NAME_BY_QUALIFIED;
    @NotNull
    private static final Set<IElementType> nodeTypesWithOperation;
    @NotNull
    private static final LightTreePositioningStrategy WHEN_EXPRESSION;
    @NotNull
    private static final LightTreePositioningStrategy IF_EXPRESSION;
    @NotNull
    private static final LightTreePositioningStrategy ELSE_ENTRY;
    @NotNull
    private static final LightTreePositioningStrategy ARRAY_ACCESS;
    @NotNull
    private static final LightTreePositioningStrategy SAFE_ACCESS;
    @NotNull
    private static final OPERATION_TO_END.1 OPERATION_TO_END;
    @NotNull
    private static final LightTreePositioningStrategy AS_TYPE;
    @NotNull
    private static final LightTreePositioningStrategy USELESS_ELVIS;
    @NotNull
    private static final LightTreePositioningStrategy RETURN_WITH_LABEL;
    @NotNull
    private static final LightTreePositioningStrategy WHOLE_ELEMENT;
    @NotNull
    private static final LightTreePositioningStrategy LONG_LITERAL_SUFFIX;
    @NotNull
    private static final LightTreePositioningStrategy REIFIED_MODIFIER;
    @NotNull
    private static final LightTreePositioningStrategy TYPE_PARAMETERS_LIST;
    @NotNull
    private static final LightTreePositioningStrategy NAME_IDENTIFIER;
    @NotNull
    private static final LightTreePositioningStrategy QUESTION_MARK_BY_TYPE;
    @NotNull
    private static final LightTreePositioningStrategy ASSIGNMENT_LHS;
    @NotNull
    private static final LightTreePositioningStrategy ANNOTATION_USE_SITE;
    @NotNull
    private static final LightTreePositioningStrategy IMPORT_LAST_NAME;
    @NotNull
    private static final LightTreePositioningStrategy SPREAD_OPERATOR;
    @NotNull
    private static final LightTreePositioningStrategy DECLARATION_WITH_BODY;
    @NotNull
    private static final LightTreePositioningStrategy UNREACHABLE_CODE;
    @NotNull
    private static final LightTreePositioningStrategy NOT_SUPPORTED_IN_INLINE_MOST_RELEVANT;
    @NotNull
    private static final LightTreePositioningStrategy LABEL;
    @NotNull
    private static final LightTreePositioningStrategy COMMAS;
    @NotNull
    private static final LightTreePositioningStrategy NON_FINAL_MODIFIER_OR_NAME;

    private LightTreePositioningStrategies() {
    }

    @NotNull
    public final LightTreePositioningStrategy getDEFAULT() {
        return DEFAULT;
    }

    @NotNull
    public final LightTreePositioningStrategy getSUPERTYPES_LIST() {
        return SUPERTYPES_LIST;
    }

    @NotNull
    public final LightTreePositioningStrategy getVAL_OR_VAR_NODE() {
        return VAL_OR_VAR_NODE;
    }

    @NotNull
    public final LightTreePositioningStrategy getCOMPANION_OBJECT() {
        return COMPANION_OBJECT;
    }

    @NotNull
    public final LightTreePositioningStrategy getSECONDARY_CONSTRUCTOR_DELEGATION_CALL() {
        return SECONDARY_CONSTRUCTOR_DELEGATION_CALL;
    }

    @NotNull
    public final LightTreePositioningStrategy getDECLARATION_RETURN_TYPE() {
        return DECLARATION_RETURN_TYPE;
    }

    @NotNull
    public final LightTreePositioningStrategy getDECLARATION_NAME() {
        return DECLARATION_NAME;
    }

    @NotNull
    public final LightTreePositioningStrategy getACTUAL_DECLARATION_NAME() {
        return ACTUAL_DECLARATION_NAME;
    }

    @NotNull
    public final LightTreePositioningStrategy getDECLARATION_SIGNATURE() {
        return DECLARATION_SIGNATURE;
    }

    @NotNull
    public final LightTreePositioningStrategy getDECLARATION_SIGNATURE_OR_DEFAULT() {
        return DECLARATION_SIGNATURE_OR_DEFAULT;
    }

    @NotNull
    public final LightTreePositioningStrategy getLAST_CHILD() {
        return LAST_CHILD;
    }

    private final boolean isDeclaration(LighterASTNode $this$isDeclaration) {
        IElementType iElementType = $this$isDeclaration.getTokenType();
        return (((((((Intrinsics.areEqual(iElementType, KtNodeTypes.PRIMARY_CONSTRUCTOR) ? true : Intrinsics.areEqual(iElementType, KtNodeTypes.SECONDARY_CONSTRUCTOR)) ? true : Intrinsics.areEqual(iElementType, KtNodeTypes.FUN)) ? true : Intrinsics.areEqual(iElementType, KtNodeTypes.FUNCTION_LITERAL)) ? true : Intrinsics.areEqual(iElementType, KtNodeTypes.PROPERTY)) ? true : Intrinsics.areEqual(iElementType, KtNodeTypes.PROPERTY_ACCESSOR)) ? true : Intrinsics.areEqual(iElementType, KtNodeTypes.CLASS)) ? true : Intrinsics.areEqual(iElementType, KtNodeTypes.OBJECT_DECLARATION)) ? true : Intrinsics.areEqual(iElementType, KtNodeTypes.CLASS_INITIALIZER);
    }

    @NotNull
    public final LightTreePositioningStrategy getVISIBILITY_MODIFIER() {
        return VISIBILITY_MODIFIER;
    }

    @NotNull
    public final LightTreePositioningStrategy getMODALITY_MODIFIER() {
        return MODALITY_MODIFIER;
    }

    @NotNull
    public final LightTreePositioningStrategy getABSTRACT_MODIFIER() {
        return ABSTRACT_MODIFIER;
    }

    @NotNull
    public final LightTreePositioningStrategy getOPEN_MODIFIER() {
        return OPEN_MODIFIER;
    }

    @NotNull
    public final LightTreePositioningStrategy getOVERRIDE_MODIFIER() {
        return OVERRIDE_MODIFIER;
    }

    @NotNull
    public final LightTreePositioningStrategy getPRIVATE_MODIFIER() {
        return PRIVATE_MODIFIER;
    }

    @NotNull
    public final LightTreePositioningStrategy getLATEINIT_MODIFIER() {
        return LATEINIT_MODIFIER;
    }

    @NotNull
    public final LightTreePositioningStrategy getVARIANCE_MODIFIER() {
        return VARIANCE_MODIFIER;
    }

    @NotNull
    public final LightTreePositioningStrategy getCONST_MODIFIER() {
        return CONST_MODIFIER;
    }

    @NotNull
    public final LightTreePositioningStrategy getFUN_MODIFIER() {
        return FUN_MODIFIER;
    }

    @NotNull
    public final LightTreePositioningStrategy getSUSPEND_MODIFIER() {
        return SUSPEND_MODIFIER;
    }

    @NotNull
    public final LightTreePositioningStrategy getINLINE_OR_VALUE_MODIFIER() {
        return INLINE_OR_VALUE_MODIFIER;
    }

    @NotNull
    public final LightTreePositioningStrategy getINNER_MODIFIER() {
        return INNER_MODIFIER;
    }

    @NotNull
    public final LightTreePositioningStrategy getDATA_MODIFIER() {
        return DATA_MODIFIER;
    }

    @NotNull
    public final LightTreePositioningStrategy getOPERATOR_MODIFIER() {
        return OPERATOR_MODIFIER;
    }

    @NotNull
    public final LightTreePositioningStrategy getENUM_MODIFIER() {
        return ENUM_MODIFIER;
    }

    @NotNull
    public final LightTreePositioningStrategy getINLINE_PARAMETER_MODIFIER() {
        return INLINE_PARAMETER_MODIFIER;
    }

    @NotNull
    public final LightTreePositioningStrategy getOPERATOR() {
        return OPERATOR;
    }

    @NotNull
    public final LightTreePositioningStrategy getPARAMETER_DEFAULT_VALUE() {
        return PARAMETER_DEFAULT_VALUE;
    }

    @NotNull
    public final LightTreePositioningStrategy getPARAMETER_VARARG_MODIFIER() {
        return PARAMETER_VARARG_MODIFIER;
    }

    @NotNull
    public final LightTreePositioningStrategy getNAME_OF_NAMED_ARGUMENT() {
        return NAME_OF_NAMED_ARGUMENT;
    }

    @NotNull
    public final LightTreePositioningStrategy getVALUE_ARGUMENTS() {
        return VALUE_ARGUMENTS;
    }

    @NotNull
    public final LightTreePositioningStrategy getDOT_BY_QUALIFIED() {
        return DOT_BY_QUALIFIED;
    }

    @NotNull
    public final LightTreePositioningStrategy getSELECTOR_BY_QUALIFIED() {
        return SELECTOR_BY_QUALIFIED;
    }

    private final LighterASTNode referencedTypeExpression(FlyweightCapableTreeStructure<LighterASTNode> $this$referencedTypeExpression, LighterASTNode node) {
        LighterASTNode lighterASTNode2;
        IElementType iElementType = node.getTokenType();
        if (Intrinsics.areEqual(iElementType, KtNodeTypes.USER_TYPE)) {
            IElementType iElementType2 = KtNodeTypes.REFERENCE_EXPRESSION;
            Intrinsics.checkNotNullExpressionValue(iElementType2, "REFERENCE_EXPRESSION");
            LighterASTNode lighterASTNode3 = LightTreePositioningStrategiesKt.findChildByType($this$referencedTypeExpression, node, iElementType2);
            if (lighterASTNode3 == null) {
                iElementType2 = KtNodeTypes.ENUM_ENTRY_SUPERCLASS_REFERENCE_EXPRESSION;
                Intrinsics.checkNotNullExpressionValue(iElementType2, "ENUM_ENTRY_SUPERCLASS_REFERENCE_EXPRESSION");
                lighterASTNode2 = LightTreePositioningStrategiesKt.findChildByType($this$referencedTypeExpression, node, iElementType2);
            } else {
                lighterASTNode2 = lighterASTNode3;
            }
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.NULLABLE_TYPE)) {
            Object object = KtStubElementTypes.TYPE_ELEMENT_TYPES;
            Intrinsics.checkNotNullExpressionValue(object, "TYPE_ELEMENT_TYPES");
            LighterASTNode lighterASTNode4 = LightTreePositioningStrategiesKt.findChildByType($this$referencedTypeExpression, node, (TokenSet)object);
            if (lighterASTNode4 == null) {
                lighterASTNode2 = null;
            } else {
                Object it = object = lighterASTNode4;
                boolean bl = false;
                lighterASTNode2 = INSTANCE.referencedTypeExpression($this$referencedTypeExpression, (LighterASTNode)it);
            }
        } else {
            lighterASTNode2 = null;
        }
        return lighterASTNode2;
    }

    @NotNull
    public final LightTreePositioningStrategy getFUN_INTERFACE() {
        return FUN_INTERFACE;
    }

    @NotNull
    public final LightTreePositioningStrategy getREFERENCE_BY_QUALIFIED() {
        return REFERENCE_BY_QUALIFIED;
    }

    @NotNull
    public final LightTreePositioningStrategy getREFERENCED_NAME_BY_QUALIFIED() {
        return REFERENCED_NAME_BY_QUALIFIED;
    }

    @NotNull
    public final LightTreePositioningStrategy getWHEN_EXPRESSION() {
        return WHEN_EXPRESSION;
    }

    @NotNull
    public final LightTreePositioningStrategy getIF_EXPRESSION() {
        return IF_EXPRESSION;
    }

    @NotNull
    public final LightTreePositioningStrategy getELSE_ENTRY() {
        return ELSE_ENTRY;
    }

    @NotNull
    public final LightTreePositioningStrategy getARRAY_ACCESS() {
        return ARRAY_ACCESS;
    }

    @NotNull
    public final LightTreePositioningStrategy getSAFE_ACCESS() {
        return SAFE_ACCESS;
    }

    @NotNull
    public final LightTreePositioningStrategy getAS_TYPE() {
        return AS_TYPE;
    }

    @NotNull
    public final LightTreePositioningStrategy getUSELESS_ELVIS() {
        return USELESS_ELVIS;
    }

    @NotNull
    public final LightTreePositioningStrategy getRETURN_WITH_LABEL() {
        return RETURN_WITH_LABEL;
    }

    @NotNull
    public final LightTreePositioningStrategy getWHOLE_ELEMENT() {
        return WHOLE_ELEMENT;
    }

    @NotNull
    public final LightTreePositioningStrategy getLONG_LITERAL_SUFFIX() {
        return LONG_LITERAL_SUFFIX;
    }

    @NotNull
    public final LightTreePositioningStrategy getREIFIED_MODIFIER() {
        return REIFIED_MODIFIER;
    }

    @NotNull
    public final LightTreePositioningStrategy getTYPE_PARAMETERS_LIST() {
        return TYPE_PARAMETERS_LIST;
    }

    @NotNull
    public final LightTreePositioningStrategy getNAME_IDENTIFIER() {
        return NAME_IDENTIFIER;
    }

    @NotNull
    public final LightTreePositioningStrategy getQUESTION_MARK_BY_TYPE() {
        return QUESTION_MARK_BY_TYPE;
    }

    @NotNull
    public final LightTreePositioningStrategy getASSIGNMENT_LHS() {
        return ASSIGNMENT_LHS;
    }

    @NotNull
    public final LightTreePositioningStrategy getANNOTATION_USE_SITE() {
        return ANNOTATION_USE_SITE;
    }

    @NotNull
    public final LightTreePositioningStrategy getIMPORT_LAST_NAME() {
        return IMPORT_LAST_NAME;
    }

    @NotNull
    public final LightTreePositioningStrategy getSPREAD_OPERATOR() {
        return SPREAD_OPERATOR;
    }

    @NotNull
    public final LightTreePositioningStrategy getDECLARATION_WITH_BODY() {
        return DECLARATION_WITH_BODY;
    }

    @NotNull
    public final LightTreePositioningStrategy getUNREACHABLE_CODE() {
        return UNREACHABLE_CODE;
    }

    @NotNull
    public final LightTreePositioningStrategy getNOT_SUPPORTED_IN_INLINE_MOST_RELEVANT() {
        return NOT_SUPPORTED_IN_INLINE_MOST_RELEVANT;
    }

    @NotNull
    public final LightTreePositioningStrategy getLABEL() {
        return LABEL;
    }

    @NotNull
    public final LightTreePositioningStrategy getCOMMAS() {
        return COMMAS;
    }

    public static /* synthetic */ void getCOMMAS$annotations() {
    }

    @NotNull
    public final LightTreePositioningStrategy getNON_FINAL_MODIFIER_OR_NAME() {
        return NON_FINAL_MODIFIER_OR_NAME;
    }

    public static final /* synthetic */ boolean access$isDeclaration(LightTreePositioningStrategies $this, LighterASTNode $receiver) {
        return $this.isDeclaration($receiver);
    }

    public static final /* synthetic */ LighterASTNode access$referencedTypeExpression(LightTreePositioningStrategies $this, FlyweightCapableTreeStructure $receiver, LighterASTNode node) {
        return $this.referencedTypeExpression($receiver, node);
    }

    public static final /* synthetic */ LightTreePositioningStrategy access$getSUSPEND_OR_FUN_MODIFIER$p() {
        return SUSPEND_OR_FUN_MODIFIER;
    }

    static {
        Object object = KtTokens.VISIBILITY_MODIFIERS;
        Intrinsics.checkNotNullExpressionValue(object, "VISIBILITY_MODIFIERS");
        VISIBILITY_MODIFIER = new ModifierSetBasedLightTreePositioningStrategy((TokenSet)object);
        object = KtTokens.MODALITY_MODIFIERS;
        Intrinsics.checkNotNullExpressionValue(object, "MODALITY_MODIFIERS");
        MODALITY_MODIFIER = new ModifierSetBasedLightTreePositioningStrategy((TokenSet)object);
        IElementType[] iElementTypeArray = new IElementType[]{KtTokens.ABSTRACT_KEYWORD};
        object = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue(object, "create(KtTokens.ABSTRACT_KEYWORD)");
        ABSTRACT_MODIFIER = new ModifierSetBasedLightTreePositioningStrategy((TokenSet)object);
        iElementTypeArray = new IElementType[]{KtTokens.OPEN_KEYWORD};
        object = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue(object, "create(KtTokens.OPEN_KEYWORD)");
        OPEN_MODIFIER = new ModifierSetBasedLightTreePositioningStrategy((TokenSet)object);
        iElementTypeArray = new IElementType[]{KtTokens.OVERRIDE_KEYWORD};
        object = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue(object, "create(KtTokens.OVERRIDE_KEYWORD)");
        OVERRIDE_MODIFIER = new ModifierSetBasedLightTreePositioningStrategy((TokenSet)object);
        iElementTypeArray = new IElementType[]{KtTokens.PRIVATE_KEYWORD};
        object = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue(object, "create(KtTokens.PRIVATE_KEYWORD)");
        PRIVATE_MODIFIER = new ModifierSetBasedLightTreePositioningStrategy((TokenSet)object);
        iElementTypeArray = new IElementType[]{KtTokens.LATEINIT_KEYWORD};
        object = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue(object, "create(KtTokens.LATEINIT_KEYWORD)");
        LATEINIT_MODIFIER = new ModifierSetBasedLightTreePositioningStrategy((TokenSet)object);
        iElementTypeArray = new IElementType[]{KtTokens.IN_KEYWORD, KtTokens.OUT_KEYWORD};
        object = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue(object, "create(KtTokens.IN_KEYWORD, KtTokens.OUT_KEYWORD)");
        VARIANCE_MODIFIER = new ModifierSetBasedLightTreePositioningStrategy((TokenSet)object);
        iElementTypeArray = new IElementType[]{KtTokens.CONST_KEYWORD};
        object = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue(object, "create(KtTokens.CONST_KEYWORD)");
        CONST_MODIFIER = new ModifierSetBasedLightTreePositioningStrategy((TokenSet)object);
        iElementTypeArray = new IElementType[]{KtTokens.FUN_KEYWORD};
        object = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue(object, "create(KtTokens.FUN_KEYWORD)");
        FUN_MODIFIER = new ModifierSetBasedLightTreePositioningStrategy((TokenSet)object);
        iElementTypeArray = new IElementType[]{KtTokens.SUSPEND_KEYWORD};
        object = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue(object, "create(KtTokens.SUSPEND_KEYWORD)");
        SUSPEND_MODIFIER = new ModifierSetBasedLightTreePositioningStrategy((TokenSet)object);
        iElementTypeArray = new IElementType[]{KtTokens.SUSPEND_KEYWORD, KtTokens.FUN_KEYWORD};
        object = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue(object, "create(KtTokens.SUSPEND_\u2026RD, KtTokens.FUN_KEYWORD)");
        SUSPEND_OR_FUN_MODIFIER = new ModifierSetBasedLightTreePositioningStrategy((TokenSet)object);
        iElementTypeArray = new IElementType[]{KtTokens.INLINE_KEYWORD, KtTokens.VALUE_KEYWORD};
        object = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue(object, "create(KtTokens.INLINE_K\u2026, KtTokens.VALUE_KEYWORD)");
        INLINE_OR_VALUE_MODIFIER = new ModifierSetBasedLightTreePositioningStrategy((TokenSet)object);
        iElementTypeArray = new IElementType[]{KtTokens.INNER_KEYWORD};
        object = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue(object, "create(KtTokens.INNER_KEYWORD)");
        INNER_MODIFIER = new ModifierSetBasedLightTreePositioningStrategy((TokenSet)object);
        iElementTypeArray = new IElementType[]{KtTokens.DATA_KEYWORD};
        object = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue(object, "create(KtTokens.DATA_KEYWORD)");
        DATA_MODIFIER = new ModifierSetBasedLightTreePositioningStrategy((TokenSet)object);
        iElementTypeArray = new IElementType[]{KtTokens.OPERATOR_KEYWORD};
        object = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue(object, "create(KtTokens.OPERATOR_KEYWORD)");
        OPERATOR_MODIFIER = new ModifierSetBasedLightTreePositioningStrategy((TokenSet)object);
        iElementTypeArray = new IElementType[]{KtTokens.ENUM_KEYWORD};
        object = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue(object, "create(KtTokens.ENUM_KEYWORD)");
        ENUM_MODIFIER = new ModifierSetBasedLightTreePositioningStrategy((TokenSet)object);
        iElementTypeArray = new IElementType[]{KtTokens.NOINLINE_KEYWORD, KtTokens.CROSSINLINE_KEYWORD};
        object = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue(object, "create(KtTokens.NOINLINE\u2026kens.CROSSINLINE_KEYWORD)");
        INLINE_PARAMETER_MODIFIER = new ModifierSetBasedLightTreePositioningStrategy((TokenSet)object);
        OPERATOR = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Intrinsics.checkNotNullParameter(node, "node");
                Intrinsics.checkNotNullParameter(tree, "tree");
                LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.access$operationReference(tree, node);
                return LightTreePositioningStrategyKt.markElement(lighterASTNode2 == null ? node : lighterASTNode2, startOffset, endOffset, tree, node);
            }
        };
        PARAMETER_DEFAULT_VALUE = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Intrinsics.checkNotNullParameter(node, "node");
                Intrinsics.checkNotNullParameter(tree, "tree");
                LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.access$defaultValue(tree, node);
                LighterASTNode defaultValueElement = lighterASTNode2 == null ? node : lighterASTNode2;
                return LightTreePositioningStrategyKt.markElement(defaultValueElement, startOffset, endOffset, tree, node);
            }
        };
        PARAMETER_VARARG_MODIFIER = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                LighterASTNode modifier;
                LighterASTNode lighterASTNode2;
                Intrinsics.checkNotNullParameter(node, "node");
                Intrinsics.checkNotNullParameter(tree, "tree");
                LighterASTNode lighterASTNode3 = LightTreePositioningStrategiesKt.access$modifierList(tree, node);
                if (lighterASTNode3 == null) {
                    lighterASTNode2 = null;
                } else {
                    LighterASTNode lighterASTNode4;
                    LighterASTNode modifierList2 = lighterASTNode4 = lighterASTNode3;
                    boolean bl = false;
                    KtModifierKeywordToken ktModifierKeywordToken = KtTokens.VARARG_KEYWORD;
                    Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken, "VARARG_KEYWORD");
                    lighterASTNode2 = LightTreePositioningStrategiesKt.findChildByType(tree, modifierList2, ktModifierKeywordToken);
                }
                lighterASTNode3 = modifier = lighterASTNode2;
                return LightTreePositioningStrategyKt.markElement(lighterASTNode3 == null ? node : lighterASTNode3, startOffset, endOffset, tree, node);
            }
        };
        NAME_OF_NAMED_ARGUMENT = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                List<TextRange> list2;
                Intrinsics.checkNotNullParameter(node, "node");
                Intrinsics.checkNotNullParameter(tree, "tree");
                Object object = KtNodeTypes.VALUE_ARGUMENT_NAME;
                Intrinsics.checkNotNullExpressionValue(object, "VALUE_ARGUMENT_NAME");
                LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.findChildByType(tree, node, (IElementType)object);
                if (lighterASTNode2 == null) {
                    list2 = LightTreePositioningStrategyKt.markElement(node, startOffset, endOffset, tree, node);
                } else {
                    Object valueArgumentName = object = lighterASTNode2;
                    boolean bl = false;
                    list2 = LightTreePositioningStrategyKt.markElement((LighterASTNode)valueArgumentName, startOffset, endOffset, tree, node);
                }
                return list2;
            }
        };
        VALUE_ARGUMENTS = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                List<TextRange> list2;
                LighterASTNode lighterASTNode2;
                LighterASTNode lighterASTNode3;
                Object object;
                Intrinsics.checkNotNullParameter(node, "node");
                Intrinsics.checkNotNullParameter(tree, "tree");
                IElementType iElementType = node.getTokenType();
                if (KtTokens.QUALIFIED_ACCESS.contains(iElementType)) {
                    object = KtNodeTypes.CALL_EXPRESSION;
                    Intrinsics.checkNotNullExpressionValue(object, "CALL_EXPRESSION");
                    lighterASTNode3 = LightTreePositioningStrategiesKt.findLastChildByType(tree, node, (IElementType)object);
                    lighterASTNode2 = lighterASTNode3 == null ? node : lighterASTNode3;
                } else {
                    lighterASTNode2 = node;
                }
                LighterASTNode nodeToStart = lighterASTNode2;
                object = KtNodeTypes.VALUE_ARGUMENT_LIST;
                Intrinsics.checkNotNullExpressionValue(object, "VALUE_ARGUMENT_LIST");
                lighterASTNode3 = LightTreePositioningStrategiesKt.findDescendantByType(tree, nodeToStart, (IElementType)object);
                if (lighterASTNode3 == null) {
                    list2 = null;
                } else {
                    Object valueArgumentList = object = lighterASTNode3;
                    boolean bl = false;
                    Object object2 = KtTokens.RPAR;
                    Intrinsics.checkNotNullExpressionValue(object2, "RPAR");
                    LighterASTNode lighterASTNode4 = LightTreePositioningStrategiesKt.findLastChildByType(tree, (LighterASTNode)valueArgumentList, (IElementType)object2);
                    if (lighterASTNode4 == null) {
                        list2 = null;
                    } else {
                        Object rpar = object2 = lighterASTNode4;
                        boolean bl2 = false;
                        list2 = LightTreePositioningStrategyKt.markElement((LighterASTNode)rpar, startOffset, endOffset, tree, node);
                    }
                }
                iElementType = list2;
                return iElementType == null ? LightTreePositioningStrategyKt.markElement(nodeToStart, startOffset, endOffset, tree, node) : iElementType;
            }
        };
        DOT_BY_QUALIFIED = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Object object;
                Intrinsics.checkNotNullParameter(node, "node");
                Intrinsics.checkNotNullParameter(tree, "tree");
                if (Intrinsics.areEqual(node.getTokenType(), KtNodeTypes.BINARY_EXPRESSION)) {
                    object = KtTokens.ALL_ASSIGNMENTS;
                    Intrinsics.checkNotNullExpressionValue(object, "ALL_ASSIGNMENTS");
                    if (LightTreePositioningStrategiesKt.findDescendantByTypes(tree, node, (TokenSet)object) != null) {
                        Object object2 = KtNodeTypes.DOT_QUALIFIED_EXPRESSION;
                        Intrinsics.checkNotNullExpressionValue(object2, "DOT_QUALIFIED_EXPRESSION");
                        object = LightTreePositioningStrategiesKt.findDescendantByType(tree, node, (IElementType)object2);
                        if (object != null) {
                            Object it = object2 = object;
                            boolean bl = false;
                            LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.access$dotOperator(tree, (LighterASTNode)it);
                            return LightTreePositioningStrategyKt.markElement((LighterASTNode)(lighterASTNode2 == null ? it : lighterASTNode2), startOffset, endOffset, tree, node);
                        }
                    }
                }
                if (Intrinsics.areEqual(node.getTokenType(), KtNodeTypes.DOT_QUALIFIED_EXPRESSION)) {
                    object = LightTreePositioningStrategiesKt.access$dotOperator(tree, node);
                    return LightTreePositioningStrategyKt.markElement((LighterASTNode)(object == null ? node : object), startOffset, endOffset, tree, node);
                }
                return LightTreePositioningStrategies.INSTANCE.getREFERENCE_BY_QUALIFIED().mark(node, startOffset, endOffset, tree);
            }
        };
        SELECTOR_BY_QUALIFIED = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Intrinsics.checkNotNullParameter(node, "node");
                Intrinsics.checkNotNullParameter(tree, "tree");
                if (Intrinsics.areEqual(node.getTokenType(), KtNodeTypes.BINARY_EXPRESSION)) {
                    Object object = KtTokens.ALL_ASSIGNMENTS;
                    Intrinsics.checkNotNullExpressionValue(object, "ALL_ASSIGNMENTS");
                    if (LightTreePositioningStrategiesKt.findDescendantByTypes(tree, node, (TokenSet)object) != null && (object = LightTreePositioningStrategiesKt.access$findExpressionDeep(tree, node)) != null) {
                        Object object2;
                        Object it = object2 = object;
                        boolean bl = false;
                        return LightTreePositioningStrategyKt.markElement((LighterASTNode)it, startOffset, endOffset, tree, node);
                    }
                }
                if (KtTokens.QUALIFIED_ACCESS.contains(node.getTokenType())) {
                    LighterASTNode selector = LightTreePositioningStrategiesKt.selector(tree, node);
                    if (selector != null) {
                        return LightTreePositioningStrategyKt.markElement(selector, startOffset, endOffset, tree, node);
                    }
                    return super.mark(node, startOffset, endOffset, tree);
                }
                if (Intrinsics.areEqual(node.getTokenType(), KtNodeTypes.TYPE_REFERENCE)) {
                    LighterASTNode referencedTypeExpression;
                    TokenSet tokenSet = KtStubElementTypes.TYPE_ELEMENT_TYPES;
                    Intrinsics.checkNotNullExpressionValue(tokenSet, "TYPE_ELEMENT_TYPES");
                    LighterASTNode typeElement = LightTreePositioningStrategiesKt.findChildByType(tree, node, tokenSet);
                    if (typeElement != null && (referencedTypeExpression = LightTreePositioningStrategies.access$referencedTypeExpression(LightTreePositioningStrategies.INSTANCE, tree, typeElement)) != null) {
                        return LightTreePositioningStrategyKt.markElement(referencedTypeExpression, startOffset, endOffset, tree, node);
                    }
                }
                return super.mark(node, startOffset, endOffset, tree);
            }
        };
        FUN_INTERFACE = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Intrinsics.checkNotNullParameter(node, "node");
                Intrinsics.checkNotNullParameter(tree, "tree");
                IElementType iElementType = node.getTokenType();
                return Intrinsics.areEqual(iElementType, KtNodeTypes.CLASS) ? LightTreePositioningStrategies.INSTANCE.getFUN_MODIFIER().mark(node, startOffset, endOffset, tree) : (Intrinsics.areEqual(iElementType, KtNodeTypes.PROPERTY) ? LightTreePositioningStrategies.INSTANCE.getVAL_OR_VAR_NODE().mark(node, startOffset, endOffset, tree) : (Intrinsics.areEqual(iElementType, KtNodeTypes.FUN) ? (LightTreePositioningStrategiesKt.typeParametersList(tree, node) != null ? LightTreePositioningStrategies.INSTANCE.getTYPE_PARAMETERS_LIST().mark(node, startOffset, endOffset, tree) : LightTreePositioningStrategies.access$getSUSPEND_OR_FUN_MODIFIER$p().mark(node, startOffset, endOffset, tree)) : LightTreePositioningStrategies.INSTANCE.getDEFAULT().mark(node, startOffset, endOffset, tree)));
            }
        };
        REFERENCE_BY_QUALIFIED = new FindReferencePositioningStrategy(false);
        REFERENCED_NAME_BY_QUALIFIED = new FindReferencePositioningStrategy(true);
        object = new IElementType[]{KtNodeTypes.IS_EXPRESSION, KtNodeTypes.BINARY_WITH_TYPE, KtNodeTypes.BINARY_EXPRESSION, KtNodeTypes.POSTFIX_EXPRESSION, KtNodeTypes.PREFIX_EXPRESSION, KtNodeTypes.BINARY_EXPRESSION, KtNodeTypes.WHEN_CONDITION_IN_RANGE};
        nodeTypesWithOperation = SetsKt.setOf(object);
        WHEN_EXPRESSION = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Intrinsics.checkNotNullParameter(node, "node");
                Intrinsics.checkNotNullParameter(tree, "tree");
                LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.access$whenKeyword(tree, node);
                return LightTreePositioningStrategyKt.markElement(lighterASTNode2 == null ? node : lighterASTNode2, startOffset, endOffset, tree, node);
            }
        };
        IF_EXPRESSION = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Intrinsics.checkNotNullParameter(node, "node");
                Intrinsics.checkNotNullParameter(tree, "tree");
                LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.access$ifKeyword(tree, node);
                return LightTreePositioningStrategyKt.markElement(lighterASTNode2 == null ? node : lighterASTNode2, startOffset, endOffset, tree, node);
            }
        };
        ELSE_ENTRY = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Intrinsics.checkNotNullParameter(node, "node");
                Intrinsics.checkNotNullParameter(tree, "tree");
                LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.access$elseKeyword(tree, node);
                return LightTreePositioningStrategyKt.markElement(lighterASTNode2 == null ? node : lighterASTNode2, startOffset, endOffset, tree, node);
            }
        };
        ARRAY_ACCESS = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Intrinsics.checkNotNullParameter(node, "node");
                Intrinsics.checkNotNullParameter(tree, "tree");
                IElementType iElementType = KtNodeTypes.INDICES;
                Intrinsics.checkNotNullExpressionValue(iElementType, "INDICES");
                LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.findChildByType(tree, node, iElementType);
                Intrinsics.checkNotNull(lighterASTNode2);
                return LightTreePositioningStrategyKt.markElement(lighterASTNode2, startOffset, endOffset, tree, node);
            }
        };
        SAFE_ACCESS = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Intrinsics.checkNotNullParameter(node, "node");
                Intrinsics.checkNotNullParameter(tree, "tree");
                LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.access$safeAccess(tree, node);
                return LightTreePositioningStrategyKt.markElement(lighterASTNode2 == null ? node : lighterASTNode2, startOffset, endOffset, tree, node);
            }
        };
        OPERATION_TO_END = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Intrinsics.checkNotNullParameter(node, "node");
                Intrinsics.checkNotNullParameter(tree, "tree");
                LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.access$operationReference(tree, node);
                LighterASTNode lighterASTNode3 = lighterASTNode2 == null ? node : lighterASTNode2;
                lighterASTNode2 = LightTreePositioningStrategiesKt.access$lastChild(tree, node);
                return LightTreePositioningStrategyKt.markRange(lighterASTNode3, lighterASTNode2 == null ? node : lighterASTNode2, startOffset, endOffset, tree, node);
            }
        };
        AS_TYPE = OPERATION_TO_END;
        USELESS_ELVIS = OPERATION_TO_END;
        RETURN_WITH_LABEL = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Intrinsics.checkNotNullParameter(node, "node");
                Intrinsics.checkNotNullParameter(tree, "tree");
                Object object = KtNodeTypes.LABEL_QUALIFIER;
                Intrinsics.checkNotNullExpressionValue(object, "LABEL_QUALIFIER");
                LighterASTNode labeledExpression = LightTreePositioningStrategiesKt.findChildByType(tree, node, (IElementType)object);
                if (labeledExpression != null) {
                    return LightTreePositioningStrategyKt.markRange(node, labeledExpression, startOffset, endOffset, tree, node);
                }
                object = LightTreePositioningStrategiesKt.access$returnKeyword(tree, node);
                return LightTreePositioningStrategyKt.markElement((LighterASTNode)(object == null ? node : object), startOffset, endOffset, tree, node);
            }
        };
        WHOLE_ELEMENT = new LightTreePositioningStrategy(){};
        LONG_LITERAL_SUFFIX = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Intrinsics.checkNotNullParameter(node, "node");
                Intrinsics.checkNotNullParameter(tree, "tree");
                if (Intrinsics.areEqual(node.getTokenType(), KtNodeTypes.INTEGER_CONSTANT)) {
                    TextRange textRange = TextRange.create(endOffset - 1, endOffset);
                    Intrinsics.checkNotNullExpressionValue(textRange, "create(endOffset - 1, endOffset)");
                    return CollectionsKt.listOf(textRange);
                }
                return super.mark(node, startOffset, endOffset, tree);
            }
        };
        iElementTypeArray = new IElementType[]{KtTokens.REIFIED_KEYWORD};
        object = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue(object, "create(KtTokens.REIFIED_KEYWORD)");
        REIFIED_MODIFIER = new ModifierSetBasedLightTreePositioningStrategy((TokenSet)object);
        TYPE_PARAMETERS_LIST = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Intrinsics.checkNotNullParameter(node, "node");
                Intrinsics.checkNotNullParameter(tree, "tree");
                LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.typeParametersList(tree, node);
                return LightTreePositioningStrategyKt.markElement(lighterASTNode2 == null ? node : lighterASTNode2, startOffset, endOffset, tree, node);
            }
        };
        NAME_IDENTIFIER = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Intrinsics.checkNotNullParameter(node, "node");
                Intrinsics.checkNotNullParameter(tree, "tree");
                LighterASTNode nameIdentifier = LightTreePositioningStrategiesKt.nameIdentifier(tree, node);
                if (nameIdentifier != null) {
                    return LightTreePositioningStrategyKt.markElement(nameIdentifier, startOffset, endOffset, tree, node);
                }
                if (Intrinsics.areEqual(node.getTokenType(), KtNodeTypes.LABEL_QUALIFIER)) {
                    return super.mark(node, startOffset, endOffset - 1, tree);
                }
                return LightTreePositioningStrategies.INSTANCE.getDEFAULT().mark(node, startOffset, endOffset, tree);
            }
        };
        QUESTION_MARK_BY_TYPE = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Intrinsics.checkNotNullParameter(node, "node");
                Intrinsics.checkNotNullParameter(tree, "tree");
                if (Intrinsics.areEqual(node.getTokenType(), KtNodeTypes.TYPE_REFERENCE)) {
                    IElementType iElementType = KtNodeTypes.NULLABLE_TYPE;
                    Intrinsics.checkNotNullExpressionValue(iElementType, "NULLABLE_TYPE");
                    LighterASTNode typeElement = LightTreePositioningStrategiesKt.findChildByType(tree, node, iElementType);
                    if (typeElement != null) {
                        KtSingleValueToken ktSingleValueToken = KtTokens.QUEST;
                        Intrinsics.checkNotNullExpressionValue(ktSingleValueToken, "QUEST");
                        LighterASTNode question = LightTreePositioningStrategiesKt.findChildByType(tree, typeElement, ktSingleValueToken);
                        if (question != null) {
                            return LightTreePositioningStrategyKt.markElement(question, startOffset, endOffset, tree, node);
                        }
                    }
                }
                return super.mark(node, startOffset, endOffset, tree);
            }
        };
        ASSIGNMENT_LHS = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                block7: {
                    LighterASTNode lhs;
                    LighterASTNode lighterASTNode2;
                    block6: {
                        TokenSet tokenSet;
                        block5: {
                            Intrinsics.checkNotNullParameter(node, "node");
                            Intrinsics.checkNotNullParameter(tree, "tree");
                            if (!Intrinsics.areEqual(node.getTokenType(), KtNodeTypes.BINARY_EXPRESSION)) break block5;
                            tokenSet = KtTokens.ALL_ASSIGNMENTS;
                            Intrinsics.checkNotNullExpressionValue(tokenSet, "ALL_ASSIGNMENTS");
                            if (LightTreePositioningStrategiesKt.findDescendantByTypes(tree, node, tokenSet) != null) break block6;
                        }
                        if (!Intrinsics.areEqual(node.getTokenType(), KtNodeTypes.PREFIX_EXPRESSION) && !Intrinsics.areEqual(node.getTokenType(), KtNodeTypes.POSTFIX_EXPRESSION)) break block7;
                        tokenSet = KtTokens.INCREMENT_AND_DECREMENT;
                        Intrinsics.checkNotNullExpressionValue(tokenSet, "INCREMENT_AND_DECREMENT");
                        if (LightTreePositioningStrategiesKt.findDescendantByTypes(tree, node, tokenSet) == null) break block7;
                    }
                    if ((lighterASTNode2 = (lhs = Intrinsics.areEqual(node.getTokenType(), KtNodeTypes.PREFIX_EXPRESSION) ? LightTreePositioningStrategiesKt.lastChildExpression(tree, node) : LightTreePositioningStrategiesKt.firstChildExpression(tree, node))) != null) {
                        LighterASTNode lighterASTNode3;
                        LighterASTNode it = lighterASTNode3 = lighterASTNode2;
                        boolean bl = false;
                        LighterASTNode lighterASTNode4 = LightTreePositioningStrategiesKt.access$unwrapParenthesesLabelsAndAnnotations(tree, it);
                        if (lighterASTNode4 != null) {
                            LighterASTNode lighterASTNode5;
                            LighterASTNode unwrapped = lighterASTNode5 = lighterASTNode4;
                            boolean bl2 = false;
                            return LightTreePositioningStrategyKt.markElement(unwrapped, startOffset, endOffset, tree, node);
                        }
                        Void cfr_ignored_0 = (Void)null;
                    }
                }
                return super.mark(node, startOffset, endOffset, tree);
            }
        };
        ANNOTATION_USE_SITE = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Intrinsics.checkNotNullParameter(node, "node");
                Intrinsics.checkNotNullParameter(tree, "tree");
                IElementType iElementType = KtNodeTypes.ANNOTATION_TARGET;
                Intrinsics.checkNotNullExpressionValue(iElementType, "ANNOTATION_TARGET");
                LighterASTNode useSiteTarget = LightTreePositioningStrategiesKt.findChildByType(tree, node, iElementType);
                if (useSiteTarget != null) {
                    return LightTreePositioningStrategyKt.markElement(useSiteTarget, startOffset, endOffset, tree, node);
                }
                return super.mark(node, startOffset, endOffset, tree);
            }
        };
        IMPORT_LAST_NAME = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Intrinsics.checkNotNullParameter(node, "node");
                Intrinsics.checkNotNullParameter(tree, "tree");
                IElementType iElementType = KtNodeTypes.REFERENCE_EXPRESSION;
                Intrinsics.checkNotNullExpressionValue(iElementType, "REFERENCE_EXPRESSION");
                LighterASTNode lighterASTNode2 = (LighterASTNode)CollectionsKt.lastOrNull(LightTreePositioningStrategiesKt.collectDescendantsOfType$default(tree, node, iElementType, null, 4, null));
                LighterASTNode nodeToMark = lighterASTNode2 == null ? node : lighterASTNode2;
                return LightTreePositioningStrategyKt.markElement(nodeToMark, startOffset, endOffset, tree, node);
            }
        };
        SPREAD_OPERATOR = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Intrinsics.checkNotNullParameter(node, "node");
                Intrinsics.checkNotNullParameter(tree, "tree");
                return super.mark(node, startOffset, startOffset + 1, tree);
            }
        };
        DECLARATION_WITH_BODY = new LightTreePositioningStrategy(){

            /*
             * WARNING - void declaration
             */
            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                List list2;
                LighterASTNode lighterASTNode2;
                Intrinsics.checkNotNullParameter(node, "node");
                Intrinsics.checkNotNullParameter(tree, "tree");
                if (!Intrinsics.areEqual(node.getTokenType(), KtNodeTypes.BLOCK)) {
                    IElementType iElementType = KtNodeTypes.BLOCK;
                    Intrinsics.checkNotNullExpressionValue(iElementType, "BLOCK");
                    lighterASTNode2 = LightTreePositioningStrategiesKt.findChildByType(tree, node, iElementType);
                } else {
                    lighterASTNode2 = node;
                }
                LighterASTNode blockNode = lighterASTNode2;
                Object object = blockNode;
                Object object2 = object == null ? node : object;
                object = KtTokens.RBRACE;
                Intrinsics.checkNotNullExpressionValue(object, "RBRACE");
                LighterASTNode bracket = LightTreePositioningStrategiesKt.findLastChildByType(tree, (LighterASTNode)object2, (IElementType)object);
                if (bracket != null) {
                    list2 = LightTreePositioningStrategyKt.markElement(bracket, startOffset, endOffset, tree, node);
                } else if (blockNode != null) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = LightTreePositioningStrategyKt.markElement(blockNode, startOffset, endOffset, tree, node);
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void p0;
                        TextRange textRange = (TextRange)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        TextRange textRange2 = this.lastSymbol((TextRange)p0);
                        collection.add(textRange2);
                    }
                    list2 = (List)destination$iv$iv;
                } else {
                    list2 = super.mark(node, startOffset, endOffset, tree);
                }
                return list2;
            }

            private final TextRange lastSymbol(TextRange range) {
                TextRange textRange;
                if (range.isEmpty()) {
                    textRange = range;
                } else {
                    TextRange textRange2 = TextRange.create(range.getEndOffset() - 1, range.getEndOffset());
                    Intrinsics.checkNotNullExpressionValue(textRange2, "create(range.endOffset - 1, range.endOffset)");
                    textRange = textRange2;
                }
                return textRange;
            }
        };
        UNREACHABLE_CODE = new LightTreePositioningStrategy(){

            /*
             * WARNING - void declaration
             */
            @NotNull
            public List<TextRange> markFirDiagnostic(@NotNull FirSourceElement element, @NotNull FirDiagnostic diagnostic) {
                void $this$flatMapTo$iv$iv;
                void $this$mapTo$iv$iv;
                LighterASTNode lighterASTNode2;
                Collection collection;
                void $this$mapTo$iv$iv2;
                UnreachableCodeLightTreeHelper unreachableCodeLightTreeHelper;
                Intrinsics.checkNotNullParameter(element, "element");
                Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
                FirDiagnosticWithParameters2 typed = (FirDiagnosticWithParameters2)diagnostic;
                UnreachableCodeLightTreeHelper $this$markFirDiagnostic_u24lambda_u2d3 = unreachableCodeLightTreeHelper = new UnreachableCodeLightTreeHelper(element.getTreeStructure());
                boolean bl = false;
                Iterable $this$map$iv = (Iterable)typed.getA();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Iterable<E> destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    FirSourceElement firSourceElement = (FirSourceElement)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    lighterASTNode2 = it.getLighterASTNode();
                    collection.add(lighterASTNode2);
                }
                Set<T> reachable = CollectionsKt.toSet((List)destination$iv$iv);
                Iterable $this$map$iv2 = (Iterable)typed.getB();
                boolean $i$f$map2 = false;
                destination$iv$iv = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                boolean $i$f$mapTo22 = false;
                for (E item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    FirSourceElement bl2 = (FirSourceElement)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl3 = false;
                    lighterASTNode2 = it.getLighterASTNode();
                    collection.add(lighterASTNode2);
                }
                Set<T> unreachable = CollectionsKt.toSet((List)destination$iv$iv2);
                if (!$this$markFirDiagnostic_u24lambda_u2d3.hasChildrenInSet(element.getLighterASTNode(), reachable)) {
                    return super.markFirDiagnostic(element, diagnostic);
                }
                List<LighterASTNode> nodesToMark = $this$markFirDiagnostic_u24lambda_u2d3.removeReachableElementsWithMeaninglessSiblings($this$markFirDiagnostic_u24lambda_u2d3.getLeavesOrReachableChildren(element.getLighterASTNode(), reachable, unreachable), reachable);
                if (nodesToMark.isEmpty()) {
                    return super.markFirDiagnostic(element, diagnostic);
                }
                Iterable $this$flatMap$iv = nodesToMark;
                boolean $i$f$flatMap = false;
                Iterable $i$f$mapTo22 = $this$flatMap$iv;
                Collection destination$iv$iv3 = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    LighterASTNode it = (LighterASTNode)element$iv$iv;
                    boolean bl4 = false;
                    Iterable list$iv$iv = LightTreePositioningStrategyKt.markElement(it, element.getStartOffset(), element.getEndOffset(), element.getTreeStructure(), element.getLighterASTNode());
                    CollectionsKt.addAll(destination$iv$iv3, list$iv$iv);
                }
                List ranges2 = (List)destination$iv$iv3;
                return $this$markFirDiagnostic_u24lambda_u2d3.mergeAdjacentTextRanges(ranges2);
            }
        };
        NOT_SUPPORTED_IN_INLINE_MOST_RELEVANT = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Object object;
                Object object2;
                Intrinsics.checkNotNullParameter(node, "node");
                Intrinsics.checkNotNullParameter(tree, "tree");
                Object object3 = node.getTokenType();
                if (Intrinsics.areEqual(object3, KtNodeTypes.CLASS)) {
                    object2 = KtTokens.CLASS_KEYWORD;
                    Intrinsics.checkNotNullExpressionValue(object2, "CLASS_KEYWORD");
                    object = LightTreePositioningStrategiesKt.findChildByType(tree, node, (IElementType)object2);
                } else if (Intrinsics.areEqual(object3, KtNodeTypes.OBJECT_DECLARATION)) {
                    object2 = KtTokens.OBJECT_KEYWORD;
                    Intrinsics.checkNotNullExpressionValue(object2, "OBJECT_KEYWORD");
                    object = LightTreePositioningStrategiesKt.findChildByType(tree, node, (IElementType)object2);
                } else if (Intrinsics.areEqual(object3, KtNodeTypes.FUN)) {
                    object2 = LightTreePositioningStrategiesKt.inlineModifier(tree, node);
                    if (object2 == null) {
                        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.FUN_KEYWORD;
                        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken, "FUN_KEYWORD");
                        object = LightTreePositioningStrategiesKt.findChildByType(tree, node, ktModifierKeywordToken);
                    } else {
                        object = object2;
                    }
                } else {
                    object = node;
                }
                LighterASTNode nodeToMark = object;
                object3 = nodeToMark;
                return LightTreePositioningStrategyKt.markElement((LighterASTNode)(object3 == null ? node : object3), startOffset, endOffset, tree, node);
            }
        };
        LABEL = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                Intrinsics.checkNotNullParameter(node, "node");
                Intrinsics.checkNotNullParameter(tree, "tree");
                IElementType iElementType = KtNodeTypes.LABEL_QUALIFIER;
                Intrinsics.checkNotNullExpressionValue(iElementType, "LABEL_QUALIFIER");
                LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.findChildByType(tree, node, iElementType);
                LighterASTNode nodeToMark = lighterASTNode2 == null ? node : lighterASTNode2;
                return LightTreePositioningStrategyKt.markElement(nodeToMark, startOffset, endOffset, tree, node);
            }
        };
        COMMAS = new LightTreePositioningStrategy(){

            @NotNull
            public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
                List<TextRange> list2;
                Intrinsics.checkNotNullParameter(node, "node");
                Intrinsics.checkNotNullParameter(tree, "tree");
                List<TextRange> $this$mark_u24lambda_u2d0 = list2 = CollectionsKt.createListBuilder();
                boolean bl = false;
                Ref<T[]> childrenRef = new Ref<T[]>();
                tree.getChildren(node, childrenRef);
                T[] TArray = childrenRef.get();
                Intrinsics.checkNotNullExpressionValue(TArray, "childrenRef.get()");
                for (LighterASTNode child : (LighterASTNode[])TArray) {
                    if (child == null || !Intrinsics.areEqual(child.getTokenType(), KtTokens.COMMA)) continue;
                    $this$mark_u24lambda_u2d0.add(LightTreePositioningStrategyKt.markSingleElement(child, child, startOffset, endOffset, tree, node));
                }
                return CollectionsKt.build(list2);
            }
        };
        iElementTypeArray = new IElementType[]{KtTokens.ABSTRACT_KEYWORD, KtTokens.OPEN_KEYWORD, KtTokens.SEALED_KEYWORD};
        object = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue(object, "create(\n            KtTo\u2026.SEALED_KEYWORD\n        )");
        NON_FINAL_MODIFIER_OR_NAME = new ModifierSetBasedLightTreePositioningStrategy((TokenSet)object);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J4\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/diagnostics/LightTreePositioningStrategies$ModifierSetBasedLightTreePositioningStrategy;", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/LightTreePositioningStrategy;", "modifierSet", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/TokenSet;", "(Lcom/intellij/psi/tree/TokenSet;)V", "mark", "", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/TextRange;", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/LighterASTNode;", "startOffset", "", "endOffset", "tree", "Lorg/jetbrains/kotlin/com/intellij/util/diff/FlyweightCapableTreeStructure;", "checkers"})
    private static final class ModifierSetBasedLightTreePositioningStrategy
    extends LightTreePositioningStrategy {
        @NotNull
        private final TokenSet modifierSet;

        public ModifierSetBasedLightTreePositioningStrategy(@NotNull TokenSet modifierSet) {
            Intrinsics.checkNotNullParameter(modifierSet, "modifierSet");
            this.modifierSet = modifierSet;
        }

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            List<TextRange> list2;
            Object object;
            Intrinsics.checkNotNullParameter(node, "node");
            Intrinsics.checkNotNullParameter(tree, "tree");
            LighterASTNode modifierList2 = LightTreePositioningStrategiesKt.access$modifierList(tree, node);
            if (modifierList2 != null && (object = LightTreePositioningStrategiesKt.findChildByType(tree, modifierList2, this.modifierSet)) != null) {
                LighterASTNode lighterASTNode2;
                LighterASTNode it = lighterASTNode2 = object;
                boolean bl = false;
                return LightTreePositioningStrategyKt.markElement(it, startOffset, endOffset, tree, node);
            }
            object = LightTreePositioningStrategiesKt.nameIdentifier(tree, node);
            if (object != null) {
                LighterASTNode lighterASTNode3;
                LighterASTNode it = lighterASTNode3 = object;
                boolean bl = false;
                return LightTreePositioningStrategyKt.markElement(it, startOffset, endOffset, tree, node);
            }
            object = node.getTokenType();
            if (Intrinsics.areEqual(object, KtNodeTypes.OBJECT_DECLARATION)) {
                LighterASTNode lighterASTNode4 = LightTreePositioningStrategiesKt.access$objectKeyword(tree, node);
                Intrinsics.checkNotNull(lighterASTNode4);
                list2 = LightTreePositioningStrategyKt.markElement(lighterASTNode4, startOffset, endOffset, tree, node);
            } else {
                list2 = Intrinsics.areEqual(object, KtNodeTypes.PROPERTY_ACCESSOR) ? LightTreePositioningStrategyKt.markElement(LightTreePositioningStrategiesKt.access$accessorNamePlaceholder(tree, node), startOffset, endOffset, tree, node) : LightTreePositioningStrategyKt.markElement$default(node, startOffset, endOffset, tree, null, 16, null);
            }
            return list2;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J4\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/diagnostics/LightTreePositioningStrategies$FindReferencePositioningStrategy;", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/LightTreePositioningStrategy;", "locateReferencedName", "", "(Z)V", "getLocateReferencedName", "()Z", "mark", "", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/TextRange;", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/LighterASTNode;", "startOffset", "", "endOffset", "tree", "Lorg/jetbrains/kotlin/com/intellij/util/diff/FlyweightCapableTreeStructure;", "checkers"})
    public static final class FindReferencePositioningStrategy
    extends LightTreePositioningStrategy {
        private final boolean locateReferencedName;

        public FindReferencePositioningStrategy(boolean locateReferencedName) {
            this.locateReferencedName = locateReferencedName;
        }

        public final boolean getLocateReferencedName() {
            return this.locateReferencedName;
        }

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
            Intrinsics.checkNotNullParameter(node, "node");
            Intrinsics.checkNotNullParameter(tree, "tree");
            if (Intrinsics.areEqual(node.getTokenType(), KtNodeTypes.CALL_EXPRESSION) || Intrinsics.areEqual(node.getTokenType(), KtNodeTypes.CONSTRUCTOR_DELEGATION_CALL)) {
                LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.access$referenceExpression(tree, node, this.locateReferencedName);
                return LightTreePositioningStrategyKt.markElement(lighterASTNode2 == null ? node : lighterASTNode2, startOffset, endOffset, tree, node);
            }
            if (Intrinsics.areEqual(node.getTokenType(), KtNodeTypes.PROPERTY_DELEGATE)) {
                LighterASTNode lighterASTNode3 = LightTreePositioningStrategiesKt.access$findExpressionDeep(tree, node);
                return LightTreePositioningStrategyKt.markElement(lighterASTNode3 == null ? node : lighterASTNode3, startOffset, endOffset, tree, node);
            }
            if (Intrinsics.areEqual(node.getTokenType(), KtNodeTypes.ANNOTATION_ENTRY)) {
                IElementType iElementType = KtNodeTypes.CONSTRUCTOR_CALLEE;
                Intrinsics.checkNotNullExpressionValue(iElementType, "CONSTRUCTOR_CALLEE");
                LighterASTNode lighterASTNode4 = LightTreePositioningStrategiesKt.findDescendantByType(tree, node, iElementType);
                return LightTreePositioningStrategyKt.markElement(lighterASTNode4 == null ? node : lighterASTNode4, startOffset, endOffset, tree, node);
            }
            if (nodeTypesWithOperation.contains(node.getTokenType())) {
                LighterASTNode lighterASTNode5 = LightTreePositioningStrategiesKt.access$operationReference(tree, node);
                return LightTreePositioningStrategyKt.markElement(lighterASTNode5 == null ? node : lighterASTNode5, startOffset, endOffset, tree, node);
            }
            if (Intrinsics.areEqual(node.getTokenType(), KtNodeTypes.TYPE_REFERENCE)) {
                Object object;
                Object object2 = KtNodeTypes.NULLABLE_TYPE;
                Intrinsics.checkNotNullExpressionValue(object2, "NULLABLE_TYPE");
                LighterASTNode lighterASTNode6 = LightTreePositioningStrategiesKt.findChildByType(tree, node, (IElementType)object2);
                if (lighterASTNode6 == null) {
                    object = node;
                } else {
                    LighterASTNode lighterASTNode7;
                    LighterASTNode it = lighterASTNode7 = lighterASTNode6;
                    boolean bl = false;
                    IElementType iElementType = KtNodeTypes.USER_TYPE;
                    Intrinsics.checkNotNullExpressionValue(iElementType, "USER_TYPE");
                    object2 = LightTreePositioningStrategiesKt.findChildByType(tree, it, iElementType);
                    object = object2 == null ? node : object2;
                }
                LighterASTNode nodeToMark = object;
                return LightTreePositioningStrategyKt.markElement(nodeToMark, startOffset, endOffset, tree, node);
            }
            if (Intrinsics.areEqual(node.getTokenType(), KtNodeTypes.IMPORT_DIRECTIVE)) {
                TokenSet tokenSet = KtStubElementTypes.INSIDE_DIRECTIVE_EXPRESSIONS;
                Intrinsics.checkNotNullExpressionValue(tokenSet, "INSIDE_DIRECTIVE_EXPRESSIONS");
                LighterASTNode lighterASTNode8 = LightTreePositioningStrategiesKt.findChildByType(tree, node, tokenSet);
                LighterASTNode nodeToMark = lighterASTNode8 == null ? node : lighterASTNode8;
                return LightTreePositioningStrategyKt.markElement(nodeToMark, startOffset, endOffset, tree, node);
            }
            if (!(Intrinsics.areEqual(node.getTokenType(), KtNodeTypes.DOT_QUALIFIED_EXPRESSION) || Intrinsics.areEqual(node.getTokenType(), KtNodeTypes.SAFE_ACCESS_EXPRESSION) || Intrinsics.areEqual(node.getTokenType(), KtNodeTypes.CALLABLE_REFERENCE_EXPRESSION))) {
                return super.mark(node, startOffset, endOffset, tree);
            }
            LighterASTNode selector = LightTreePositioningStrategiesKt.selector(tree, node);
            if (selector != null) {
                IElementType iElementType = selector.getTokenType();
                if (Intrinsics.areEqual(iElementType, KtNodeTypes.REFERENCE_EXPRESSION)) {
                    return LightTreePositioningStrategyKt.markElement(selector, startOffset, endOffset, tree, node);
                }
                if ((Intrinsics.areEqual(iElementType, KtNodeTypes.CALL_EXPRESSION) ? true : Intrinsics.areEqual(iElementType, KtNodeTypes.CONSTRUCTOR_DELEGATION_CALL)) ? true : Intrinsics.areEqual(iElementType, KtNodeTypes.SUPER_TYPE_CALL_ENTRY)) {
                    LighterASTNode lighterASTNode9 = LightTreePositioningStrategiesKt.access$referenceExpression(tree, selector, this.locateReferencedName);
                    return LightTreePositioningStrategyKt.markElement(lighterASTNode9 == null ? selector : lighterASTNode9, startOffset, endOffset, tree, node);
                }
            }
            return super.mark(node, startOffset, endOffset, tree);
        }
    }
}

