/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirRealSourceElementKind;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationCheckerUtilsKt;
import org.jetbrains.kotlin.fir.analysis.collectors.AbstractDiagnosticCollector;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.CallableReferenceResolutionKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0014H\u0002J\f\u0010\u0015\u001a\u00020\u0013*\u00020\u0016H\u0002J\f\u0010\u0017\u001a\u00020\u0013*\u00020\u0018H\u0002J\u0016\u0010\u0019\u001a\u00020\u0013*\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J,\u0010\u001d\u001a\u00020\u0013*\u00020\u00162\u0016\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u00160\u001fj\b\u0012\u0004\u0012\u00020\u0016` 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0014\u0010\u001d\u001a\u00020\u0013*\u00020\u00162\u0006\u0010!\u001a\u00020\"H\u0002J\u0016\u0010#\u001a\u00020\u0013*\u00020\u001c2\b\u0010$\u001a\u0004\u0018\u00010\u001aH\u0002J\u0014\u0010%\u001a\u00020\u0013*\u00020\u00022\u0006\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineClassDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "()V", "cloneableFqName", "Lorg/jetbrains/kotlin/name/FqName;", "javaLangFqName", "reservedFunctionNames", "", "", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "isCloneableId", "", "Lorg/jetbrains/kotlin/name/ClassId;", "isGenericArrayOfTypeParameter", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "isInapplicableParameterType", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "isNotFinalReadOnly", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "primaryConstructorProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "isRecursiveInlineClassType", "visited", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isRelatedToParameter", "parameter", "isSubtypeOfCloneable", "checkers"})
public final class FirInlineClassDeclarationChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirInlineClassDeclarationChecker INSTANCE = new FirInlineClassDeclarationChecker();
    @NotNull
    private static final Set<String> reservedFunctionNames;
    @NotNull
    private static final FqName javaLangFqName;
    @NotNull
    private static final FqName cloneableFqName;

    private FirInlineClassDeclarationChecker() {
    }

    @Override
    public void check(@NotNull FirRegularClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        CheckerContext context3;
        List<String> list2;
        FirAnnotationContainer firAnnotationContainer;
        FirSourceElement firSourceElement;
        FirElement firElement;
        Object $this$isInterface$iv;
        block62: {
            block61: {
                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                Intrinsics.checkNotNullParameter(context2, "context");
                Intrinsics.checkNotNullParameter(reporter2, "reporter");
                if (!FirDeclarationCheckerUtilsKt.isInlineOrValueClass(declaration2)) {
                    return;
                }
                FirMemberDeclaration $this$isInner$iv = declaration2;
                boolean $i$f$isInner = false;
                if ($this$isInner$iv.getStatus().isInner()) break block61;
                FirClassLikeDeclaration $this$isLocal$iv = declaration2;
                boolean $i$f$isLocal = false;
                if (!$this$isLocal$iv.getSymbol().getClassId().isLocal()) break block62;
            }
            DiagnosticReporterKt.reportOn$default(reporter2, declaration2.getSource(), FirErrors.INSTANCE.getINLINE_CLASS_NOT_TOP_LEVEL(), context2, null, 8, null);
        }
        FirMemberDeclaration $this$modality$iv = declaration2;
        boolean $i$f$getModality = false;
        if ($this$modality$iv.getStatus().getModality() != Modality.FINAL) {
            DiagnosticReporterKt.reportOn$default(reporter2, declaration2.getSource(), FirErrors.INSTANCE.getINLINE_CLASS_NOT_FINAL(), context2, null, 8, null);
        }
        for (FirTypeRef supertypeEntry : declaration2.getSuperTypeRefs()) {
            boolean bl;
            FirRegularClassSymbol firRegularClassSymbol = FirHelpersKt.toRegularClassSymbol(supertypeEntry, context2.getSession());
            if (firRegularClassSymbol == null) {
                bl = false;
            } else {
                $this$isInterface$iv = firRegularClassSymbol;
                boolean $i$f$isInterface = false;
                ClassKind $this$isInterface$iv$iv = ((FirClassSymbol)$this$isInterface$iv).getClassKind();
                boolean $i$f$isInterface2 = false;
                bl = $this$isInterface$iv$iv == ClassKind.INTERFACE;
            }
            if (bl) continue;
            DiagnosticReporterKt.reportOnWithSuppression$default(reporter2, supertypeEntry, FirErrors.INSTANCE.getINLINE_CLASS_CANNOT_EXTEND_CLASSES(), context2, null, 8, null);
        }
        if (this.isSubtypeOfCloneable(declaration2, context2.getSession())) {
            DiagnosticReporterKt.reportOn$default(reporter2, declaration2.getSource(), FirErrors.INSTANCE.getVALUE_CLASS_CANNOT_BE_CLONEABLE(), context2, null, 8, null);
        }
        FirConstructor primaryConstructor2 = null;
        FirValueParameter primaryConstructorParameter = null;
        FirDeclaration primaryConstructorProperty = null;
        for (FirDeclaration innerDeclaration : declaration2.getDeclarations()) {
            FirSourceElement $i$f$withSuppressedDiagnostics4;
            List<String> arguments$iv;
            FirAnnotationContainer firAnnotationContainer2;
            FirAnnotationContainer firAnnotationContainer3;
            firElement = innerDeclaration;
            if (firElement instanceof FirConstructor) {
                FirBlock body2;
                boolean bl;
                List<String> list3;
                if (((FirConstructor)innerDeclaration).isPrimary()) {
                    primaryConstructor2 = (FirConstructor)innerDeclaration;
                    primaryConstructorParameter = CollectionsKt.singleOrNull(((FirConstructor)innerDeclaration).getValueParameters());
                    continue;
                }
                if (((FirConstructor)innerDeclaration).getBody() == null) continue;
                Intrinsics.checkNotNull(((FirConstructor)innerDeclaration).getBody());
                boolean $i$f$withSuppressedDiagnostics2 = false;
                FirAnnotationContainer firAnnotationContainer4 = firAnnotationContainer3 = (FirElement)innerDeclaration instanceof FirAnnotationContainer ? (FirAnnotationContainer)((Object)innerDeclaration) : null;
                if (firAnnotationContainer3 == null) {
                    list3 = null;
                } else {
                    FirAnnotationContainer it$iv = firAnnotationContainer2 = firAnnotationContainer3;
                    boolean bl2 = false;
                    list3 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(it$iv);
                }
                arguments$iv = list3;
                if (arguments$iv != null) {
                    CheckerContext context4 = context2.addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
                    bl = false;
                    DiagnosticReporterKt.reportOnWithSuppression$default(reporter2, body2, FirErrors.INSTANCE.getSECONDARY_CONSTRUCTOR_WITH_BODY_INSIDE_INLINE_CLASS(), context4, null, 8, null);
                    continue;
                }
                CheckerContext context5 = context2;
                bl = false;
                DiagnosticReporterKt.reportOnWithSuppression$default(reporter2, body2, FirErrors.INSTANCE.getSECONDARY_CONSTRUCTOR_WITH_BODY_INSIDE_INLINE_CLASS(), context5, null, 8, null);
                continue;
            }
            if (firElement instanceof FirRegularClass) {
                FirMemberDeclaration $this$isInner$iv = (FirMemberDeclaration)((Object)innerDeclaration);
                boolean $i$f$isInner = false;
                if (!$this$isInner$iv.getStatus().isInner()) continue;
                DiagnosticReporterKt.reportOnWithSuppression$default(reporter2, innerDeclaration, FirErrors.INSTANCE.getINNER_CLASS_INSIDE_INLINE_CLASS(), context2, null, 8, null);
                continue;
            }
            if (firElement instanceof FirSimpleFunction) {
                String $i$f$isInner = ((FirSimpleFunction)innerDeclaration).getName().asString();
                Intrinsics.checkNotNullExpressionValue($i$f$isInner, "innerDeclaration.name.asString()");
                String functionName = $i$f$isInner;
                if (!reservedFunctionNames.contains(functionName)) continue;
                DiagnosticReporterKt.reportOnWithSuppression$default(reporter2, innerDeclaration, FirErrors.INSTANCE.getRESERVED_MEMBER_INSIDE_INLINE_CLASS(), functionName, context2, null, 16, null);
                continue;
            }
            if (firElement instanceof FirField) {
                boolean bl;
                List<String> list4;
                FirDeclaration $this$isSynthetic$iv = innerDeclaration;
                boolean $i$f$isSynthetic22 = false;
                if (!Intrinsics.areEqual($this$isSynthetic$iv.getOrigin(), FirDeclarationOrigin.Synthetic.INSTANCE)) continue;
                FirTypeRef $i$f$isSynthetic22 = ((FirResolvedTypeRef)((FirField)innerDeclaration).getReturnTypeRef()).getDelegatedTypeRef();
                FirSourceElement delegatedTypeRefSource = $i$f$isSynthetic22 == null ? null : $i$f$isSynthetic22.getSource();
                boolean $i$f$withSuppressedDiagnostics3 = false;
                FirAnnotationContainer firAnnotationContainer5 = firAnnotationContainer3 = (FirElement)innerDeclaration instanceof FirAnnotationContainer ? (FirAnnotationContainer)((Object)innerDeclaration) : null;
                if (firAnnotationContainer3 == null) {
                    list4 = null;
                } else {
                    FirAnnotationContainer it$iv = firAnnotationContainer2 = firAnnotationContainer3;
                    boolean bl3 = false;
                    list4 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(it$iv);
                }
                arguments$iv = list4;
                if (arguments$iv != null) {
                    CheckerContext context6 = context2.addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
                    bl = false;
                    DiagnosticReporterKt.reportOn$default(reporter2, delegatedTypeRefSource, FirErrors.INSTANCE.getINLINE_CLASS_CANNOT_IMPLEMENT_INTERFACE_BY_DELEGATION(), context6, null, 8, null);
                    continue;
                }
                CheckerContext context7 = context2;
                bl = false;
                DiagnosticReporterKt.reportOn$default(reporter2, delegatedTypeRefSource, FirErrors.INSTANCE.getINLINE_CLASS_CANNOT_IMPLEMENT_INTERFACE_BY_DELEGATION(), context7, null, 8, null);
                continue;
            }
            if (!(firElement instanceof FirProperty)) continue;
            if (this.isRelatedToParameter((FirProperty)innerDeclaration, primaryConstructorParameter)) {
                primaryConstructorProperty = innerDeclaration;
                continue;
            }
            if (((FirProperty)innerDeclaration).getDelegate() != null) {
                CheckerContext context8;
                List<String> list5;
                FirAnnotationContainer $i$f$withSuppressedDiagnostics3;
                boolean $i$f$withSuppressedDiagnostics4 = false;
                FirAnnotationContainer firAnnotationContainer6 = $i$f$withSuppressedDiagnostics3 = (FirElement)innerDeclaration instanceof FirAnnotationContainer ? (FirAnnotationContainer)((Object)innerDeclaration) : null;
                if ($i$f$withSuppressedDiagnostics3 == null) {
                    list5 = null;
                } else {
                    FirAnnotationContainer it$iv = firAnnotationContainer3 = $i$f$withSuppressedDiagnostics3;
                    boolean bl = false;
                    list5 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(it$iv);
                }
                List<String> arguments$iv2 = list5;
                if (arguments$iv2 != null) {
                    context8 = context2.addSuppressedDiagnostics((Collection<String>)arguments$iv2, arguments$iv2.contains("infos"), arguments$iv2.contains("warnings"), arguments$iv2.contains("errors"));
                    boolean bl = false;
                    FirExpression firExpression2 = ((FirProperty)innerDeclaration).getDelegate();
                    Intrinsics.checkNotNull(firExpression2);
                    DiagnosticReporterKt.reportOn$default(reporter2, firExpression2.getSource(), FirErrors.INSTANCE.getDELEGATED_PROPERTY_INSIDE_INLINE_CLASS(), context8, null, 8, null);
                    continue;
                }
                context8 = context2;
                boolean bl = false;
                FirExpression firExpression3 = ((FirProperty)innerDeclaration).getDelegate();
                Intrinsics.checkNotNull(firExpression3);
                DiagnosticReporterKt.reportOn$default(reporter2, firExpression3.getSource(), FirErrors.INSTANCE.getDELEGATED_PROPERTY_INSIDE_INLINE_CLASS(), context8, null, 8, null);
                continue;
            }
            if (!DeclarationAttributesKt.getHasBackingField((FirProperty)innerDeclaration) || (($i$f$withSuppressedDiagnostics4 = innerDeclaration.getSource()) == null ? null : $i$f$withSuppressedDiagnostics4.getKind()) instanceof FirFakeSourceElementKind) continue;
            DiagnosticReporterKt.reportOnWithSuppression$default(reporter2, innerDeclaration, FirErrors.INSTANCE.getPROPERTY_WITH_BACKING_FIELD_INSIDE_INLINE_CLASS(), context2, null, 8, null);
        }
        $this$isInterface$iv = primaryConstructor2;
        if (!(($this$isInterface$iv == null ? null : ((firSourceElement = ((FirConstructor)$this$isInterface$iv).getSource()) == null ? null : firSourceElement.getKind())) instanceof FirRealSourceElementKind)) {
            DiagnosticReporterKt.reportOn$default(reporter2, declaration2.getSource(), FirErrors.INSTANCE.getABSENCE_OF_PRIMARY_CONSTRUCTOR_FOR_INLINE_CLASS(), context2, null, 8, null);
            return;
        }
        if (primaryConstructorParameter == null) {
            DiagnosticReporterKt.reportOnWithSuppression$default(reporter2, primaryConstructor2, FirErrors.INSTANCE.getINLINE_CLASS_CONSTRUCTOR_WRONG_PARAMETERS_SIZE(), context2, null, 8, null);
            return;
        }
        boolean $i$f$withSuppressedDiagnostics = false;
        FirAnnotationContainer firAnnotationContainer7 = firAnnotationContainer = (FirElement)primaryConstructor2 instanceof FirAnnotationContainer ? (FirAnnotationContainer)((FirElement)primaryConstructor2) : null;
        if (firAnnotationContainer == null) {
            list2 = null;
        } else {
            FirElement it$iv = firElement = firAnnotationContainer;
            boolean bl = false;
            list2 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer((FirAnnotationContainer)it$iv);
        }
        List<String> arguments$iv = list2;
        if (arguments$iv != null) {
            List<String> list6;
            FirAnnotationContainer firAnnotationContainer8;
            context3 = context2.addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
            boolean bl = false;
            FirElement element$iv = primaryConstructorParameter;
            boolean $i$f$withSuppressedDiagnostics5 = false;
            FirAnnotationContainer firAnnotationContainer9 = firAnnotationContainer8 = element$iv instanceof FirAnnotationContainer ? (FirAnnotationContainer)element$iv : null;
            if (firAnnotationContainer8 == null) {
                list6 = null;
            } else {
                FirAnnotationContainer firAnnotationContainer10;
                FirAnnotationContainer it$iv = firAnnotationContainer10 = firAnnotationContainer8;
                boolean bl4 = false;
                list6 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(it$iv);
            }
            List<String> arguments$iv3 = list6;
            if (arguments$iv3 != null) {
                CheckerContext context9 = context3.addSuppressedDiagnostics((Collection<String>)arguments$iv3, arguments$iv3.contains("infos"), arguments$iv3.contains("warnings"), arguments$iv3.contains("errors"));
                boolean bl5 = false;
                if (INSTANCE.isNotFinalReadOnly(primaryConstructorParameter, (FirProperty)primaryConstructorProperty)) {
                    DiagnosticReporterKt.reportOn$default(reporter2, primaryConstructorParameter.getSource(), FirErrors.INSTANCE.getINLINE_CLASS_CONSTRUCTOR_NOT_FINAL_READ_ONLY_PARAMETER(), context9, null, 8, null);
                } else if (INSTANCE.isInapplicableParameterType(primaryConstructorParameter.getReturnTypeRef())) {
                    DiagnosticReporterKt.reportOn$default(reporter2, primaryConstructorParameter.getReturnTypeRef().getSource(), FirErrors.INSTANCE.getINLINE_CLASS_HAS_INAPPLICABLE_PARAMETER_TYPE(), (Object)FirTypeUtilsKt.getConeType(primaryConstructorParameter.getReturnTypeRef()), context9, null, 16, null);
                } else if (INSTANCE.isRecursiveInlineClassType(FirTypeUtilsKt.getConeType(primaryConstructorParameter.getReturnTypeRef()), context9.getSession())) {
                    DiagnosticReporterKt.reportOnWithSuppression$default(reporter2, primaryConstructorParameter.getReturnTypeRef(), FirErrors.INSTANCE.getINLINE_CLASS_CANNOT_BE_RECURSIVE(), context9, null, 8, null);
                }
            } else {
                CheckerContext context10 = context3;
                boolean bl6 = false;
                if (INSTANCE.isNotFinalReadOnly(primaryConstructorParameter, (FirProperty)primaryConstructorProperty)) {
                    DiagnosticReporterKt.reportOn$default(reporter2, primaryConstructorParameter.getSource(), FirErrors.INSTANCE.getINLINE_CLASS_CONSTRUCTOR_NOT_FINAL_READ_ONLY_PARAMETER(), context10, null, 8, null);
                } else if (INSTANCE.isInapplicableParameterType(primaryConstructorParameter.getReturnTypeRef())) {
                    DiagnosticReporterKt.reportOn$default(reporter2, primaryConstructorParameter.getReturnTypeRef().getSource(), FirErrors.INSTANCE.getINLINE_CLASS_HAS_INAPPLICABLE_PARAMETER_TYPE(), (Object)FirTypeUtilsKt.getConeType(primaryConstructorParameter.getReturnTypeRef()), context10, null, 16, null);
                } else if (INSTANCE.isRecursiveInlineClassType(FirTypeUtilsKt.getConeType(primaryConstructorParameter.getReturnTypeRef()), context10.getSession())) {
                    DiagnosticReporterKt.reportOnWithSuppression$default(reporter2, primaryConstructorParameter.getReturnTypeRef(), FirErrors.INSTANCE.getINLINE_CLASS_CANNOT_BE_RECURSIVE(), context10, null, 8, null);
                }
            }
        } else {
            List<String> list7;
            FirAnnotationContainer firAnnotationContainer11;
            context3 = context2;
            boolean bl = false;
            FirElement element$iv = primaryConstructorParameter;
            boolean $i$f$withSuppressedDiagnostics6 = false;
            FirAnnotationContainer firAnnotationContainer12 = firAnnotationContainer11 = element$iv instanceof FirAnnotationContainer ? (FirAnnotationContainer)element$iv : null;
            if (firAnnotationContainer11 == null) {
                list7 = null;
            } else {
                FirAnnotationContainer firAnnotationContainer13;
                FirAnnotationContainer it$iv = firAnnotationContainer13 = firAnnotationContainer11;
                boolean bl7 = false;
                list7 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(it$iv);
            }
            List<String> arguments$iv4 = list7;
            if (arguments$iv4 != null) {
                CheckerContext context11 = context3.addSuppressedDiagnostics((Collection<String>)arguments$iv4, arguments$iv4.contains("infos"), arguments$iv4.contains("warnings"), arguments$iv4.contains("errors"));
                boolean bl8 = false;
                if (INSTANCE.isNotFinalReadOnly(primaryConstructorParameter, (FirProperty)primaryConstructorProperty)) {
                    DiagnosticReporterKt.reportOn$default(reporter2, primaryConstructorParameter.getSource(), FirErrors.INSTANCE.getINLINE_CLASS_CONSTRUCTOR_NOT_FINAL_READ_ONLY_PARAMETER(), context11, null, 8, null);
                } else if (INSTANCE.isInapplicableParameterType(primaryConstructorParameter.getReturnTypeRef())) {
                    DiagnosticReporterKt.reportOn$default(reporter2, primaryConstructorParameter.getReturnTypeRef().getSource(), FirErrors.INSTANCE.getINLINE_CLASS_HAS_INAPPLICABLE_PARAMETER_TYPE(), (Object)FirTypeUtilsKt.getConeType(primaryConstructorParameter.getReturnTypeRef()), context11, null, 16, null);
                } else if (INSTANCE.isRecursiveInlineClassType(FirTypeUtilsKt.getConeType(primaryConstructorParameter.getReturnTypeRef()), context11.getSession())) {
                    DiagnosticReporterKt.reportOnWithSuppression$default(reporter2, primaryConstructorParameter.getReturnTypeRef(), FirErrors.INSTANCE.getINLINE_CLASS_CANNOT_BE_RECURSIVE(), context11, null, 8, null);
                }
            } else {
                CheckerContext context12 = context3;
                boolean bl9 = false;
                if (INSTANCE.isNotFinalReadOnly(primaryConstructorParameter, (FirProperty)primaryConstructorProperty)) {
                    DiagnosticReporterKt.reportOn$default(reporter2, primaryConstructorParameter.getSource(), FirErrors.INSTANCE.getINLINE_CLASS_CONSTRUCTOR_NOT_FINAL_READ_ONLY_PARAMETER(), context12, null, 8, null);
                } else if (INSTANCE.isInapplicableParameterType(primaryConstructorParameter.getReturnTypeRef())) {
                    DiagnosticReporterKt.reportOn$default(reporter2, primaryConstructorParameter.getReturnTypeRef().getSource(), FirErrors.INSTANCE.getINLINE_CLASS_HAS_INAPPLICABLE_PARAMETER_TYPE(), (Object)FirTypeUtilsKt.getConeType(primaryConstructorParameter.getReturnTypeRef()), context12, null, 16, null);
                } else if (INSTANCE.isRecursiveInlineClassType(FirTypeUtilsKt.getConeType(primaryConstructorParameter.getReturnTypeRef()), context12.getSession())) {
                    DiagnosticReporterKt.reportOnWithSuppression$default(reporter2, primaryConstructorParameter.getReturnTypeRef(), FirErrors.INSTANCE.getINLINE_CLASS_CANNOT_BE_RECURSIVE(), context12, null, 8, null);
                }
            }
        }
    }

    private final boolean isRelatedToParameter(FirProperty $this$isRelatedToParameter, FirValueParameter parameter) {
        Object object;
        return Intrinsics.areEqual($this$isRelatedToParameter.getName(), (object = parameter) == null ? null : ((FirValueParameter)object).getName()) && ((object = $this$isRelatedToParameter.getSource()) == null ? null : ((FirSourceElement)object).getKind()) instanceof FirFakeSourceElementKind;
    }

    private final boolean isNotFinalReadOnly(FirValueParameter $this$isNotFinalReadOnly, FirProperty primaryConstructorProperty) {
        if (primaryConstructorProperty == null) {
            return true;
        }
        FirElement firElement = $this$isNotFinalReadOnly;
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken, "OPEN_KEYWORD");
        boolean isOpen = FirKeywordUtilsKt.hasModifier(firElement, ktModifierKeywordToken);
        return $this$isNotFinalReadOnly.isVararg() || !primaryConstructorProperty.isVal() || isOpen;
    }

    private final boolean isInapplicableParameterType(FirTypeRef $this$isInapplicableParameterType) {
        return FirTypeUtilsKt.isUnit($this$isInapplicableParameterType) || FirTypeUtilsKt.isNothing($this$isInapplicableParameterType) || FirTypeUtilsKt.getConeType($this$isInapplicableParameterType) instanceof ConeTypeParameterType || this.isGenericArrayOfTypeParameter(FirTypeUtilsKt.getConeType($this$isInapplicableParameterType));
    }

    private final boolean isGenericArrayOfTypeParameter(ConeKotlinType $this$isGenericArrayOfTypeParameter) {
        if (ArraysKt.firstOrNull($this$isGenericArrayOfTypeParameter.getTypeArguments()) instanceof ConeStarProjection || !CallableReferenceResolutionKt.isPotentiallyArray($this$isGenericArrayOfTypeParameter)) {
            return false;
        }
        ConeKotlinType coneKotlinType = ArrayUtilsKt.arrayElementType($this$isGenericArrayOfTypeParameter);
        if (coneKotlinType == null) {
            return false;
        }
        ConeKotlinType arrayElementType = coneKotlinType.getType();
        return arrayElementType instanceof ConeTypeParameterType || this.isGenericArrayOfTypeParameter(arrayElementType);
    }

    private final boolean isRecursiveInlineClassType(ConeKotlinType $this$isRecursiveInlineClassType, FirSession session2) {
        return this.isRecursiveInlineClassType($this$isRecursiveInlineClassType, new HashSet<ConeKotlinType>(), session2);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isRecursiveInlineClassType(ConeKotlinType $this$isRecursiveInlineClassType, HashSet<ConeKotlinType> visited2, FirSession session2) {
        ConeKotlinType coneKotlinType;
        Object v0;
        Object object;
        block5: {
            void $this$firstOrNull$iv;
            if (!visited2.add($this$isRecursiveInlineClassType)) {
                return true;
            }
            FirRegularClassSymbol firRegularClassSymbol = FirHelpersKt.toRegularClassSymbol($this$isRecursiveInlineClassType, session2);
            if (firRegularClassSymbol == null) {
                return false;
            }
            FirRegularClassSymbol asRegularClass = firRegularClassSymbol;
            if (!FirDeclarationCheckerUtilsKt.isInlineOrValueClass(asRegularClass)) {
                return false;
            }
            object = asRegularClass.getDeclarationSymbols();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirBasedSymbol it = (FirBasedSymbol)element$iv;
                boolean bl = false;
                if (!(it instanceof FirConstructorSymbol && ((FirConstructorSymbol)it).isPrimary())) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        FirCallableSymbol firCallableSymbol = v0;
        if (firCallableSymbol == null) {
            return false;
        }
        FirCallableSymbol primaryConstructor2 = firCallableSymbol;
        return (firCallableSymbol = CollectionsKt.firstOrNull(primaryConstructor2.getValueParameterSymbols())) == null ? false : this.isRecursiveInlineClassType(coneKotlinType = FirTypeUtilsKt.getConeType((FirTypeRef)(object = firCallableSymbol.getResolvedReturnTypeRef())), visited2, session2);
    }

    private final boolean isSubtypeOfCloneable(FirRegularClass $this$isSubtypeOfCloneable, FirSession session2) {
        boolean bl;
        block4: {
            if (this.isCloneableId(FirDeclarationUtilKt.getClassId($this$isSubtypeOfCloneable))) {
                return true;
            }
            Iterable $this$any$iv = SupertypeUtilsKt.lookupSuperTypes$default($this$isSubtypeOfCloneable, true, true, session2, null, false, 48, null);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ConeClassLikeType coneClassLikeType;
                    ConeClassLikeLookupTag coneClassLikeLookupTag;
                    ClassId classId;
                    ConeClassLikeType coneClassLikeType2;
                    ConeClassLikeType superType2 = (ConeClassLikeType)element$iv;
                    boolean bl2 = false;
                    ConeClassLikeType coneClassLikeType3 = coneClassLikeType2 = superType2 instanceof ConeClassLikeType ? superType2 : null;
                    if (!(coneClassLikeType2 == null ? false : INSTANCE.isCloneableId(classId = (coneClassLikeLookupTag = (coneClassLikeType = TypeExpansionUtilsKt.fullyExpandedType$default(coneClassLikeType2, session2, null, 2, null)).getLookupTag()).getClassId()))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isCloneableId(ClassId $this$isCloneableId) {
        return Intrinsics.areEqual($this$isCloneableId.getRelativeClassName(), cloneableFqName) && Intrinsics.areEqual($this$isCloneableId.getPackageFqName(), StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE()) || Intrinsics.areEqual($this$isCloneableId.getPackageFqName(), javaLangFqName);
    }

    static {
        String[] stringArray = new String[]{"box", "unbox", "equals", "hashCode"};
        reservedFunctionNames = SetsKt.setOf(stringArray);
        javaLangFqName = new FqName("java.lang");
        cloneableFqName = new FqName("Cloneable");
    }
}

