/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util.io;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.LoggerRt;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfoRt;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.NullAppendable;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtilRt;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;

public class FileUtilRt {
    public static final int MEGABYTE = 0x100000;
    public static final int LARGE_FOR_CONTENT_LOADING = Math.max(0x1400000, Math.max(FileUtilRt.getUserFileSizeLimit(), FileUtilRt.getUserContentLoadLimit()));
    public static final int LARGE_FILE_PREVIEW_SIZE = Math.min(FileUtilRt.getLargeFilePreviewSize(), LARGE_FOR_CONTENT_LOADING);
    private static final boolean USE_FILE_CHANNELS = "true".equalsIgnoreCase(System.getProperty("idea.fs.useChannels"));
    public static final FileFilter ALL_FILES = new FileFilter(){

        @Override
        public boolean accept(File file2) {
            return true;
        }
    };
    public static final FileFilter ALL_DIRECTORIES = new FileFilter(){

        @Override
        public boolean accept(File file2) {
            return file2.isDirectory();
        }
    };
    public static final int THREAD_LOCAL_BUFFER_LENGTH = 20480;
    protected static final ThreadLocal<byte[]> BUFFER = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[20480];
        }
    };
    private static String ourCanonicalTempPathCache;
    private static final Random RANDOM;

    public static boolean isJarOrZip(@NotNull File file2) {
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(0);
        }
        return FileUtilRt.isJarOrZip(file2, true);
    }

    public static boolean isJarOrZip(@NotNull File file2, boolean isCheckIsDirectory) {
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(1);
        }
        if (isCheckIsDirectory && file2.isDirectory()) {
            return false;
        }
        String path2 = file2.getPath();
        return StringUtilRt.endsWithIgnoreCase(path2, ".jar") || StringUtilRt.endsWithIgnoreCase(path2, ".zip");
    }

    @NotNull
    public static List<String> splitPath(@NotNull String path2, char separatorChar) {
        int nextSeparator;
        if (path2 == null) {
            FileUtilRt.$$$reportNull$$$0(2);
        }
        ArrayList<String> list2 = new ArrayList<String>();
        int index2 = 0;
        while ((nextSeparator = path2.indexOf(separatorChar, index2)) != -1) {
            list2.add(path2.substring(index2, nextSeparator));
            index2 = nextSeparator + 1;
        }
        list2.add(path2.substring(index2));
        ArrayList<String> arrayList = list2;
        if (arrayList == null) {
            FileUtilRt.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public static boolean isFilePathAcceptable(@NotNull File root2, @Nullable FileFilter fileFilter) {
        if (root2 == null) {
            FileUtilRt.$$$reportNull$$$0(4);
        }
        if (fileFilter == null) {
            return true;
        }
        File file2 = root2;
        do {
            if (fileFilter.accept(file2)) continue;
            return false;
        } while ((file2 = file2.getParentFile()) != null);
        return true;
    }

    @Contract(value="null, _, _ -> null; !null,_,_->!null")
    public static String toCanonicalPath(@Nullable String path2, char separatorChar, boolean removeLastSlash) {
        return FileUtilRt.toCanonicalPath(path2, separatorChar, removeLastSlash, null);
    }

    @Contract(value="null, _, _, _ -> null; !null,_,_,_->!null")
    protected static String toCanonicalPath(@Nullable String path2, char separatorChar, boolean removeLastSlash, @Nullable SymlinkResolver resolver) {
        char next;
        if (path2 == null || path2.isEmpty()) {
            return path2;
        }
        if (path2.charAt(0) == '.') {
            if (path2.length() == 1) {
                return "";
            }
            char c = path2.charAt(1);
            if (c == '/' || c == separatorChar) {
                path2 = path2.substring(2);
            }
        }
        if (separatorChar != '/') {
            path2 = path2.replace(separatorChar, '/');
        }
        int index2 = -1;
        do {
            char c = next = (index2 = path2.indexOf(47, index2 + 1)) == path2.length() - 1 ? (char)'\u0000' : path2.charAt(index2 + 1);
        } while (next != '.' && next != '/' && index2 != -1);
        if (index2 == -1) {
            if (removeLastSlash) {
                int start = FileUtilRt.processRoot(path2, NullAppendable.INSTANCE);
                int slashIndex = path2.lastIndexOf(47);
                return slashIndex != -1 && slashIndex > start && slashIndex == path2.length() - 1 ? path2.substring(0, path2.length() - 1) : path2;
            }
            return path2;
        }
        StringBuilder result2 = new StringBuilder(path2.length());
        int start = FileUtilRt.processRoot(path2, result2);
        int dots = 0;
        boolean separator = true;
        for (int i = start; i < path2.length(); ++i) {
            char c = path2.charAt(i);
            if (c == '/') {
                if (!separator) {
                    if (!FileUtilRt.processDots(result2, dots, start, resolver)) {
                        return resolver.resolveSymlinksAndCanonicalize(path2, separatorChar, removeLastSlash);
                    }
                    dots = 0;
                }
                separator = true;
                continue;
            }
            if (c == '.') {
                if (separator || dots > 0) {
                    ++dots;
                } else {
                    result2.append('.');
                }
                separator = false;
                continue;
            }
            while (dots > 0) {
                result2.append('.');
                --dots;
            }
            result2.append(c);
            separator = false;
        }
        if (dots > 0 && !FileUtilRt.processDots(result2, dots, start, resolver)) {
            return resolver.resolveSymlinksAndCanonicalize(path2, separatorChar, removeLastSlash);
        }
        int lastChar = result2.length() - 1;
        if (removeLastSlash && lastChar >= 0 && result2.charAt(lastChar) == '/' && lastChar > start) {
            result2.deleteCharAt(lastChar);
        }
        return result2.toString();
    }

    private static int processRoot(@NotNull String path2, @NotNull Appendable result2) {
        if (path2 == null) {
            FileUtilRt.$$$reportNull$$$0(5);
        }
        if (result2 == null) {
            FileUtilRt.$$$reportNull$$$0(6);
        }
        try {
            if (SystemInfoRt.isWindows && path2.length() > 1 && path2.charAt(0) == '/' && path2.charAt(1) == '/') {
                int shareStart;
                int hostStart;
                result2.append("//");
                for (hostStart = 2; hostStart < path2.length() && path2.charAt(hostStart) == '/'; ++hostStart) {
                }
                if (hostStart == path2.length()) {
                    return hostStart;
                }
                int hostEnd = path2.indexOf(47, hostStart);
                if (hostEnd < 0) {
                    hostEnd = path2.length();
                }
                result2.append(path2, hostStart, hostEnd);
                result2.append('/');
                for (shareStart = hostEnd; shareStart < path2.length() && path2.charAt(shareStart) == '/'; ++shareStart) {
                }
                if (shareStart == path2.length()) {
                    return shareStart;
                }
                int shareEnd = path2.indexOf(47, shareStart);
                if (shareEnd < 0) {
                    shareEnd = path2.length();
                }
                result2.append(path2, shareStart, shareEnd);
                result2.append('/');
                return shareEnd;
            }
            if (!path2.isEmpty() && path2.charAt(0) == '/') {
                result2.append('/');
                return 1;
            }
            if (path2.length() > 2 && path2.charAt(1) == ':' && path2.charAt(2) == '/') {
                result2.append(path2, 0, 3);
                return 3;
            }
            return 0;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Contract(value="_, _, _, null -> true")
    private static boolean processDots(@NotNull StringBuilder result2, int dots, int start, SymlinkResolver symlinkResolver) {
        if (result2 == null) {
            FileUtilRt.$$$reportNull$$$0(7);
        }
        if (dots == 2) {
            int pos = -1;
            if (!StringUtilRt.endsWith(result2, "/../") && !"../".contentEquals(result2)) {
                pos = StringUtilRt.lastIndexOf(result2, '/', start, result2.length() - 1);
                if (pos >= 0) {
                    ++pos;
                } else if (start > 0) {
                    pos = start;
                } else if (result2.length() > 0) {
                    pos = 0;
                }
            }
            if (pos >= 0) {
                if (symlinkResolver != null && symlinkResolver.isSymlink(result2)) {
                    return false;
                }
                result2.delete(pos, result2.length());
            } else {
                result2.append("../");
            }
        } else if (dots != 1) {
            for (int i = 0; i < dots; ++i) {
                result2.append('.');
            }
            result2.append('/');
        }
        return true;
    }

    @NotNull
    public static String getExtension(@NotNull String fileName) {
        int index2;
        if (fileName == null) {
            FileUtilRt.$$$reportNull$$$0(8);
        }
        if ((index2 = fileName.lastIndexOf(46)) < 0) {
            return "";
        }
        String string2 = fileName.substring(index2 + 1);
        if (string2 == null) {
            FileUtilRt.$$$reportNull$$$0(9);
        }
        return string2;
    }

    @NotNull
    public static CharSequence getExtension(@NotNull CharSequence fileName) {
        if (fileName == null) {
            FileUtilRt.$$$reportNull$$$0(10);
        }
        CharSequence charSequence2 = FileUtilRt.getExtension(fileName, "");
        if (charSequence2 == null) {
            FileUtilRt.$$$reportNull$$$0(11);
        }
        return charSequence2;
    }

    @Contract(value="_,!null -> !null")
    public static CharSequence getExtension(@NotNull CharSequence fileName, @Nullable String defaultValue2) {
        int index2;
        if (fileName == null) {
            FileUtilRt.$$$reportNull$$$0(12);
        }
        if ((index2 = StringUtilRt.lastIndexOf(fileName, '.', 0, fileName.length())) < 0) {
            return defaultValue2;
        }
        return fileName.subSequence(index2 + 1, fileName.length());
    }

    public static boolean extensionEquals(@NotNull @NonNls String filePath, @NotNull @NonNls String extension) {
        int extLen;
        if (filePath == null) {
            FileUtilRt.$$$reportNull$$$0(13);
        }
        if (extension == null) {
            FileUtilRt.$$$reportNull$$$0(14);
        }
        if ((extLen = extension.length()) == 0) {
            int lastSlash = Math.max(filePath.lastIndexOf(47), filePath.lastIndexOf(92));
            return filePath.indexOf(46, lastSlash + 1) == -1;
        }
        int extStart = filePath.length() - extLen;
        return extStart >= 1 && filePath.charAt(extStart - 1) == '.' && filePath.regionMatches(!SystemInfoRt.isFileSystemCaseSensitive, extStart, extension, 0, extLen);
    }

    public static boolean fileNameEquals(@NotNull File file2, @NonNls @NotNull String name2) {
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(15);
        }
        if (name2 == null) {
            FileUtilRt.$$$reportNull$$$0(16);
        }
        return FileUtilRt.fileNameEquals(file2.getName(), (CharSequence)name2);
    }

    public static boolean fileNameEquals(@NotNull @NonNls CharSequence fileName, @NotNull @NonNls CharSequence expectedName) {
        if (fileName == null) {
            FileUtilRt.$$$reportNull$$$0(17);
        }
        if (expectedName == null) {
            FileUtilRt.$$$reportNull$$$0(18);
        }
        return StringUtilRt.equal(expectedName, fileName, SystemInfoRt.isFileSystemCaseSensitive);
    }

    @NotNull
    public static String toSystemDependentName(@NotNull String fileName) {
        if (fileName == null) {
            FileUtilRt.$$$reportNull$$$0(19);
        }
        return FileUtilRt.toSystemDependentName(fileName, File.separatorChar);
    }

    @NotNull
    public static String toSystemDependentName(@NotNull String fileName, char separatorChar) {
        if (fileName == null) {
            FileUtilRt.$$$reportNull$$$0(20);
        }
        String string2 = fileName.replace('/', separatorChar).replace('\\', separatorChar);
        if (string2 == null) {
            FileUtilRt.$$$reportNull$$$0(21);
        }
        return string2;
    }

    @NotNull
    public static String toSystemIndependentName(@NotNull String fileName) {
        if (fileName == null) {
            FileUtilRt.$$$reportNull$$$0(22);
        }
        String string2 = fileName.replace('\\', '/');
        if (string2 == null) {
            FileUtilRt.$$$reportNull$$$0(23);
        }
        return string2;
    }

    @Nullable
    public static String getRelativePath(File base2, File file2) {
        if (base2 == null || file2 == null) {
            return null;
        }
        if (base2.equals(file2)) {
            return ".";
        }
        String filePath = file2.getAbsolutePath();
        String basePath2 = base2.getAbsolutePath();
        return FileUtilRt.getRelativePath(basePath2, filePath, File.separatorChar);
    }

    @Nullable
    public static String getRelativePath(@NotNull String basePath2, @NotNull String filePath, char separator) {
        if (basePath2 == null) {
            FileUtilRt.$$$reportNull$$$0(24);
        }
        if (filePath == null) {
            FileUtilRt.$$$reportNull$$$0(25);
        }
        return FileUtilRt.getRelativePath(basePath2, filePath, separator, SystemInfoRt.isFileSystemCaseSensitive);
    }

    @Nullable
    public static String getRelativePath(@NotNull String basePath2, @NotNull String filePath, char separator, boolean caseSensitive) {
        int len;
        CharComparingStrategy strategy;
        if (basePath2 == null) {
            FileUtilRt.$$$reportNull$$$0(26);
        }
        if (filePath == null) {
            FileUtilRt.$$$reportNull$$$0(27);
        }
        basePath2 = FileUtilRt.ensureEnds(basePath2, separator);
        if (caseSensitive ? basePath2.equals(FileUtilRt.ensureEnds(filePath, separator)) : basePath2.equalsIgnoreCase(FileUtilRt.ensureEnds(filePath, separator))) {
            return ".";
        }
        int lastSeparatorIndex = 0;
        CharComparingStrategy charComparingStrategy = strategy = caseSensitive ? CharComparingStrategy.IDENTITY : CharComparingStrategy.CASE_INSENSITIVE;
        for (len = 0; len < filePath.length() && len < basePath2.length() && strategy.charsEqual(filePath.charAt(len), basePath2.charAt(len)); ++len) {
            if (basePath2.charAt(len) != separator) continue;
            lastSeparatorIndex = len;
        }
        if (len == 0) {
            return null;
        }
        StringBuilder relativePath = new StringBuilder();
        for (int i = len; i < basePath2.length(); ++i) {
            if (basePath2.charAt(i) != separator) continue;
            relativePath.append("..");
            relativePath.append(separator);
        }
        relativePath.append(filePath.substring(lastSeparatorIndex + 1));
        return relativePath.toString();
    }

    @NotNull
    private static String ensureEnds(@NotNull String s, char endsWith) {
        if (s == null) {
            FileUtilRt.$$$reportNull$$$0(28);
        }
        String string2 = StringUtilRt.endsWithChar(s, endsWith) ? s : s + endsWith;
        if (string2 == null) {
            FileUtilRt.$$$reportNull$$$0(29);
        }
        return string2;
    }

    @NotNull
    public static CharSequence getNameWithoutExtension(@NotNull CharSequence name2) {
        int i;
        if (name2 == null) {
            FileUtilRt.$$$reportNull$$$0(30);
        }
        CharSequence charSequence2 = (i = StringUtilRt.lastIndexOf(name2, '.', 0, name2.length())) < 0 ? name2 : name2.subSequence(0, i);
        if (charSequence2 == null) {
            FileUtilRt.$$$reportNull$$$0(31);
        }
        return charSequence2;
    }

    @NotNull
    public static String getNameWithoutExtension(@NotNull String name2) {
        if (name2 == null) {
            FileUtilRt.$$$reportNull$$$0(32);
        }
        String string2 = FileUtilRt.getNameWithoutExtension((CharSequence)name2).toString();
        if (string2 == null) {
            FileUtilRt.$$$reportNull$$$0(33);
        }
        return string2;
    }

    @NotNull
    public static File createTempDirectory(@NotNull String prefix, @Nullable String suffix) throws IOException {
        if (prefix == null) {
            FileUtilRt.$$$reportNull$$$0(34);
        }
        return FileUtilRt.createTempDirectory(prefix, suffix, true);
    }

    @NotNull
    public static File createTempDirectory(@NotNull String prefix, @Nullable String suffix, boolean deleteOnExit) throws IOException {
        if (prefix == null) {
            FileUtilRt.$$$reportNull$$$0(35);
        }
        File dir = new File(FileUtilRt.getTempDirectory());
        return FileUtilRt.createTempDirectory(dir, prefix, suffix, deleteOnExit);
    }

    @NotNull
    public static File createTempDirectory(@NotNull File dir, @NotNull String prefix, @Nullable String suffix) throws IOException {
        if (dir == null) {
            FileUtilRt.$$$reportNull$$$0(36);
        }
        if (prefix == null) {
            FileUtilRt.$$$reportNull$$$0(37);
        }
        return FileUtilRt.createTempDirectory(dir, prefix, suffix, true);
    }

    @NotNull
    public static File createTempDirectory(@NotNull File dir, @NotNull String prefix, @Nullable String suffix, boolean deleteOnExit) throws IOException {
        if (dir == null) {
            FileUtilRt.$$$reportNull$$$0(38);
        }
        if (prefix == null) {
            FileUtilRt.$$$reportNull$$$0(39);
        }
        File file2 = FileUtilRt.doCreateTempFile(dir, prefix, suffix, true);
        if (deleteOnExit) {
            FilesToDeleteHolder.ourFilesToDelete.add(file2.getPath());
        }
        if (!file2.isDirectory()) {
            throw new IOException("Cannot create a directory: " + file2);
        }
        File file3 = file2;
        if (file3 == null) {
            FileUtilRt.$$$reportNull$$$0(40);
        }
        return file3;
    }

    @NotNull
    public static File createTempFile(@NotNull String prefix, @Nullable String suffix) throws IOException {
        if (prefix == null) {
            FileUtilRt.$$$reportNull$$$0(41);
        }
        return FileUtilRt.createTempFile(prefix, suffix, false);
    }

    @NotNull
    public static File createTempFile(@NonNls @NotNull String prefix, @NonNls @Nullable String suffix, boolean deleteOnExit) throws IOException {
        if (prefix == null) {
            FileUtilRt.$$$reportNull$$$0(42);
        }
        File dir = new File(FileUtilRt.getTempDirectory());
        return FileUtilRt.createTempFile(dir, prefix, suffix, true, deleteOnExit);
    }

    @NotNull
    public static File createTempFile(@NotNull File dir, @NotNull String prefix, @Nullable String suffix) throws IOException {
        if (dir == null) {
            FileUtilRt.$$$reportNull$$$0(43);
        }
        if (prefix == null) {
            FileUtilRt.$$$reportNull$$$0(44);
        }
        return FileUtilRt.createTempFile(dir, prefix, suffix, true, true);
    }

    @NotNull
    public static File createTempFile(@NotNull File dir, @NotNull String prefix, @Nullable String suffix, boolean create2) throws IOException {
        if (dir == null) {
            FileUtilRt.$$$reportNull$$$0(45);
        }
        if (prefix == null) {
            FileUtilRt.$$$reportNull$$$0(46);
        }
        return FileUtilRt.createTempFile(dir, prefix, suffix, create2, true);
    }

    @NotNull
    public static File createTempFile(@NotNull File dir, @NotNull String prefix, @Nullable String suffix, boolean create2, boolean deleteOnExit) throws IOException {
        if (dir == null) {
            FileUtilRt.$$$reportNull$$$0(47);
        }
        if (prefix == null) {
            FileUtilRt.$$$reportNull$$$0(48);
        }
        File file2 = FileUtilRt.doCreateTempFile(dir, prefix, suffix, false);
        if (deleteOnExit) {
            file2.deleteOnExit();
        }
        if (!create2 && !file2.delete() && file2.exists()) {
            throw new IOException("Cannot delete a file: " + file2);
        }
        File file3 = file2;
        if (file3 == null) {
            FileUtilRt.$$$reportNull$$$0(49);
        }
        return file3;
    }

    @NotNull
    private static File doCreateTempFile(@NotNull File dir, @NotNull String prefix, @Nullable String suffix, boolean isDirectory) throws IOException {
        if (dir == null) {
            FileUtilRt.$$$reportNull$$$0(50);
        }
        if (prefix == null) {
            FileUtilRt.$$$reportNull$$$0(51);
        }
        dir.mkdirs();
        if (prefix.length() < 3) {
            prefix = (prefix + "___").substring(0, 3);
        }
        if (suffix == null) {
            suffix = "";
        }
        prefix = new File(prefix).getName();
        int attempts = 0;
        int i = 0;
        int maxFileNumber = 10;
        IOException exception = null;
        while (true) {
            File f = null;
            try {
                boolean success;
                f = FileUtilRt.calcName(dir, prefix, suffix, i);
                boolean bl = success = isDirectory ? f.mkdir() : f.createNewFile();
                if (success) {
                    return FileUtilRt.normalizeFile(f);
                }
            }
            catch (IOException e) {
                exception = e;
            }
            int MAX_ATTEMPTS = 100;
            if (++attempts > maxFileNumber / 2 || attempts > MAX_ATTEMPTS) {
                Object[] children2 = dir.list();
                int size = children2 == null ? 0 : children2.length;
                maxFileNumber = Math.max(10, size * 10);
                if (attempts > MAX_ATTEMPTS) {
                    throw exception != null ? exception : new IOException("Unable to create a temporary file " + f + "\nDirectory '" + dir + "' list (" + size + " children): " + Arrays.toString(children2));
                }
            }
            if (++i <= 2) continue;
            i = 2 + RANDOM.nextInt(maxFileNumber);
        }
    }

    @NotNull
    private static File calcName(@NotNull File dir, @NotNull String prefix, @NotNull String suffix, int i) throws IOException {
        File f;
        String name2;
        if (dir == null) {
            FileUtilRt.$$$reportNull$$$0(52);
        }
        if (prefix == null) {
            FileUtilRt.$$$reportNull$$$0(53);
        }
        if (suffix == null) {
            FileUtilRt.$$$reportNull$$$0(54);
        }
        String string2 = prefix = i == 0 ? prefix : prefix + i;
        if (prefix.endsWith(".") && suffix.startsWith(".")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        if (!(name2 = prefix + suffix).equals((f = new File(dir, name2)).getName())) {
            throw new IOException("A generated name is malformed: '" + name2 + "' (" + f + ")");
        }
        File file2 = f;
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(55);
        }
        return file2;
    }

    @NotNull
    private static File normalizeFile(@NotNull File temp) throws IOException {
        if (temp == null) {
            FileUtilRt.$$$reportNull$$$0(56);
        }
        File canonical = temp.getCanonicalFile();
        File file2 = SystemInfoRt.isWindows && canonical.getAbsolutePath().contains(" ") ? temp.getAbsoluteFile() : canonical;
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(57);
        }
        return file2;
    }

    @NotNull
    public static String getTempDirectory() {
        if (ourCanonicalTempPathCache == null) {
            ourCanonicalTempPathCache = FileUtilRt.calcCanonicalTempPath();
        }
        String string2 = ourCanonicalTempPathCache;
        if (string2 == null) {
            FileUtilRt.$$$reportNull$$$0(58);
        }
        return string2;
    }

    @NotNull
    private static String calcCanonicalTempPath() {
        File file2;
        block4: {
            String string2;
            file2 = new File(System.getProperty("java.io.tmpdir"));
            try {
                String canonical = file2.getCanonicalPath();
                if (SystemInfoRt.isWindows && canonical.contains(" ")) break block4;
                string2 = canonical;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (string2 == null) {
                FileUtilRt.$$$reportNull$$$0(59);
            }
            return string2;
        }
        String string3 = file2.getAbsolutePath();
        if (string3 == null) {
            FileUtilRt.$$$reportNull$$$0(60);
        }
        return string3;
    }

    @TestOnly
    static void resetCanonicalTempPathCache(@NotNull String tempPath) {
        if (tempPath == null) {
            FileUtilRt.$$$reportNull$$$0(61);
        }
        ourCanonicalTempPathCache = tempPath;
    }

    @NotNull
    public static File generateRandomTemporaryPath() throws IOException {
        File file2 = new File(FileUtilRt.getTempDirectory(), UUID.randomUUID().toString());
        for (int i = 0; file2.exists() && i < 5; ++i) {
            file2 = new File(FileUtilRt.getTempDirectory(), UUID.randomUUID().toString());
        }
        if (file2.exists()) {
            throw new IOException("Couldn't generate unique random path.");
        }
        return FileUtilRt.normalizeFile(file2);
    }

    @Deprecated
    public static void setExecutableAttribute(@NotNull String path2, boolean executableFlag) throws IOException {
        if (path2 == null) {
            FileUtilRt.$$$reportNull$$$0(62);
        }
        try {
            File file2 = new File(path2);
            if (!file2.setExecutable(executableFlag) && file2.canExecute() != executableFlag) {
                FileUtilRt.logger().warn("Can't set executable attribute of '" + path2 + "' to " + executableFlag);
            }
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
    }

    @NotNull
    public static String loadFile(@NotNull File file2) throws IOException {
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(63);
        }
        return FileUtilRt.loadFile(file2, null, false);
    }

    @NotNull
    public static String loadFile(@NotNull File file2, boolean convertLineSeparators) throws IOException {
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(64);
        }
        return FileUtilRt.loadFile(file2, null, convertLineSeparators);
    }

    @NotNull
    public static String loadFile(@NotNull File file2, @Nullable String encoding) throws IOException {
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(65);
        }
        return FileUtilRt.loadFile(file2, encoding, false);
    }

    @NotNull
    public static String loadFile(@NotNull File file2, @Nullable String encoding, boolean convertLineSeparators) throws IOException {
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(66);
        }
        String s = new String(FileUtilRt.loadFileText(file2, encoding));
        String string2 = convertLineSeparators ? StringUtilRt.convertLineSeparators(s) : s;
        if (string2 == null) {
            FileUtilRt.$$$reportNull$$$0(67);
        }
        return string2;
    }

    @NotNull
    public static char[] loadFileText(@NotNull File file2) throws IOException {
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(68);
        }
        return FileUtilRt.loadFileText(file2, (String)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static char[] loadFileText(@NotNull File file2, @Nullable String encoding) throws IOException {
        char[] cArray;
        InputStreamReader reader;
        block4: {
            if (file2 == null) {
                FileUtilRt.$$$reportNull$$$0(69);
            }
            FileInputStream stream = new FileInputStream(file2);
            reader = encoding == null ? new InputStreamReader(stream) : new InputStreamReader((InputStream)stream, encoding);
            cArray = FileUtilRt.loadText(reader, (int)file2.length());
            if (cArray != null) break block4;
            FileUtilRt.$$$reportNull$$$0(70);
        }
        return cArray;
        finally {
            ((Reader)reader).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static char[] loadFileText(@NotNull File file2, @NotNull Charset encoding) throws IOException {
        char[] cArray;
        InputStreamReader reader;
        block5: {
            if (file2 == null) {
                FileUtilRt.$$$reportNull$$$0(71);
            }
            if (encoding == null) {
                FileUtilRt.$$$reportNull$$$0(72);
            }
            reader = new InputStreamReader((InputStream)new FileInputStream(file2), encoding);
            cArray = FileUtilRt.loadText(reader, (int)file2.length());
            if (cArray != null) break block5;
            FileUtilRt.$$$reportNull$$$0(73);
        }
        return cArray;
        finally {
            ((Reader)reader).close();
        }
    }

    @NotNull
    public static char[] loadText(@NotNull Reader reader, int length) throws IOException {
        int count2;
        int n;
        if (reader == null) {
            FileUtilRt.$$$reportNull$$$0(74);
        }
        char[] chars = new char[length];
        for (count2 = 0; count2 < chars.length && (n = reader.read(chars, count2, chars.length - count2)) > 0; count2 += n) {
        }
        if (count2 == chars.length) {
            if (chars == null) {
                FileUtilRt.$$$reportNull$$$0(75);
            }
            return chars;
        }
        char[] newChars = new char[count2];
        System.arraycopy(chars, 0, newChars, 0, count2);
        if (newChars == null) {
            FileUtilRt.$$$reportNull$$$0(76);
        }
        return newChars;
    }

    @NotNull
    public static List<String> loadLines(@NotNull File file2) throws IOException {
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(77);
        }
        return FileUtilRt.loadLines(file2.getPath());
    }

    @NotNull
    public static List<String> loadLines(@NotNull File file2, @Nullable String encoding) throws IOException {
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(78);
        }
        return FileUtilRt.loadLines(file2.getPath(), encoding);
    }

    @NotNull
    public static List<String> loadLines(@NotNull String path2) throws IOException {
        if (path2 == null) {
            FileUtilRt.$$$reportNull$$$0(79);
        }
        return FileUtilRt.loadLines(path2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    public static List<String> loadLines(@NotNull String path2, @Nullable String encoding) throws IOException {
        if (path2 == null) {
            FileUtilRt.$$$reportNull$$$0(80);
        }
        FileInputStream stream = new FileInputStream(path2);
        BufferedReader reader = new BufferedReader(encoding == null ? new InputStreamReader(stream) : new InputStreamReader((InputStream)stream, encoding));
        List<String> list2 = FileUtilRt.loadLines(reader);
        reader.close();
        List<String> list3 = list2;
        if (list3 == null) {
            FileUtilRt.$$$reportNull$$$0(81);
        }
        return list3;
        {
            catch (Throwable throwable) {
                reader.close();
                throw throwable;
            }
        }
        finally {
            ((InputStream)stream).close();
        }
    }

    @NotNull
    public static List<String> loadLines(@NotNull BufferedReader reader) throws IOException {
        String line;
        if (reader == null) {
            FileUtilRt.$$$reportNull$$$0(82);
        }
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            lines.add(line);
        }
        ArrayList<String> arrayList = lines;
        if (arrayList == null) {
            FileUtilRt.$$$reportNull$$$0(83);
        }
        return arrayList;
    }

    @NotNull
    public static byte[] loadBytes(@NotNull InputStream stream) throws IOException {
        if (stream == null) {
            FileUtilRt.$$$reportNull$$$0(84);
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        FileUtilRt.copy(stream, buffer);
        byte[] byArray = buffer.toByteArray();
        if (byArray == null) {
            FileUtilRt.$$$reportNull$$$0(85);
        }
        return byArray;
    }

    public static boolean isTooLarge(long len) {
        return len > (long)LARGE_FOR_CONTENT_LOADING;
    }

    @NotNull
    public static byte[] loadBytes(@NotNull InputStream stream, int length) throws IOException {
        int n;
        if (stream == null) {
            FileUtilRt.$$$reportNull$$$0(86);
        }
        if (length == 0) {
            if (ArrayUtilRt.EMPTY_BYTE_ARRAY == null) {
                FileUtilRt.$$$reportNull$$$0(87);
            }
            return ArrayUtilRt.EMPTY_BYTE_ARRAY;
        }
        byte[] bytes = new byte[length];
        for (int count2 = 0; count2 < length && (n = stream.read(bytes, count2, length - count2)) > 0; count2 += n) {
        }
        if (bytes == null) {
            FileUtilRt.$$$reportNull$$$0(88);
        }
        return bytes;
    }

    @Nullable
    public static File getParentFile(@NotNull File file2) {
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(89);
        }
        int skipCount = 0;
        File parentFile = file2;
        while (true) {
            if ((parentFile = parentFile.getParentFile()) == null) {
                return null;
            }
            if (".".equals(parentFile.getName())) continue;
            if ("..".equals(parentFile.getName())) {
                ++skipCount;
                continue;
            }
            if (skipCount <= 0) break;
            --skipCount;
        }
        return parentFile;
    }

    public static boolean delete(@NotNull File file2) {
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(90);
        }
        if (NIOReflect.IS_AVAILABLE) {
            try {
                FileUtilRt.deleteRecursivelyNIO(NIOReflect.toPath(file2));
                return true;
            }
            catch (IOException e) {
                return false;
            }
            catch (Exception e) {
                FileUtilRt.logger().info(e);
                return false;
            }
        }
        return FileUtilRt.deleteRecursively(file2);
    }

    static void deleteRecursivelyNIO(@NotNull Object path2) throws IOException {
        if (path2 == null) {
            FileUtilRt.$$$reportNull$$$0(91);
        }
        try {
            NIOReflect.deleteRecursively(path2);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
        }
        catch (Exception e) {
            FileUtilRt.logger().info(e);
        }
    }

    private static boolean deleteRecursively(@NotNull File file2) {
        File[] files2;
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(92);
        }
        if ((files2 = file2.listFiles()) != null) {
            for (File child : files2) {
                if (FileUtilRt.deleteRecursively(child)) continue;
                return false;
            }
        }
        return FileUtilRt.deleteFile(file2);
    }

    @Nullable
    public static <T, E extends Throwable> T doIOOperation(@NotNull RepeatableIOOperation<T, E> ioTask) throws E {
        if (ioTask == null) {
            FileUtilRt.$$$reportNull$$$0(93);
        }
        for (int i = 10; i > 0; --i) {
            T result2 = ioTask.execute(i == 1);
            if (result2 != null) {
                return result2;
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return null;
    }

    protected static boolean deleteFile(final @NotNull File file2) {
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(94);
        }
        Boolean result2 = FileUtilRt.doIOOperation(new RepeatableIOOperation<Boolean, RuntimeException>(){

            @Override
            public Boolean execute(boolean lastAttempt) {
                if (file2.delete() || !file2.exists()) {
                    return Boolean.TRUE;
                }
                if (lastAttempt) {
                    return Boolean.FALSE;
                }
                return null;
            }
        });
        return Boolean.TRUE.equals(result2);
    }

    public static boolean ensureCanCreateFile(@NotNull File file2) {
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(95);
        }
        if (file2.exists()) {
            return file2.canWrite();
        }
        if (!FileUtilRt.createIfNotExists(file2)) {
            return false;
        }
        return FileUtilRt.delete(file2);
    }

    public static boolean createIfNotExists(@NotNull File file2) {
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(96);
        }
        if (file2.exists()) {
            return true;
        }
        try {
            if (!FileUtilRt.createParentDirs(file2)) {
                return false;
            }
            FileOutputStream s = new FileOutputStream(file2);
            ((OutputStream)s).close();
            return true;
        }
        catch (IOException e) {
            FileUtilRt.logger().info(e);
            return false;
        }
    }

    public static boolean createParentDirs(@NotNull File file2) {
        File parentPath;
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(97);
        }
        return (parentPath = file2.getParentFile()) == null || FileUtilRt.createDirectory(parentPath);
    }

    public static boolean createDirectory(@NotNull File path2) {
        if (path2 == null) {
            FileUtilRt.$$$reportNull$$$0(98);
        }
        return path2.isDirectory() || path2.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(@NotNull File fromFile, @NotNull File toFile) throws IOException {
        if (fromFile == null) {
            FileUtilRt.$$$reportNull$$$0(99);
        }
        if (toFile == null) {
            FileUtilRt.$$$reportNull$$$0(100);
        }
        if (!FileUtilRt.ensureCanCreateFile(toFile)) {
            return;
        }
        FileOutputStream fos = new FileOutputStream(toFile);
        try {
            FileInputStream fis = new FileInputStream(fromFile);
            try {
                FileUtilRt.copy(fis, fos);
            }
            finally {
                fis.close();
            }
        }
        finally {
            fos.close();
        }
        long timeStamp = fromFile.lastModified();
        if (timeStamp < 0L) {
            FileUtilRt.logger().warn("Invalid timestamp " + timeStamp + " of '" + fromFile + "'");
        } else if (!toFile.setLastModified(timeStamp)) {
            FileUtilRt.logger().warn("Unable to set timestamp " + timeStamp + " to '" + toFile + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(@NotNull InputStream inputStream, @NotNull OutputStream outputStream2) throws IOException {
        block10: {
            int read2;
            if (inputStream == null) {
                FileUtilRt.$$$reportNull$$$0(101);
            }
            if (outputStream2 == null) {
                FileUtilRt.$$$reportNull$$$0(102);
            }
            if (USE_FILE_CHANNELS && inputStream instanceof FileInputStream && outputStream2 instanceof FileOutputStream) {
                FileChannel fromChannel = ((FileInputStream)inputStream).getChannel();
                try {
                    FileChannel toChannel2 = ((FileOutputStream)outputStream2).getChannel();
                    try {
                        fromChannel.transferTo(0L, Long.MAX_VALUE, toChannel2);
                        break block10;
                    }
                    finally {
                        toChannel2.close();
                    }
                }
                finally {
                    fromChannel.close();
                }
            }
            byte[] buffer = FileUtilRt.getThreadLocalBuffer();
            while ((read2 = inputStream.read(buffer)) >= 0) {
                outputStream2.write(buffer, 0, read2);
            }
        }
    }

    @NotNull
    public static byte[] getThreadLocalBuffer() {
        byte[] byArray = BUFFER.get();
        if (byArray == null) {
            FileUtilRt.$$$reportNull$$$0(103);
        }
        return byArray;
    }

    public static int getUserFileSizeLimit() {
        return FileUtilRt.parseKilobyteProperty("idea.max.intellisense.filesize", 2560000);
    }

    public static int getUserContentLoadLimit() {
        return FileUtilRt.parseKilobyteProperty("idea.max.content.load.filesize", 0x1400000);
    }

    private static int getLargeFilePreviewSize() {
        return FileUtilRt.parseKilobyteProperty("idea.max.content.load.large.preview.size", 2560000);
    }

    private static int parseKilobyteProperty(String key, int defaultValue2) {
        try {
            long i = Integer.parseInt(System.getProperty(key, String.valueOf(defaultValue2 / 1024)));
            if (i < 0L) {
                return Integer.MAX_VALUE;
            }
            return (int)Math.min(i * 1024L, Integer.MAX_VALUE);
        }
        catch (NumberFormatException e) {
            return defaultValue2;
        }
    }

    @NotNull
    private static LoggerRt logger() {
        LoggerRt loggerRt = LoggerRt.getInstance("#com.intellij.openapi.util.io.FileUtilRt");
        if (loggerRt == null) {
            FileUtilRt.$$$reportNull$$$0(104);
        }
        return loggerRt;
    }

    @NotNull
    public static URI fileToUri(@NotNull File file2) {
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(105);
        }
        String path2 = file2.getAbsolutePath();
        if (File.separatorChar != '/') {
            path2 = path2.replace(File.separatorChar, '/');
        }
        if (!path2.startsWith("/")) {
            path2 = '/' + path2;
        }
        if (path2.startsWith("//")) {
            path2 = "//" + path2;
        }
        try {
            return new URI("file", null, path2, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(path2, e);
        }
    }

    public static int pathHashCode(@Nullable String path2) {
        if (path2 == null || path2.isEmpty()) {
            return 0;
        }
        path2 = FileUtilRt.toCanonicalPath(path2, File.separatorChar, true);
        return SystemInfoRt.isFileSystemCaseSensitive ? path2.hashCode() : StringUtilRt.stringHashCodeInsensitive(path2);
    }

    public static boolean filesEqual(@Nullable File file1, @Nullable File file2) {
        return FileUtilRt.pathsEqual(file1 == null ? null : file1.getPath(), file2 == null ? null : file2.getPath());
    }

    public static boolean pathsEqual(@Nullable String path1, @Nullable String path2) {
        if (path1 == path2) {
            return true;
        }
        if (path1 == null || path2 == null) {
            return false;
        }
        path1 = FileUtilRt.toCanonicalPath(path1, File.separatorChar, true);
        path2 = FileUtilRt.toCanonicalPath(path2, File.separatorChar, true);
        if (SystemInfoRt.isFileSystemCaseSensitive) {
            return path1.equals(path2);
        }
        return path1.equalsIgnoreCase(path2);
    }

    static {
        RANDOM = new Random();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 21: 
            case 23: 
            case 29: 
            case 31: 
            case 33: 
            case 40: 
            case 49: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 67: 
            case 70: 
            case 73: 
            case 75: 
            case 76: 
            case 81: 
            case 83: 
            case 85: 
            case 87: 
            case 88: 
            case 103: 
            case 104: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 21: 
            case 23: 
            case 29: 
            case 31: 
            case 33: 
            case 40: 
            case 49: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 67: 
            case 70: 
            case 73: 
            case 75: 
            case 76: 
            case 81: 
            case 83: 
            case 85: 
            case 87: 
            case 88: 
            case 103: 
            case 104: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: 
            case 62: 
            case 79: 
            case 80: 
            case 91: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 21: 
            case 23: 
            case 29: 
            case 31: 
            case 33: 
            case 40: 
            case 49: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 67: 
            case 70: 
            case 73: 
            case 75: 
            case 76: 
            case 81: 
            case 83: 
            case 85: 
            case 87: 
            case 88: 
            case 103: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/io/FileUtilRt";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 17: 
            case 19: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 13: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 16: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedName";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 36: 
            case 38: 
            case 43: 
            case 45: 
            case 47: 
            case 50: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "temp";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempPath";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
            case 74: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 84: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ioTask";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromFile";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toFile";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/io/FileUtilRt";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "splitPath";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtension";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "toSystemDependentName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "toSystemIndependentName";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureEnds";
                break;
            }
            case 31: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameWithoutExtension";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempDirectory";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempFile";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "calcName";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeFile";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDirectory";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "calcCanonicalTempPath";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFile";
                break;
            }
            case 70: 
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFileText";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "loadText";
                break;
            }
            case 81: 
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "loadLines";
                break;
            }
            case 85: 
            case 87: 
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "loadBytes";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadLocalBuffer";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "logger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isJarOrZip";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "splitPath";
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 21: 
            case 23: 
            case 29: 
            case 31: 
            case 33: 
            case 40: 
            case 49: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 67: 
            case 70: 
            case 73: 
            case 75: 
            case 76: 
            case 81: 
            case 83: 
            case 85: 
            case 87: 
            case 88: 
            case 103: 
            case 104: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isFilePathAcceptable";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processRoot";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processDots";
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getExtension";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "extensionEquals";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "fileNameEquals";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "toSystemDependentName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "toSystemIndependentName";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "ensureEnds";
                break;
            }
            case 30: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getNameWithoutExtension";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createTempDirectory";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createTempFile";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "doCreateTempFile";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "calcName";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "normalizeFile";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "resetCanonicalTempPathCache";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "setExecutableAttribute";
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "loadFile";
                break;
            }
            case 68: 
            case 69: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "loadFileText";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "loadLines";
                break;
            }
            case 84: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "loadBytes";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "getParentFile";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "deleteRecursivelyNIO";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "deleteRecursively";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "doIOOperation";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "ensureCanCreateFile";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "createIfNotExists";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "createParentDirs";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "createDirectory";
                break;
            }
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "fileToUri";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 21: 
            case 23: 
            case 29: 
            case 31: 
            case 33: 
            case 40: 
            case 49: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 67: 
            case 70: 
            case 73: 
            case 75: 
            case 76: 
            case 81: 
            case 83: 
            case 85: 
            case 87: 
            case 88: 
            case 103: 
            case 104: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface CharComparingStrategy {
        public static final CharComparingStrategy IDENTITY = new CharComparingStrategy(){

            @Override
            public boolean charsEqual(char ch1, char ch2) {
                return ch1 == ch2;
            }
        };
        public static final CharComparingStrategy CASE_INSENSITIVE = new CharComparingStrategy(){

            @Override
            public boolean charsEqual(char ch1, char ch2) {
                return StringUtilRt.charsEqualIgnoreCase(ch1, ch2);
            }
        };

        public boolean charsEqual(char var1, char var2);
    }

    public static interface RepeatableIOOperation<T, E extends Throwable> {
        @Nullable
        public T execute(boolean var1) throws E;
    }

    private static class FilesToDeleteHolder {
        private static final Queue<String> ourFilesToDelete = FilesToDeleteHolder.createFilesToDelete();

        @NotNull
        private static Queue<String> createFilesToDelete() {
            final ConcurrentLinkedQueue<String> queue = new ConcurrentLinkedQueue<String>();
            Runtime.getRuntime().addShutdownHook(new Thread("FileUtil deleteOnExit"){

                @Override
                public void run() {
                    String name2;
                    while ((name2 = (String)queue.poll()) != null) {
                        FileUtilRt.delete(new File(name2));
                    }
                }
            });
            ConcurrentLinkedQueue<String> concurrentLinkedQueue = queue;
            if (concurrentLinkedQueue == null) {
                FilesToDeleteHolder.$$$reportNull$$$0(0);
            }
            return concurrentLinkedQueue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/io/FileUtilRt$FilesToDeleteHolder", "createFilesToDelete"));
        }
    }

    private static final class NIOReflect {
        static final boolean IS_AVAILABLE;
        private static Method ourFilesDeleteIfExistsMethod;
        private static Method ourFilesWalkMethod;
        private static Method ourFileToPathMethod;
        private static Method ourPathToFileMethod;
        private static Method ourAttributesIsOtherMethod;
        private static Object ourDeletionVisitor;
        private static Class<?> ourNoSuchFileExceptionClass;
        private static Class<?> ourAccessDeniedExceptionClass;

        static Object toPath(File file2) throws InvocationTargetException, IllegalAccessException {
            return ourFileToPathMethod.invoke((Object)file2, new Object[0]);
        }

        static void deleteRecursively(Object path2) throws InvocationTargetException, IllegalAccessException {
            block2: {
                try {
                    ourFilesWalkMethod.invoke(null, path2, ourDeletionVisitor);
                }
                catch (InvocationTargetException e) {
                    if (ourNoSuchFileExceptionClass.isInstance(e.getCause())) break block2;
                    throw e;
                }
            }
        }

        static {
            boolean initSuccess = false;
            try {
                Class<?> pathClass = Class.forName("java.nio.file.Path");
                Class<?> visitorClass = Class.forName("java.nio.file.FileVisitor");
                Class<?> filesClass = Class.forName("java.nio.file.Files");
                ourNoSuchFileExceptionClass = Class.forName("java.nio.file.NoSuchFileException");
                ourAccessDeniedExceptionClass = Class.forName("java.nio.file.AccessDeniedException");
                ourFileToPathMethod = Class.forName("java.io.File").getMethod("toPath", new Class[0]);
                ourPathToFileMethod = pathClass.getMethod("toFile", new Class[0]);
                ourFilesWalkMethod = filesClass.getMethod("walkFileTree", pathClass, visitorClass);
                ourAttributesIsOtherMethod = Class.forName("java.nio.file.attribute.BasicFileAttributes").getDeclaredMethod("isOther", new Class[0]);
                ourFilesDeleteIfExistsMethod = filesClass.getMethod("deleteIfExists", pathClass);
                final Object Result_Continue = Class.forName("java.nio.file.FileVisitResult").getDeclaredField("CONTINUE").get(null);
                final Object Result_Skip = Class.forName("java.nio.file.FileVisitResult").getDeclaredField("SKIP_SUBTREE").get(null);
                ourDeletionVisitor = Proxy.newProxyInstance(FileUtilRt.class.getClassLoader(), new Class[]{visitorClass}, new InvocationHandler(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
                        if (args2.length != 2) return Result_Continue;
                        String methodName = method.getName();
                        Object second2 = args2[1];
                        if (second2 instanceof Throwable) {
                            if (!SystemInfoRt.isWindows || !"visitFileFailed".equals(methodName) || !ourNoSuchFileExceptionClass.isInstance(second2)) throw (Throwable)second2;
                            this.performDelete(args2[0]);
                            return Result_Continue;
                        }
                        if ("visitFile".equals(methodName) || "postVisitDirectory".equals(methodName)) {
                            this.performDelete(args2[0]);
                            return Result_Continue;
                        }
                        if (!SystemInfoRt.isWindows || !"preVisitDirectory".equals(methodName)) return Result_Continue;
                        boolean notDirectory = false;
                        try {
                            notDirectory = Boolean.TRUE.equals(ourAttributesIsOtherMethod.invoke(second2, new Object[0]));
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (!notDirectory) return Result_Continue;
                        this.performDelete(args2[0]);
                        return Result_Skip;
                    }

                    private void performDelete(final Object fileObject) throws IOException {
                        Boolean result2 = FileUtilRt.doIOOperation(new RepeatableIOOperation<Boolean, RuntimeException>(){

                            @Override
                            public Boolean execute(boolean lastAttempt) {
                                block8: {
                                    try {
                                        ourFilesDeleteIfExistsMethod.invoke(null, fileObject);
                                        return Boolean.TRUE;
                                    }
                                    catch (InvocationTargetException e) {
                                        Throwable cause = e.getCause();
                                        if (!(cause instanceof IOException)) {
                                            return Boolean.FALSE;
                                        }
                                        if (!ourAccessDeniedExceptionClass.isInstance(cause)) break block8;
                                        try {
                                            File file2 = (File)ourPathToFileMethod.invoke(fileObject, new Object[0]);
                                            if (file2 == null) {
                                                return Boolean.FALSE;
                                            }
                                            if (file2.delete() || !file2.exists()) {
                                                return Boolean.TRUE;
                                            }
                                        }
                                        catch (Throwable ignored) {
                                            return Boolean.FALSE;
                                        }
                                    }
                                    catch (IllegalAccessException e) {
                                        return Boolean.FALSE;
                                    }
                                }
                                return lastAttempt ? Boolean.FALSE : null;
                            }
                        });
                        if (!Boolean.TRUE.equals(result2)) {
                            throw new IOException("Failed to delete " + fileObject){

                                @Override
                                public synchronized Throwable fillInStackTrace() {
                                    return this;
                                }
                            };
                        }
                    }
                });
                initSuccess = true;
            }
            catch (Throwable ignored) {
                FileUtilRt.logger().info("Was not able to detect NIO API");
                ourFileToPathMethod = null;
                ourFilesWalkMethod = null;
                ourFilesDeleteIfExistsMethod = null;
                ourDeletionVisitor = null;
                ourNoSuchFileExceptionClass = null;
            }
            IS_AVAILABLE = initSuccess;
        }
    }

    protected static interface SymlinkResolver {
        @NotNull
        public String resolveSymlinksAndCanonicalize(@NotNull String var1, char var2, boolean var3);

        public boolean isSymlink(@NotNull CharSequence var1);
    }
}

