/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.inject.internal;

import org.jetbrains.kotlin.com.google.inject.Provider;
import org.jetbrains.kotlin.com.google.inject.internal.InjectorImpl;
import org.jetbrains.kotlin.com.google.inject.internal.InternalContext;
import org.jetbrains.kotlin.com.google.inject.internal.InternalFactory;
import org.jetbrains.kotlin.com.google.inject.internal.InternalProvisionException;

final class ProviderToInternalFactoryAdapter<T>
implements Provider<T> {
    private final InjectorImpl injector;
    private final InternalFactory<? extends T> internalFactory;

    public ProviderToInternalFactoryAdapter(InjectorImpl injector, InternalFactory<? extends T> internalFactory) {
        this.injector = injector;
        this.internalFactory = internalFactory;
    }

    @Override
    public T get() {
        InternalContext context2 = this.injector.enterContext();
        try {
            T t;
            T t2 = t = this.internalFactory.get(context2, context2.getDependency(), true);
            return t2;
        }
        catch (InternalProvisionException e) {
            throw e.toProvisionException();
        }
        finally {
            context2.close();
        }
    }

    InjectorImpl getInjector() {
        return this.injector;
    }

    public String toString() {
        return this.internalFactory.toString();
    }
}

