/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.inject;

import java.lang.annotation.Annotation;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.inject.Binder;
import org.jetbrains.kotlin.com.google.inject.Binding;
import org.jetbrains.kotlin.com.google.inject.Key;
import org.jetbrains.kotlin.com.google.inject.MembersInjector;
import org.jetbrains.kotlin.com.google.inject.Module;
import org.jetbrains.kotlin.com.google.inject.PrivateBinder;
import org.jetbrains.kotlin.com.google.inject.Provider;
import org.jetbrains.kotlin.com.google.inject.Scope;
import org.jetbrains.kotlin.com.google.inject.Stage;
import org.jetbrains.kotlin.com.google.inject.TypeLiteral;
import org.jetbrains.kotlin.com.google.inject.binder.AnnotatedBindingBuilder;
import org.jetbrains.kotlin.com.google.inject.binder.AnnotatedConstantBindingBuilder;
import org.jetbrains.kotlin.com.google.inject.binder.AnnotatedElementBuilder;
import org.jetbrains.kotlin.com.google.inject.binder.LinkedBindingBuilder;
import org.jetbrains.kotlin.com.google.inject.matcher.Matcher;
import org.jetbrains.kotlin.com.google.inject.spi.Message;
import org.jetbrains.kotlin.com.google.inject.spi.ProvisionListener;
import org.jetbrains.kotlin.com.google.inject.spi.TypeConverter;
import org.jetbrains.kotlin.com.google.inject.spi.TypeListener;

public abstract class PrivateModule
implements Module {
    private PrivateBinder binder;

    @Override
    public final synchronized void configure(Binder binder) {
        Preconditions.checkState(this.binder == null, "Re-entry is not allowed.");
        this.binder = (PrivateBinder)binder.skipSources(PrivateModule.class);
        try {
            this.configure();
        }
        finally {
            this.binder = null;
        }
    }

    protected abstract void configure();

    protected final <T> void expose(Key<T> key) {
        this.binder().expose(key);
    }

    protected final AnnotatedElementBuilder expose(Class<?> type2) {
        return this.binder().expose(type2);
    }

    protected final AnnotatedElementBuilder expose(TypeLiteral<?> type2) {
        return this.binder().expose(type2);
    }

    protected final PrivateBinder binder() {
        Preconditions.checkState(this.binder != null, "The binder can only be used inside configure()");
        return this.binder;
    }

    protected final void bindScope(Class<? extends Annotation> scopeAnnotation, Scope scope2) {
        this.binder().bindScope(scopeAnnotation, scope2);
    }

    protected final <T> LinkedBindingBuilder<T> bind(Key<T> key) {
        return this.binder().bind(key);
    }

    protected final <T> AnnotatedBindingBuilder<T> bind(TypeLiteral<T> typeLiteral) {
        return this.binder().bind(typeLiteral);
    }

    protected final <T> AnnotatedBindingBuilder<T> bind(Class<T> clazz) {
        return this.binder().bind(clazz);
    }

    protected final AnnotatedConstantBindingBuilder bindConstant() {
        return this.binder().bindConstant();
    }

    protected final void install(Module module2) {
        this.binder().install(module2);
    }

    protected final void addError(String message2, Object ... arguments2) {
        this.binder().addError(message2, arguments2);
    }

    protected final void addError(Throwable t) {
        this.binder().addError(t);
    }

    protected final void addError(Message message2) {
        this.binder().addError(message2);
    }

    protected final void requestInjection(Object instance) {
        this.binder().requestInjection(instance);
    }

    protected final void requestStaticInjection(Class<?> ... types2) {
        this.binder().requestStaticInjection(types2);
    }

    protected final void requireBinding(Key<?> key) {
        this.binder().getProvider(key);
    }

    protected final void requireBinding(Class<?> type2) {
        this.binder().getProvider(type2);
    }

    protected final <T> Provider<T> getProvider(Key<T> key) {
        return this.binder().getProvider(key);
    }

    protected final <T> Provider<T> getProvider(Class<T> type2) {
        return this.binder().getProvider(type2);
    }

    protected final void convertToTypes(Matcher<? super TypeLiteral<?>> typeMatcher, TypeConverter converter) {
        this.binder().convertToTypes(typeMatcher, converter);
    }

    protected final Stage currentStage() {
        return this.binder().currentStage();
    }

    protected <T> MembersInjector<T> getMembersInjector(Class<T> type2) {
        return this.binder().getMembersInjector(type2);
    }

    protected <T> MembersInjector<T> getMembersInjector(TypeLiteral<T> type2) {
        return this.binder().getMembersInjector(type2);
    }

    protected void bindListener(Matcher<? super TypeLiteral<?>> typeMatcher, TypeListener listener) {
        this.binder().bindListener(typeMatcher, listener);
    }

    protected void bindListener(Matcher<? super Binding<?>> bindingMatcher, ProvisionListener ... listeners) {
        this.binder().bindListener(bindingMatcher, listeners);
    }
}

