/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TFloatHashingStrategy;
import gnu.trove.TFloatObjectIterator;
import gnu.trove.TFloatObjectProcedure;
import gnu.trove.TFloatProcedure;
import gnu.trove.THash;
import gnu.trove.TObjectFunction;
import gnu.trove.TObjectHash;
import gnu.trove.TObjectProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TFloatObjectHashMap<V>
extends THash
implements TFloatHashingStrategy {
    protected transient V[] _values;
    protected transient float[] _set;
    protected final TFloatHashingStrategy _hashingStrategy;

    public TFloatObjectHashMap() {
        this._hashingStrategy = this;
    }

    public TFloatObjectHashMap(int initialCapacity) {
        super(initialCapacity);
        this._hashingStrategy = this;
    }

    public TFloatObjectHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = this;
    }

    public TFloatObjectHashMap(TFloatHashingStrategy strategy) {
        this._hashingStrategy = strategy;
    }

    public TFloatObjectHashMap(int initialCapacity, TFloatHashingStrategy strategy) {
        super(initialCapacity);
        this._hashingStrategy = strategy;
    }

    public TFloatObjectHashMap(int initialCapacity, float loadFactor, TFloatHashingStrategy strategy) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = strategy;
    }

    @Override
    public TFloatObjectHashMap<V> clone() {
        TFloatObjectHashMap m = (TFloatObjectHashMap)super.clone();
        m._values = this._values == EMPTY_OBJECT_ARRAY ? EMPTY_OBJECT_ARRAY : (Object[])this._values.clone();
        m._set = this._values == EMPTY_OBJECT_ARRAY ? null : (float[])this._set.clone();
        return m;
    }

    public TFloatObjectIterator<V> iterator() {
        return new TFloatObjectIterator(this);
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = initialCapacity == -1 ? EMPTY_OBJECT_ARRAY : new Object[capacity];
        this._set = initialCapacity == -1 ? null : new float[capacity];
        return capacity;
    }

    public boolean contains(float val) {
        return this.index(val) >= 0;
    }

    @Override
    protected int capacity() {
        return this._values.length;
    }

    public boolean forEach(TFloatProcedure procedure) {
        float[] set = this._set;
        Object[] values2 = this._values;
        int i = values2.length;
        while (i-- > 0) {
            if (!TFloatObjectHashMap.isFull(values2, i) || procedure.execute(set[i])) continue;
            return false;
        }
        return true;
    }

    public V put(float key, V value2) {
        boolean wasFree = false;
        V previous = null;
        int index2 = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index2 < 0) {
            index2 = -index2 - 1;
            previous = TFloatObjectHashMap.unwrapNull(this._values[index2]);
            isNewMapping = false;
        } else {
            wasFree = TFloatObjectHashMap.isFree(this._values, index2);
        }
        this._set[index2] = key;
        this._values[index2] = TFloatObjectHashMap.wrapNull(value2);
        if (isNewMapping) {
            this.postInsertHook(wasFree);
        }
        return previous;
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this.capacity();
        float[] oldKeys = this._set;
        Object[] oldVals = this._values;
        this._set = new float[newCapacity];
        this._values = new Object[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (!TFloatObjectHashMap.isFull(oldVals, i)) continue;
            float o = oldKeys[i];
            int index2 = this.insertionIndex(o);
            this._set[index2] = o;
            this._values[index2] = oldVals[i];
        }
    }

    public V get(float key) {
        int index2 = this.index(key);
        return index2 < 0 ? null : (V)TFloatObjectHashMap.unwrapNull(this._values[index2]);
    }

    private static <V> V unwrapNull(V value2) {
        return value2 == TObjectHash.NULL ? null : (V)value2;
    }

    private static <V> V wrapNull(V value2) {
        return (V)(value2 == null ? TObjectHash.NULL : value2);
    }

    @Override
    public void clear() {
        super.clear();
        float[] keys2 = this._set;
        V[] values2 = this._values;
        int i = values2.length;
        while (i-- > 0) {
            keys2[i] = 0.0f;
            values2[i] = null;
        }
    }

    public V remove(float key) {
        V prev = null;
        int index2 = this.index(key);
        if (index2 >= 0) {
            prev = TFloatObjectHashMap.unwrapNull(this._values[index2]);
            this.removeAt(index2);
        }
        return prev;
    }

    protected int index(float val) {
        float[] set = this._set;
        Object[] values2 = this._values;
        if (values2 == EMPTY_OBJECT_ARRAY) {
            return -1;
        }
        int length = set.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index2 = hash % length;
        if (!TFloatObjectHashMap.isFree(values2, index2) && (TFloatObjectHashMap.isRemoved(values2, index2) || set[index2] != val)) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index2 -= probe) >= 0) continue;
                index2 += length;
            } while (!TFloatObjectHashMap.isFree(values2, index2) && (TFloatObjectHashMap.isRemoved(values2, index2) || set[index2] != val));
        }
        return TFloatObjectHashMap.isFree(values2, index2) ? -1 : index2;
    }

    protected int insertionIndex(float val) {
        int firstRemoved;
        if (this._values == EMPTY_OBJECT_ARRAY) {
            this.setUp(6);
        }
        Object[] values2 = this._values;
        float[] set = this._set;
        int length = set.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index2 = hash % length;
        if (TFloatObjectHashMap.isFree(values2, index2)) {
            return index2;
        }
        if (TFloatObjectHashMap.isFull(values2, index2) && set[index2] == val) {
            return -index2 - 1;
        }
        int probe = 1 + hash % (length - 2);
        int n = firstRemoved = TFloatObjectHashMap.isRemoved(values2, index2) ? index2 : -1;
        do {
            if ((index2 -= probe) < 0) {
                index2 += length;
            }
            if (firstRemoved != -1 || !TFloatObjectHashMap.isRemoved(values2, index2)) continue;
            firstRemoved = index2;
        } while (TFloatObjectHashMap.isFull(values2, index2) && set[index2] != val);
        if (TFloatObjectHashMap.isRemoved(values2, index2)) {
            while (!TFloatObjectHashMap.isFree(values2, index2) && (TFloatObjectHashMap.isRemoved(values2, index2) || set[index2] != val)) {
                if ((index2 -= probe) >= 0) continue;
                index2 += length;
            }
        }
        if (TFloatObjectHashMap.isFull(values2, index2)) {
            return -index2 - 1;
        }
        return firstRemoved == -1 ? index2 : firstRemoved;
    }

    static boolean isFull(Object[] values2, int index2) {
        Object value2 = values2[index2];
        return value2 != null && value2 != TObjectHash.REMOVED;
    }

    private static boolean isRemoved(Object[] values2, int index2) {
        return values2[index2] == TObjectHash.REMOVED;
    }

    private static boolean isFree(Object[] values2, int index2) {
        return values2[index2] == null;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TFloatObjectHashMap)) {
            return false;
        }
        TFloatObjectHashMap that = (TFloatObjectHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEachEntry(p);
        return p.getHashCode();
    }

    @Override
    protected void removeAt(int index2) {
        this._values[index2] = TObjectHash.REMOVED;
        super.removeAt(index2);
    }

    public Object[] getValues() {
        Object[] vals = new Object[this.size()];
        Object[] values2 = this._values;
        int i = values2.length;
        int j = 0;
        while (i-- > 0) {
            if (!TFloatObjectHashMap.isFull(values2, i)) continue;
            vals[j++] = TFloatObjectHashMap.unwrapNull(values2[i]);
        }
        return vals;
    }

    public float[] keys() {
        float[] keys2 = new float[this.size()];
        float[] k = this._set;
        Object[] values2 = this._values;
        int i = values2.length;
        int j = 0;
        while (i-- > 0) {
            if (!TFloatObjectHashMap.isFull(values2, i)) continue;
            keys2[j++] = k[i];
        }
        return keys2;
    }

    public boolean containsValue(V val) {
        Object[] values2 = this._values;
        if (null == val) {
            int i = values2.length;
            while (i-- > 0) {
                if (TObjectHash.NULL != values2[i]) continue;
                return true;
            }
        } else {
            int i = values2.length;
            while (i-- > 0) {
                V value2 = TFloatObjectHashMap.unwrapNull(values2[i]);
                if (!TFloatObjectHashMap.isFull(values2, i) || val != value2 && !val.equals(value2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(float key) {
        return this.contains(key);
    }

    public boolean forEachKey(TFloatProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TObjectProcedure<V> procedure) {
        Object[] values2 = this._values;
        int i = values2.length;
        while (i-- > 0) {
            if (!TFloatObjectHashMap.isFull(values2, i) || procedure.execute(TFloatObjectHashMap.unwrapNull(values2[i]))) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TFloatObjectProcedure<V> procedure) {
        float[] keys2 = this._set;
        Object[] values2 = this._values;
        int i = values2.length;
        while (i-- > 0) {
            if (!TFloatObjectHashMap.isFull(values2, i) || procedure.execute(keys2[i], TFloatObjectHashMap.unwrapNull(values2[i]))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainEntries(TFloatObjectProcedure<V> procedure) {
        boolean modified = false;
        float[] keys2 = this._set;
        Object[] values2 = this._values;
        this.stopCompactingOnRemove();
        try {
            int i = values2.length;
            while (i-- > 0) {
                if (!TFloatObjectHashMap.isFull(values2, i) || procedure.execute(keys2[i], TFloatObjectHashMap.unwrapNull(values2[i]))) continue;
                this.removeAt(i);
                modified = true;
            }
        }
        finally {
            this.startCompactingOnRemove(modified);
        }
        return modified;
    }

    public void transformValues(TObjectFunction<V, V> function2) {
        Object[] values2 = this._values;
        int i = values2.length;
        while (i-- > 0) {
            if (!TFloatObjectHashMap.isFull(values2, i)) continue;
            values2[i] = TFloatObjectHashMap.wrapNull(function2.execute(TFloatObjectHashMap.unwrapNull(values2[i])));
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            float key = stream.readFloat();
            Object val = stream.readObject();
            this.put(key, val);
        }
    }

    @Override
    public final int computeHashCode(float val) {
        return HashFunctions.hash(val);
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        this.forEachEntry(new TFloatObjectProcedure<V>(){

            @Override
            public boolean execute(float key, V value2) {
                if (sb.length() != 0) {
                    sb.append(',').append(' ');
                }
                sb.append(key);
                sb.append('=');
                sb.append((Object)(value2 == this ? "(this Map)" : value2));
                return true;
            }
        });
        sb.append('}');
        sb.insert(0, '{');
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EqProcedure<V>
    implements TFloatObjectProcedure<V> {
        private final TFloatObjectHashMap<V> _otherMap;

        EqProcedure(TFloatObjectHashMap<V> otherMap) {
            this._otherMap = otherMap;
        }

        @Override
        public final boolean execute(float key, V value2) {
            int index2 = this._otherMap.index(key);
            return index2 >= 0 && EqProcedure.eq(value2, this._otherMap.get(key));
        }

        private static boolean eq(Object o1, Object o2) {
            return o1 == o2 || o1 != null && o1.equals(o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class HashProcedure
    implements TFloatObjectProcedure<V> {
        private int h;

        HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        @Override
        public final boolean execute(float key, V value2) {
            this.h += TFloatObjectHashMap.this._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value2);
            return true;
        }
    }
}

