/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.plexus.components.cipher;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.sonatype.plexus.components.cipher.Base64;
import org.sonatype.plexus.components.cipher.PlexusCipherException;

public class PBECipher {
    protected static final String STRING_ENCODING = "UTF8";
    protected static final int SPICE_SIZE = 16;
    protected static final int SALT_SIZE = 8;
    protected static final int CHUNK_SIZE = 16;
    protected static final byte WIPER = 0;
    protected static final String DIGEST_ALG = "SHA-256";
    protected static final String KEY_ALG = "AES";
    protected static final String CIPHER_ALG = "AES/CBC/PKCS5Padding";
    protected static int PBE_ITERATIONS = 1000;
    protected MessageDigest _digester;
    protected SecureRandom _secureRandom;
    protected boolean _onLinux = false;

    public PBECipher() throws PlexusCipherException {
        try {
            this._digester = MessageDigest.getInstance(DIGEST_ALG);
            if (System.getProperty("os.name", "blah").toLowerCase().indexOf("linux") != -1) {
                this._onLinux = true;
            }
            if (this._onLinux) {
                System.setProperty("securerandom.source", "file:/dev/./urandom");
            } else {
                this._secureRandom = new SecureRandom();
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new PlexusCipherException(e);
        }
    }

    private byte[] getSalt(int sz) throws NoSuchAlgorithmException, NoSuchProviderException {
        byte[] res2 = null;
        if (this._secureRandom != null) {
            this._secureRandom.setSeed(System.currentTimeMillis());
            res2 = this._secureRandom.generateSeed(sz);
        } else {
            res2 = new byte[sz];
            Random r = new Random(System.currentTimeMillis());
            r.nextBytes(res2);
        }
        return res2;
    }

    public String encrypt64(String clearText, String password) throws PlexusCipherException {
        try {
            byte[] clearBytes = clearText.getBytes();
            byte[] salt = this.getSalt(8);
            if (this._secureRandom != null) {
                new SecureRandom().nextBytes(salt);
            }
            Cipher cipher = this.createCipher(password.getBytes(STRING_ENCODING), salt, 1);
            byte[] encryptedBytes = cipher.doFinal(clearBytes);
            int len = encryptedBytes.length;
            byte padLen = (byte)(16 - (8 + len + 1) % 16);
            int totalLen = 8 + len + padLen + 1;
            byte[] allEncryptedBytes = this.getSalt(totalLen);
            System.arraycopy(salt, 0, allEncryptedBytes, 0, 8);
            allEncryptedBytes[8] = padLen;
            System.arraycopy(encryptedBytes, 0, allEncryptedBytes, 9, len);
            byte[] encryptedTextBytes = Base64.encodeBase64(allEncryptedBytes);
            String encryptedText = new String(encryptedTextBytes, STRING_ENCODING);
            return encryptedText;
        }
        catch (Exception e) {
            throw new PlexusCipherException(e);
        }
    }

    public String decrypt64(String encryptedText, String password) throws PlexusCipherException {
        try {
            byte[] allEncryptedBytes = Base64.decodeBase64(encryptedText.getBytes());
            int totalLen = allEncryptedBytes.length;
            byte[] salt = new byte[8];
            System.arraycopy(allEncryptedBytes, 0, salt, 0, 8);
            byte padLen = allEncryptedBytes[8];
            byte[] encryptedBytes = new byte[totalLen - 8 - 1 - padLen];
            System.arraycopy(allEncryptedBytes, 9, encryptedBytes, 0, encryptedBytes.length);
            Cipher cipher = this.createCipher(password.getBytes(STRING_ENCODING), salt, 2);
            byte[] clearBytes = cipher.doFinal(encryptedBytes);
            String clearText = new String(clearBytes, STRING_ENCODING);
            return clearText;
        }
        catch (Exception e) {
            throw new PlexusCipherException(e);
        }
    }

    private Cipher createCipher(byte[] pwdAsBytes, byte[] salt, int mode) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        this._digester.reset();
        byte[] keyAndIv = new byte[32];
        if (salt == null || salt.length == 0) {
            salt = null;
        }
        int currentPos = 0;
        while (currentPos < keyAndIv.length) {
            int stillNeed;
            byte[] result2;
            this._digester.update(pwdAsBytes);
            if (salt != null) {
                this._digester.update(salt, 0, 8);
            }
            if ((result2 = this._digester.digest()).length > (stillNeed = keyAndIv.length - currentPos)) {
                byte[] b = new byte[stillNeed];
                System.arraycopy(result2, 0, b, 0, b.length);
                result2 = b;
            }
            System.arraycopy(result2, 0, keyAndIv, currentPos, result2.length);
            if ((currentPos += result2.length) >= keyAndIv.length) continue;
            this._digester.reset();
            this._digester.update(result2);
        }
        byte[] key = new byte[16];
        byte[] iv = new byte[16];
        System.arraycopy(keyAndIv, 0, key, 0, key.length);
        System.arraycopy(keyAndIv, key.length, iv, 0, iv.length);
        Cipher cipher = Cipher.getInstance(CIPHER_ALG);
        cipher.init(mode, (Key)new SecretKeySpec(key, KEY_ALG), new IvParameterSpec(iv));
        return cipher;
    }
}

