/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModalityUtilsKt;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.load.java.DescriptorsJvmAbiUtil;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.jvm.InlineClassManglingRulesKt;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.checkers.DeclarationCheckersKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u000f\u001a\u00020\f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010\u0013\u001a\u00020\f*\u00020\u0014H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmFieldApplicabilityChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "isInterfaceCompanionWithPublicJvmFieldProperties", "", "companionObject", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "hasBackingField", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "hasCustomAccessor", "Lorg/jetbrains/kotlin/psi/KtProperty;", "Problem", "frontend.java"})
public final class JvmFieldApplicabilityChecker
implements DeclarationChecker {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Problem problem;
        AnnotationDescriptor annotationDescriptor;
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (!(descriptor2 instanceof PropertyDescriptor)) return;
        if (!(declaration2 instanceof KtProperty)) {
            return;
        }
        AnnotationDescriptor annotationDescriptor2 = JvmAnnotationUtilKt.findJvmFieldAnnotation(descriptor2);
        if (annotationDescriptor2 == null) {
            object2 = ((PropertyDescriptor)descriptor2).getDelegateField();
            if (object2 == null) {
                return;
            }
            Annotations annotations2 = object2.getAnnotations();
            if (annotations2 == null) {
                return;
            }
            Object object3 = object = annotations2.findAnnotation(JvmAbi.JVM_FIELD_ANNOTATION_FQ_NAME);
            if (object == null) {
                return;
            }
            annotationDescriptor = object;
        } else {
            annotationDescriptor = annotationDescriptor2;
        }
        AnnotationDescriptor annotation2 = annotationDescriptor;
        if (((KtProperty)declaration2).hasDelegate()) {
            problem = Problem.DELEGATE;
        } else {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor2;
            object = context2.getTrace().getBindingContext();
            Intrinsics.checkNotNullExpressionValue(object, "context.trace.bindingContext");
            if (!this.hasBackingField(propertyDescriptor, (BindingContext)object)) {
                return;
            }
            if (ModalityUtilsKt.isOverridable((CallableMemberDescriptor)descriptor2)) {
                problem = Problem.NOT_FINAL;
            } else if (DescriptorVisibilities.isPrivate(((PropertyDescriptor)descriptor2).getVisibility())) {
                problem = Problem.PRIVATE;
            } else if (this.hasCustomAccessor((KtProperty)declaration2)) {
                problem = Problem.CUSTOM_ACCESSOR;
            } else {
                object = ((PropertyDescriptor)descriptor2).getOverriddenDescriptors();
                Intrinsics.checkNotNullExpressionValue(object, "descriptor.overriddenDescriptors");
                boolean bl = false;
                if (!object.isEmpty()) {
                    problem = Problem.OVERRIDES;
                } else if (((PropertyDescriptor)descriptor2).isLateInit()) {
                    problem = Problem.LATEINIT;
                } else if (((PropertyDescriptor)descriptor2).isConst()) {
                    problem = Problem.CONST;
                } else if (DeclarationCheckersKt.isInsideCompanionObjectOfInterface((CallableMemberDescriptor)descriptor2)) {
                    if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.JvmFieldInInterface)) {
                        problem = Problem.INSIDE_COMPANION_OF_INTERFACE;
                    } else {
                        if (this.isInterfaceCompanionWithPublicJvmFieldProperties((ClassDescriptor)((PropertyDescriptor)descriptor2).getContainingDeclaration())) return;
                        problem = Problem.NOT_PUBLIC_VAL_WITH_JVMFIELD;
                    }
                } else if (DescriptorUtils.isTopLevelDeclaration(descriptor2) && JvmFileClassUtilKt.isInsideJvmMultifileClassFile(declaration2)) {
                    problem = Problem.TOP_LEVEL_PROPERTY_OF_MULTIFILE_FACADE;
                } else {
                    object = ((PropertyDescriptor)descriptor2).getReturnType();
                    if (!Intrinsics.areEqual(object == null ? null : Boolean.valueOf(InlineClassManglingRulesKt.isInlineClassThatRequiresMangling((KotlinType)object)), true)) return;
                    problem = Problem.RETURN_TYPE_IS_INLINE_CLASS;
                }
            }
        }
        Problem problem2 = problem;
        object2 = DescriptorToSourceUtils.getSourceFromAnnotation(annotation2);
        if (object2 == null) {
            return;
        }
        Object annotationEntry = object2;
        context2.getTrace().report(ErrorsJvm.INAPPLICABLE_JVM_FIELD.on((KtAnnotationEntry)((PsiElement)annotationEntry), problem2.getErrorMessage()));
    }

    private final boolean isInterfaceCompanionWithPublicJvmFieldProperties(ClassDescriptor companionObject) {
        for (DeclarationDescriptor next : companionObject.getUnsubstitutedMemberScope().getContributedDescriptors(DescriptorKindFilter.VARIABLES, MemberScope.Companion.getALL_NAME_FILTER())) {
            if (!(next instanceof PropertyDescriptor)) continue;
            if (!Intrinsics.areEqual(((PropertyDescriptor)next).getVisibility(), DescriptorVisibilities.PUBLIC) || ((PropertyDescriptor)next).isVar() || ((PropertyDescriptor)next).getModality() != Modality.FINAL) {
                return false;
            }
            if (DescriptorsJvmAbiUtil.hasJvmFieldAnnotation((CallableMemberDescriptor)next)) continue;
            return false;
        }
        return true;
    }

    private final boolean hasCustomAccessor(KtProperty $this$hasCustomAccessor) {
        return $this$hasCustomAccessor.getGetter() != null || $this$hasCustomAccessor.getSetter() != null;
    }

    private final boolean hasBackingField(PropertyDescriptor $this$hasBackingField, BindingContext bindingContext) {
        Boolean bl = (Boolean)bindingContext.get(BindingContext.BACKING_FIELD_REQUIRED, $this$hasBackingField);
        Boolean bl2 = bl == null ? Boolean.valueOf(false) : bl;
        return bl2;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmFieldApplicabilityChecker$Problem;", "", "errorMessage", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getErrorMessage", "()Ljava/lang/String;", "NOT_FINAL", "PRIVATE", "CUSTOM_ACCESSOR", "OVERRIDES", "LATEINIT", "CONST", "INSIDE_COMPANION_OF_INTERFACE", "NOT_PUBLIC_VAL_WITH_JVMFIELD", "TOP_LEVEL_PROPERTY_OF_MULTIFILE_FACADE", "DELEGATE", "RETURN_TYPE_IS_INLINE_CLASS", "frontend.java"})
    public static final class Problem
    extends Enum<Problem> {
        @NotNull
        private final String errorMessage;
        public static final /* enum */ Problem NOT_FINAL = new Problem("JvmField can only be applied to final property");
        public static final /* enum */ Problem PRIVATE = new Problem("JvmField has no effect on a private property");
        public static final /* enum */ Problem CUSTOM_ACCESSOR = new Problem("JvmField cannot be applied to a property with a custom accessor");
        public static final /* enum */ Problem OVERRIDES = new Problem("JvmField cannot be applied to a property that overrides some other property");
        public static final /* enum */ Problem LATEINIT = new Problem("JvmField cannot be applied to lateinit property");
        public static final /* enum */ Problem CONST = new Problem("JvmField cannot be applied to const property");
        public static final /* enum */ Problem INSIDE_COMPANION_OF_INTERFACE = new Problem("JvmField cannot be applied to a property defined in companion object of interface");
        public static final /* enum */ Problem NOT_PUBLIC_VAL_WITH_JVMFIELD = new Problem("JvmField could be applied only if all interface companion properties are 'public final val' with '@JvmField' annotation");
        public static final /* enum */ Problem TOP_LEVEL_PROPERTY_OF_MULTIFILE_FACADE = new Problem(Intrinsics.stringPlus("JvmField cannot be applied to top level property of a file annotated with ", JvmFileClassUtil.INSTANCE.getJVM_MULTIFILE_CLASS_SHORT()));
        public static final /* enum */ Problem DELEGATE = new Problem("JvmField cannot be applied to delegated property");
        public static final /* enum */ Problem RETURN_TYPE_IS_INLINE_CLASS = new Problem("JvmField cannot be applied to a property of an inline class type");
        private static final /* synthetic */ Problem[] $VALUES;

        private Problem(String errorMessage2) {
            this.errorMessage = errorMessage2;
        }

        @NotNull
        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public static Problem[] values() {
            Problem[] problemArray = $VALUES;
            Problem[] problemArray2 = new Problem[problemArray.length];
            System.arraycopy(problemArray, 0, problemArray2, 0, problemArray.length);
            return problemArray2;
        }

        public static Problem valueOf(String value2) {
            Intrinsics.checkNotNullParameter(value2, "value");
            return Enum.valueOf(Problem.class, value2);
        }

        static {
            Problem[] problemArray = new Problem[]{NOT_FINAL, PRIVATE, CUSTOM_ACCESSOR, OVERRIDES, LATEINIT, CONST, INSIDE_COMPANION_OF_INTERFACE, NOT_PUBLIC_VAL_WITH_JVMFIELD, TOP_LEVEL_PROPERTY_OF_MULTIFILE_FACADE, DELEGATE, RETURN_TYPE_IS_INLINE_CLASS};
            $VALUES = problemArray;
        }
    }
}

