/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.name;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0003J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0007J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/name/NameUtils;", "", "()V", "SANITIZE_AS_JAVA_INVALID_CHARACTERS", "Lkotlin/text/Regex;", "capitalizeAsJavaClassName", "", "str", "getPackagePartClassNamePrefix", "shortFileName", "getScriptNameForFile", "Lorg/jetbrains/kotlin/name/Name;", "filePath", "hasName", "", "name", "sanitizeAsJavaIdentifier", "compiler.common"})
public final class NameUtils {
    @NotNull
    public static final NameUtils INSTANCE = new NameUtils();
    @NotNull
    private static final Regex SANITIZE_AS_JAVA_INVALID_CHARACTERS;

    private NameUtils() {
    }

    @JvmStatic
    @NotNull
    public static final String sanitizeAsJavaIdentifier(@NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        return SANITIZE_AS_JAVA_INVALID_CHARACTERS.replace((CharSequence)name2, "_");
    }

    @JvmStatic
    @NotNull
    public static final String getPackagePartClassNamePrefix(@NotNull String shortFileName) {
        Intrinsics.checkNotNullParameter(shortFileName, "shortFileName");
        CharSequence charSequence = shortFileName;
        boolean bl = false;
        return charSequence.length() == 0 ? "_" : NameUtils.capitalizeAsJavaClassName(NameUtils.sanitizeAsJavaIdentifier(shortFileName));
    }

    @JvmStatic
    private static final String capitalizeAsJavaClassName(String str) {
        String string2;
        if (Character.isJavaIdentifierStart(str.charAt(0))) {
            String string3 = str;
            int n = 0;
            int n2 = 1;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue(string5, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string3 = string5;
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue(locale, "ENGLISH");
            n2 = 0;
            String string6 = string3;
            boolean bl2 = false;
            String string7 = string6;
            if (string7 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string8 = string7.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue(string8, "(this as java.lang.String).toUpperCase(locale)");
            string3 = str;
            int n3 = 1;
            n2 = 0;
            String string9 = string3;
            if (string9 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string10 = string9.substring(n3);
            Intrinsics.checkNotNullExpressionValue(string10, "(this as java.lang.String).substring(startIndex)");
            string2 = Intrinsics.stringPlus(string8, string10);
        } else {
            string2 = Intrinsics.stringPlus("_", str);
        }
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final Name getScriptNameForFile(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter(filePath, "filePath");
        Name name2 = Name.identifier(NameUtils.getPackagePartClassNamePrefix(StringsKt.substringBeforeLast$default(StringsKt.substringAfterLast$default(filePath, '/', null, 2, null), '.', null, 2, null)));
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(NameUtils.getPackagePartClassNamePrefix(filePath.substringAfterLast('/').substringBeforeLast('.')))");
        return name2;
    }

    @JvmStatic
    public static final boolean hasName(@NotNull Name name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        return !Intrinsics.areEqual(name2, SpecialNames.NO_NAME_PROVIDED) && !Intrinsics.areEqual(name2, SpecialNames.ANONYMOUS_FUNCTION);
    }

    static {
        String string2 = "[^\\p{L}\\p{Digit}]";
        boolean bl = false;
        SANITIZE_AS_JAVA_INVALID_CHARACTERS = new Regex(string2);
    }
}

