/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptorImpl;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.descriptors.WrappedDeclarationDescriptor;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.ByteValue;
import org.jetbrains.kotlin.resolve.constants.CharValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.DoubleValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.FloatValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.ShortValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0006\u0010\u001a\u001a\u00020\u001bJ\f\u0010\u001c\u001a\u00020\u001d*\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 *\u00020!H\u0002R\u0012\u0010\u0005\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\f\u0010\nR$\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00028\u00008F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/ir/descriptors/WrappedDeclarationDescriptor;", "T", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithSource;", "()V", "_owner", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "annotations", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "getAnnotations", "()Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "annotationsFromOwner", "getAnnotationsFromOwner", "annotationsFromOwner$delegate", "Lkotlin/Lazy;", "value", "owner", "getOwner", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "setOwner", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)V", "bind", "", "declaration", "getSource", "Lorg/jetbrains/kotlin/descriptors/SourceElement;", "isBound", "", "toAnnotationDescriptor", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "toConstantValue", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "Lorg/jetbrains/kotlin/ir/IrElement;", "ir.tree"})
public abstract class WrappedDeclarationDescriptor<T extends IrDeclaration>
implements DeclarationDescriptorWithSource {
    @NotNull
    private final Lazy annotationsFromOwner$delegate = LazyKt.lazy((Function0)new Function0<Annotations>(this){
        final /* synthetic */ WrappedDeclarationDescriptor<T> this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Annotations invoke() {
            Collection<AnnotationDescriptor> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable<IrConstructorCall> iterable;
            T t = this.this$0.getOwner();
            Object object = t instanceof IrAnnotationContainer ? (IrAnnotationContainer)t : null;
            List<IrConstructorCall> list2 = iterable = object == null ? null : object.getAnnotations();
            if (iterable == null) {
                return Annotations.Companion.getEMPTY();
            }
            List<IrConstructorCall> ownerAnnotations = iterable;
            iterable = ownerAnnotations;
            object = this.this$0;
            Annotations.Companion companion = Annotations.Companion;
            boolean $i$f$map = false;
            void var5_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrConstructorCall irConstructorCall = (IrConstructorCall)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                AnnotationDescriptor annotationDescriptor = WrappedDeclarationDescriptor.access$toAnnotationDescriptor((WrappedDeclarationDescriptor)object, (IrConstructorCall)it);
                collection.add(annotationDescriptor);
            }
            collection = (List)destination$iv$iv;
            return companion.create((List<? extends AnnotationDescriptor>)collection);
        }
    });
    @Nullable
    private T _owner;

    @Override
    @NotNull
    public Annotations getAnnotations() {
        return this.getAnnotationsFromOwner();
    }

    @Override
    @NotNull
    public SourceElement getSource() {
        SourceElement sourceElement = SourceElement.NO_SOURCE;
        Intrinsics.checkNotNullExpressionValue(sourceElement, "NO_SOURCE");
        return sourceElement;
    }

    private final Annotations getAnnotationsFromOwner() {
        Lazy lazy = this.annotationsFromOwner$delegate;
        boolean bl = false;
        return (Annotations)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final AnnotationDescriptor toAnnotationDescriptor(IrConstructorCall $this$toAnnotationDescriptor) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Pair it;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        boolean bl = IrUtilsKt.isAnnotationClass(IrUtilsKt.getParentAsClass((IrDeclaration)$this$toAnnotationDescriptor.getSymbol().getOwner()));
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-WrappedDeclarationDescriptor$toAnnotationDescriptor$22 = false;
            String $i$a$-assert-WrappedDeclarationDescriptor$toAnnotationDescriptor$22 = Intrinsics.stringPlus("Expected call to constructor of annotation class but was: ", DumpIrTreeKt.dump$default($this$toAnnotationDescriptor, false, 1, null));
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-WrappedDeclarationDescriptor$toAnnotationDescriptor$22));
        }
        Iterable iterable = ((IrConstructor)$this$toAnnotationDescriptor.getSymbol().getOwner()).getValueParameters();
        KotlinType kotlinType = IrTypesKt.toKotlinType(IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass((IrDeclaration)$this$toAnnotationDescriptor.getSymbol().getOwner())));
        boolean $i$f$map = false;
        void $i$a$-assert-WrappedDeclarationDescriptor$toAnnotationDescriptor$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            object = destination$iv$iv;
            boolean bl3 = false;
            Pair<Name, IrExpression> pair = TuplesKt.to(it.getName(), $this$toAnnotationDescriptor.getValueArgument(((IrValueParameter)((Object)it)).getIndex()));
            object.add(pair);
        }
        object = (List)destination$iv$iv;
        $this$map$iv = (Iterable)object;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl4 = false;
            if (!(it.getSecond() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        object = (List)destination$iv$iv;
        $this$filter$iv = (Iterable)object;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv2;
            Pair it2 = (Pair)element$iv$iv;
            boolean bl5 = false;
            Object a = it2.getFirst();
            IrExpression irExpression = (IrExpression)it2.getSecond();
            Intrinsics.checkNotNull(irExpression);
            Pair pair = TuplesKt.to(a, this.toConstantValue(irExpression));
            boolean bl6 = false;
            map2.put(pair.getFirst(), pair.getSecond());
        }
        object = destination$iv$iv2;
        SourceElement sourceElement = SourceElement.NO_SOURCE;
        Object object2 = object;
        KotlinType kotlinType2 = kotlinType;
        return new AnnotationDescriptorImpl(kotlinType2, (Map<Name, ConstantValue<?>>)object2, sourceElement);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ConstantValue<?> toConstantValue(IrElement $this$toConstantValue) {
        ConstantValue constantValue;
        if ($this$toConstantValue instanceof IrConst) {
            IrConstKind irConstKind = ((IrConst)$this$toConstantValue).getKind();
            if (Intrinsics.areEqual(irConstKind, IrConstKind.Null.INSTANCE)) {
                constantValue = new NullValue();
                return constantValue;
            } else if (Intrinsics.areEqual(irConstKind, IrConstKind.Boolean.INSTANCE)) {
                Object t = ((IrConst)$this$toConstantValue).getValue();
                if (t == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                }
                constantValue = new BooleanValue((Boolean)t);
                return constantValue;
            } else if (Intrinsics.areEqual(irConstKind, IrConstKind.Char.INSTANCE)) {
                Object t = ((IrConst)$this$toConstantValue).getValue();
                if (t == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Char");
                }
                constantValue = new CharValue(((Character)t).charValue());
                return constantValue;
            } else if (Intrinsics.areEqual(irConstKind, IrConstKind.Byte.INSTANCE)) {
                Object t = ((IrConst)$this$toConstantValue).getValue();
                if (t == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                }
                constantValue = new ByteValue((Byte)t);
                return constantValue;
            } else if (Intrinsics.areEqual(irConstKind, IrConstKind.Short.INSTANCE)) {
                Object t = ((IrConst)$this$toConstantValue).getValue();
                if (t == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                }
                constantValue = new ShortValue((Short)t);
                return constantValue;
            } else if (Intrinsics.areEqual(irConstKind, IrConstKind.Int.INSTANCE)) {
                Object t = ((IrConst)$this$toConstantValue).getValue();
                if (t == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                constantValue = new IntValue((Integer)t);
                return constantValue;
            } else if (Intrinsics.areEqual(irConstKind, IrConstKind.Long.INSTANCE)) {
                Object t = ((IrConst)$this$toConstantValue).getValue();
                if (t == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                }
                constantValue = new LongValue((Long)t);
                return constantValue;
            } else if (Intrinsics.areEqual(irConstKind, IrConstKind.String.INSTANCE)) {
                Object t = ((IrConst)$this$toConstantValue).getValue();
                if (t == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                constantValue = new StringValue((String)t);
                return constantValue;
            } else if (Intrinsics.areEqual(irConstKind, IrConstKind.Float.INSTANCE)) {
                Object t = ((IrConst)$this$toConstantValue).getValue();
                if (t == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                }
                constantValue = new FloatValue(((Float)t).floatValue());
                return constantValue;
            } else {
                if (!Intrinsics.areEqual(irConstKind, IrConstKind.Double.INSTANCE)) throw new NoWhenBranchMatchedException();
                Object t = ((IrConst)$this$toConstantValue).getValue();
                if (t == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                }
                constantValue = new DoubleValue((Double)t);
            }
            return constantValue;
        } else if ($this$toConstantValue instanceof IrVararg) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((IrVararg)$this$toConstantValue).getElements();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrVarargElement irVarargElement = (IrVarargElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (it instanceof IrSpreadElement) {
                    String string2 = it + " is not expected";
                    boolean bl2 = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                ConstantValue<?> constantValue2 = this.toConstantValue((IrElement)it);
                collection.add(constantValue2);
            }
            List elements = (List)destination$iv$iv;
            constantValue = new ArrayValue(elements, toConstantValue.1.INSTANCE);
            return constantValue;
        } else if ($this$toConstantValue instanceof IrGetEnumValue) {
            ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)IrUtilsKt.getParentAsClass((IrDeclaration)((IrGetEnumValue)$this$toConstantValue).getSymbol().getOwner()).getDescriptor());
            Intrinsics.checkNotNull(classId);
            constantValue = new EnumValue(classId, ((IrEnumEntry)((IrGetEnumValue)$this$toConstantValue).getSymbol().getOwner()).getName());
            return constantValue;
        } else if ($this$toConstantValue instanceof IrClassReference) {
            ClassId classId = DescriptorUtilsKt.getClassId(IrTypesKt.getClassifierOrFail(((IrClassReference)$this$toConstantValue).getClassType()).getDescriptor());
            Intrinsics.checkNotNull(classId);
            constantValue = new KClassValue(classId, 0);
            return constantValue;
        } else if ($this$toConstantValue instanceof IrConstructorCall) {
            constantValue = new AnnotationValue(this.toAnnotationDescriptor((IrConstructorCall)$this$toConstantValue));
            return constantValue;
        } else {
            String string3 = $this$toConstantValue + " is not expected: " + DumpIrTreeKt.dump$default($this$toConstantValue, false, 1, null);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string3.toString());
        }
    }

    @NotNull
    public final T getOwner() {
        T t = this._owner;
        if (t == null) {
            String string2 = this + " is not bound";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return t;
    }

    private final void setOwner(T value2) {
        T t = this._owner;
        if (t != null) {
            T t2 = t;
            boolean bl = false;
            boolean bl2 = false;
            T it = t2;
            boolean bl3 = false;
            String string2 = this + " is already bound to " + DumpIrTreeKt.dump$default((IrElement)it, false, 1, null);
            boolean bl4 = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        this._owner = value2;
    }

    public final void bind(@NotNull T declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        this.setOwner(declaration2);
    }

    public final boolean isBound() {
        return this._owner != null;
    }

    public static final /* synthetic */ AnnotationDescriptor access$toAnnotationDescriptor(WrappedDeclarationDescriptor $this, IrConstructorCall $receiver) {
        return $this.toAnnotationDescriptor($receiver);
    }
}

