/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.ICReporter;
import org.jetbrains.kotlin.incremental.BuildDifference;
import org.jetbrains.kotlin.incremental.DirtyData;
import org.jetbrains.kotlin.incremental.LookupSymbol;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/incremental/BuildDiffsStorage;", "", "buildDiffs", "", "Lorg/jetbrains/kotlin/incremental/BuildDifference;", "(Ljava/util/List;)V", "getBuildDiffs", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "incremental-compilation-impl"})
public final class BuildDiffsStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<BuildDifference> buildDiffs;
    public static final int MAX_DIFFS_ENTRIES = 10;
    private static int CURRENT_VERSION;

    public BuildDiffsStorage(@NotNull List<BuildDifference> buildDiffs) {
        Intrinsics.checkNotNullParameter(buildDiffs, "buildDiffs");
        this.buildDiffs = buildDiffs;
    }

    @NotNull
    public final List<BuildDifference> getBuildDiffs() {
        return this.buildDiffs;
    }

    @NotNull
    public final List<BuildDifference> component1() {
        return this.buildDiffs;
    }

    @NotNull
    public final BuildDiffsStorage copy(@NotNull List<BuildDifference> buildDiffs) {
        Intrinsics.checkNotNullParameter(buildDiffs, "buildDiffs");
        return new BuildDiffsStorage(buildDiffs);
    }

    public static /* synthetic */ BuildDiffsStorage copy$default(BuildDiffsStorage buildDiffsStorage, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            list2 = buildDiffsStorage.buildDiffs;
        }
        return buildDiffsStorage.copy(list2);
    }

    @NotNull
    public String toString() {
        return "BuildDiffsStorage(buildDiffs=" + this.buildDiffs + ')';
    }

    public int hashCode() {
        return ((Object)this.buildDiffs).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BuildDiffsStorage)) {
            return false;
        }
        BuildDiffsStorage buildDiffsStorage = (BuildDiffsStorage)other;
        return Intrinsics.areEqual(this.buildDiffs, buildDiffsStorage.buildDiffs);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00132\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\f\u0010\u0017\u001a\u00020\r*\u00020\u0018H\u0002J\f\u0010\u0019\u001a\u00020\u001a*\u00020\u0018H\u0002J\u0014\u0010\u001b\u001a\u00020\u0015*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\rH\u0002J\u0014\u0010\u001e\u001a\u00020\u0015*\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001aH\u0002R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/incremental/BuildDiffsStorage$Companion;", "", "()V", "<set-?>", "", "CURRENT_VERSION", "getCURRENT_VERSION", "()I", "setCURRENT_VERSION", "(I)V", "MAX_DIFFS_ENTRIES", "readDiffsFromFile", "", "Lorg/jetbrains/kotlin/incremental/BuildDifference;", "file", "Ljava/io/File;", "reporter", "Lorg/jetbrains/kotlin/build/report/ICReporter;", "readFromFile", "Lorg/jetbrains/kotlin/incremental/BuildDiffsStorage;", "writeToFile", "", "storage", "readBuildDifference", "Ljava/io/ObjectInputStream;", "readDirtyData", "Lorg/jetbrains/kotlin/incremental/DirtyData;", "writeBuildDifference", "Ljava/io/ObjectOutputStream;", "diff", "writeDirtyData", "dirtyData", "incremental-compilation-impl"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final BuildDiffsStorage readFromFile(@NotNull File file2, @Nullable ICReporter reporter2) {
            BuildDiffsStorage buildDiffsStorage;
            List<BuildDifference> diffs;
            Intrinsics.checkNotNullParameter(file2, "file");
            List<BuildDifference> list2 = diffs = this.readDiffsFromFile(file2, reporter2);
            if (list2 == null) {
                buildDiffsStorage = null;
            } else {
                List<BuildDifference> list3 = list2;
                boolean bl = false;
                boolean bl2 = false;
                List<BuildDifference> it = list3;
                boolean bl3 = false;
                buildDiffsStorage = new BuildDiffsStorage(it);
            }
            return buildDiffsStorage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final List<BuildDifference> readDiffsFromFile(@NotNull File file2, @Nullable ICReporter reporter2) {
            Intrinsics.checkNotNullParameter(file2, "file");
            if (!file2.exists()) {
                return null;
            }
            try {
                Object object = file2;
                int n = 0;
                object = new FileInputStream((File)object);
                n = 8192;
                boolean bl = false;
                object = new ObjectInputStream(object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n));
                n = 0;
                bl = false;
                Throwable throwable = null;
                try {
                    ObjectInputStream input = (ObjectInputStream)object;
                    boolean bl2 = false;
                    int version = input.readInt();
                    if (version != this.getCURRENT_VERSION()) {
                        org.jetbrains.kotlin.incremental.BuildDiffsStorage$Companion.readDiffsFromFile$reportFail(reporter2, file2, "incompatible version " + version + ", actual version is " + this.getCURRENT_VERSION());
                        List<BuildDifference> list2 = null;
                        return list2;
                    }
                    int size = input.readInt();
                    ArrayList<BuildDifference> result2 = new ArrayList<BuildDifference>(size);
                    boolean bl3 = false;
                    int n2 = 0;
                    n2 = 0;
                    int n3 = size;
                    while (n2 < n3) {
                        int it = n2++;
                        boolean bl4 = false;
                        result2.add(this.readBuildDifference(input));
                    }
                    List list3 = result2;
                    return list3;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, throwable);
                }
            }
            catch (IOException e) {
                org.jetbrains.kotlin.incremental.BuildDiffsStorage$Companion.readDiffsFromFile$reportFail(reporter2, file2, e.toString());
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void writeToFile(@NotNull File file2, @NotNull BuildDiffsStorage storage2, @Nullable ICReporter reporter2) {
            block8: {
                Intrinsics.checkNotNullParameter(file2, "file");
                Intrinsics.checkNotNullParameter(storage2, "storage");
                file2.getParentFile().mkdirs();
                try {
                    Object object = file2;
                    int n = 0;
                    object = new FileOutputStream((File)object);
                    n = 8192;
                    boolean bl = false;
                    object = new ObjectOutputStream(object instanceof BufferedOutputStream ? (BufferedOutputStream)object : new BufferedOutputStream((OutputStream)object, n));
                    n = 0;
                    bl = false;
                    Throwable throwable = null;
                    try {
                        ObjectOutputStream output = (ObjectOutputStream)object;
                        boolean bl2 = false;
                        output.writeInt(this.getCURRENT_VERSION());
                        Iterable $this$sortedBy$iv = storage2.getBuildDiffs();
                        boolean $i$f$sortedBy = false;
                        boolean bl3 = false;
                        List<BuildDifference> diffsToWrite = CollectionsKt.takeLast(CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator<T>(){

                            public final int compare(T a, T b) {
                                boolean bl = false;
                                BuildDifference it = (BuildDifference)a;
                                boolean bl2 = false;
                                Comparable comparable = Long.valueOf(it.getTs());
                                it = (BuildDifference)b;
                                Comparable comparable2 = comparable;
                                bl2 = false;
                                Long l = it.getTs();
                                return ComparisonsKt.compareValues(comparable2, (Comparable)l);
                            }
                        }), 10);
                        output.writeInt(diffsToWrite.size());
                        for (BuildDifference diff : diffsToWrite) {
                            this.writeBuildDifference(output, diff);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object, throwable);
                    }
                }
                catch (IOException e) {
                    ICReporter iCReporter = reporter2;
                    if (iCReporter == null) break block8;
                    iCReporter.report(new Function0<String>(file2, e){
                        final /* synthetic */ File $file;
                        final /* synthetic */ IOException $e;
                        {
                            this.$file = $file;
                            this.$e = $e;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Could not write diff to file " + this.$file + ": " + this.$e;
                        }
                    });
                }
            }
        }

        private final BuildDifference readBuildDifference(ObjectInputStream $this$readBuildDifference) {
            long ts = $this$readBuildDifference.readLong();
            boolean isIncremental = $this$readBuildDifference.readBoolean();
            DirtyData dirtyData = this.readDirtyData($this$readBuildDifference);
            return new BuildDifference(ts, isIncremental, dirtyData);
        }

        private final void writeBuildDifference(ObjectOutputStream $this$writeBuildDifference, BuildDifference diff) {
            $this$writeBuildDifference.writeLong(diff.getTs());
            $this$writeBuildDifference.writeBoolean(diff.isIncremental());
            this.writeDirtyData($this$writeBuildDifference, diff.getDirtyData());
        }

        private final DirtyData readDirtyData(ObjectInputStream $this$readDirtyData) {
            int lookupSymbolSize = $this$readDirtyData.readInt();
            ArrayList<LookupSymbol> lookupSymbols = new ArrayList<LookupSymbol>(lookupSymbolSize);
            boolean bl = false;
            int n = 0;
            n = 0;
            int n2 = lookupSymbolSize;
            while (n < n2) {
                int it = n++;
                boolean bl2 = false;
                String name2 = $this$readDirtyData.readUTF();
                String scope2 = $this$readDirtyData.readUTF();
                Intrinsics.checkNotNullExpressionValue(name2, "name");
                Intrinsics.checkNotNullExpressionValue(scope2, "scope");
                lookupSymbols.add(new LookupSymbol(name2, scope2));
            }
            int dirtyClassesSize = $this$readDirtyData.readInt();
            ArrayList<FqName> dirtyClassesFqNames = new ArrayList<FqName>(dirtyClassesSize);
            n2 = 0;
            int n3 = 0;
            n3 = 0;
            int n4 = dirtyClassesSize;
            while (n3 < n4) {
                int it = n3++;
                boolean bl3 = false;
                String fqNameString = $this$readDirtyData.readUTF();
                dirtyClassesFqNames.add(new FqName(fqNameString));
            }
            return new DirtyData(lookupSymbols, dirtyClassesFqNames, null, 4, null);
        }

        private final void writeDirtyData(ObjectOutputStream $this$writeDirtyData, DirtyData dirtyData) {
            Collection<LookupSymbol> lookupSymbols = dirtyData.getDirtyLookupSymbols();
            $this$writeDirtyData.writeInt(lookupSymbols.size());
            for (LookupSymbol object : lookupSymbols) {
                String name2 = object.component1();
                String scope2 = object.component2();
                $this$writeDirtyData.writeUTF(name2);
                $this$writeDirtyData.writeUTF(scope2);
            }
            Collection<FqName> dirtyClassesFqNames = dirtyData.getDirtyClassesFqNames();
            $this$writeDirtyData.writeInt(dirtyClassesFqNames.size());
            for (FqName fqName2 : dirtyClassesFqNames) {
                $this$writeDirtyData.writeUTF(fqName2.asString());
            }
        }

        public final int getCURRENT_VERSION() {
            return CURRENT_VERSION;
        }

        public final void setCURRENT_VERSION(int n) {
            CURRENT_VERSION = n;
        }

        private static final void readDiffsFromFile$reportFail(ICReporter $reporter, File $file, String reason) {
            ICReporter iCReporter = $reporter;
            if (iCReporter != null) {
                iCReporter.report(new Function0<String>($file, reason){
                    final /* synthetic */ File $file;
                    final /* synthetic */ String $reason;
                    {
                        this.$file = $file;
                        this.$reason = $reason;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Could not read diff from file " + this.$file + ": " + this.$reason;
                    }
                });
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

