/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.quickfix;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.extapi.psi.ASTDelegatePsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithInitializer;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.DeferredType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

public class QuickFixUtil {
    private QuickFixUtil() {
    }

    public static boolean removePossiblyWhiteSpace(ASTDelegatePsiElement element, PsiElement possiblyWhiteSpace) {
        if (possiblyWhiteSpace instanceof PsiWhiteSpace) {
            element.deleteChildInternal(possiblyWhiteSpace.getNode());
            return true;
        }
        return false;
    }

    @Nullable
    public static <T extends PsiElement> T getParentElementOfType(Diagnostic diagnostic, Class<T> aClass2) {
        return PsiTreeUtil.getParentOfType(diagnostic.getPsiElement(), aClass2, false);
    }

    @Nullable
    public static KotlinType getDeclarationReturnType(KtNamedDeclaration declaration2) {
        PsiFile file2 = declaration2.getContainingFile();
        if (!(file2 instanceof KtFile)) {
            return null;
        }
        DeclarationDescriptor descriptor2 = ResolutionUtils.unsafeResolveToDescriptor(declaration2, BodyResolveMode.FULL);
        if (!(descriptor2 instanceof CallableDescriptor)) {
            return null;
        }
        KotlinType type2 = ((CallableDescriptor)descriptor2).getReturnType();
        if (type2 instanceof DeferredType) {
            type2 = ((DeferredType)type2).getDelegate();
        }
        return type2;
    }

    @Nullable
    public static KotlinType findLowerBoundOfOverriddenCallablesReturnTypes(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            QuickFixUtil.$$$reportNull$$$0(0);
        }
        KotlinType matchingReturnType = null;
        for (CallableDescriptor callableDescriptor : descriptor2.getOverriddenDescriptors()) {
            KotlinType overriddenReturnType = callableDescriptor.getReturnType();
            if (overriddenReturnType == null) {
                return null;
            }
            if (matchingReturnType == null || KotlinTypeChecker.DEFAULT.isSubtypeOf(overriddenReturnType, matchingReturnType)) {
                matchingReturnType = overriddenReturnType;
                continue;
            }
            if (KotlinTypeChecker.DEFAULT.isSubtypeOf(matchingReturnType, overriddenReturnType)) continue;
            return null;
        }
        return matchingReturnType;
    }

    @Nullable
    public static PsiElement safeGetDeclaration(@Nullable CallableDescriptor descriptor2) {
        if (descriptor2 == null || descriptor2.getOverriddenDescriptors().size() > 1) {
            return null;
        }
        return DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
    }

    @Nullable
    public static KtParameter getParameterDeclarationForValueArgument(@NotNull ResolvedCall<?> resolvedCall2, @Nullable ValueArgument valueArgument) {
        PsiElement declaration2;
        if (resolvedCall2 == null) {
            QuickFixUtil.$$$reportNull$$$0(1);
        }
        return (declaration2 = QuickFixUtil.safeGetDeclaration(CallUtilKt.getParameterForArgument(resolvedCall2, valueArgument))) instanceof KtParameter ? (KtParameter)declaration2 : null;
    }

    private static boolean equalOrLastInBlock(KtExpression block, KtExpression expression2) {
        if (block == expression2) {
            return true;
        }
        return block instanceof KtBlockExpression && expression2.getParent() == block && PsiTreeUtil.getNextSiblingOfType(expression2, KtExpression.class) == null;
    }

    @Nullable
    public static KtIfExpression getParentIfForBranch(@Nullable KtExpression expression2) {
        KtIfExpression ifExpression = PsiTreeUtil.getParentOfType((PsiElement)expression2, KtIfExpression.class, true);
        if (ifExpression == null) {
            return null;
        }
        if (QuickFixUtil.equalOrLastInBlock(ifExpression.getThen(), expression2) || QuickFixUtil.equalOrLastInBlock(ifExpression.getElse(), expression2)) {
            return ifExpression;
        }
        return null;
    }

    @Nullable
    private static KtWhenExpression getParentWhenForBranch(@Nullable KtExpression expression2) {
        KtWhenEntry whenEntry = PsiTreeUtil.getParentOfType((PsiElement)expression2, KtWhenEntry.class, true);
        if (whenEntry == null) {
            return null;
        }
        KtExpression whenEntryExpression = whenEntry.getExpression();
        if (whenEntryExpression == null) {
            return null;
        }
        if (!QuickFixUtil.equalOrLastInBlock(whenEntryExpression, expression2)) {
            return null;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)whenEntry, KtWhenExpression.class, true);
    }

    @Nullable
    private static KtExpression getParentForBranch(@Nullable KtExpression expression2) {
        KtIfExpression parent2 = QuickFixUtil.getParentIfForBranch(expression2);
        if (parent2 != null) {
            return parent2;
        }
        return QuickFixUtil.getParentWhenForBranch(expression2);
    }

    public static boolean canEvaluateTo(KtExpression parent2, KtExpression child) {
        if (parent2 == null || child == null) {
            return false;
        }
        while (parent2 != child) {
            PsiElement childParent = child.getParent();
            if (childParent instanceof KtParenthesizedExpression) {
                child = (KtExpression)childParent;
                continue;
            }
            if (childParent instanceof KtDotQualifiedExpression && (child instanceof KtCallExpression || child instanceof KtDotQualifiedExpression)) {
                child = (KtExpression)childParent;
                continue;
            }
            if ((child = QuickFixUtil.getParentForBranch(child)) != null) continue;
            return false;
        }
        return true;
    }

    public static boolean canFunctionOrGetterReturnExpression(@NotNull KtDeclaration functionOrGetter, @NotNull KtExpression expression2) {
        if (functionOrGetter == null) {
            QuickFixUtil.$$$reportNull$$$0(2);
        }
        if (expression2 == null) {
            QuickFixUtil.$$$reportNull$$$0(3);
        }
        if (functionOrGetter instanceof KtFunctionLiteral) {
            PsiElement[] children2;
            int length;
            KtBlockExpression functionLiteralBody = ((KtFunctionLiteral)functionOrGetter).getBodyExpression();
            PsiElement returnedElement = null;
            if (functionLiteralBody != null && (length = (children2 = functionLiteralBody.getChildren()).length) > 0) {
                returnedElement = children2[length - 1];
            }
            return returnedElement instanceof KtExpression && QuickFixUtil.canEvaluateTo((KtExpression)returnedElement, expression2);
        }
        if (functionOrGetter instanceof KtDeclarationWithInitializer && QuickFixUtil.canEvaluateTo(((KtDeclarationWithInitializer)functionOrGetter).getInitializer(), expression2)) {
            return true;
        }
        KtReturnExpression returnExpression = PsiTreeUtil.getParentOfType((PsiElement)expression2, KtReturnExpression.class);
        return returnExpression != null && QuickFixUtil.canEvaluateTo(returnExpression.getReturnedExpression(), expression2);
    }

    public static String renderTypeWithFqNameOnClash(KotlinType type2, String nameToCheckAgainst) {
        FqName fqNameToCheckAgainst = new FqName(nameToCheckAgainst);
        ClassifierDescriptor typeClassifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        FqName typeFqName2 = typeClassifierDescriptor != null ? DescriptorUtils.getFqNameSafe(typeClassifierDescriptor) : fqNameToCheckAgainst;
        DescriptorRenderer renderer = typeFqName2.shortName().equals(fqNameToCheckAgainst.shortName()) ? IdeDescriptorRenderers.SOURCE_CODE : IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_NO_ANNOTATIONS;
        return renderer.renderType(type2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedCall";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionOrGetter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/idea/core/quickfix/QuickFixUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findLowerBoundOfOverriddenCallablesReturnTypes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getParameterDeclarationForValueArgument";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "canFunctionOrGetterReturnExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

