/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import org.jetbrains.kotlin.fir.contracts.ContractUtilsKt;
import org.jetbrains.kotlin.fir.contracts.FirContractDescription;
import org.jetbrains.kotlin.fir.contracts.FirEffectDeclaration;
import org.jetbrains.kotlin.fir.contracts.builder.FirResolvedContractDescriptionBuilder;
import org.jetbrains.kotlin.fir.contracts.description.ConeBinaryLogicExpression;
import org.jetbrains.kotlin.fir.contracts.description.ConeBooleanConstantReference;
import org.jetbrains.kotlin.fir.contracts.description.ConeBooleanExpression;
import org.jetbrains.kotlin.fir.contracts.description.ConeBooleanValueParameterReference;
import org.jetbrains.kotlin.fir.contracts.description.ConeCallsEffectDeclaration;
import org.jetbrains.kotlin.fir.contracts.description.ConeConditionalEffectDeclaration;
import org.jetbrains.kotlin.fir.contracts.description.ConeConstantReference;
import org.jetbrains.kotlin.fir.contracts.description.ConeEffectDeclaration;
import org.jetbrains.kotlin.fir.contracts.description.ConeIsInstancePredicate;
import org.jetbrains.kotlin.fir.contracts.description.ConeIsNullPredicate;
import org.jetbrains.kotlin.fir.contracts.description.ConeLogicalNot;
import org.jetbrains.kotlin.fir.contracts.description.ConeReturnsEffectDeclaration;
import org.jetbrains.kotlin.fir.contracts.description.ConeValueParameterReference;
import org.jetbrains.kotlin.fir.declarations.FirContractDescriptionOwner;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.deserialization.FirDeserializationContext;
import org.jetbrains.kotlin.fir.expressions.LogicOperationKind;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.metadata.deserialization.ProtoTypeTableUtilKt;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002'(B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0007\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0007\u001a\u00020\u001e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0007\u001a\u00020\u001e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\f\u0010 \u001a\u00020!*\u00020\bH\u0002J\u0014\u0010\"\u001a\u00020\u0006*\u00020\u00062\u0006\u0010#\u001a\u00020!H\u0002J\u000e\u0010$\u001a\u0004\u0018\u00010%*\u00020&H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/fir/deserialization/FirContractDeserializer;", "", "c", "Lorg/jetbrains/kotlin/fir/deserialization/FirDeserializationContext;", "(Lorg/jetbrains/kotlin/fir/deserialization/FirDeserializationContext;)V", "extractPrimitiveExpression", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeBooleanExpression;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Expression;", "primitiveType", "Lorg/jetbrains/kotlin/fir/deserialization/FirContractDeserializer$PrimitiveExpressionType;", "owner", "Lorg/jetbrains/kotlin/fir/declarations/FirContractDescriptionOwner;", "extractType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "extractVariable", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeValueParameterReference;", "getComplexType", "Lorg/jetbrains/kotlin/fir/deserialization/FirContractDeserializer$ComplexExpressionType;", "getPrimitiveType", "loadConstant", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeConstantReference;", "value", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Expression$ConstantValue;", "loadContract", "Lorg/jetbrains/kotlin/fir/contracts/FirContractDescription;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Contract;", "loadExpression", "loadPossiblyConditionalEffect", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeEffectDeclaration;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Effect;", "loadSimpleEffect", "hasType", "", "invertIfNecessary", "shouldInvert", "toDescriptorInvocationKind", "Lorg/jetbrains/kotlin/contracts/description/EventOccurrencesRange;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Effect$InvocationKind;", "ComplexExpressionType", "PrimitiveExpressionType", "fir-deserialization"})
public final class FirContractDeserializer {
    @NotNull
    private final FirDeserializationContext c;

    public FirContractDeserializer(@NotNull FirDeserializationContext c) {
        Intrinsics.checkNotNullParameter(c, "c");
        this.c = c;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final FirContractDescription loadContract(@NotNull ProtoBuf.Contract proto, @NotNull FirContractDescriptionOwner owner) {
        void $this$mapTo$iv$iv;
        Object object;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(owner, "owner");
        List<ProtoBuf.Effect> list2 = proto.getEffectList();
        Intrinsics.checkNotNullExpressionValue(list2, "proto.effectList");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            object = (ProtoBuf.Effect)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            ConeEffectDeclaration coneEffectDeclaration = this.loadPossiblyConditionalEffect((ProtoBuf.Effect)it, owner);
            if (coneEffectDeclaration == null) {
                return null;
            }
            ConeEffectDeclaration coneEffectDeclaration2 = coneEffectDeclaration;
            collection.add(coneEffectDeclaration2);
        }
        List effects = (List)destination$iv$iv;
        boolean $i$f$buildResolvedContractDescription = false;
        boolean bl = false;
        FirResolvedContractDescriptionBuilder firResolvedContractDescriptionBuilder = new FirResolvedContractDescriptionBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        FirResolvedContractDescriptionBuilder $this$loadContract_u24lambda_u2d2 = firResolvedContractDescriptionBuilder;
        boolean bl4 = false;
        FirResolvedContractDescriptionBuilder firResolvedContractDescriptionBuilder2 = $this$loadContract_u24lambda_u2d2;
        object = firResolvedContractDescriptionBuilder2.getEffects();
        Iterable $this$map$iv2 = effects;
        boolean $i$f$map2 = false;
        Iterable iterable2 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ConeEffectDeclaration coneEffectDeclaration = (ConeEffectDeclaration)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl5 = false;
            FirEffectDeclaration firEffectDeclaration = ContractUtilsKt.toFirEffectDeclaration$default((ConeEffectDeclaration)it, null, 1, null);
            collection.add(firEffectDeclaration);
        }
        Iterable iterable3 = (List)destination$iv$iv2;
        boolean bl6 = false;
        kotlin.collections.CollectionsKt.addAll(object, iterable3);
        return firResolvedContractDescriptionBuilder.build();
    }

    private final ConeEffectDeclaration loadPossiblyConditionalEffect(ProtoBuf.Effect proto, FirContractDescriptionOwner owner) {
        if (proto.hasConclusionOfConditionalEffect()) {
            Object object = proto.getConclusionOfConditionalEffect();
            Intrinsics.checkNotNullExpressionValue(object, "proto.conclusionOfConditionalEffect");
            ConeBooleanExpression coneBooleanExpression = this.loadExpression((ProtoBuf.Expression)object, owner);
            if (coneBooleanExpression == null) {
                return null;
            }
            ConeBooleanExpression conclusion = coneBooleanExpression;
            object = this.loadSimpleEffect(proto, owner);
            if (object == null) {
                return null;
            }
            Object effect = object;
            return new ConeConditionalEffectDeclaration((ConeEffectDeclaration)effect, conclusion);
        }
        return this.loadSimpleEffect(proto, owner);
    }

    private final ConeEffectDeclaration loadSimpleEffect(ProtoBuf.Effect proto, FirContractDescriptionOwner owner) {
        ConeEffectDeclaration coneEffectDeclaration;
        ProtoBuf.Effect.EffectType type2;
        if (!proto.hasEffectType()) {
            return null;
        }
        ProtoBuf.Effect.EffectType effectType = proto.getEffectType();
        Intrinsics.checkNotNullExpressionValue(effectType, "proto.effectType");
        effectType = type2 = effectType;
        int n = WhenMappings.$EnumSwitchMapping$0[effectType.ordinal()];
        switch (n) {
            case 1: {
                ConeConstantReference coneConstantReference;
                List<ProtoBuf.Expression> list2 = proto.getEffectConstructorArgumentList();
                Intrinsics.checkNotNullExpressionValue(list2, "proto.effectConstructorArgumentList");
                ProtoBuf.Expression argument = kotlin.collections.CollectionsKt.firstOrNull(list2);
                if (argument == null) {
                    coneConstantReference = ConeConstantReference.Companion.getWILDCARD();
                } else {
                    ConeConstantReference coneConstantReference2;
                    ConeBooleanExpression coneBooleanExpression = this.loadExpression(argument, owner);
                    ConeConstantReference coneConstantReference3 = coneConstantReference2 = coneBooleanExpression instanceof ConeConstantReference ? (ConeConstantReference)((Object)coneBooleanExpression) : null;
                    if (coneConstantReference2 == null) {
                        return null;
                    }
                    coneConstantReference = coneConstantReference2;
                }
                ConeConstantReference returnValue = coneConstantReference;
                coneEffectDeclaration = new ConeReturnsEffectDeclaration(returnValue);
                break;
            }
            case 2: {
                coneEffectDeclaration = new ConeReturnsEffectDeclaration(ConeConstantReference.Companion.getNOT_NULL());
                break;
            }
            case 3: {
                EventOccurrencesRange eventOccurrencesRange;
                Object object = proto.getEffectConstructorArgumentList();
                Intrinsics.checkNotNullExpressionValue(object, "proto.effectConstructorArgumentList");
                ProtoBuf.Expression returnValue = kotlin.collections.CollectionsKt.firstOrNull(object);
                if (returnValue == null) {
                    return null;
                }
                ProtoBuf.Expression argument = returnValue;
                object = this.extractVariable(argument, owner);
                if (object == null) {
                    return null;
                }
                Object callable = object;
                if (proto.hasKind()) {
                    ProtoBuf.Effect.InvocationKind invocationKind = proto.getKind();
                    Intrinsics.checkNotNullExpressionValue(invocationKind, "proto.kind");
                    EventOccurrencesRange eventOccurrencesRange2 = this.toDescriptorInvocationKind(invocationKind);
                    if (eventOccurrencesRange2 == null) {
                        return null;
                    }
                    eventOccurrencesRange = eventOccurrencesRange2;
                } else {
                    eventOccurrencesRange = EventOccurrencesRange.UNKNOWN;
                }
                EventOccurrencesRange invocationKind = eventOccurrencesRange;
                coneEffectDeclaration = new ConeCallsEffectDeclaration((ConeValueParameterReference)callable, invocationKind);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return coneEffectDeclaration;
    }

    /*
     * WARNING - void declaration
     */
    private final ConeBooleanExpression loadExpression(ProtoBuf.Expression proto, FirContractDescriptionOwner owner) {
        ConeBooleanExpression coneBooleanExpression;
        PrimitiveExpressionType primitiveType = this.getPrimitiveType(proto);
        ConeBooleanExpression primitiveExpression = this.extractPrimitiveExpression(proto, primitiveType, owner);
        ComplexExpressionType complexType = this.getComplexType(proto);
        boolean bl = false;
        List childs = new ArrayList();
        CollectionsKt.addIfNotNull(childs, primitiveExpression);
        ComplexExpressionType complexExpressionType = complexType;
        int n = complexExpressionType == null ? -1 : WhenMappings.$EnumSwitchMapping$1[complexExpressionType.ordinal()];
        switch (n) {
            case 1: {
                ConeBooleanExpression it;
                List<ProtoBuf.Expression> list2 = proto.getAndArgumentList();
                Intrinsics.checkNotNullExpressionValue(list2, "proto.andArgumentList");
                Iterable $this$mapTo$iv = list2;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    ProtoBuf.Expression expression2 = (ProtoBuf.Expression)item$iv;
                    Collection collection = childs;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue(it, "it");
                    ConeBooleanExpression coneBooleanExpression2 = this.loadExpression((ProtoBuf.Expression)((Object)it), owner);
                    if (coneBooleanExpression2 == null) {
                        return null;
                    }
                    ConeBooleanExpression coneBooleanExpression3 = coneBooleanExpression2;
                    collection.add(coneBooleanExpression3);
                }
                Iterable $this$reduce$iv = childs;
                boolean $i$f$reduce = false;
                Iterator iterator$iv = $this$reduce$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
                }
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void booleanExpression;
                    it = (ConeBooleanExpression)iterator$iv.next();
                    ConeBooleanExpression acc = (ConeBooleanExpression)accumulator$iv;
                    boolean bl3 = false;
                    accumulator$iv = new ConeBinaryLogicExpression(acc, (ConeBooleanExpression)booleanExpression, LogicOperationKind.AND);
                }
                coneBooleanExpression = (ConeBooleanExpression)accumulator$iv;
                break;
            }
            case 2: {
                ConeBooleanExpression it;
                ProtoBuf.Expression booleanExpression;
                Iterable<ProtoBuf.Expression> $this$reduce$iv = proto.getOrArgumentList();
                Intrinsics.checkNotNullExpressionValue($this$reduce$iv, "proto.orArgumentList");
                Iterable $this$mapTo$iv = $this$reduce$iv;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    booleanExpression = (ProtoBuf.Expression)item$iv;
                    Collection collection = childs;
                    boolean bl4 = false;
                    Intrinsics.checkNotNullExpressionValue(it, "it");
                    ConeBooleanExpression bl3 = this.loadExpression((ProtoBuf.Expression)((Object)it), owner);
                    if (bl3 == null) {
                        return null;
                    }
                    ConeBooleanExpression coneBooleanExpression4 = bl3;
                    collection.add(coneBooleanExpression4);
                }
                $this$reduce$iv = childs;
                boolean $i$f$reduce = false;
                Iterator<Object> iterator$iv = $this$reduce$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
                }
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    it = (ConeBooleanExpression)iterator$iv.next();
                    ConeBooleanExpression acc = (ConeBooleanExpression)accumulator$iv;
                    boolean bl5 = false;
                    accumulator$iv = new ConeBinaryLogicExpression(acc, (ConeBooleanExpression)((Object)booleanExpression), LogicOperationKind.OR);
                }
                coneBooleanExpression = (ConeBooleanExpression)accumulator$iv;
                break;
            }
            case -1: {
                coneBooleanExpression = primitiveExpression;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return coneBooleanExpression;
    }

    private final ConeBooleanExpression extractPrimitiveExpression(ProtoBuf.Expression proto, PrimitiveExpressionType primitiveType, FirContractDescriptionOwner owner) {
        ConeBooleanExpression coneBooleanExpression;
        Object object = Flags.IS_NEGATED.get(proto.getFlags());
        Intrinsics.checkNotNullExpressionValue(object, "IS_NEGATED.get(proto.flags)");
        boolean isInverted = (Boolean)object;
        object = primitiveType;
        int n = object == null ? -1 : WhenMappings.$EnumSwitchMapping$2[((Enum)object).ordinal()];
        switch (n) {
            case 1: 
            case 2: {
                ConeBooleanValueParameterReference coneBooleanValueParameterReference;
                ConeValueParameterReference coneValueParameterReference = this.extractVariable(proto, owner);
                ConeBooleanValueParameterReference coneBooleanValueParameterReference2 = coneBooleanValueParameterReference = coneValueParameterReference instanceof ConeBooleanValueParameterReference ? (ConeBooleanValueParameterReference)coneValueParameterReference : null;
                if (coneBooleanValueParameterReference == null) {
                    coneBooleanExpression = null;
                    break;
                }
                coneBooleanExpression = this.invertIfNecessary(coneBooleanValueParameterReference, isInverted);
                break;
            }
            case 3: {
                ConeBooleanConstantReference coneBooleanConstantReference;
                ProtoBuf.Expression.ConstantValue constantValue = proto.getConstantValue();
                Intrinsics.checkNotNullExpressionValue(constantValue, "proto.constantValue");
                ConeConstantReference coneConstantReference = this.loadConstant(constantValue);
                ConeBooleanConstantReference coneBooleanConstantReference2 = coneBooleanConstantReference = coneConstantReference instanceof ConeBooleanConstantReference ? (ConeBooleanConstantReference)coneConstantReference : null;
                if (coneBooleanConstantReference == null) {
                    coneBooleanExpression = null;
                    break;
                }
                coneBooleanExpression = this.invertIfNecessary(coneBooleanConstantReference, isInverted);
                break;
            }
            case 4: {
                ConeValueParameterReference coneValueParameterReference = this.extractVariable(proto, owner);
                if (coneValueParameterReference == null) {
                    return null;
                }
                ConeValueParameterReference variable2 = coneValueParameterReference;
                ConeKotlinType coneKotlinType = this.extractType(proto);
                if (coneKotlinType == null) {
                    return null;
                }
                ConeKotlinType type2 = coneKotlinType;
                coneBooleanExpression = new ConeIsInstancePredicate(variable2, type2, isInverted);
                break;
            }
            case 5: {
                ConeValueParameterReference coneValueParameterReference = this.extractVariable(proto, owner);
                if (coneValueParameterReference == null) {
                    return null;
                }
                ConeValueParameterReference variable3 = coneValueParameterReference;
                coneBooleanExpression = new ConeIsNullPredicate(variable3, isInverted);
                break;
            }
            case -1: {
                coneBooleanExpression = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return coneBooleanExpression;
    }

    private final ConeBooleanExpression invertIfNecessary(ConeBooleanExpression $this$invertIfNecessary, boolean shouldInvert) {
        return shouldInvert ? (ConeBooleanExpression)new ConeLogicalNot($this$invertIfNecessary) : $this$invertIfNecessary;
    }

    private final ConeValueParameterReference extractVariable(ProtoBuf.Expression proto, FirContractDescriptionOwner owner) {
        FirTypeRef firTypeRef;
        FirTypeRef firTypeRef2;
        if (!proto.hasValueParameterReference()) {
            return null;
        }
        FirSimpleFunction ownerFunction = (FirSimpleFunction)owner;
        int valueParameterIndex = proto.getValueParameterReference() - 1;
        Object name2 = null;
        if (valueParameterIndex < 0) {
            name2 = "this";
            firTypeRef2 = ownerFunction.getReceiverTypeRef();
        } else {
            Object object = kotlin.collections.CollectionsKt.getOrNull(ownerFunction.getValueParameters(), valueParameterIndex);
            if (object == null) {
                return null;
            }
            FirValueParameter parameter = object;
            object = parameter.getName().asString();
            Intrinsics.checkNotNullExpressionValue(object, "parameter.name.asString()");
            name2 = object;
            firTypeRef2 = firTypeRef = parameter.getReturnTypeRef();
        }
        if (firTypeRef == null) {
            return null;
        }
        FirTypeRef typeRef = firTypeRef;
        return !FirTypeUtilsKt.isBoolean(typeRef) ? new ConeValueParameterReference(valueParameterIndex, (String)name2) : (ConeValueParameterReference)new ConeBooleanValueParameterReference(valueParameterIndex, (String)name2);
    }

    private final EventOccurrencesRange toDescriptorInvocationKind(ProtoBuf.Effect.InvocationKind $this$toDescriptorInvocationKind) {
        EventOccurrencesRange eventOccurrencesRange;
        ProtoBuf.Effect.InvocationKind invocationKind = $this$toDescriptorInvocationKind;
        int n = WhenMappings.$EnumSwitchMapping$3[invocationKind.ordinal()];
        switch (n) {
            case 1: {
                eventOccurrencesRange = EventOccurrencesRange.AT_MOST_ONCE;
                break;
            }
            case 2: {
                eventOccurrencesRange = EventOccurrencesRange.EXACTLY_ONCE;
                break;
            }
            case 3: {
                eventOccurrencesRange = EventOccurrencesRange.AT_LEAST_ONCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return eventOccurrencesRange;
    }

    private final ConeKotlinType extractType(ProtoBuf.Expression proto) {
        ProtoBuf.Type type2 = ProtoTypeTableUtilKt.isInstanceType(proto, this.c.getTypeTable());
        if (type2 == null) {
            return null;
        }
        return this.c.getTypeDeserializer().type(type2);
    }

    private final ConeConstantReference loadConstant(ProtoBuf.Expression.ConstantValue value2) {
        ConeConstantReference coneConstantReference;
        ProtoBuf.Expression.ConstantValue constantValue = value2;
        int n = WhenMappings.$EnumSwitchMapping$4[constantValue.ordinal()];
        switch (n) {
            case 1: {
                coneConstantReference = ConeBooleanConstantReference.Companion.getTRUE();
                break;
            }
            case 2: {
                coneConstantReference = ConeBooleanConstantReference.Companion.getFALSE();
                break;
            }
            case 3: {
                coneConstantReference = ConeConstantReference.Companion.getNULL();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return coneConstantReference;
    }

    private final ComplexExpressionType getComplexType(ProtoBuf.Expression proto) {
        boolean isOrSequence = proto.getOrArgumentCount() != 0;
        boolean isAndSequence = proto.getAndArgumentCount() != 0;
        return isOrSequence && isAndSequence ? null : (isOrSequence ? ComplexExpressionType.OR_SEQUENCE : (isAndSequence ? ComplexExpressionType.AND_SEQUENCE : null));
    }

    private final PrimitiveExpressionType getPrimitiveType(ProtoBuf.Expression proto) {
        boolean bl = false;
        List expressionTypes = new ArrayList();
        if (proto.hasValueParameterReference() && this.hasType(proto)) {
            expressionTypes.add(PrimitiveExpressionType.INSTANCE_CHECK);
        } else if (proto.hasValueParameterReference()) {
            Boolean bl2 = Flags.IS_NULL_CHECK_PREDICATE.get(proto.getFlags());
            Intrinsics.checkNotNullExpressionValue(bl2, "IS_NULL_CHECK_PREDICATE.get(proto.flags)");
            if (bl2.booleanValue()) {
                expressionTypes.add(PrimitiveExpressionType.NULLABILITY_CHECK);
            }
        }
        Collection collection = expressionTypes;
        boolean bl3 = false;
        if (!collection.isEmpty()) {
            return (PrimitiveExpressionType)((Object)kotlin.collections.CollectionsKt.singleOrNull(expressionTypes));
        }
        if (proto.hasValueParameterReference() && proto.getValueParameterReference() > 0) {
            expressionTypes.add(PrimitiveExpressionType.VALUE_PARAMETER_REFERENCE);
        } else if (proto.hasValueParameterReference() && proto.getValueParameterReference() == 0) {
            expressionTypes.add(PrimitiveExpressionType.RECEIVER_REFERENCE);
        } else if (proto.hasConstantValue()) {
            expressionTypes.add(PrimitiveExpressionType.CONSTANT);
        }
        return (PrimitiveExpressionType)((Object)kotlin.collections.CollectionsKt.singleOrNull(expressionTypes));
    }

    private final boolean hasType(ProtoBuf.Expression $this$hasType) {
        return $this$hasType.hasIsInstanceType() || $this$hasType.hasIsInstanceTypeId();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/fir/deserialization/FirContractDeserializer$PrimitiveExpressionType;", "", "(Ljava/lang/String;I)V", "VALUE_PARAMETER_REFERENCE", "RECEIVER_REFERENCE", "CONSTANT", "INSTANCE_CHECK", "NULLABILITY_CHECK", "fir-deserialization"})
    private static final class PrimitiveExpressionType
    extends Enum<PrimitiveExpressionType> {
        public static final /* enum */ PrimitiveExpressionType VALUE_PARAMETER_REFERENCE = new PrimitiveExpressionType();
        public static final /* enum */ PrimitiveExpressionType RECEIVER_REFERENCE = new PrimitiveExpressionType();
        public static final /* enum */ PrimitiveExpressionType CONSTANT = new PrimitiveExpressionType();
        public static final /* enum */ PrimitiveExpressionType INSTANCE_CHECK = new PrimitiveExpressionType();
        public static final /* enum */ PrimitiveExpressionType NULLABILITY_CHECK = new PrimitiveExpressionType();
        private static final /* synthetic */ PrimitiveExpressionType[] $VALUES;

        public static PrimitiveExpressionType[] values() {
            PrimitiveExpressionType[] primitiveExpressionTypeArray = $VALUES;
            PrimitiveExpressionType[] primitiveExpressionTypeArray2 = new PrimitiveExpressionType[primitiveExpressionTypeArray.length];
            System.arraycopy(primitiveExpressionTypeArray, 0, primitiveExpressionTypeArray2, 0, primitiveExpressionTypeArray.length);
            return primitiveExpressionTypeArray2;
        }

        public static PrimitiveExpressionType valueOf(String value2) {
            Intrinsics.checkNotNullParameter(value2, "value");
            return Enum.valueOf(PrimitiveExpressionType.class, value2);
        }

        static {
            PrimitiveExpressionType[] primitiveExpressionTypeArray = new PrimitiveExpressionType[]{VALUE_PARAMETER_REFERENCE, RECEIVER_REFERENCE, CONSTANT, INSTANCE_CHECK, NULLABILITY_CHECK};
            $VALUES = primitiveExpressionTypeArray;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/fir/deserialization/FirContractDeserializer$ComplexExpressionType;", "", "(Ljava/lang/String;I)V", "AND_SEQUENCE", "OR_SEQUENCE", "fir-deserialization"})
    private static final class ComplexExpressionType
    extends Enum<ComplexExpressionType> {
        public static final /* enum */ ComplexExpressionType AND_SEQUENCE = new ComplexExpressionType();
        public static final /* enum */ ComplexExpressionType OR_SEQUENCE = new ComplexExpressionType();
        private static final /* synthetic */ ComplexExpressionType[] $VALUES;

        public static ComplexExpressionType[] values() {
            ComplexExpressionType[] complexExpressionTypeArray = $VALUES;
            ComplexExpressionType[] complexExpressionTypeArray2 = new ComplexExpressionType[complexExpressionTypeArray.length];
            System.arraycopy(complexExpressionTypeArray, 0, complexExpressionTypeArray2, 0, complexExpressionTypeArray.length);
            return complexExpressionTypeArray2;
        }

        public static ComplexExpressionType valueOf(String value2) {
            Intrinsics.checkNotNullParameter(value2, "value");
            return Enum.valueOf(ComplexExpressionType.class, value2);
        }

        static {
            ComplexExpressionType[] complexExpressionTypeArray = new ComplexExpressionType[]{AND_SEQUENCE, OR_SEQUENCE};
            $VALUES = complexExpressionTypeArray;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;
        public static final /* synthetic */ int[] $EnumSwitchMapping$4;

        static {
            int[] nArray = new int[ProtoBuf.Effect.EffectType.values().length];
            nArray[ProtoBuf.Effect.EffectType.RETURNS_CONSTANT.ordinal()] = 1;
            nArray[ProtoBuf.Effect.EffectType.RETURNS_NOT_NULL.ordinal()] = 2;
            nArray[ProtoBuf.Effect.EffectType.CALLS.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ComplexExpressionType.values().length];
            nArray[ComplexExpressionType.AND_SEQUENCE.ordinal()] = 1;
            nArray[ComplexExpressionType.OR_SEQUENCE.ordinal()] = 2;
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[PrimitiveExpressionType.values().length];
            nArray[PrimitiveExpressionType.VALUE_PARAMETER_REFERENCE.ordinal()] = 1;
            nArray[PrimitiveExpressionType.RECEIVER_REFERENCE.ordinal()] = 2;
            nArray[PrimitiveExpressionType.CONSTANT.ordinal()] = 3;
            nArray[PrimitiveExpressionType.INSTANCE_CHECK.ordinal()] = 4;
            nArray[PrimitiveExpressionType.NULLABILITY_CHECK.ordinal()] = 5;
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[ProtoBuf.Effect.InvocationKind.values().length];
            nArray[ProtoBuf.Effect.InvocationKind.AT_MOST_ONCE.ordinal()] = 1;
            nArray[ProtoBuf.Effect.InvocationKind.EXACTLY_ONCE.ordinal()] = 2;
            nArray[ProtoBuf.Effect.InvocationKind.AT_LEAST_ONCE.ordinal()] = 3;
            $EnumSwitchMapping$3 = nArray;
            nArray = new int[ProtoBuf.Expression.ConstantValue.values().length];
            nArray[ProtoBuf.Expression.ConstantValue.TRUE.ordinal()] = 1;
            nArray[ProtoBuf.Expression.ConstantValue.FALSE.ordinal()] = 2;
            nArray[ProtoBuf.Expression.ConstantValue.NULL.ordinal()] = 3;
            $EnumSwitchMapping$4 = nArray;
        }
    }
}

