/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.BuiltinTypes;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0016H\u0002J\f\u0010\u0017\u001a\u00020\u0015*\u00020\u0016H\u0002J\f\u0010\u0018\u001a\u00020\u0015*\u00020\u0016H\u0002J\u001e\u0010\u0019\u001a\u00020\r*\u00020\u00122\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\"\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInapplicableLateinitChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirMemberDeclarationChecker;", "()V", "primitives", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getPrimitives", "()Ljava/util/Set;", "setPrimitives", "(Ljava/util/Set;)V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "getPrimitiveTypes", "hasGetter", "", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "hasSetter", "isNullable", "report", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "target", "", "checkers"})
public final class FirInapplicableLateinitChecker
extends FirDeclarationChecker<FirMemberDeclaration> {
    @NotNull
    public static final FirInapplicableLateinitChecker INSTANCE = new FirInapplicableLateinitChecker();
    @Nullable
    private static Set<? extends ConeKotlinType> primitives;

    private FirInapplicableLateinitChecker() {
    }

    @Nullable
    public final Set<ConeKotlinType> getPrimitives() {
        return primitives;
    }

    public final void setPrimitives(@Nullable Set<? extends ConeKotlinType> set) {
        primitives = set;
    }

    private final Set<ConeKotlinType> getPrimitiveTypes(CheckerContext context2) {
        Set set;
        Set set2 = primitives;
        if (set2 == null) {
            boolean bl = false;
            Set set3 = new LinkedHashSet();
            boolean bl2 = false;
            boolean bl3 = false;
            Set $this$getPrimitiveTypes_u24lambda_u2d1 = set3;
            boolean bl4 = false;
            BuiltinTypes builtinTypes = context2.getSession().getBuiltinTypes();
            boolean bl5 = false;
            boolean bl6 = false;
            BuiltinTypes $this$getPrimitiveTypes_u24lambda_u2d1_u24lambda_u2d0 = builtinTypes;
            boolean bl7 = false;
            FirTypeRef $this$coneType$iv = $this$getPrimitiveTypes_u24lambda_u2d1_u24lambda_u2d0.getIntType();
            boolean $i$f$getConeType = false;
            FirTypeRef $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
            boolean $i$f$coneTypeUnsafe = false;
            ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
            if (coneKotlinType == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
            $this$getPrimitiveTypes_u24lambda_u2d1.add(coneKotlinType);
            $this$coneType$iv = $this$getPrimitiveTypes_u24lambda_u2d1_u24lambda_u2d0.getBooleanType();
            $i$f$getConeType = false;
            $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
            $i$f$coneTypeUnsafe = false;
            ConeKotlinType coneKotlinType2 = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
            if (coneKotlinType2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
            $this$getPrimitiveTypes_u24lambda_u2d1.add(coneKotlinType2);
            $this$coneType$iv = $this$getPrimitiveTypes_u24lambda_u2d1_u24lambda_u2d0.getCharType();
            $i$f$getConeType = false;
            $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
            $i$f$coneTypeUnsafe = false;
            ConeKotlinType coneKotlinType3 = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
            if (coneKotlinType3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
            $this$getPrimitiveTypes_u24lambda_u2d1.add(coneKotlinType3);
            $this$coneType$iv = $this$getPrimitiveTypes_u24lambda_u2d1_u24lambda_u2d0.getShortType();
            $i$f$getConeType = false;
            $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
            $i$f$coneTypeUnsafe = false;
            ConeKotlinType coneKotlinType4 = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
            if (coneKotlinType4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
            $this$getPrimitiveTypes_u24lambda_u2d1.add(coneKotlinType4);
            $this$coneType$iv = $this$getPrimitiveTypes_u24lambda_u2d1_u24lambda_u2d0.getByteType();
            $i$f$getConeType = false;
            $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
            $i$f$coneTypeUnsafe = false;
            ConeKotlinType coneKotlinType5 = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
            if (coneKotlinType5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
            $this$getPrimitiveTypes_u24lambda_u2d1.add(coneKotlinType5);
            $this$coneType$iv = $this$getPrimitiveTypes_u24lambda_u2d1_u24lambda_u2d0.getLongType();
            $i$f$getConeType = false;
            $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
            $i$f$coneTypeUnsafe = false;
            ConeKotlinType coneKotlinType6 = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
            if (coneKotlinType6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
            $this$getPrimitiveTypes_u24lambda_u2d1.add(coneKotlinType6);
            $this$coneType$iv = $this$getPrimitiveTypes_u24lambda_u2d1_u24lambda_u2d0.getDoubleType();
            $i$f$getConeType = false;
            $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
            $i$f$coneTypeUnsafe = false;
            ConeKotlinType coneKotlinType7 = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
            if (coneKotlinType7 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
            $this$getPrimitiveTypes_u24lambda_u2d1.add(coneKotlinType7);
            $this$coneType$iv = $this$getPrimitiveTypes_u24lambda_u2d1_u24lambda_u2d0.getFloatType();
            $i$f$getConeType = false;
            $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
            $i$f$coneTypeUnsafe = false;
            ConeKotlinType coneKotlinType8 = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
            if (coneKotlinType8 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
            $this$getPrimitiveTypes_u24lambda_u2d1.add(coneKotlinType8);
            this.setPrimitives($this$getPrimitiveTypes_u24lambda_u2d1);
            set = set3;
        } else {
            set = set2;
        }
        return set;
    }

    @Override
    public void check(@NotNull FirMemberDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        block20: {
            block19: {
                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                Intrinsics.checkNotNullParameter(context2, "context");
                Intrinsics.checkNotNullParameter(reporter2, "reporter");
                if (!(declaration2 instanceof FirProperty)) break block19;
                FirMemberDeclaration $this$isLateInit$iv = declaration2;
                boolean $i$f$isLateInit = false;
                if ($this$isLateInit$iv.getStatus().isLateInit()) break block20;
            }
            return;
        }
        if (((FirProperty)declaration2).isVal()) {
            this.report(reporter2, declaration2.getSource(), "is allowed only on mutable properties");
        } else if (((FirProperty)declaration2).getInitializer() != null) {
            if (((FirProperty)declaration2).isLocal()) {
                this.report(reporter2, declaration2.getSource(), "is not allowed on local variables with initializer");
            } else {
                this.report(reporter2, declaration2.getSource(), "is not allowed on properties with initializer");
            }
        } else if (((FirProperty)declaration2).getDelegate() != null) {
            this.report(reporter2, declaration2.getSource(), "is not allowed on delegated properties");
        } else if (this.isNullable((FirProperty)declaration2)) {
            this.report(reporter2, declaration2.getSource(), "is not allowed on properties of a type with nullable upper bound");
        } else {
            FirTypeRef $this$coneType$iv = ((FirProperty)declaration2).getReturnTypeRef();
            boolean $i$f$getConeType = false;
            FirTypeRef $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
            boolean $i$f$coneTypeUnsafe = false;
            ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
            if (coneKotlinType == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
            if (this.getPrimitiveTypes(context2).contains(coneKotlinType)) {
                if (((FirProperty)declaration2).isLocal()) {
                    this.report(reporter2, declaration2.getSource(), "is not allowed on local variables of primitive types");
                } else {
                    this.report(reporter2, declaration2.getSource(), "is not allowed on properties of primitive types");
                }
            } else if (this.hasGetter((FirProperty)declaration2) || this.hasSetter((FirProperty)declaration2)) {
                this.report(reporter2, declaration2.getSource(), "is not allowed on properties with a custom getter or setter");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNullable(FirProperty $this$isNullable) {
        FirTypeRef $this$coneType$iv = $this$isNullable.getReturnTypeRef();
        boolean $i$f$getConeType = false;
        FirTypeRef $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
        boolean $i$f$coneTypeUnsafe = false;
        ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
        if (coneKotlinType == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
        }
        ConeKotlinType type2 = coneKotlinType;
        if (type2 instanceof ConeTypeParameterType) {
            ConeKotlinType coneKotlinType2;
            if (ConeTypeUtilsKt.isNullable(type2)) return true;
            Iterable $this$any$iv = ((FirTypeParameter)((ConeTypeParameterType)type2).getLookupTag().getTypeParameterSymbol().getFir()).getBounds();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                FirTypeRef it = (FirTypeRef)element$iv;
                boolean bl = false;
                FirTypeRef $this$coneType$iv2 = it;
                boolean $i$f$getConeType2 = false;
                FirTypeRef $this$coneTypeUnsafe$iv$iv2 = $this$coneType$iv2;
                boolean $i$f$coneTypeUnsafe2 = false;
                coneKotlinType2 = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv2).getType();
                if (coneKotlinType2 != null) continue;
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            } while (!ConeTypeUtilsKt.isNullable(coneKotlinType2));
            return true;
        }
        boolean bl = ConeTypeUtilsKt.isNullable(type2);
        return bl;
    }

    private final boolean hasGetter(FirProperty $this$hasGetter) {
        FirSourceElement firSourceElement;
        FirPropertyAccessor firPropertyAccessor;
        return $this$hasGetter.getGetter() != null && ((firPropertyAccessor = $this$hasGetter.getGetter()) == null ? null : firPropertyAccessor.getSource()) != null && !(((firPropertyAccessor = $this$hasGetter.getGetter()) == null ? null : ((firSourceElement = firPropertyAccessor.getSource()) == null ? null : firSourceElement.getKind())) instanceof FirFakeSourceElementKind);
    }

    private final boolean hasSetter(FirProperty $this$hasSetter) {
        FirSourceElement firSourceElement;
        FirPropertyAccessor firPropertyAccessor;
        return $this$hasSetter.getSetter() != null && ((firPropertyAccessor = $this$hasSetter.getSetter()) == null ? null : firPropertyAccessor.getSource()) != null && !(((firPropertyAccessor = $this$hasSetter.getSetter()) == null ? null : ((firSourceElement = firPropertyAccessor.getSource()) == null ? null : firSourceElement.getKind())) instanceof FirFakeSourceElementKind);
    }

    private final void report(DiagnosticReporter $this$report, FirSourceElement source, String target) {
        FirSourceElement firSourceElement = source;
        if (firSourceElement != null) {
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$report.report((FirDiagnostic)FirErrors.INSTANCE.getINAPPLICABLE_LATEINIT_MODIFIER().on(it, target));
        }
    }
}

