/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.indexing;

import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.LanguageFileType;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.LanguageSubstitutors;

public class SubstitutedFileType
extends LanguageFileType {
    @NotNull
    private final FileType myOriginalFileType;
    @NotNull
    private final FileType myFileType;

    private SubstitutedFileType(@NotNull FileType originalFileType, @NotNull LanguageFileType substitutionFileType, @NotNull Language substitutedLanguage) {
        if (originalFileType == null) {
            SubstitutedFileType.$$$reportNull$$$0(0);
        }
        if (substitutionFileType == null) {
            SubstitutedFileType.$$$reportNull$$$0(1);
        }
        if (substitutedLanguage == null) {
            SubstitutedFileType.$$$reportNull$$$0(2);
        }
        super(substitutedLanguage);
        this.myOriginalFileType = originalFileType;
        this.myFileType = substitutionFileType;
    }

    @NotNull
    public static FileType substituteFileType(@NotNull VirtualFile file2, @NotNull FileType fileType, @Nullable Project project) {
        if (file2 == null) {
            SubstitutedFileType.$$$reportNull$$$0(3);
        }
        if (fileType == null) {
            SubstitutedFileType.$$$reportNull$$$0(4);
        }
        if (project == null) {
            FileType fileType2 = fileType;
            if (fileType2 == null) {
                SubstitutedFileType.$$$reportNull$$$0(5);
            }
            return fileType2;
        }
        if (fileType instanceof LanguageFileType) {
            LanguageFileType substFileType;
            Language language = ((LanguageFileType)fileType).getLanguage();
            Language substitutedLanguage = LanguageSubstitutors.getInstance().substituteLanguage(language, file2, project);
            if (!substitutedLanguage.equals(language) && (substFileType = substitutedLanguage.getAssociatedFileType()) != null) {
                return new SubstitutedFileType(fileType, substFileType, substitutedLanguage);
            }
        }
        FileType fileType3 = fileType;
        if (fileType3 == null) {
            SubstitutedFileType.$$$reportNull$$$0(6);
        }
        return fileType3;
    }

    @Override
    @NotNull
    public String getName() {
        String string2 = this.myFileType.getName();
        if (string2 == null) {
            SubstitutedFileType.$$$reportNull$$$0(7);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getDescription() {
        String string2 = this.myFileType.getDescription();
        if (string2 == null) {
            SubstitutedFileType.$$$reportNull$$$0(8);
        }
        return string2;
    }

    @Override
    public Icon getIcon() {
        return this.myFileType.getIcon();
    }

    @Override
    public String getCharset(@NotNull VirtualFile file2, byte @NotNull [] content2) {
        if (file2 == null) {
            SubstitutedFileType.$$$reportNull$$$0(10);
        }
        if (content2 == null) {
            SubstitutedFileType.$$$reportNull$$$0(11);
        }
        return this.myFileType.getCharset(file2, content2);
    }

    @NotNull
    public FileType getOriginalFileType() {
        FileType fileType = this.myOriginalFileType;
        if (fileType == null) {
            SubstitutedFileType.$$$reportNull$$$0(12);
        }
        return fileType;
    }

    public String toString() {
        return "SubstitutedFileType: original=" + this.myOriginalFileType + "; substituted=" + this.myFileType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFileType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutionFileType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutedLanguage";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/indexing/SubstitutedFileType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/indexing/SubstitutedFileType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteFileType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultExtension";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalFileType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "substituteFileType";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCharset";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

