/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang.java.parser;

import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.kotlin.com.intellij.core.JavaPsiBundle;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilder;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilderUtil;
import org.jetbrains.kotlin.com.intellij.lang.WhitespacesBinders;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.JavaParser;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.JavaParserUtil;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.ReferenceParser;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.TokenType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;

public class ExpressionParser {
    private static final TokenSet ASSIGNMENT_OPS = TokenSet.create(JavaTokenType.EQ, JavaTokenType.ASTERISKEQ, JavaTokenType.DIVEQ, JavaTokenType.PERCEQ, JavaTokenType.PLUSEQ, JavaTokenType.MINUSEQ, JavaTokenType.LTLTEQ, JavaTokenType.GTGTEQ, JavaTokenType.GTGTGTEQ, JavaTokenType.ANDEQ, JavaTokenType.OREQ, JavaTokenType.XOREQ);
    private static final TokenSet RELATIONAL_OPS = TokenSet.create(JavaTokenType.LT, JavaTokenType.GT, JavaTokenType.LE, JavaTokenType.GE);
    private static final TokenSet POSTFIX_OPS = TokenSet.create(JavaTokenType.PLUSPLUS, JavaTokenType.MINUSMINUS);
    private static final TokenSet PREF_ARITHMETIC_OPS = TokenSet.orSet(POSTFIX_OPS, TokenSet.create(JavaTokenType.PLUS, JavaTokenType.MINUS));
    private static final TokenSet PREFIX_OPS = TokenSet.orSet(PREF_ARITHMETIC_OPS, TokenSet.create(JavaTokenType.TILDE, JavaTokenType.EXCL));
    private static final TokenSet CONDITIONAL_OR_OPS = TokenSet.create(JavaTokenType.OROR);
    private static final TokenSet CONDITIONAL_AND_OPS = TokenSet.create(JavaTokenType.ANDAND);
    private static final TokenSet OR_OPS = TokenSet.create(JavaTokenType.OR);
    private static final TokenSet XOR_OPS = TokenSet.create(JavaTokenType.XOR);
    private static final TokenSet AND_OPS = TokenSet.create(JavaTokenType.AND);
    private static final TokenSet EQUALITY_OPS = TokenSet.create(JavaTokenType.EQEQ, JavaTokenType.NE);
    private static final TokenSet SHIFT_OPS = TokenSet.create(JavaTokenType.LTLT, JavaTokenType.GTGT, JavaTokenType.GTGTGT);
    private static final TokenSet ADDITIVE_OPS = TokenSet.create(JavaTokenType.PLUS, JavaTokenType.MINUS);
    private static final TokenSet MULTIPLICATIVE_OPS = TokenSet.create(JavaTokenType.ASTERISK, JavaTokenType.DIV, JavaTokenType.PERC);
    private static final TokenSet ARGS_LIST_END = TokenSet.create(JavaTokenType.RPARENTH, JavaTokenType.RBRACE, JavaTokenType.RBRACKET);
    private static final TokenSet ARGS_LIST_CONTINUE = TokenSet.create(JavaTokenType.IDENTIFIER, TokenType.BAD_CHARACTER, JavaTokenType.COMMA, JavaTokenType.INTEGER_LITERAL, JavaTokenType.STRING_LITERAL);
    private static final TokenSet THIS_OR_SUPER = TokenSet.create(JavaTokenType.THIS_KEYWORD, JavaTokenType.SUPER_KEYWORD);
    private static final TokenSet ID_OR_SUPER = TokenSet.create(JavaTokenType.IDENTIFIER, JavaTokenType.SUPER_KEYWORD);
    private static final TokenSet TYPE_START = TokenSet.orSet(ElementType.PRIMITIVE_TYPE_BIT_SET, TokenSet.create(JavaTokenType.IDENTIFIER, JavaTokenType.AT));
    private static final Key<Boolean> CASE_LABEL = Key.create("java.parser.case.label.expr");
    private final JavaParser myParser;

    public ExpressionParser(@NotNull JavaParser javaParser) {
        if (javaParser == null) {
            ExpressionParser.$$$reportNull$$$0(0);
        }
        this.myParser = javaParser;
    }

    @Nullable
    public PsiBuilder.Marker parse(@NotNull PsiBuilder builder2) {
        if (builder2 == null) {
            ExpressionParser.$$$reportNull$$$0(1);
        }
        return this.parseAssignment(builder2);
    }

    @Nullable
    public PsiBuilder.Marker parseCaseLabel(@NotNull PsiBuilder builder2) {
        if (builder2 == null) {
            ExpressionParser.$$$reportNull$$$0(2);
        }
        CASE_LABEL.set(builder2, Boolean.TRUE);
        try {
            PsiBuilder.Marker marker = this.parseAssignment(builder2);
            return marker;
        }
        finally {
            CASE_LABEL.set(builder2, null);
        }
    }

    @Nullable
    private PsiBuilder.Marker parseAssignment(PsiBuilder builder2) {
        PsiBuilder.Marker left = this.parseConditional(builder2);
        if (left == null) {
            return null;
        }
        IElementType tokenType = ExpressionParser.getGtTokenType(builder2);
        if (tokenType != null && ASSIGNMENT_OPS.contains(tokenType)) {
            PsiBuilder.Marker assignment = left.precede();
            ExpressionParser.advanceGtToken(builder2, tokenType);
            PsiBuilder.Marker right = this.parse(builder2);
            if (right == null) {
                JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.expression", new Object[0]));
            }
            assignment.done(JavaElementType.ASSIGNMENT_EXPRESSION);
            return assignment;
        }
        return left;
    }

    @Nullable
    public PsiBuilder.Marker parseConditional(PsiBuilder builder2) {
        PsiBuilder.Marker condition = this.parseExpression(builder2, ExprType.CONDITIONAL_OR);
        if (condition == null) {
            return null;
        }
        if (builder2.getTokenType() != JavaTokenType.QUEST) {
            return condition;
        }
        PsiBuilder.Marker ternary = condition.precede();
        builder2.advanceLexer();
        PsiBuilder.Marker truePart = this.parse(builder2);
        if (truePart == null) {
            JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.expression", new Object[0]));
            ternary.done(JavaElementType.CONDITIONAL_EXPRESSION);
            return ternary;
        }
        if (builder2.getTokenType() != JavaTokenType.COLON) {
            JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.colon", new Object[0]));
            ternary.done(JavaElementType.CONDITIONAL_EXPRESSION);
            return ternary;
        }
        builder2.advanceLexer();
        PsiBuilder.Marker falsePart = this.parseConditional(builder2);
        if (falsePart == null) {
            JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.expression", new Object[0]));
            ternary.done(JavaElementType.CONDITIONAL_EXPRESSION);
            return ternary;
        }
        ternary.done(JavaElementType.CONDITIONAL_EXPRESSION);
        return ternary;
    }

    @Nullable
    private PsiBuilder.Marker parseExpression(PsiBuilder builder2, ExprType type2) {
        switch (type2) {
            case CONDITIONAL_OR: {
                return this.parseBinary(builder2, ExprType.CONDITIONAL_AND, CONDITIONAL_OR_OPS);
            }
            case CONDITIONAL_AND: {
                return this.parseBinary(builder2, ExprType.OR, CONDITIONAL_AND_OPS);
            }
            case OR: {
                return this.parseBinary(builder2, ExprType.XOR, OR_OPS);
            }
            case XOR: {
                return this.parseBinary(builder2, ExprType.AND, XOR_OPS);
            }
            case AND: {
                return this.parseBinary(builder2, ExprType.EQUALITY, AND_OPS);
            }
            case EQUALITY: {
                return this.parseBinary(builder2, ExprType.RELATIONAL, EQUALITY_OPS);
            }
            case RELATIONAL: {
                return this.parseRelational(builder2);
            }
            case SHIFT: {
                return this.parseBinary(builder2, ExprType.ADDITIVE, SHIFT_OPS);
            }
            case ADDITIVE: {
                return this.parseBinary(builder2, ExprType.MULTIPLICATIVE, ADDITIVE_OPS);
            }
            case MULTIPLICATIVE: {
                return this.parseBinary(builder2, ExprType.UNARY, MULTIPLICATIVE_OPS);
            }
            case UNARY: {
                return this.parseUnary(builder2);
            }
            case TYPE: {
                return this.myParser.getReferenceParser().parseType(builder2, 5);
            }
        }
        assert (false) : "Unexpected type: " + (Object)((Object)type2);
        return null;
    }

    @Nullable
    private PsiBuilder.Marker parsePattern(PsiBuilder builder2) {
        PsiBuilder.Marker pattern = builder2.mark();
        PsiBuilder.Marker patternVariable = builder2.mark();
        PsiBuilder.Marker type2 = this.myParser.getReferenceParser().parseType(builder2, 5);
        if (type2 == null) {
            patternVariable.drop();
            pattern.drop();
            return null;
        }
        if (!PsiBuilderUtil.expect(builder2, JavaTokenType.IDENTIFIER)) {
            patternVariable.drop();
        } else {
            patternVariable.done(JavaElementType.PATTERN_VARIABLE);
        }
        pattern.done(JavaElementType.TYPE_TEST_PATTERN);
        return pattern;
    }

    @Nullable
    private PsiBuilder.Marker parseBinary(PsiBuilder builder2, ExprType type2, TokenSet ops) {
        IElementType tokenType;
        PsiBuilder.Marker result2 = this.parseExpression(builder2, type2);
        if (result2 == null) {
            return null;
        }
        int operandCount = 1;
        IElementType currentExprTokenType = tokenType = ExpressionParser.getGtTokenType(builder2);
        while (tokenType != null && ops.contains(tokenType)) {
            ExpressionParser.advanceGtToken(builder2, tokenType);
            PsiBuilder.Marker right = this.parseExpression(builder2, type2);
            ++operandCount;
            tokenType = ExpressionParser.getGtTokenType(builder2);
            if (tokenType != null && ops.contains(tokenType) && tokenType == currentExprTokenType && right != null) continue;
            result2 = result2.precede();
            if (right == null) {
                JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.expression", new Object[0]));
            }
            result2.done(operandCount > 2 ? JavaElementType.POLYADIC_EXPRESSION : JavaElementType.BINARY_EXPRESSION);
            if (right == null) break;
            currentExprTokenType = tokenType;
            operandCount = 1;
        }
        return result2;
    }

    @Nullable
    private PsiBuilder.Marker parseRelational(PsiBuilder builder2) {
        IElementType tokenType;
        PsiBuilder.Marker left = this.parseExpression(builder2, ExprType.SHIFT);
        if (left == null) {
            return null;
        }
        while ((tokenType = ExpressionParser.getGtTokenType(builder2)) != null) {
            PsiBuilder.Marker right;
            boolean patternExpected;
            IElementType toCreate;
            if (RELATIONAL_OPS.contains(tokenType)) {
                toCreate = JavaElementType.BINARY_EXPRESSION;
                patternExpected = false;
            } else {
                if (tokenType != JavaTokenType.INSTANCEOF_KEYWORD) break;
                toCreate = JavaElementType.INSTANCE_OF_EXPRESSION;
                patternExpected = true;
            }
            PsiBuilder.Marker expression2 = left.precede();
            ExpressionParser.advanceGtToken(builder2, tokenType);
            PsiBuilder.Marker marker = right = patternExpected ? this.parsePattern(builder2) : this.parseExpression(builder2, ExprType.SHIFT);
            if (right == null) {
                JavaParserUtil.error(builder2, JavaPsiBundle.message(patternExpected ? "expected.type" : "expected.expression", new Object[0]));
                expression2.done(toCreate);
                return expression2;
            }
            expression2.done(toCreate);
            left = expression2;
        }
        return left;
    }

    @Nullable
    private PsiBuilder.Marker parseUnary(PsiBuilder builder2) {
        IElementType tokenType = builder2.getTokenType();
        if (PREFIX_OPS.contains(tokenType)) {
            PsiBuilder.Marker unary = builder2.mark();
            builder2.advanceLexer();
            PsiBuilder.Marker operand = this.parseUnary(builder2);
            if (operand == null) {
                JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.expression", new Object[0]));
            }
            unary.done(JavaElementType.PREFIX_EXPRESSION);
            return unary;
        }
        if (tokenType == JavaTokenType.LPARENTH) {
            PsiBuilder.Marker typeCast = builder2.mark();
            builder2.advanceLexer();
            ReferenceParser.TypeInfo typeInfo = this.myParser.getReferenceParser().parseTypeInfo(builder2, 101);
            if (typeInfo == null || !PsiBuilderUtil.expect(builder2, JavaTokenType.RPARENTH)) {
                typeCast.rollbackTo();
                return this.parsePostfix(builder2);
            }
            if (PREF_ARITHMETIC_OPS.contains(builder2.getTokenType()) && !typeInfo.isPrimitive) {
                typeCast.rollbackTo();
                return this.parsePostfix(builder2);
            }
            PsiBuilder.Marker expr = this.parseUnary(builder2);
            if (expr == null) {
                if (!typeInfo.isParameterized) {
                    typeCast.rollbackTo();
                    return this.parsePostfix(builder2);
                }
                JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.expression", new Object[0]));
            }
            typeCast.done(JavaElementType.TYPE_CAST_EXPRESSION);
            return typeCast;
        }
        if (tokenType == JavaTokenType.SWITCH_KEYWORD) {
            return this.myParser.getStatementParser().parseExprInParenthWithBlock(builder2, JavaElementType.SWITCH_EXPRESSION, true);
        }
        return this.parsePostfix(builder2);
    }

    @Nullable
    private PsiBuilder.Marker parsePostfix(PsiBuilder builder2) {
        PsiBuilder.Marker operand = this.parsePrimary(builder2, null, -1);
        if (operand == null) {
            return null;
        }
        while (POSTFIX_OPS.contains(builder2.getTokenType())) {
            PsiBuilder.Marker postfix = operand.precede();
            builder2.advanceLexer();
            postfix.done(JavaElementType.POSTFIX_EXPRESSION);
            operand = postfix;
        }
        return operand;
    }

    @Nullable
    private PsiBuilder.Marker parsePrimary(PsiBuilder builder2, @Nullable BreakPoint breakPoint, int breakOffset) {
        IElementType tokenType;
        PsiBuilder.Marker startMarker = builder2.mark();
        PsiBuilder.Marker expr = this.parsePrimaryExpressionStart(builder2);
        if (expr == null) {
            startMarker.drop();
            return null;
        }
        while (true) {
            if ((tokenType = builder2.getTokenType()) == JavaTokenType.DOT) {
                PsiBuilder.Marker refExpr;
                int offset2;
                PsiBuilder.Marker copy2;
                PsiBuilder.Marker dotPos = builder2.mark();
                int dotOffset = builder2.getCurrentOffset();
                builder2.advanceLexer();
                IElementType dotTokenType = builder2.getTokenType();
                if (dotTokenType == JavaTokenType.AT) {
                    this.myParser.getDeclarationParser().parseAnnotations(builder2);
                    dotTokenType = builder2.getTokenType();
                }
                if (dotTokenType == JavaTokenType.CLASS_KEYWORD && JavaParserUtil.exprType(expr) == JavaElementType.REFERENCE_EXPRESSION) {
                    if (breakPoint == BreakPoint.P1 && builder2.getCurrentOffset() == breakOffset) {
                        JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.identifier", new Object[0]));
                        PsiBuilderUtil.drop(startMarker, dotPos);
                        return expr;
                    }
                    copy2 = startMarker.precede();
                    offset2 = builder2.getCurrentOffset();
                    startMarker.rollbackTo();
                    PsiBuilder.Marker classObjAccess = this.parseClassAccessOrMethodReference(builder2);
                    if (classObjAccess == null || builder2.getCurrentOffset() < offset2) {
                        copy2.rollbackTo();
                        return this.parsePrimary(builder2, BreakPoint.P1, offset2);
                    }
                    startMarker = copy2;
                    expr = classObjAccess;
                    continue;
                }
                if (dotTokenType == JavaTokenType.NEW_KEYWORD) {
                    dotPos.drop();
                    expr = this.parseNew(builder2, expr);
                    continue;
                }
                if (dotTokenType == JavaTokenType.SUPER_KEYWORD && builder2.lookAhead(1) == JavaTokenType.LPARENTH) {
                    dotPos.drop();
                    refExpr = expr.precede();
                    builder2.mark().done(JavaElementType.REFERENCE_PARAMETER_LIST);
                    builder2.advanceLexer();
                    refExpr.done(JavaElementType.REFERENCE_EXPRESSION);
                    expr = refExpr;
                    continue;
                }
                if (THIS_OR_SUPER.contains(dotTokenType) && JavaParserUtil.exprType(expr) == JavaElementType.REFERENCE_EXPRESSION) {
                    if (breakPoint == BreakPoint.P2 && builder2.getCurrentOffset() == breakOffset) {
                        dotPos.rollbackTo();
                        startMarker.drop();
                        return expr;
                    }
                    copy2 = startMarker.precede();
                    offset2 = builder2.getCurrentOffset();
                    startMarker.rollbackTo();
                    PsiBuilder.Marker ref = this.myParser.getReferenceParser().parseJavaCodeReference(builder2, false, true, false, false);
                    if (ref == null || builder2.getTokenType() != JavaTokenType.DOT || builder2.getCurrentOffset() != dotOffset) {
                        copy2.rollbackTo();
                        return this.parsePrimary(builder2, BreakPoint.P2, offset2);
                    }
                    builder2.advanceLexer();
                    if (builder2.getTokenType() != dotTokenType) {
                        copy2.rollbackTo();
                        return this.parsePrimary(builder2, BreakPoint.P2, offset2);
                    }
                    builder2.advanceLexer();
                    startMarker = copy2;
                    expr = ref.precede();
                    expr.done(dotTokenType == JavaTokenType.THIS_KEYWORD ? JavaElementType.THIS_EXPRESSION : JavaElementType.SUPER_EXPRESSION);
                    continue;
                }
                refExpr = expr.precede();
                this.myParser.getReferenceParser().parseReferenceParameterList(builder2, false, false);
                if (!PsiBuilderUtil.expect(builder2, ID_OR_SUPER)) {
                    dotPos.rollbackTo();
                    builder2.advanceLexer();
                    this.myParser.getReferenceParser().parseReferenceParameterList(builder2, false, false);
                    JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.identifier", new Object[0]));
                    refExpr.done(JavaElementType.REFERENCE_EXPRESSION);
                    startMarker.drop();
                    return refExpr;
                }
                dotPos.drop();
                refExpr.done(JavaElementType.REFERENCE_EXPRESSION);
                expr = refExpr;
                continue;
            }
            if (tokenType == JavaTokenType.LPARENTH) {
                if (JavaParserUtil.exprType(expr) != JavaElementType.REFERENCE_EXPRESSION) {
                    startMarker.drop();
                    return expr;
                }
                PsiBuilder.Marker callExpr = expr.precede();
                this.parseArgumentList(builder2);
                callExpr.done(JavaElementType.METHOD_CALL_EXPRESSION);
                expr = callExpr;
                continue;
            }
            if (tokenType != JavaTokenType.LBRACKET) break;
            if (breakPoint == BreakPoint.P4) {
                startMarker.drop();
                return expr;
            }
            builder2.advanceLexer();
            if (builder2.getTokenType() == JavaTokenType.RBRACKET && JavaParserUtil.exprType(expr) == JavaElementType.REFERENCE_EXPRESSION) {
                int pos = builder2.getCurrentOffset();
                PsiBuilder.Marker copy3 = startMarker.precede();
                startMarker.rollbackTo();
                PsiBuilder.Marker classObjAccess = this.parseClassAccessOrMethodReference(builder2);
                if (classObjAccess == null || builder2.getCurrentOffset() <= pos) {
                    copy3.rollbackTo();
                    return this.parsePrimary(builder2, BreakPoint.P4, -1);
                }
                startMarker = copy3;
                expr = classObjAccess;
                continue;
            }
            PsiBuilder.Marker arrayAccess = expr.precede();
            PsiBuilder.Marker index2 = this.parse(builder2);
            if (index2 == null) {
                JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.expression", new Object[0]));
                arrayAccess.done(JavaElementType.ARRAY_ACCESS_EXPRESSION);
                startMarker.drop();
                return arrayAccess;
            }
            if (builder2.getTokenType() != JavaTokenType.RBRACKET) {
                JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.rbracket", new Object[0]));
                arrayAccess.done(JavaElementType.ARRAY_ACCESS_EXPRESSION);
                startMarker.drop();
                return arrayAccess;
            }
            builder2.advanceLexer();
            arrayAccess.done(JavaElementType.ARRAY_ACCESS_EXPRESSION);
            expr = arrayAccess;
        }
        if (tokenType == JavaTokenType.DOUBLE_COLON) {
            return this.parseMethodReference(builder2, startMarker);
        }
        startMarker.drop();
        return expr;
    }

    @Nullable
    private PsiBuilder.Marker parsePrimaryExpressionStart(PsiBuilder builder2) {
        IElementType tokenType = builder2.getTokenType();
        if (ElementType.ALL_LITERALS.contains(tokenType)) {
            PsiBuilder.Marker literal = builder2.mark();
            builder2.advanceLexer();
            literal.done(JavaElementType.LITERAL_EXPRESSION);
            return literal;
        }
        if (tokenType == JavaTokenType.LBRACE) {
            return this.parseArrayInitializer(builder2);
        }
        if (tokenType == JavaTokenType.NEW_KEYWORD) {
            return this.parseNew(builder2, null);
        }
        if (tokenType == JavaTokenType.LPARENTH) {
            PsiBuilder.Marker lambda2;
            if (CASE_LABEL.get(builder2) != Boolean.TRUE && (lambda2 = this.parseLambdaAfterParenth(builder2)) != null) {
                return lambda2;
            }
            PsiBuilder.Marker parenth = builder2.mark();
            builder2.advanceLexer();
            PsiBuilder.Marker inner = this.parse(builder2);
            if (inner == null) {
                JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.expression", new Object[0]));
            }
            if (!PsiBuilderUtil.expect(builder2, JavaTokenType.RPARENTH) && inner != null) {
                JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.rparen", new Object[0]));
            }
            parenth.done(JavaElementType.PARENTH_EXPRESSION);
            return parenth;
        }
        if (TYPE_START.contains(tokenType)) {
            PsiBuilder.Marker mark = builder2.mark();
            ReferenceParser.TypeInfo typeInfo = this.myParser.getReferenceParser().parseTypeInfo(builder2, 0);
            if (typeInfo != null) {
                PsiBuilder.Marker result2;
                boolean optionalClassKeyword;
                boolean bl = optionalClassKeyword = typeInfo.isPrimitive || typeInfo.isArray;
                if ((optionalClassKeyword || !typeInfo.hasErrors && typeInfo.isParameterized) && (result2 = this.parseClassAccessOrMethodReference(builder2, mark, optionalClassKeyword)) != null) {
                    return result2;
                }
            }
            mark.rollbackTo();
        }
        PsiBuilder.Marker annotation2 = null;
        if (tokenType == JavaTokenType.AT) {
            annotation2 = this.myParser.getDeclarationParser().parseAnnotations(builder2);
            tokenType = builder2.getTokenType();
        }
        if (tokenType == JavaTokenType.VAR_KEYWORD) {
            tokenType = JavaTokenType.IDENTIFIER;
            builder2.remapCurrentToken(tokenType);
        }
        if (tokenType == JavaTokenType.IDENTIFIER) {
            PsiBuilder.Marker refExpr;
            if (CASE_LABEL.get(builder2) != Boolean.TRUE && builder2.lookAhead(1) == JavaTokenType.ARROW) {
                return this.parseLambdaExpression(builder2, false);
            }
            if (annotation2 != null) {
                PsiBuilder.Marker refParam = annotation2.precede();
                refParam.doneBefore(JavaElementType.REFERENCE_PARAMETER_LIST, annotation2);
                refExpr = refParam.precede();
            } else {
                refExpr = builder2.mark();
                builder2.mark().done(JavaElementType.REFERENCE_PARAMETER_LIST);
            }
            builder2.advanceLexer();
            refExpr.done(JavaElementType.REFERENCE_EXPRESSION);
            return refExpr;
        }
        if (annotation2 != null) {
            annotation2.rollbackTo();
            tokenType = builder2.getTokenType();
        }
        PsiBuilder.Marker expr = null;
        if (tokenType == JavaTokenType.LT) {
            expr = builder2.mark();
            if (!this.myParser.getReferenceParser().parseReferenceParameterList(builder2, false, false)) {
                expr.rollbackTo();
                return null;
            }
            tokenType = builder2.getTokenType();
            if (!THIS_OR_SUPER.contains(tokenType)) {
                expr.rollbackTo();
                return null;
            }
        }
        if (THIS_OR_SUPER.contains(tokenType)) {
            if (expr == null) {
                expr = builder2.mark();
                builder2.mark().done(JavaElementType.REFERENCE_PARAMETER_LIST);
            }
            builder2.advanceLexer();
            expr.done(builder2.getTokenType() == JavaTokenType.LPARENTH ? JavaElementType.REFERENCE_EXPRESSION : (tokenType == JavaTokenType.THIS_KEYWORD ? JavaElementType.THIS_EXPRESSION : JavaElementType.SUPER_EXPRESSION));
            return expr;
        }
        return null;
    }

    @NotNull
    private PsiBuilder.Marker parseArrayInitializer(PsiBuilder builder2) {
        PsiBuilder.Marker marker = this.parseArrayInitializer(builder2, JavaElementType.ARRAY_INITIALIZER_EXPRESSION, this::parse, "expected.expression");
        if (marker == null) {
            ExpressionParser.$$$reportNull$$$0(3);
        }
        return marker;
    }

    @NotNull
    public PsiBuilder.Marker parseArrayInitializer(@NotNull PsiBuilder builder2, @NotNull IElementType type2, @NotNull Function<? super PsiBuilder, PsiBuilder.Marker> elementParser, @NotNull @PropertyKey(resourceBundle="messages.JavaPsiBundle") String missingElementKey) {
        if (builder2 == null) {
            ExpressionParser.$$$reportNull$$$0(4);
        }
        if (type2 == null) {
            ExpressionParser.$$$reportNull$$$0(5);
        }
        if (elementParser == null) {
            ExpressionParser.$$$reportNull$$$0(6);
        }
        if (missingElementKey == null) {
            ExpressionParser.$$$reportNull$$$0(7);
        }
        PsiBuilder.Marker arrayInit = builder2.mark();
        builder2.advanceLexer();
        boolean first2 = true;
        while (true) {
            if (builder2.getTokenType() == JavaTokenType.RBRACE) {
                builder2.advanceLexer();
                break;
            }
            if (builder2.getTokenType() == null) {
                JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.rbrace", new Object[0]));
                break;
            }
            if (elementParser.apply(builder2) == null) {
                if (builder2.getTokenType() == JavaTokenType.COMMA) {
                    if (first2 && builder2.lookAhead(1) == JavaTokenType.RBRACE) {
                        PsiBuilderUtil.advance(builder2, 2);
                        break;
                    }
                    builder2.error(JavaPsiBundle.message(missingElementKey, new Object[0]));
                } else if (builder2.getTokenType() != JavaTokenType.RBRACE) {
                    JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.rbrace", new Object[0]));
                    break;
                }
            }
            first2 = false;
            IElementType tokenType = builder2.getTokenType();
            if (PsiBuilderUtil.expect(builder2, JavaTokenType.COMMA) || tokenType == JavaTokenType.RBRACE) continue;
            JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.comma", new Object[0]));
        }
        arrayInit.done(type2);
        PsiBuilder.Marker marker = arrayInit;
        if (marker == null) {
            ExpressionParser.$$$reportNull$$$0(8);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseNew(PsiBuilder builder2, @Nullable PsiBuilder.Marker start) {
        int dimCount;
        PsiBuilder.Marker anno;
        PsiBuilder.Marker newExpr;
        block19: {
            PsiBuilder.Marker refOrType;
            newExpr = start != null ? start.precede() : builder2.mark();
            builder2.advanceLexer();
            this.myParser.getReferenceParser().parseReferenceParameterList(builder2, false, true);
            anno = this.myParser.getDeclarationParser().parseAnnotations(builder2);
            IElementType tokenType = builder2.getTokenType();
            if (tokenType == JavaTokenType.IDENTIFIER) {
                PsiBuilderUtil.rollbackTo(anno);
                refOrType = this.myParser.getReferenceParser().parseJavaCodeReference(builder2, true, true, true, true);
                if (refOrType == null) {
                    JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.identifier", new Object[0]));
                    newExpr.done(JavaElementType.NEW_EXPRESSION);
                    PsiBuilder.Marker marker = newExpr;
                    if (marker == null) {
                        ExpressionParser.$$$reportNull$$$0(9);
                    }
                    return marker;
                }
            } else if (ElementType.PRIMITIVE_TYPE_BIT_SET.contains(tokenType)) {
                refOrType = null;
                builder2.advanceLexer();
            } else {
                JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.identifier", new Object[0]));
                newExpr.done(JavaElementType.NEW_EXPRESSION);
                PsiBuilder.Marker marker = newExpr;
                if (marker == null) {
                    ExpressionParser.$$$reportNull$$$0(10);
                }
                return marker;
            }
            if (refOrType != null && builder2.getTokenType() == JavaTokenType.LPARENTH) {
                this.parseArgumentList(builder2);
                if (builder2.getTokenType() == JavaTokenType.LBRACE) {
                    PsiBuilder.Marker classElement = refOrType.precede();
                    this.myParser.getDeclarationParser().parseClassBodyWithBraces(builder2, false, false);
                    classElement.done(JavaElementType.ANONYMOUS_CLASS);
                }
                newExpr.done(JavaElementType.NEW_EXPRESSION);
                PsiBuilder.Marker marker = newExpr;
                if (marker == null) {
                    ExpressionParser.$$$reportNull$$$0(11);
                }
                return marker;
            }
            anno = this.myParser.getDeclarationParser().parseAnnotations(builder2);
            if (builder2.getTokenType() != JavaTokenType.LBRACKET) {
                PsiBuilderUtil.rollbackTo(anno);
                JavaParserUtil.error(builder2, JavaPsiBundle.message(refOrType == null ? "expected.lbracket" : "expected.lparen.or.lbracket", new Object[0]));
                newExpr.done(JavaElementType.NEW_EXPRESSION);
                PsiBuilder.Marker marker = newExpr;
                if (marker == null) {
                    ExpressionParser.$$$reportNull$$$0(12);
                }
                return marker;
            }
            int bracketCount = 0;
            dimCount = 0;
            do {
                PsiBuilder.Marker dimExpr;
                anno = this.myParser.getDeclarationParser().parseAnnotations(builder2);
                if (builder2.getTokenType() != JavaTokenType.LBRACKET) break block19;
                builder2.advanceLexer();
                if (bracketCount == dimCount && (dimExpr = this.parse(builder2)) != null) {
                    ++dimCount;
                }
                ++bracketCount;
            } while (JavaParserUtil.expectOrError(builder2, JavaTokenType.RBRACKET, "expected.rbracket"));
            newExpr.done(JavaElementType.NEW_EXPRESSION);
            PsiBuilder.Marker marker = newExpr;
            if (marker == null) {
                ExpressionParser.$$$reportNull$$$0(13);
            }
            return marker;
        }
        PsiBuilderUtil.rollbackTo(anno);
        if (dimCount == 0) {
            if (builder2.getTokenType() == JavaTokenType.LBRACE) {
                this.parseArrayInitializer(builder2);
            } else {
                JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.array.initializer", new Object[0]));
            }
        }
        newExpr.done(JavaElementType.NEW_EXPRESSION);
        PsiBuilder.Marker marker = newExpr;
        if (marker == null) {
            ExpressionParser.$$$reportNull$$$0(14);
        }
        return marker;
    }

    @Nullable
    private PsiBuilder.Marker parseClassAccessOrMethodReference(PsiBuilder builder2) {
        PsiBuilder.Marker expr = builder2.mark();
        boolean primitive = ElementType.PRIMITIVE_TYPE_BIT_SET.contains(builder2.getTokenType());
        if (this.myParser.getReferenceParser().parseType(builder2, 0) == null) {
            expr.drop();
            return null;
        }
        PsiBuilder.Marker result2 = this.parseClassAccessOrMethodReference(builder2, expr, primitive);
        if (result2 == null) {
            expr.rollbackTo();
        }
        return result2;
    }

    @Nullable
    private PsiBuilder.Marker parseClassAccessOrMethodReference(PsiBuilder builder2, PsiBuilder.Marker expr, boolean optionalClassKeyword) {
        IElementType tokenType = builder2.getTokenType();
        if (tokenType == JavaTokenType.DOT) {
            return ExpressionParser.parseClassObjectAccess(builder2, expr, optionalClassKeyword);
        }
        if (tokenType == JavaTokenType.DOUBLE_COLON) {
            return this.parseMethodReference(builder2, expr);
        }
        return null;
    }

    @Nullable
    private static PsiBuilder.Marker parseClassObjectAccess(PsiBuilder builder2, PsiBuilder.Marker expr, boolean optionalClassKeyword) {
        PsiBuilder.Marker mark = builder2.mark();
        builder2.advanceLexer();
        if (builder2.getTokenType() == JavaTokenType.CLASS_KEYWORD) {
            mark.drop();
            builder2.advanceLexer();
        } else {
            if (!optionalClassKeyword) {
                return null;
            }
            mark.rollbackTo();
            builder2.error(JavaPsiBundle.message("class.literal.expected", new Object[0]));
        }
        expr.done(JavaElementType.CLASS_OBJECT_ACCESS_EXPRESSION);
        return expr;
    }

    @NotNull
    private PsiBuilder.Marker parseMethodReference(PsiBuilder builder2, PsiBuilder.Marker start) {
        builder2.advanceLexer();
        this.myParser.getReferenceParser().parseReferenceParameterList(builder2, false, false);
        if (!PsiBuilderUtil.expect(builder2, JavaTokenType.IDENTIFIER) && !PsiBuilderUtil.expect(builder2, JavaTokenType.NEW_KEYWORD)) {
            JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.identifier", new Object[0]));
        }
        start.done(JavaElementType.METHOD_REF_EXPRESSION);
        PsiBuilder.Marker marker = start;
        if (marker == null) {
            ExpressionParser.$$$reportNull$$$0(15);
        }
        return marker;
    }

    @Nullable
    private PsiBuilder.Marker parseLambdaAfterParenth(PsiBuilder builder2) {
        boolean isTyped;
        boolean isLambda;
        IElementType nextToken1 = builder2.lookAhead(1);
        IElementType nextToken2 = builder2.lookAhead(2);
        if (nextToken1 == JavaTokenType.RPARENTH && nextToken2 == JavaTokenType.ARROW) {
            isLambda = true;
            isTyped = false;
        } else if (nextToken1 == JavaTokenType.AT || ElementType.MODIFIER_BIT_SET.contains(nextToken1) || ElementType.PRIMITIVE_TYPE_BIT_SET.contains(nextToken1)) {
            isLambda = true;
            isTyped = true;
        } else if (nextToken1 == JavaTokenType.IDENTIFIER) {
            if (nextToken2 == JavaTokenType.COMMA || nextToken2 == JavaTokenType.RPARENTH && builder2.lookAhead(3) == JavaTokenType.ARROW) {
                isLambda = true;
                isTyped = false;
            } else if (nextToken2 == JavaTokenType.ARROW) {
                isLambda = false;
                isTyped = false;
            } else {
                IElementType t;
                boolean lambda2 = false;
                PsiBuilder.Marker marker = builder2.mark();
                builder2.advanceLexer();
                ReferenceParser.TypeInfo typeInfo = this.myParser.getReferenceParser().parseTypeInfo(builder2, 7);
                if (typeInfo != null && ((t = builder2.getTokenType()) == JavaTokenType.IDENTIFIER || t == JavaTokenType.THIS_KEYWORD || t == JavaTokenType.RPARENTH && builder2.lookAhead(1) == JavaTokenType.ARROW)) {
                    lambda2 = true;
                }
                marker.rollbackTo();
                isLambda = lambda2;
                isTyped = true;
            }
        } else {
            isLambda = false;
            isTyped = false;
        }
        return isLambda ? this.parseLambdaExpression(builder2, isTyped) : null;
    }

    @Nullable
    private PsiBuilder.Marker parseLambdaExpression(PsiBuilder builder2, boolean typed) {
        PsiBuilder.Marker start = builder2.mark();
        this.myParser.getDeclarationParser().parseLambdaParameterList(builder2, typed);
        if (!PsiBuilderUtil.expect(builder2, JavaTokenType.ARROW)) {
            start.rollbackTo();
            return null;
        }
        PsiBuilder.Marker body2 = builder2.getTokenType() == JavaTokenType.LBRACE ? this.myParser.getStatementParser().parseCodeBlock(builder2) : this.parse(builder2);
        if (body2 == null) {
            builder2.error(JavaPsiBundle.message("expected.lbrace", new Object[0]));
        }
        start.done(JavaElementType.LAMBDA_EXPRESSION);
        return start;
    }

    @NotNull
    public PsiBuilder.Marker parseArgumentList(PsiBuilder builder2) {
        PsiBuilder.Marker list2 = builder2.mark();
        builder2.advanceLexer();
        boolean first2 = true;
        while (true) {
            IElementType tokenType = builder2.getTokenType();
            if (first2 && (ARGS_LIST_END.contains(tokenType) || builder2.eof()) || !first2 && !ARGS_LIST_CONTINUE.contains(tokenType)) break;
            boolean hasError = false;
            if (!first2) {
                if (builder2.getTokenType() == JavaTokenType.COMMA) {
                    builder2.advanceLexer();
                } else {
                    hasError = true;
                    JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.comma.or.rparen", new Object[0]));
                    ExpressionParser.emptyExpression(builder2);
                }
            }
            first2 = false;
            PsiBuilder.Marker arg = this.parse(builder2);
            if (arg != null) continue;
            if (!hasError) {
                JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.expression", new Object[0]));
                ExpressionParser.emptyExpression(builder2);
            }
            if (!ARGS_LIST_CONTINUE.contains(builder2.getTokenType())) break;
            if (builder2.getTokenType() == JavaTokenType.COMMA || builder2.eof()) continue;
            builder2.advanceLexer();
        }
        boolean closed = JavaParserUtil.expectOrError(builder2, JavaTokenType.RPARENTH, "expected.rparen");
        list2.done(JavaElementType.EXPRESSION_LIST);
        if (!closed) {
            list2.setCustomEdgeTokenBinders(null, WhitespacesBinders.GREEDY_RIGHT_BINDER);
        }
        PsiBuilder.Marker marker = list2;
        if (marker == null) {
            ExpressionParser.$$$reportNull$$$0(16);
        }
        return marker;
    }

    private static void emptyExpression(PsiBuilder builder2) {
        JavaParserUtil.emptyElement(builder2, JavaElementType.EMPTY_EXPRESSION);
    }

    @Nullable
    private static IElementType getGtTokenType(PsiBuilder builder2) {
        IElementType tokenType = builder2.getTokenType();
        if (tokenType != JavaTokenType.GT) {
            return tokenType;
        }
        if (builder2.rawLookup(1) == JavaTokenType.GT) {
            tokenType = builder2.rawLookup(2) == JavaTokenType.GT ? (builder2.rawLookup(3) == JavaTokenType.EQ ? JavaTokenType.GTGTGTEQ : JavaTokenType.GTGTGT) : (builder2.rawLookup(2) == JavaTokenType.EQ ? JavaTokenType.GTGTEQ : JavaTokenType.GTGT);
        } else if (builder2.rawLookup(1) == JavaTokenType.EQ) {
            tokenType = JavaTokenType.GE;
        }
        return tokenType;
    }

    private static void advanceGtToken(PsiBuilder builder2, IElementType type2) {
        PsiBuilder.Marker gtToken = builder2.mark();
        if (type2 == JavaTokenType.GTGTGTEQ) {
            PsiBuilderUtil.advance(builder2, 4);
        } else if (type2 == JavaTokenType.GTGTGT || type2 == JavaTokenType.GTGTEQ) {
            PsiBuilderUtil.advance(builder2, 3);
        } else if (type2 == JavaTokenType.GTGT || type2 == JavaTokenType.GE) {
            PsiBuilderUtil.advance(builder2, 2);
        } else {
            gtToken.drop();
            builder2.advanceLexer();
            return;
        }
        gtToken.collapse(type2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParser";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/lang/java/parser/ExpressionParser";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementParser";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "missingElementKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/lang/java/parser/ExpressionParser";
                break;
            }
            case 3: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parseArrayInitializer";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "parseNew";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "parseMethodReference";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "parseArgumentList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseCaseLabel";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseArrayInitializer";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum BreakPoint {
        P1,
        P2,
        P4;

    }

    private static enum ExprType {
        CONDITIONAL_OR,
        CONDITIONAL_AND,
        OR,
        XOR,
        AND,
        EQUALITY,
        RELATIONAL,
        SHIFT,
        ADDITIVE,
        MULTIPLICATIVE,
        UNARY,
        TYPE;

    }
}

