/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.wire;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.spi.Element;
import com.google.inject.spi.Elements;
import java.util.Arrays;
import org.eclipse.sisu.inject.DefaultBeanLocator;
import org.eclipse.sisu.wire.ElementAnalyzer;
import org.eclipse.sisu.wire.WireModule;

public final class ChildWireModule
implements Module {
    private final Injector parent;
    private final Iterable<Module> modules;
    private WireModule.Strategy strategy = WireModule.Strategy.DEFAULT;

    public ChildWireModule(Injector parent2, Module ... modules) {
        this(parent2, Arrays.asList(modules));
    }

    public ChildWireModule(Injector parent2, Iterable<Module> modules) {
        this.modules = modules;
        this.parent = parent2;
    }

    public Module with(WireModule.Strategy _strategy) {
        this.strategy = _strategy;
        return this;
    }

    @Override
    public void configure(Binder binder) {
        binder.requestStaticInjection(DefaultBeanLocator.class);
        ElementAnalyzer analyzer2 = new ElementAnalyzer(binder);
        Injector i = this.parent;
        while (i != null) {
            analyzer2.ignoreKeys(i.getAllBindings().keySet());
            i = i.getParent();
        }
        for (Element e : Elements.getElements(this.modules)) {
            e.acceptVisitor(analyzer2);
        }
        analyzer2.apply(this.strategy);
    }
}

