/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.transformer;

import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.collection.DependencyGraphTransformationContext;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;

public final class JavaDependencyContextRefiner
implements DependencyGraphTransformer {
    public DependencyNode transformGraph(DependencyNode node, DependencyGraphTransformationContext context2) throws RepositoryException {
        String scope2;
        String ctx = node.getRequestContext();
        if ("project".equals(ctx) && (scope2 = this.getClasspathScope(node)) != null) {
            ctx = ctx + '/' + scope2;
            node.setRequestContext(ctx);
        }
        for (DependencyNode child : node.getChildren()) {
            this.transformGraph(child, context2);
        }
        return node;
    }

    private String getClasspathScope(DependencyNode node) {
        Dependency dependency = node.getDependency();
        if (dependency == null) {
            return null;
        }
        String scope2 = dependency.getScope();
        if ("compile".equals(scope2) || "system".equals(scope2) || "provided".equals(scope2)) {
            return "compile";
        }
        if ("runtime".equals(scope2)) {
            return "runtime";
        }
        if ("test".equals(scope2)) {
            return "test";
        }
        return null;
    }
}

