/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transport.http;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.client.utils.URIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class UriUtils {
    UriUtils() {
    }

    public static URI resolve(URI base2, URI ref) {
        String path2 = ref.getRawPath();
        if (!(path2 == null || path2.length() <= 0 || (path2 = base2.getRawPath()) != null && path2.endsWith("/"))) {
            try {
                base2 = new URI(base2.getScheme(), base2.getAuthority(), base2.getPath() + '/', null, null);
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException(e);
            }
        }
        return URIUtils.resolve(base2, ref);
    }

    public static List<URI> getDirectories(URI base2, URI uri) {
        ArrayList<URI> dirs = new ArrayList<URI>();
        URI dir = uri.resolve(".");
        while (!UriUtils.isBase(base2, dir)) {
            dirs.add(dir);
            dir = dir.resolve("..");
        }
        return dirs;
    }

    private static boolean isBase(URI base2, URI uri) {
        URI rel;
        String path2 = uri.getRawPath();
        if (path2 == null || "/".equals(path2)) {
            return true;
        }
        return base2 != null && ((rel = base2.relativize(uri)).getRawPath() == null || rel.getRawPath().length() <= 0 || rel.equals(uri));
    }
}

