/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.impl.Installer;
import org.eclipse.aether.impl.MetadataGenerator;
import org.eclipse.aether.impl.MetadataGeneratorFactory;
import org.eclipse.aether.impl.RepositoryEventDispatcher;
import org.eclipse.aether.impl.SyncContextFactory;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallResult;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.internal.impl.PrioritizedComponent;
import org.eclipse.aether.internal.impl.PrioritizedComponents;
import org.eclipse.aether.internal.impl.Utils;
import org.eclipse.aether.metadata.MergeableMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.LocalArtifactRegistration;
import org.eclipse.aether.repository.LocalMetadataRegistration;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.spi.io.FileProcessor;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.spi.log.LoggerFactory;
import org.eclipse.aether.spi.log.NullLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
public class DefaultInstaller
implements Installer,
Service {
    private Logger logger = NullLoggerFactory.LOGGER;
    private FileProcessor fileProcessor;
    private RepositoryEventDispatcher repositoryEventDispatcher;
    private Collection<MetadataGeneratorFactory> metadataFactories = new ArrayList<MetadataGeneratorFactory>();
    private SyncContextFactory syncContextFactory;

    public DefaultInstaller() {
    }

    @Inject
    DefaultInstaller(FileProcessor fileProcessor, RepositoryEventDispatcher repositoryEventDispatcher, Set<MetadataGeneratorFactory> metadataFactories, SyncContextFactory syncContextFactory, LoggerFactory loggerFactory) {
        this.setFileProcessor(fileProcessor);
        this.setRepositoryEventDispatcher(repositoryEventDispatcher);
        this.setMetadataGeneratorFactories(metadataFactories);
        this.setSyncContextFactory(syncContextFactory);
        this.setLoggerFactory(loggerFactory);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(LoggerFactory.class));
        this.setFileProcessor(locator.getService(FileProcessor.class));
        this.setRepositoryEventDispatcher(locator.getService(RepositoryEventDispatcher.class));
        this.setMetadataGeneratorFactories(locator.getServices(MetadataGeneratorFactory.class));
        this.setSyncContextFactory(locator.getService(SyncContextFactory.class));
    }

    public DefaultInstaller setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger(loggerFactory, this.getClass());
        return this;
    }

    public DefaultInstaller setFileProcessor(FileProcessor fileProcessor) {
        if (fileProcessor == null) {
            throw new IllegalArgumentException("file processor has not been specified");
        }
        this.fileProcessor = fileProcessor;
        return this;
    }

    public DefaultInstaller setRepositoryEventDispatcher(RepositoryEventDispatcher repositoryEventDispatcher) {
        if (repositoryEventDispatcher == null) {
            throw new IllegalArgumentException("repository event dispatcher has not been specified");
        }
        this.repositoryEventDispatcher = repositoryEventDispatcher;
        return this;
    }

    public DefaultInstaller addMetadataGeneratorFactory(MetadataGeneratorFactory factory2) {
        if (factory2 == null) {
            throw new IllegalArgumentException("metadata generator factory has not been specified");
        }
        this.metadataFactories.add(factory2);
        return this;
    }

    public DefaultInstaller setMetadataGeneratorFactories(Collection<MetadataGeneratorFactory> metadataFactories) {
        this.metadataFactories = metadataFactories == null ? new ArrayList<MetadataGeneratorFactory>() : metadataFactories;
        return this;
    }

    public DefaultInstaller setSyncContextFactory(SyncContextFactory syncContextFactory) {
        if (syncContextFactory == null) {
            throw new IllegalArgumentException("sync context factory has not been specified");
        }
        this.syncContextFactory = syncContextFactory;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InstallResult install(RepositorySystemSession session2, InstallRequest request) throws InstallationException {
        SyncContext syncContext = this.syncContextFactory.newInstance(session2, false);
        try {
            InstallResult installResult = this.install(syncContext, session2, request);
            return installResult;
        }
        finally {
            syncContext.close();
        }
    }

    private InstallResult install(SyncContext syncContext, RepositorySystemSession session2, InstallRequest request) throws InstallationException {
        InstallResult result2 = new InstallResult(request);
        RequestTrace trace = RequestTrace.newChild(request.getTrace(), request);
        List<? extends MetadataGenerator> generators = this.getMetadataGenerators(session2, request);
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>(request.getArtifacts());
        IdentityHashMap processedMetadata = new IdentityHashMap();
        List<Metadata> metadatas = Utils.prepareMetadata(generators, artifacts);
        syncContext.acquire(artifacts, Utils.combine(request.getMetadata(), metadatas));
        for (Metadata metadata2 : metadatas) {
            this.install(session2, trace, metadata2);
            processedMetadata.put(metadata2, null);
            result2.addMetadata(metadata2);
        }
        for (int i = 0; i < artifacts.size(); ++i) {
            Artifact artifact = (Artifact)artifacts.get(i);
            for (MetadataGenerator metadataGenerator : generators) {
                artifact = metadataGenerator.transformArtifact(artifact);
            }
            artifacts.set(i, artifact);
            this.install(session2, trace, artifact);
            result2.addArtifact(artifact);
        }
        metadatas = Utils.finishMetadata(generators, artifacts);
        syncContext.acquire(null, metadatas);
        for (Metadata metadata2 : metadatas) {
            this.install(session2, trace, metadata2);
            processedMetadata.put(metadata2, null);
            result2.addMetadata(metadata2);
        }
        for (Metadata metadata2 : request.getMetadata()) {
            if (processedMetadata.containsKey(metadata2)) continue;
            this.install(session2, trace, metadata2);
            result2.addMetadata(metadata2);
        }
        return result2;
    }

    private List<? extends MetadataGenerator> getMetadataGenerators(RepositorySystemSession session2, InstallRequest request) {
        PrioritizedComponents<MetadataGeneratorFactory> factories = Utils.sortMetadataGeneratorFactories(session2, this.metadataFactories);
        ArrayList<MetadataGenerator> generators = new ArrayList<MetadataGenerator>();
        for (PrioritizedComponent<MetadataGeneratorFactory> factory2 : factories.getEnabled()) {
            MetadataGenerator generator2 = factory2.getComponent().newInstance(session2, request);
            if (generator2 == null) continue;
            generators.add(generator2);
        }
        return generators;
    }

    private void install(RepositorySystemSession session2, RequestTrace trace, Artifact artifact) throws InstallationException {
        LocalRepositoryManager lrm = session2.getLocalRepositoryManager();
        File srcFile = artifact.getFile();
        File dstFile = new File(lrm.getRepository().getBasedir(), lrm.getPathForLocalArtifact(artifact));
        this.artifactInstalling(session2, trace, artifact, dstFile);
        Exception exception = null;
        try {
            boolean copy2;
            if (dstFile.equals(srcFile)) {
                throw new IllegalArgumentException("Cannot install " + dstFile + " to same path");
            }
            boolean bl = copy2 = "pom".equals(artifact.getExtension()) || srcFile.lastModified() != dstFile.lastModified() || srcFile.length() != dstFile.length() || !srcFile.exists();
            if (copy2) {
                this.fileProcessor.copy(srcFile, dstFile);
                dstFile.setLastModified(srcFile.lastModified());
            } else {
                this.logger.debug("Skipped re-installing " + srcFile + " to " + dstFile + ", seems unchanged");
            }
            lrm.add(session2, new LocalArtifactRegistration(artifact));
        }
        catch (Exception e) {
            exception = e;
            throw new InstallationException("Failed to install artifact " + artifact + ": " + e.getMessage(), e);
        }
        finally {
            this.artifactInstalled(session2, trace, artifact, dstFile, exception);
        }
    }

    private void install(RepositorySystemSession session2, RequestTrace trace, Metadata metadata2) throws InstallationException {
        LocalRepositoryManager lrm = session2.getLocalRepositoryManager();
        File dstFile = new File(lrm.getRepository().getBasedir(), lrm.getPathForLocalMetadata(metadata2));
        this.metadataInstalling(session2, trace, metadata2, dstFile);
        Exception exception = null;
        try {
            if (metadata2 instanceof MergeableMetadata) {
                ((MergeableMetadata)metadata2).merge(dstFile, dstFile);
            } else {
                if (dstFile.equals(metadata2.getFile())) {
                    throw new IllegalArgumentException("Cannot install " + dstFile + " to same path");
                }
                this.fileProcessor.copy(metadata2.getFile(), dstFile);
            }
            lrm.add(session2, new LocalMetadataRegistration(metadata2));
        }
        catch (Exception e) {
            exception = e;
            throw new InstallationException("Failed to install metadata " + metadata2 + ": " + e.getMessage(), e);
        }
        finally {
            this.metadataInstalled(session2, trace, metadata2, dstFile, exception);
        }
    }

    private void artifactInstalling(RepositorySystemSession session2, RequestTrace trace, Artifact artifact, File dstFile) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session2, RepositoryEvent.EventType.ARTIFACT_INSTALLING);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setRepository(session2.getLocalRepositoryManager().getRepository());
        event.setFile(dstFile);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void artifactInstalled(RepositorySystemSession session2, RequestTrace trace, Artifact artifact, File dstFile, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session2, RepositoryEvent.EventType.ARTIFACT_INSTALLED);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setRepository(session2.getLocalRepositoryManager().getRepository());
        event.setFile(dstFile);
        event.setException(exception);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void metadataInstalling(RepositorySystemSession session2, RequestTrace trace, Metadata metadata2, File dstFile) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session2, RepositoryEvent.EventType.METADATA_INSTALLING);
        event.setTrace(trace);
        event.setMetadata(metadata2);
        event.setRepository(session2.getLocalRepositoryManager().getRepository());
        event.setFile(dstFile);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void metadataInstalled(RepositorySystemSession session2, RequestTrace trace, Metadata metadata2, File dstFile, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session2, RepositoryEvent.EventType.METADATA_INSTALLED);
        event.setTrace(trace);
        event.setMetadata(metadata2);
        event.setRepository(session2.getLocalRepositoryManager().getRepository());
        event.setFile(dstFile);
        event.setException(exception);
        this.repositoryEventDispatcher.dispatch(event.build());
    }
}

