/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.ArtifactRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RepositoryEvent {
    private final EventType type;
    private final RepositorySystemSession session;
    private final Artifact artifact;
    private final Metadata metadata;
    private final ArtifactRepository repository;
    private final File file;
    private final List<Exception> exceptions;
    private final RequestTrace trace;

    RepositoryEvent(Builder builder2) {
        this.type = builder2.type;
        this.session = builder2.session;
        this.artifact = builder2.artifact;
        this.metadata = builder2.metadata;
        this.repository = builder2.repository;
        this.file = builder2.file;
        this.exceptions = builder2.exceptions;
        this.trace = builder2.trace;
    }

    public EventType getType() {
        return this.type;
    }

    public RepositorySystemSession getSession() {
        return this.session;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public File getFile() {
        return this.file;
    }

    public ArtifactRepository getRepository() {
        return this.repository;
    }

    public Exception getException() {
        return this.exceptions.isEmpty() ? null : this.exceptions.get(0);
    }

    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    public RequestTrace getTrace() {
        return this.trace;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append((Object)this.getType());
        if (this.getArtifact() != null) {
            buffer.append(" ").append(this.getArtifact());
        }
        if (this.getMetadata() != null) {
            buffer.append(" ").append(this.getMetadata());
        }
        if (this.getFile() != null) {
            buffer.append(" (").append(this.getFile()).append(")");
        }
        if (this.getRepository() != null) {
            buffer.append(" @ ").append(this.getRepository());
        }
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder {
        EventType type;
        RepositorySystemSession session;
        Artifact artifact;
        Metadata metadata;
        ArtifactRepository repository;
        File file;
        List<Exception> exceptions = Collections.emptyList();
        RequestTrace trace;

        public Builder(RepositorySystemSession session2, EventType type2) {
            if (session2 == null) {
                throw new IllegalArgumentException("session not specified");
            }
            this.session = session2;
            if (type2 == null) {
                throw new IllegalArgumentException("event type not specified");
            }
            this.type = type2;
        }

        public Builder setArtifact(Artifact artifact) {
            this.artifact = artifact;
            return this;
        }

        public Builder setMetadata(Metadata metadata2) {
            this.metadata = metadata2;
            return this;
        }

        public Builder setRepository(ArtifactRepository repository) {
            this.repository = repository;
            return this;
        }

        public Builder setFile(File file2) {
            this.file = file2;
            return this;
        }

        public Builder setException(Exception exception) {
            this.exceptions = exception != null ? Collections.singletonList(exception) : Collections.emptyList();
            return this;
        }

        public Builder setExceptions(List<Exception> exceptions) {
            this.exceptions = exceptions != null ? exceptions : Collections.emptyList();
            return this;
        }

        public Builder setTrace(RequestTrace trace) {
            this.trace = trace;
            return this;
        }

        public RepositoryEvent build() {
            return new RepositoryEvent(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        ARTIFACT_DESCRIPTOR_INVALID,
        ARTIFACT_DESCRIPTOR_MISSING,
        METADATA_INVALID,
        ARTIFACT_RESOLVING,
        ARTIFACT_RESOLVED,
        METADATA_RESOLVING,
        METADATA_RESOLVED,
        ARTIFACT_DOWNLOADING,
        ARTIFACT_DOWNLOADED,
        METADATA_DOWNLOADING,
        METADATA_DOWNLOADED,
        ARTIFACT_INSTALLING,
        ARTIFACT_INSTALLED,
        METADATA_INSTALLING,
        METADATA_INSTALLED,
        ARTIFACT_DEPLOYING,
        ARTIFACT_DEPLOYED,
        METADATA_DEPLOYING,
        METADATA_DEPLOYED;

    }
}

